#include <stdio.h>
#include <string.h>
#include "defs.h"

/*  The banner used here should be replaced with an #ident directive	*/
/*  if the target C compiler supports #ident directives.		*/
/*									*/
/*  If the skeleton is changed, the banner should be changed so that	*/
/*  the altered version can easily be distinguished from the original.	*/

char *banner[] =
{
    "#ifndef lint",
    "static char yysccsid[] = \"@(#)yaccpar	1.8 (Berkeley) 01/20/90\";",
    "#endif",
    "#define YYBYACC 1",
    0
};

char *jbanner[] =
{
    "### This file was created by BYACC/R 1.0 which is based on",
    "### BYACC 1.8/Java extension 0.92",
    "### Ruby extensions are added by Takaaki Tateishi <ttate@jaist.ac.jp>",
    "###",
    "### Java capabilities added 7 Jan 97, Bob Jamison",
    "### Updated : 27 Nov 97  -- Bob Jamison, Joe Nieten",
    "###           01 Jan 98  -- Bob Jamison -- fixed generic semantic constructor",
    "###           01 Jun 99  -- Bob Jamison -- added Runnable support",
    "### Please send bug reports to rjamison@lincom-asg.com",
    "### static char yysccsid[] = \"@(#)yaccpar	1.8 (Berkeley) 01/20/90\";",
    "\n\n",
    0
};


char *tables[] =
{
    "extern short yylhs[];",
    "extern short yylen[];",
    "extern short yydefred[];",
    "extern short yydgoto[];",
    "extern short yysindex[];",
    "extern short yyrindex[];",
    "extern short yygindex[];",
    "extern short yytable[];",
    "extern short yycheck[];",
    "#if YYDEBUG",
    "extern char *yyname[];",
    "extern char *yyrule[];",
    "#endif",
    0
};

char *jtables[] =
{
    0
};


char *header[] =
{
    "#define yyclearin (yychar=(-1))",
    "#define yyerrok (yyerrflag=0)",
    "#ifdef YYSTACKSIZE",
    "#ifndef YYMAXDEPTH",
    "#define YYMAXDEPTH YYSTACKSIZE",
    "#endif",
    "#else",
    "#ifdef YYMAXDEPTH",
    "#define YYSTACKSIZE YYMAXDEPTH",
    "#else",
    "#define YYSTACKSIZE 500",
    "#define YYMAXDEPTH 500",
    "#endif",
    "#endif",
    "int yydebug;",
    "int yynerrs;",
    "int yyerrflag;",
    "int yychar;",
    "short *yyssp;",
    "YYSTYPE *yyvsp;",
    "YYSTYPE yyval;",
    "YYSTYPE yylval;",
    "short yyss[YYSTACKSIZE];",
    "YYSTYPE yyvs[YYSTACKSIZE];",
    "#define yystacksize YYSTACKSIZE",
    0
};

char *jheader[] =
{
  "\n\n\n",
  "######################################################################",
  "@RUBY@# class: %s\n",
  "# does : encapsulates yacc() parser functionality in a Ruby",
  "#        class for quick code development",
  "######################################################################",
  "@RUBYX@class %s",
  "\n",
  "  YYSTACKSIZE = 500 # maximum stack size",
  "",
  "  def initialize",
  "    @yydebug   = nil      # do I want debug output?",
  "    @yynerrs   = nil      # number of errors so far",
  "    @yyerrflag = nil      # was there an error?",
  "    @yychar    = nil      # the current working character",
  "    @statestk  = []       # state stack",
  "    @stateptr  = nil      # state stack pointer",
  "    @yytext    = nil      # user variable to return contextual strings",
  "    @yyval     = nil      # used to return semantic vals from action routines",
  "    @yylval    = nil      # the 'lval' (result) I got from yylex()",
  "    @valstk    = []",
  "    @valptr    = nil      #",
  "    init_rule_data",
  "    init_yydefred",
  "    init_yydgoto",
  "    init_base",
  "    init_table",
  "    init_check",
  "    init_yyname",
  "    init_yyrule",
  "  end",
  "",
  "###############################################################",
  "# method: debug",
  "################################################################",
  "  def debug(msg)",
  "    if (@yydebug)",
  "      $stdout.print(msg,\"\\n\")",
  "    end",
  "  end",
  "",
  "  def yyerror(msg)",
  "    $stderr.print(msg,\"\\n\")",
  "  end",
  "",
  "################################################################",
  "# methods: state stack push,pop,drop,peek",
  "################################################################",
  "def state_push(state)",
  "  if (@stateptr >= YYSTACKSIZE) # overflowed?",
  "    return",
  "  end",
  "  @stateptr += 1",
  "  @statestk[@stateptr] = state",
  "end",
  "",
  "def state_pop()",
  "  if (@stateptr < 0) # underflowed?",
  "    return -1",
  "  end",
  "  ptr = @stateptr",
  "  @stateptr -= 1",
  "  return @statestk[ptr]",
  "end",
  "",
  "def state_drop(cnt)",
  "  ptr = @stateptr - cnt",
  "  if (ptr < 0)",
  "    return",
  "  end",
  "  @stateptr = ptr;",
  "end",
  "",
  "def state_peek(relative)",
  "  ptr = @stateptr - relative",
  "  if (ptr < 0)",
  "    return -1",
  "  end",
  "  return @statestk[ptr]",
  "end",
  "",
  "################################################################",
  "# method: init_stacks : allocate and prepare stacks",
  "################################################################",
  "def init_stacks()",
  "  @statestk = Array.new(YYSTACKSIZE)",
  "  @stateptr = -1",
  "  val_init()",
  "  return true;",
  "end",
  "",
  "################################################################",
  "# method: dump_stacks : show n levels of the stacks",
  "################################################################",
  "def dump_stacks(count)",
  "  $stdout.print(\"=index==state====value=     s:#{@stateptr.to_s}  v:#{@valptr.to_s}\\n\")",
  "  for i in 0..(count - 1)",
  "    $stdout.print(\" #{i.to_s}  #{@statestk[i].to_s}   #{@valstk[i].to_s}\\n\")",
  "  end",
  "  $stdout.print(\"======================\\n\");",
  "end",
  "",
  0
};


char *body[] =
{
    "#define YYABORT goto yyabort",
    "#define YYACCEPT goto yyaccept",
    "#define YYERROR goto yyerrlab",
    "int",
    "yyparse()",
    "{",
    "    register int yym, yyn, yystate;",
    "#if YYDEBUG",
    "    register char *yys;",
    "    extern char *getenv();",
    "",
    "    if (yys = getenv(\"YYDEBUG\"))",
    "    {",
    "        yyn = *yys;",
    "        if (yyn >= '0' && yyn <= '9')",
    "            yydebug = yyn - '0';",
    "    }",
    "#endif",
    "",
    "    yynerrs = 0;",
    "    yyerrflag = 0;",
    "    yychar = (-1);",
    "",
    "    yyssp = yyss;",
    "    yyvsp = yyvs;",
    "    *yyssp = yystate = 0;",
    "",
    "yyloop:",
    "    if (yyn = yydefred[yystate]) goto yyreduce;",
    "    if (yychar < 0)",
    "    {",
    "        if ((yychar = yylex()) < 0) yychar = 0;",
    "#if YYDEBUG",
    "        if (yydebug)",
    "        {",
    "            yys = 0;",
    "            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];",
    "            if (!yys) yys = \"illegal-symbol\";",
    "            printf(\"yydebug: state %d, reading %d (%s)\\n\", yystate,",
    "                    yychar, yys);",
    "        }",
    "#endif",
    "    }",
    "    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&",
    "            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)",
    "    {",
    "#if YYDEBUG",
    "        if (yydebug)",
    "            printf(\"yydebug: state %d, shifting to state %d\\n\",",
    "                    yystate, yytable[yyn]);",
    "#endif",
    "        if (yyssp >= yyss + yystacksize - 1)",
    "        {",
    "            goto yyoverflow;",
    "        }",
    "        *++yyssp = yystate = yytable[yyn];",
    "        *++yyvsp = yylval;",
    "        yychar = (-1);",
    "        if (yyerrflag > 0)  --yyerrflag;",
    "        goto yyloop;",
    "    }",
    "    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&",
    "            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)",
    "    {",
    "        yyn = yytable[yyn];",
    "        goto yyreduce;",
    "    }",
    "    if (yyerrflag) goto yyinrecovery;",
    "#ifdef lint",
    "    goto yynewerror;",
    "#endif",
    "yynewerror:",
    "    yyerror(\"syntax error\");",
    "#ifdef lint",
    "    goto yyerrlab;",
    "#endif",
    "yyerrlab:",
    "    ++yynerrs;",
    "yyinrecovery:",
    "    if (yyerrflag < 3)",
    "    {",
    "        yyerrflag = 3;",
    "        for (;;)",
    "        {",
    "            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&",
    "                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)",
    "            {",
    "#if YYDEBUG",
    "                if (yydebug)",
    "                    printf(\"yydebug: state %d, error recovery shifting\\",
    " to state %d\\n\", *yyssp, yytable[yyn]);",
    "#endif",
    "                if (yyssp >= yyss + yystacksize - 1)",
    "                {",
    "                    goto yyoverflow;",
    "                }",
    "                *++yyssp = yystate = yytable[yyn];",
    "                *++yyvsp = yylval;",
    "                goto yyloop;",
    "            }",
    "            else",
    "            {",
    "#if YYDEBUG",
    "                if (yydebug)",
    "                    printf(\"yydebug: error recovery discarding state %d\
\\n\",",
    "                            *yyssp);",
    "#endif",
    "                if (yyssp <= yyss) goto yyabort;",
    "                --yyssp;",
    "                --yyvsp;",
    "            }",
    "        }",
    "    }",
    "    else",
    "    {",
    "        if (yychar == 0) goto yyabort;",
    "#if YYDEBUG",
    "        if (yydebug)",
    "        {",
    "            yys = 0;",
    "            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];",
    "            if (!yys) yys = \"illegal-symbol\";",
    "            printf(\"yydebug: state %d, error recovery discards token %d\
 (%s)\\n\",",
    "                    yystate, yychar, yys);",
    "        }",
    "#endif",
    "        yychar = (-1);",
    "        goto yyloop;",
    "    }",
    "yyreduce:",
    "#if YYDEBUG",
    "    if (yydebug)",
    "        printf(\"yydebug: state %d, reducing by rule %d (%s)\\n\",",
    "                yystate, yyn, yyrule[yyn]);",
    "#endif",
    "    yym = yylen[yyn];",
    "    yyval = yyvsp[1-yym];",
    "    switch (yyn)",
    "    {",
    0
};

char *jbody[] =
{
    "################################################################",
    "# method: yylexdebug : check lexer state",
    "################################################################",
    "def yylexdebug(state, ch)",
    "  s = nil",
    "  if (ch < 0); ch = 0; end",
    "  if (ch <= YYMAXTOKEN) # check index bounds",
    "     s = @yyname[ch]    # now get it",
    "  end",
    "  if (s == nil)",
    "    s = \"illegal-symbol\"",
    "  end",
    "  debug(\"state #{state}, reading #{ch} (#{s})\")",
    "end\n",
    "",
    "################################################################",
    "# method: yyparse : parse input and execute indicated items",
    "################################################################",
    "def yyparse()",
    "  @yyn = nil     # next next thing to do",
    "  @yym = nil",
    "  @yystate = nil # current parsing state from state table",
    "  @yys = nil     # current token string",
    "  doaction = nil",
    "  init_stacks()",
    "  @yynerrs = 0",
    "  @yyerrflag = 0",
    "  @yychar = -1          # impossible char forces a read",
    "  @yystate=0            # initial state",
    "  state_push(@yystate)  # save it",
    "  while (true) # until parsing is done, either correctly, or w/error",
    "    doaction = true",
    "    if (@yydebug)",
    "      debug(\"loop\")",
    "    end",
    "    ##### NEXT ACTION (from reduction table)",
    "    while( (@yyn = @yydefred[@yystate]) && (@yyn == 0) )",
    "      if (@yydebug)",
    "        debug(\"yyn:#{@yyn}  state:#{@yystate}  char:#{@yychar}\")",
    "      end",
    "      if (@yychar < 0)      # we want a char?",
    "        @yychar = yylex()   # get next token",
    "        ##### ERROR CHECK ####",
    "        if (@yychar < 0)    # it it didn't work/error",
    "          @yychar = 0;      # change it to default string (no -1!)",
    "          if (@yydebug)",
    "            yylexdebug(@yystate, @yychar)",
    "          end",
    "        end # @yychar<0",
    "      end # @yychar<0",
    "      @yyn = @yysindex[@yystate]   # get amount to shift by (shift index)",
    "      if ((@yyn != 0) && ((@yyn += @yychar) >= 0) &&",
    "          (@yyn <= YYTABLESIZE) && (@yycheck[@yyn] == @yychar))",
    "        if (@yydebug)",
    "          debug(\"state #{@yystate}, shifting to state #{@yytable[@yyn]}\")",
    "        end",
    "        ##### NEXT STATE ####",
    "        @yystate = @yytable[@yyn] # we are in a new state",
    "        state_push(@yystate)    # save it",
    "        val_push(@yylval)       # push our lval as the input for next rule",
    "        @yychar = -1  # since we have 'eaten' a token, say we need another",
    "        if (@yyerrflag > 0)     # have we recovered an error?",
    "           @yyerrflag -= 1      # give ourselves credit",
    "        end",
    "        doaction = false       # but don't process yet",
    "        break                  # quit the yyn=0 loop",
    "      end  # if((@yyn != 0)....)",
    "",
    "      @yyn = @yyrindex[@yystate]  # reduce",
    "      if ((@yyn !=0 ) && ((@yyn += @yychar) >= 0) &&",
    "          (@yyn <= YYTABLESIZE) && (@yycheck[@yyn] == @yychar))",
    "        if (@yydebug)",
    "          debug(\"reduce\")",
    "        end",
    "        @yyn = @yytable[@yyn]",
    "        doaction=true  # get ready to execute",
    "        break          # drop down to actions",
    "      else # ERROR RECOVERY",
    "        if (@yyerrflag==0)",
    "          yyerror(\"syntax error\")",
    "          @yynerrs += 1",
    "        end",
    "        if (@yyerrflag < 3) # low error count?",
    "          @yyerrflag = 3",
    "          while (true)      # do until break",
    "            if (@stateptr<0) # check for under & overflow here",
    "              yyerror(\"stack underflow. aborting...\") # note lower case 's'",
    "              return 1",
    "            end",
    "            @yyn = @yysindex[state_peek(0)]",
    "            if ((@yyn != 0) && ((@yyn += YYERRCODE) >= 0) &&",
    "                (@yyn <= YYTABLESIZE) && (@yycheck[@yyn] == YYERRCODE))",
    "              if (@yydebug)",
    "                debug(\"state #{state_peek(0)}, error recovery shifting to state #{yytable[yyn]}\")",
    "              end",
    "              @yystate = @yytable[@yyn]",
    "              state_push(@yystate)",
    "              val_push(@yylval)",
    "              doaction = false",
    "              break",
    "            else",
    "              if (@yydebug)",
    "                debug(\"error recovery discarding state #{state_peek(0)}\")",
    "              end",
    "              if (@stateptr<0)   # check for under & overflow here",
    "                yyerror(\"Stack underflow. aborting...\")  # capital 'S'",
    "                return 1",
    "              end",
    "              state_pop()",
    "              val_pop()",
    "            end",
    "          end # while(true)",
    "        else            # discard this token",
    "          if (@yychar == 0)",
    "            return 1 # yyabort",
    "          end",
    "          if (@yydebug)",
    "            @yys = nil",
    "            if (@yychar <= YYMAXTOKEN)",
    "              @yys = @yyname[@yychar]",
    "            end",
    "            if (@yys == nil)",
    "              @yys = \"illegal-symbol\"",
    "            end",
    "            debug(\"state #{@yystate}, error recovery discards token #{@yychar} (#{@yys}\")",
    "          end",
    "          @yychar = -1 # read another",
    "        end",
    "      end # End of ERROR RECOVERY",
    "    end # while(@yyn==0) loop",
    "    if (!doaction)   # any reason not to proceed?",
    "      next           # skip action (continue in Ruby)",
    "    end",
    "    @yym = @yylen[@yyn] # get count of terminals on rhs",
    "    if (@yydebug)",
    "      debug(\"state #{@yystate}, reducing #{@yym} by rule #{@yyn} (#{@yyrule[@yyn]})\")",
    "    end",
    "    if (@yym > 0)                 # if count of rhs not 'nil'",
    "      @yyval = val_peek(@yym-1)   # get current semantic value",
    "    end",
    "    case @yyn",
    "########### USER-SUPPLIED ACTIONS ##########",
    0
};


char *trailer[] =
{
    "    }",
    "    yyssp -= yym;",
    "    yystate = *yyssp;",
    "    yyvsp -= yym;",
    "    yym = yylhs[yyn];",
    "    if (yystate == 0 && yym == 0)",
    "    {",
    "#if YYDEBUG",
    "        if (yydebug)",
    "            printf(\"yydebug: after reduction, shifting from state 0 to\\",
    " state %d\\n\", YYFINAL);",
    "#endif",
    "        yystate = YYFINAL;",
    "        *++yyssp = YYFINAL;",
    "        *++yyvsp = yyval;",
    "        if (yychar < 0)",
    "        {",
    "            if ((yychar = yylex()) < 0) yychar = 0;",
    "#if YYDEBUG",
    "            if (yydebug)",
    "            {",
    "                yys = 0;",
    "                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];",
    "                if (!yys) yys = \"illegal-symbol\";",
    "                printf(\"yydebug: state %d, reading %d (%s)\\n\",",
    "                        YYFINAL, yychar, yys);",
    "            }",
    "#endif",
    "        }",
    "        if (yychar == 0) goto yyaccept;",
    "        goto yyloop;",
    "    }",
    "    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&",
    "            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)",
    "        yystate = yytable[yyn];",
    "    else",
    "        yystate = yydgoto[yym];",
    "#if YYDEBUG",
    "    if (yydebug)",
    "        printf(\"yydebug: after reduction, shifting from state %d \\",
    "to state %d\\n\", *yyssp, yystate);",
    "#endif",
    "    if (yyssp >= yyss + yystacksize - 1)",
    "    {",
    "        goto yyoverflow;",
    "    }",
    "    *++yyssp = yystate;",
    "    *++yyvsp = yyval;",
    "    goto yyloop;",
    "yyoverflow:",
    "    yyerror(\"yacc stack overflow\");",
    "yyabort:",
    "    return (1);",
    "yyaccept:",
    "    return (0);",
    "}",
    0
};

char *jtrailer[] =
{
    "########### END OF USER-SUPPLIED ACTIONS ##########",
    "    end # case yyn",
    "    ##### Now let's reduce... ####",
    "    if (@yydebug); debug(\"reduce\"); end",
    "    state_drop(@yym)              # we just reduced yylen states",
    "    @yystate = state_peek(0)      # get new state",
    "    val_drop(@yym)                # corresponding value drop",
    "    @yym = @yylhs[@yyn]             # select next TERMINAL(on lhs)",
    "    if (@yystate == 0 && @yym == 0)# done? 'rest' state and at first TERMINAL",
    "      debug(\"After reduction, shifting from state 0 to state #{YYFINAL}\")",
    "      @yystate = YYFINAL;         # explicitly say we're done",
    "      state_push(YYFINAL);       # and save it",
    "      val_push(@yyval);           # also save the semantic value of parsing",
    "      if (@yychar < 0)            # we want another character?",
    "        @yychar = yylex();        # get next character",
    "        if (@yychar < 0)",
    "          @yychar=0               # clean, if necessary",
    "        end",
    "        if (@yydebug)",
    "          yylexdebug(@yystate, @yychar)",
    "        end",
    "      end",
    "      if (@yychar == 0)         # Good exit (if lex returns 0 ;-)",
    "         break                 # quit the loop--all DONE",
    "      end",
    "    else                       # if (yystate == 0....)",
    "      @yyn = @yygindex[@yym];     # find out where to go",
    "      if ((@yyn != 0) && ((@yyn += @yystate) >= 0) &&",
    "          (@yyn <= YYTABLESIZE) && (@yycheck[@yyn] == @yystate))",
    "        @yystate = @yytable[@yyn] # get new state",
    "      else",
    "        @yystate = @yydgoto[@yym] # else go to new defred",
    "      end",
    "      debug(\"after reduction, shifting from state #{state_peek(0)} to state #{@yystate}\")",
    "      state_push(@yystate)      # going again, so push state & val...",
    "      val_push(@yyval)          # for next action",
    "    end",
    "  end # main loop",
    "  return 0 # yyaccept!!",
    "end",
    "### end of method parse() ######################################",
    "\n\n",
    "### run() --- for Thread #######################################",
    "def run()",
    "   yyparse()",
    "end",
    "### end of method run() ########################################",
    "\n\n",
    "### Constructor ################################################",
    "@RUBY@def %s()\n",
    "end\n",
    "@RUBY@def %s(debug_me)\n",
    "  @yydebug = debug_me",
    "end",
    "################################################################",
    "\n\n",
    "end # end of class",
    0
};

char *jtrailer_nothread[] =
{
    "########## END OF USER-SUPPLIED ACTIONS ##########",
    "    end # case(@yyn)",
    "    ##### Now let's reduce... ####",
    "    if (@yydebug); debug(\"reduce\"); end",
    "    state_drop(@yym)              # we just reduced yylen states",
    "    @yystate = state_peek(0)      # get new state",
    "    val_drop(@yym)                # corresponding value drop",
    "    @yym = @yylhs[@yyn]             # select next TERMINAL(on lhs)",
    "    if ((@yystate == 0) && (@yym == 0))# done? 'rest' state and at first TERMINAL",
    "      debug(\"After reduction, shifting from state 0 to state #{YYFINAL}\")",
    "      @yystate = YYFINAL          # explicitly say we're done",
    "      state_push(YYFINAL)        # and save it",
    "      val_push(@yyval)            # also save the semantic value of parsing",
    "      if (@yychar < 0)            # we want another character?",
    "        @yychar = yylex()         # get next character",
    "        if (@yychar < 0)",
    "          @yychar = 0               # clean, if necessary",
    "        end",
    "        if (@yydebug)",
    "          yylexdebug(@yystate, @yychar)",
    "        end",
    "      end",
    "      if (@yychar == 0)           # Good exit (if lex returns 0 ;-)",
    "         break                   # quit the loop--all DONE",
    "      end",
    "    else                         # if yystate (else not done yet)",
    "      @yyn = @yygindex[@yym]        # find out where to go",
    "      if ((@yyn != 0) && (@yyn += @yystate) >= 0 &&",
    "          (@yyn <= YYTABLESIZE) && (@yycheck[@yyn] == @yystate))",
    "        @yystate = @yytable[@yyn]   # get new state",
    "      else",
    "        @yystate = @yydgoto[@yym]   # else go to new defred",
    "      end",
    "      debug(\"after reduction, shifting from state #{state_peek(0)} to state #{@yystate}\")",
    "      state_push(@yystate)        # going again, so push state & val...",
    "      val_push(@yyval)            # for next action",
    "    end # else",
    "  end # main loop",
    "  return 0 # yyaccept!!",
    "end",
    "### end of method parse() ######################################",
    "\n\n",
    "end",
    "#################### END OF CLASS yaccpar ######################",
    0
};


void
write_section(char **section)
{
  int i;
  FILE *fp;

  fp = code_file;
  if (section==jtrailer){
    if (strcmp(ruby_extend_name,"Thread")!=0)
      section=jtrailer_nothread;
  }
  for (i = 0; section[i]; ++i){
    ++outline;
    if (strncmp(section[i],"@RUBY@",6)==0){
      fprintf(fp,&(section[i][6]),ruby_class_name);
    }
    else if (strncmp(section[i],"@RUBYX@",7)==0){
      fprintf(fp,&(section[i][7]),ruby_class_name);
      if (ruby_extend_name[0]!='\0'){
        fprintf(fp," < %s",ruby_extend_name);
      };
      if (ruby_include_name[0]!='\0'){
        fprintf(fp,"\n  include %s",ruby_include_name);
      };
      fprintf(fp,"\n");
    }
    else{
      fprintf(fp, "%s\n", section[i]);
    };
  };
};
