10 PRINT "FEDERAL WITHHOLDING TAXES"
20 PRINT
27 REM - THE FOLLOWING DATA CONTAINS THE TAX TABLES FROM IRS CIRCULAR
28 REM - E, PERCENTAGE METHOD, TABLE 7 (ANNUAL PAYROLL PERIOD)
29 REM - FOR SINGLE PERSONS
30 DATA 16,1300,20,3500,23,6000,21,9500,26,12500,30,14500,36,18000
39 REM - FOR MARRIED PERSONS
40 DATA 17,2500,20,5000,17,9000,25,13750,28,18000,32,22500,36,26000
49 REM - F1=FICA RATE AS DECIMAL
50 F1=.0585
59 REM - F2=FICA CUTOFF AMOUNT
60 F2=16500
69 REM - W1=AMOUNT OF WITHHOLDING ALLOWANCE (ANNUAL PAYROLL)
70 W1=750
79 REM - N=NUMBER OF PAY PERIODS PER YEAR
80 N=12
89 REM - LOAD THE TAX TABLE ARRAYS FROM DATA TABLES
90 DIM F9(28)
100 FOR I=1 TO 28
110 READ F9(I)
120 NEXT I
130 PRINT
139 REM - STATEMENTS 140 TO 210 REQUEST PERTINENT EMPLOYEE DATA
140 PRINT "MARITAL STATUS (1=SINGLE, 2=MARRIED)";
150 INPUT S
160 PRINT "WITHHOLDING TAX EXEMPTIONS";
170 INPUT W
180 PRINT "TAXABLE PAY";
190 INPUT P
199 REM - Y=TOTAL TAXABLE PAY THIS YEAR, EXCLUDING CURRENT PAYCHECK
200 PRINT "YTD TAXABLE  PAY";
210 INPUT Y
219 REM - ANNUALIZE CURRENT TAXABLE PAY, ADJUST FOR EXEMPTIONS
220 G=P*N-W1*W
230 T1=0
239 REM - CALCULATE INCOME TAX
240 FOR I=2 TO 7
250 X=2*I+14*(S-1)-1
260 IF G<=F9(X-1) THEN 330
270 IF G>F9(X+1) THEN 300
280 T1=T1+(G-F9(X-1))*F9(X-2)/100
290 GOTO 330
300 T1=T1+(F9(X+1)-F9(X-1))*F9(X-2)/100
310 NEXT I
315 T1=T1+(G-F9(X+1))*F9(X)/100
320 T1=T1+(G-F9(X+1))*F9(X)/100
329 REM - ROUND OFF TO NEAREST CENT
330 T1=INT((T1/N)*100+.5)/100
340 T2=0
349 REM - CALCULATE FICA
350 IF Y>F2 THEN 400
360 IF Y+P>F2 THEN 390
370 T2=INT((P*F1)*100+.5)/100
380 GOTO 400
389 REM - ROUND OFF TO NEAREST CENT
390 T2=INT(((F2-Y)*F1)*100+.5)/100
399 REM - PRINT RESULTS
400 PRINT "TAXABLE = $";P
410 PRINT "INCOME TAX = $";T1
420 PRINT "FICA = $";T2
430 PRINT
439 REM - RESTART OR END PROGRAM?
440 PRINT "MORE DATA (1=YES, 0=NO)";
450 INPUT S
460 IF S=1 THEN 130
470 END
900 REM ----------------------
910 REM Changes for bwBASIC
920 REM renamed F1() to F9()
999 END
