REM ------------------------------------------------------------
REM   PURPOSE: TEST THE PARAMETER RANGE CHECKS
REM    AUTHOR: HOWARD WULF, AF5NE
REM GENERATED: 02/21/2015 14:08:18
REM  FILENAME: F_COT_X_N.BAS
REM    SYNTAX: N  = COT( X )
REM  UNIQUEID: F_COT_X_N
REM  FUNCTION: COT
REM 
REM	VARIABLE	DESCRIPTION
REM	I	CURRENT  TESTCASE NUMBER
REM	E	EXPECTED ERROR FLAG
REM	F	ACTUAL   ERROR FLAG
REM	R	EXPECTED FUNCTION RESULT
REM	N	ACTUAL   FUNCTION RESULT
REM	X	ACTUAL   FUNCTION PARAMETER
REM 
RESTORE 2000
REM GET TESTCASE #
READ  I
WHILE I > 0
REM GET TESTCASE DATA
READ  E, R, X
REM DISPLAY TESTCASE DATA
PRINT "TESTCASE #";I,"E=";E,"R=";R, "X=";X
REM EXECUTE TESTCASE
N =  0 
S$ = ""
ON ERROR GOTO 9000
F = 0
999 N  = COT( X )
ERROR 0
REM DISPLAY TESTCASE RESULTS
PRINT ,"F=";F,"N=";N
REM VERIFY EXPECTED ERROR
IF E <> F THEN
  PRINT "*** TEST FAILED, EXCEPTION MISMATCH ***"
  STOP
END IF
REM VERIFY EXPECTED RESULT
IF R > 0 THEN
  LET RMIN = 0.99 * R
  IF R > MAXNUM / 1.012 THEN
    LET RMAX = MAXNUM
  ELSE
    LET RMAX = 1.01 * R
  END IF
END IF
IF R < 0 THEN
  IF R < - MAXNUM / 1.012 THEN
    LET RMIN = -MAXNUM
  ELSE
    LET RMIN = 1.01 * R
  END IF
  LET RMAX = 0.99 * R
END IF
IF R = 0 THEN
  LET RMIN = -.01
  LET RMAX = +.01
END IF
IF N < RMIN THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
IF N > RMAX THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
PRINT "*** TEST PASSED ***"
REM GET NEXT TESTCASE #
READ  I
WEND
PRINT "*** ALL TESTS PASSED ***"
GOTO 9999
1999 REM TESTCASE, EXPECTED ERROR, EXPECTED RESULT, PARAMETERS...
DATA  1 ,  1 ,  0 ,  0 
DATA  2 ,  0 ,  .642093 ,  1 
DATA  3 ,  0 , -.642093 , -1 
DATA  4 ,  0 ,  2.36522 ,  .4 
DATA  5 ,  0 , -2.36522 , -.4 
DATA  6 ,  0 ,  1.4617 ,  .6 
DATA  7 ,  0 , -1.4617 , -.6 
DATA  8 ,  0 , -1.9735 ,  254 
DATA  9 ,  0 ,  1.70284 ,  255 
DATA  10 ,  0 ,  3.98223E-2 ,  256 
DATA  11 ,  0 , -3.71762 ,  32000 
DATA  12 ,  0 , -4.32484 , -.227229 
DATA  13 ,  0 , -4.10133 , -.239157 
DATA  14 ,  0 , -4.61054 , -.213586 
DATA  15 ,  0 ,  3.54864 ,  .274675 
DATA  16 ,  0 ,  5.83376 ,  .169766 
DATA  17 ,  0 ,  3.03012 ,  .318766 
DATA  18 ,  0 ,  48.3822 ,  2.06658E-2 
DATA  19 ,  0 ,  5.24899 ,  .188257 
DATA  20 ,  0 , -3.51013 , -.277537 
DATA  21 ,  0 , -1.91473 , -.481303 
DATA  22 ,  0 ,  2.14884 ,  .43556 
DATA  23 ,  0 , -4.66945 , -.210971 
DATA  24 ,  0 , -2.04288 , -.455216 
DATA  25 ,  0 , -.713214 , -110.907 
DATA  26 ,  0 , -.409473 ,  105.632 
DATA  27 ,  0 , -.339323 , -114.341 
DATA  28 ,  0 , -3.92052 ,  109.706 
DATA  29 ,  0 , -1.0569 ,  109.198 
DATA  30 ,  0 ,  .567921 ,  85.8773 
DATA  31 ,  0 ,  .239779 , -58.3548 
DATA  32 ,  0 ,  .20837 ,  29.6397 
DATA  33 ,  0 , -2.49517E-2 , -108.36 
DATA  34 ,  0 ,  1.44925 , -46.5199 
DATA  35 ,  0 , -1.5386 ,  112.521 
DATA  36 ,  0 ,  .138876 ,  45.4151 
DATA  37 ,  0 ,  1.46788 ,  101.129 
DATA  38 ,  0 , -.751798 ,  65.0473 
DATA  39 ,  0 ,  .302213 ,  48.4012 
DATA  40 ,  0 , -4.30748 ,  122.294 
DATA  41 ,  0 ,  2.12817 , -56.1094 
DATA  42 ,  0 ,  .136522 , -121.087 
DATA  43 ,  0 , -.649338 , -123.517 
DATA  44 ,  0 , -4.07352 , -97.6301 
DATA  45 ,  0 , -.425802 , -64.0001 
DATA  46 ,  0 , -1.60908 , -25.6888 
DATA  47 ,  0 , -.781621 ,  14.8006 
DATA  48 ,  0 , -.175114 , -61.0877 
DATA  49 ,  0 , -1.27618 , -66.6381 
DATA  50 ,  0 , -1.17764 , -5476.5 
DATA  51 ,  0 , -.164254 , -21210.3 
DATA  52 ,  0 ,  .731638 , -28757.2 
DATA  53 ,  0 ,  .958836 , -28732.2 
DATA  54 ,  0 ,  1.57199 ,  12730.3 
DATA  55 ,  0 ,  .8635 , -1830.69 
DATA  56 ,  0 ,  .424644 ,  5486.39 
DATA  57 ,  0 ,  16.3209 ,  22405.9 
DATA  58 ,  0 ,  4.9118 ,  30809.8 
DATA  59 ,  0 ,  2.95077 , -28930.6 
DATA  60 ,  0 , -4.91749E-2 , -6014.53 
DATA  61 ,  0 ,  1.0693 ,  17414.6 
DATA  62 ,  0 , -.17429 , -10538.3 
DATA  63 ,  0 ,  14.2232 , -17536.3 
DATA  64 ,  0 , -1.96713 , -8856.62 
DATA  65 ,  0 , -1.94728 , -5140.12 
DATA  66 ,  0 ,  11.3994 , -8595.31 
DATA  67 ,  0 ,  1.38519 , -3382.87 
DATA  68 ,  0 , -1.30323 , -5002.07 
DATA  69 ,  0 , -.235024 , -5800.72 
DATA  70 ,  0 ,  7.99498E-2 ,  29686.4 
DATA  71 ,  0 ,  .415254 ,  2571. 
DATA  72 ,  0 , -.232355 ,  31091. 
DATA  73 ,  0 ,  9.27055 ,  14819. 
DATA  74 ,  0 , -.638803 ,  3790.9 
DATA  75 ,  0 ,  1.43769 , -4.2981E+9 
DATA  76 ,  0 , -2.15999 , -7.05453E+8 
DATA  77 ,  0 ,  2.23381 , -3.10179E+9 
DATA  78 ,  0 ,  .230976 , -4.86159E+9 
DATA  79 ,  0 , -.898042 , -8.62908E+8 
DATA  80 ,  0 ,  2.42162 , -3.4101E+9 
DATA  81 ,  0 ,  .784532 ,  3.3889E+9 
DATA  82 ,  0 ,  .953851 ,  2.49826E+9 
DATA  83 ,  0 , -.449034 ,  2.3491E+9 
DATA  84 ,  0 , -1.2471 ,  1.94745E+8 
DATA  85 ,  0 ,  6.23385 ,  2.02475E+9 
DATA  86 ,  0 ,  .848779 , -2.26748E+9 
DATA  87 ,  0 , -17.8045 , -2.10587E+9 
DATA  88 ,  0 ,  .35432 ,  4.23585E+9 
DATA  89 ,  0 , -6.00957 , -2.66524E+9 
DATA  90 ,  0 , -.926233 ,  4.01052E+9 
DATA  91 ,  0 ,  2.45903 , -4.87912E+9 
DATA  92 ,  0 , -3.92629E-2 ,  1.77556E+9 
DATA  93 ,  0 , -1.41819 ,  2.87705E+8 
DATA  94 ,  0 ,  2.79479 ,  1.99977E+8 
DATA  95 ,  0 , -1.45136 , -3.39941E+9 
DATA  96 ,  0 ,  .14549 , -3.49119E+9 
DATA  97 ,  0 ,  5.30698E-2 , -2.86324E+9 
DATA  98 ,  0 ,  .745094 ,  4.20418E+9 
DATA  99 ,  0 , -.859138 , -3.1518E+9 
DATA  100 ,  0 ,  1.02889 ,  4.60615E+9 
DATA 0
9000 REM ERROR HANDLER
IF ERL = 999 THEN
  F = ABS(SGN(ERR))
  RESUME NEXT
END IF
PRINT "*** UNEXPECTED ERROR ON LINE ";ERL;" ***"
9999 END
