10 REM Solar Surface Oscillations
20 REM SOLAROSC.BAS by John Kennewell
30 DIM P(200)
40 SCREEN 12: PH=1.570795: MX=0
50 RD=1: GN=256: BL=65536!
60 PRINT "Solar Oscillation Modes"
70 INPUT "Degree L [0 to 28]";L
80 INPUT "Order M [0 to L ]";M
90 REM Generate Legendre function
100 FOR XI=0 TO 200
110 X=(XI-100)/100: D=SQR(1-X*X)
120 P1=D^L: P2=0
130 FOR LI=1 TO (2*L-1) STEP 2
140 P1=P1*LI: NEXT LI
150 IF M>=L OR P1=0 THEN 200
160 FOR MI=L-1 TO M STEP -1
170 PM=2*(MI+1)*X*P1/D-P2
180 PM=PM/(L-MI)/(L+MI+1)
190 P2=P1: P1=PM: NEXT MI
200 P(XI)=P1: MT=ABS(P1)
210 IF MT>MX THEN MX=MT
220 NEXT XI
230 CLS : COLOR 1: LOCATE 2,3
240 PRINT "Solar Global Oscillations"
250 LOCATE 28,3
260 PRINT "MODE : L ="; L;" M =";M
270 REM Show color palette
280 FOR I=1 TO 15
290 LINE (600,-15+30*I)-(620,15+30*I),I,BF
300 RC=RD*INT((15-I)*4.5)
310 BC=BL*INT((I-1)*4.5)
320 GC=GN*INT((7-ABS(8-I))*4.5)
330 PALETTE I,RC+BC+GC: NEXT I
340 REM Plotting
350 FOR CT=-1 TO 1 STEP .005
360 ST=SQR(1-CT*CT)
370 PM=P(CT*100+100)/MX
380 FOR SF=-1 TO 1 STEP .005
390 CF=SQR(1-SF*SF)
400 FI=PH*SGN(SF)
410 IF CF<>0 THEN FI=ATN(SF/CF)
420 S=PM*COS(M*FI)*ST*CF
430 X%=300+200*SF*ST
440 Y%=240-200*CT
450 PSET (X%,Y%),8-7*S
460 NEXT SF: NEXT CT: END
