// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/display.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DisplayOrganizationElementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// which elements should be displayed.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *DisplayOrganizationElementsRequest) Reset() {
	*x = DisplayOrganizationElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOrganizationElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOrganizationElementsRequest) ProtoMessage() {}

func (x *DisplayOrganizationElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayOrganizationElementsRequest.ProtoReflect.Descriptor instead.
func (*DisplayOrganizationElementsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{0}
}

func (x *DisplayOrganizationElementsRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type DisplayOrganizationElementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display create organization repository element if true.
	CreateRepository bool `protobuf:"varint,1,opt,name=create_repository,json=createRepository,proto3" json:"create_repository,omitempty"`
	// Display organization settings element if true.
	Settings bool `protobuf:"varint,4,opt,name=settings,proto3" json:"settings,omitempty"`
	// Display update organization settings element if true.
	UpdateSettings bool `protobuf:"varint,5,opt,name=update_settings,json=updateSettings,proto3" json:"update_settings,omitempty"`
	// Display delete organization element if true.
	Delete bool `protobuf:"varint,6,opt,name=delete,proto3" json:"delete,omitempty"`
}

func (x *DisplayOrganizationElementsResponse) Reset() {
	*x = DisplayOrganizationElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOrganizationElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOrganizationElementsResponse) ProtoMessage() {}

func (x *DisplayOrganizationElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayOrganizationElementsResponse.ProtoReflect.Descriptor instead.
func (*DisplayOrganizationElementsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{1}
}

func (x *DisplayOrganizationElementsResponse) GetCreateRepository() bool {
	if x != nil {
		return x.CreateRepository
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) GetSettings() bool {
	if x != nil {
		return x.Settings
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) GetUpdateSettings() bool {
	if x != nil {
		return x.UpdateSettings
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) GetDelete() bool {
	if x != nil {
		return x.Delete
	}
	return false
}

type DisplayRepositoryElementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// which elements should be displayed.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *DisplayRepositoryElementsRequest) Reset() {
	*x = DisplayRepositoryElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryElementsRequest) ProtoMessage() {}

func (x *DisplayRepositoryElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayRepositoryElementsRequest.ProtoReflect.Descriptor instead.
func (*DisplayRepositoryElementsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{2}
}

func (x *DisplayRepositoryElementsRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type DisplayRepositoryElementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display repository settings element if true.
	Settings bool `protobuf:"varint,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// Display delete repository element if true.
	Delete bool `protobuf:"varint,2,opt,name=delete,proto3" json:"delete,omitempty"`
	// Display write repository elements if true. It includes all elements from limited_write.
	Write bool `protobuf:"varint,3,opt,name=write,proto3" json:"write,omitempty"`
	// Display limited_write repository elements if true. This is a subset of write elements.
	LimitedWrite bool `protobuf:"varint,4,opt,name=limited_write,json=limitedWrite,proto3" json:"limited_write,omitempty"`
}

func (x *DisplayRepositoryElementsResponse) Reset() {
	*x = DisplayRepositoryElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryElementsResponse) ProtoMessage() {}

func (x *DisplayRepositoryElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayRepositoryElementsResponse.ProtoReflect.Descriptor instead.
func (*DisplayRepositoryElementsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{3}
}

func (x *DisplayRepositoryElementsResponse) GetSettings() bool {
	if x != nil {
		return x.Settings
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) GetDelete() bool {
	if x != nil {
		return x.Delete
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) GetWrite() bool {
	if x != nil {
		return x.Write
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) GetLimitedWrite() bool {
	if x != nil {
		return x.LimitedWrite
	}
	return false
}

type DisplayUserElementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisplayUserElementsRequest) Reset() {
	*x = DisplayUserElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayUserElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayUserElementsRequest) ProtoMessage() {}

func (x *DisplayUserElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayUserElementsRequest.ProtoReflect.Descriptor instead.
func (*DisplayUserElementsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{4}
}

type DisplayUserElementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display delete user element if true.
	Delete bool `protobuf:"varint,1,opt,name=delete,proto3" json:"delete,omitempty"`
}

func (x *DisplayUserElementsResponse) Reset() {
	*x = DisplayUserElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayUserElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayUserElementsResponse) ProtoMessage() {}

func (x *DisplayUserElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayUserElementsResponse.ProtoReflect.Descriptor instead.
func (*DisplayUserElementsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{5}
}

func (x *DisplayUserElementsResponse) GetDelete() bool {
	if x != nil {
		return x.Delete
	}
	return false
}

type DisplayServerElementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisplayServerElementsRequest) Reset() {
	*x = DisplayServerElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayServerElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayServerElementsRequest) ProtoMessage() {}

func (x *DisplayServerElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayServerElementsRequest.ProtoReflect.Descriptor instead.
func (*DisplayServerElementsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{6}
}

type DisplayServerElementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display server admin panel element if true.
	AdminPanel bool `protobuf:"varint,1,opt,name=admin_panel,json=adminPanel,proto3" json:"admin_panel,omitempty"`
}

func (x *DisplayServerElementsResponse) Reset() {
	*x = DisplayServerElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayServerElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayServerElementsResponse) ProtoMessage() {}

func (x *DisplayServerElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayServerElementsResponse.ProtoReflect.Descriptor instead.
func (*DisplayServerElementsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{7}
}

func (x *DisplayServerElementsResponse) GetAdminPanel() bool {
	if x != nil {
		return x.AdminPanel
	}
	return false
}

type DisplayOwnerEntitledElementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the owner for which to check
	// which elements are entitled to be displayed.
	OwnerName string `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
}

func (x *DisplayOwnerEntitledElementsRequest) Reset() {
	*x = DisplayOwnerEntitledElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOwnerEntitledElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOwnerEntitledElementsRequest) ProtoMessage() {}

func (x *DisplayOwnerEntitledElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayOwnerEntitledElementsRequest.ProtoReflect.Descriptor instead.
func (*DisplayOwnerEntitledElementsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{8}
}

func (x *DisplayOwnerEntitledElementsRequest) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

type DisplayOwnerEntitledElementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display create private repository element if true.
	CreatePrivateRepository bool `protobuf:"varint,1,opt,name=create_private_repository,json=createPrivateRepository,proto3" json:"create_private_repository,omitempty"`
}

func (x *DisplayOwnerEntitledElementsResponse) Reset() {
	*x = DisplayOwnerEntitledElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOwnerEntitledElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOwnerEntitledElementsResponse) ProtoMessage() {}

func (x *DisplayOwnerEntitledElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayOwnerEntitledElementsResponse.ProtoReflect.Descriptor instead.
func (*DisplayOwnerEntitledElementsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{9}
}

func (x *DisplayOwnerEntitledElementsResponse) GetCreatePrivateRepository() bool {
	if x != nil {
		return x.CreatePrivateRepository
	}
	return false
}

type DisplayRepositoryEntitledElementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// which elements are entitled to be displayed.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *DisplayRepositoryEntitledElementsRequest) Reset() {
	*x = DisplayRepositoryEntitledElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryEntitledElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryEntitledElementsRequest) ProtoMessage() {}

func (x *DisplayRepositoryEntitledElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayRepositoryEntitledElementsRequest.ProtoReflect.Descriptor instead.
func (*DisplayRepositoryEntitledElementsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{10}
}

func (x *DisplayRepositoryEntitledElementsRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type DisplayRepositoryEntitledElementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display repository change to private setting element if true.
	SetPrivate bool `protobuf:"varint,1,opt,name=set_private,json=setPrivate,proto3" json:"set_private,omitempty"`
}

func (x *DisplayRepositoryEntitledElementsResponse) Reset() {
	*x = DisplayRepositoryEntitledElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryEntitledElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryEntitledElementsResponse) ProtoMessage() {}

func (x *DisplayRepositoryEntitledElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayRepositoryEntitledElementsResponse.ProtoReflect.Descriptor instead.
func (*DisplayRepositoryEntitledElementsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{11}
}

func (x *DisplayRepositoryEntitledElementsResponse) GetSetPrivate() bool {
	if x != nil {
		return x.SetPrivate
	}
	return false
}

type ListManageableRepositoryRolesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// which roles should be displayed as manageable.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *ListManageableRepositoryRolesRequest) Reset() {
	*x = ListManageableRepositoryRolesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableRepositoryRolesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableRepositoryRolesRequest) ProtoMessage() {}

func (x *ListManageableRepositoryRolesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManageableRepositoryRolesRequest.ProtoReflect.Descriptor instead.
func (*ListManageableRepositoryRolesRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{12}
}

func (x *ListManageableRepositoryRolesRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type ListManageableRepositoryRolesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of roles that should be displayed
	// to the user as manageable.
	Roles []RepositoryRole `protobuf:"varint,1,rep,packed,name=roles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"roles,omitempty"`
}

func (x *ListManageableRepositoryRolesResponse) Reset() {
	*x = ListManageableRepositoryRolesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableRepositoryRolesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableRepositoryRolesResponse) ProtoMessage() {}

func (x *ListManageableRepositoryRolesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManageableRepositoryRolesResponse.ProtoReflect.Descriptor instead.
func (*ListManageableRepositoryRolesResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{13}
}

func (x *ListManageableRepositoryRolesResponse) GetRoles() []RepositoryRole {
	if x != nil {
		return x.Roles
	}
	return nil
}

type ListManageableUserRepositoryRolesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// which roles should be displayed as manageable.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// The ID of the target user for which to check
	// which roles are manageable.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
}

func (x *ListManageableUserRepositoryRolesRequest) Reset() {
	*x = ListManageableUserRepositoryRolesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableUserRepositoryRolesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableUserRepositoryRolesRequest) ProtoMessage() {}

func (x *ListManageableUserRepositoryRolesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManageableUserRepositoryRolesRequest.ProtoReflect.Descriptor instead.
func (*ListManageableUserRepositoryRolesRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{14}
}

func (x *ListManageableUserRepositoryRolesRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *ListManageableUserRepositoryRolesRequest) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

type ListManageableUserRepositoryRolesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of roles that should be displayed
	// to the user as manageable.
	Roles []RepositoryRole `protobuf:"varint,1,rep,packed,name=roles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"roles,omitempty"`
}

func (x *ListManageableUserRepositoryRolesResponse) Reset() {
	*x = ListManageableUserRepositoryRolesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableUserRepositoryRolesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableUserRepositoryRolesResponse) ProtoMessage() {}

func (x *ListManageableUserRepositoryRolesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManageableUserRepositoryRolesResponse.ProtoReflect.Descriptor instead.
func (*ListManageableUserRepositoryRolesResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP(), []int{15}
}

func (x *ListManageableUserRepositoryRolesResponse) GetRoles() []RepositoryRole {
	if x != nil {
		return x.Roles
	}
	return nil
}

var File_buf_alpha_registry_v1alpha1_display_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_display_proto_rawDesc = []byte{
	0x0a, 0x29, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x4d, 0x0a, 0x22, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22,
	0xdb, 0x01, 0x0a, 0x23, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x52, 0x0d, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x47, 0x0a,
	0x20, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x92, 0x01, 0x0a, 0x21, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65,
	0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x73, 0x65, 0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x35, 0x0a, 0x1b, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x55, 0x73, 0x65, 0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x22, 0x1e, 0x0a, 0x1c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0x40, 0x0a, 0x1d, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x6e, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e,
	0x65, 0x6c, 0x22, 0x44, 0x0a, 0x23, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x77, 0x6e,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x24, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64,
	0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3a, 0x0a, 0x19, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x17, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x4f, 0x0a, 0x28,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x4c, 0x0a,
	0x29, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65,
	0x74, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x73, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x22, 0x4b, 0x0a, 0x24, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x6a, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x05, 0x72,
	0x6f, 0x6c, 0x65, 0x73, 0x22, 0x68, 0x0a, 0x28, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x22, 0x6e,
	0x0a, 0x29, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x05, 0x72,
	0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x32, 0xcd,
	0x0a, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xa5, 0x01, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x40, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x9f, 0x01, 0x0a, 0x19, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x45,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x13,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x73, 0x65, 0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x73, 0x65, 0x72, 0x45, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x55, 0x73, 0x65, 0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x93, 0x01, 0x0a, 0x15,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02,
	0x01, 0x12, 0xa8, 0x01, 0x0a, 0x1c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x77, 0x6e,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x40, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xb7, 0x01, 0x0a,
	0x21, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x45, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xab, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0xb7, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x45, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x46, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x99,
	0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x42, 0x0c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62,
	0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03,
	0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2,
	0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50,
	0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a,
	0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_display_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_display_proto_rawDescData = file_buf_alpha_registry_v1alpha1_display_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_display_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_display_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_display_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_display_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_display_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_display_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_buf_alpha_registry_v1alpha1_display_proto_goTypes = []any{
	(*DisplayOrganizationElementsRequest)(nil),        // 0: buf.alpha.registry.v1alpha1.DisplayOrganizationElementsRequest
	(*DisplayOrganizationElementsResponse)(nil),       // 1: buf.alpha.registry.v1alpha1.DisplayOrganizationElementsResponse
	(*DisplayRepositoryElementsRequest)(nil),          // 2: buf.alpha.registry.v1alpha1.DisplayRepositoryElementsRequest
	(*DisplayRepositoryElementsResponse)(nil),         // 3: buf.alpha.registry.v1alpha1.DisplayRepositoryElementsResponse
	(*DisplayUserElementsRequest)(nil),                // 4: buf.alpha.registry.v1alpha1.DisplayUserElementsRequest
	(*DisplayUserElementsResponse)(nil),               // 5: buf.alpha.registry.v1alpha1.DisplayUserElementsResponse
	(*DisplayServerElementsRequest)(nil),              // 6: buf.alpha.registry.v1alpha1.DisplayServerElementsRequest
	(*DisplayServerElementsResponse)(nil),             // 7: buf.alpha.registry.v1alpha1.DisplayServerElementsResponse
	(*DisplayOwnerEntitledElementsRequest)(nil),       // 8: buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsRequest
	(*DisplayOwnerEntitledElementsResponse)(nil),      // 9: buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsResponse
	(*DisplayRepositoryEntitledElementsRequest)(nil),  // 10: buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsRequest
	(*DisplayRepositoryEntitledElementsResponse)(nil), // 11: buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsResponse
	(*ListManageableRepositoryRolesRequest)(nil),      // 12: buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesRequest
	(*ListManageableRepositoryRolesResponse)(nil),     // 13: buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse
	(*ListManageableUserRepositoryRolesRequest)(nil),  // 14: buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesRequest
	(*ListManageableUserRepositoryRolesResponse)(nil), // 15: buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse
	(RepositoryRole)(0),                               // 16: buf.alpha.registry.v1alpha1.RepositoryRole
}
var file_buf_alpha_registry_v1alpha1_display_proto_depIdxs = []int32{
	16, // 0: buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse.roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	16, // 1: buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse.roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	0,  // 2: buf.alpha.registry.v1alpha1.DisplayService.DisplayOrganizationElements:input_type -> buf.alpha.registry.v1alpha1.DisplayOrganizationElementsRequest
	2,  // 3: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryElements:input_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryElementsRequest
	4,  // 4: buf.alpha.registry.v1alpha1.DisplayService.DisplayUserElements:input_type -> buf.alpha.registry.v1alpha1.DisplayUserElementsRequest
	6,  // 5: buf.alpha.registry.v1alpha1.DisplayService.DisplayServerElements:input_type -> buf.alpha.registry.v1alpha1.DisplayServerElementsRequest
	8,  // 6: buf.alpha.registry.v1alpha1.DisplayService.DisplayOwnerEntitledElements:input_type -> buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsRequest
	10, // 7: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryEntitledElements:input_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsRequest
	12, // 8: buf.alpha.registry.v1alpha1.DisplayService.ListManageableRepositoryRoles:input_type -> buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesRequest
	14, // 9: buf.alpha.registry.v1alpha1.DisplayService.ListManageableUserRepositoryRoles:input_type -> buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesRequest
	1,  // 10: buf.alpha.registry.v1alpha1.DisplayService.DisplayOrganizationElements:output_type -> buf.alpha.registry.v1alpha1.DisplayOrganizationElementsResponse
	3,  // 11: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryElements:output_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryElementsResponse
	5,  // 12: buf.alpha.registry.v1alpha1.DisplayService.DisplayUserElements:output_type -> buf.alpha.registry.v1alpha1.DisplayUserElementsResponse
	7,  // 13: buf.alpha.registry.v1alpha1.DisplayService.DisplayServerElements:output_type -> buf.alpha.registry.v1alpha1.DisplayServerElementsResponse
	9,  // 14: buf.alpha.registry.v1alpha1.DisplayService.DisplayOwnerEntitledElements:output_type -> buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsResponse
	11, // 15: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryEntitledElements:output_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsResponse
	13, // 16: buf.alpha.registry.v1alpha1.DisplayService.ListManageableRepositoryRoles:output_type -> buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse
	15, // 17: buf.alpha.registry.v1alpha1.DisplayService.ListManageableUserRepositoryRoles:output_type -> buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse
	10, // [10:18] is the sub-list for method output_type
	2,  // [2:10] is the sub-list for method input_type
	2,  // [2:2] is the sub-list for extension type_name
	2,  // [2:2] is the sub-list for extension extendee
	0,  // [0:2] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_display_proto_init() }
func file_buf_alpha_registry_v1alpha1_display_proto_init() {
	if File_buf_alpha_registry_v1alpha1_display_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_display_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_display_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_display_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_display_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_display_proto = out.File
	file_buf_alpha_registry_v1alpha1_display_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_display_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_display_proto_depIdxs = nil
}
