// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/authz.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UserCanCreateOrganizationRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *UserCanCreateOrganizationRepositoryRequest) Reset() {
	*x = UserCanCreateOrganizationRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanCreateOrganizationRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanCreateOrganizationRepositoryRequest) ProtoMessage() {}

func (x *UserCanCreateOrganizationRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanCreateOrganizationRepositoryRequest.ProtoReflect.Descriptor instead.
func (*UserCanCreateOrganizationRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{0}
}

func (x *UserCanCreateOrganizationRepositoryRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type UserCanCreateOrganizationRepositoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanCreateOrganizationRepositoryResponse) Reset() {
	*x = UserCanCreateOrganizationRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanCreateOrganizationRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanCreateOrganizationRepositoryResponse) ProtoMessage() {}

func (x *UserCanCreateOrganizationRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanCreateOrganizationRepositoryResponse.ProtoReflect.Descriptor instead.
func (*UserCanCreateOrganizationRepositoryResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{1}
}

func (x *UserCanCreateOrganizationRepositoryResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanSeeRepositorySettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *UserCanSeeRepositorySettingsRequest) Reset() {
	*x = UserCanSeeRepositorySettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeRepositorySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeRepositorySettingsRequest) ProtoMessage() {}

func (x *UserCanSeeRepositorySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanSeeRepositorySettingsRequest.ProtoReflect.Descriptor instead.
func (*UserCanSeeRepositorySettingsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{2}
}

func (x *UserCanSeeRepositorySettingsRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type UserCanSeeRepositorySettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanSeeRepositorySettingsResponse) Reset() {
	*x = UserCanSeeRepositorySettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeRepositorySettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeRepositorySettingsResponse) ProtoMessage() {}

func (x *UserCanSeeRepositorySettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanSeeRepositorySettingsResponse.ProtoReflect.Descriptor instead.
func (*UserCanSeeRepositorySettingsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{3}
}

func (x *UserCanSeeRepositorySettingsResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanSeeOrganizationSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *UserCanSeeOrganizationSettingsRequest) Reset() {
	*x = UserCanSeeOrganizationSettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeOrganizationSettingsRequest) ProtoMessage() {}

func (x *UserCanSeeOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanSeeOrganizationSettingsRequest.ProtoReflect.Descriptor instead.
func (*UserCanSeeOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{4}
}

func (x *UserCanSeeOrganizationSettingsRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type UserCanSeeOrganizationSettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanSeeOrganizationSettingsResponse) Reset() {
	*x = UserCanSeeOrganizationSettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeOrganizationSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeOrganizationSettingsResponse) ProtoMessage() {}

func (x *UserCanSeeOrganizationSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanSeeOrganizationSettingsResponse.ProtoReflect.Descriptor instead.
func (*UserCanSeeOrganizationSettingsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{5}
}

func (x *UserCanSeeOrganizationSettingsResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanAddOrganizationMemberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *UserCanAddOrganizationMemberRequest) Reset() {
	*x = UserCanAddOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanAddOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanAddOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanAddOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanAddOrganizationMemberRequest.ProtoReflect.Descriptor instead.
func (*UserCanAddOrganizationMemberRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{6}
}

func (x *UserCanAddOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type UserCanAddOrganizationMemberResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of roles that the user is authorized to add, empty list means the user is
	// not authorized to add any members.
	AuthorizedRoles []OrganizationRole `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"authorized_roles,omitempty"`
}

func (x *UserCanAddOrganizationMemberResponse) Reset() {
	*x = UserCanAddOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanAddOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanAddOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanAddOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanAddOrganizationMemberResponse.ProtoReflect.Descriptor instead.
func (*UserCanAddOrganizationMemberResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{7}
}

func (x *UserCanAddOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.AuthorizedRoles
	}
	return nil
}

type UserCanUpdateOrganizationMemberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *UserCanUpdateOrganizationMemberRequest) Reset() {
	*x = UserCanUpdateOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanUpdateOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanUpdateOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanUpdateOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanUpdateOrganizationMemberRequest.ProtoReflect.Descriptor instead.
func (*UserCanUpdateOrganizationMemberRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{8}
}

func (x *UserCanUpdateOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type UserCanUpdateOrganizationMemberResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of roles that the user is authorized to update (from and to), empty list means the user is
	// not authorized to update any members' role.
	AuthorizedRoles []OrganizationRole `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"authorized_roles,omitempty"`
}

func (x *UserCanUpdateOrganizationMemberResponse) Reset() {
	*x = UserCanUpdateOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanUpdateOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanUpdateOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanUpdateOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanUpdateOrganizationMemberResponse.ProtoReflect.Descriptor instead.
func (*UserCanUpdateOrganizationMemberResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{9}
}

func (x *UserCanUpdateOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.AuthorizedRoles
	}
	return nil
}

type UserCanRemoveOrganizationMemberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *UserCanRemoveOrganizationMemberRequest) Reset() {
	*x = UserCanRemoveOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanRemoveOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanRemoveOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanRemoveOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanRemoveOrganizationMemberRequest.ProtoReflect.Descriptor instead.
func (*UserCanRemoveOrganizationMemberRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{10}
}

func (x *UserCanRemoveOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type UserCanRemoveOrganizationMemberResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of roles that the user is authorized to remove, empty list means the user is
	// not authorized to remove any members.
	AuthorizedRoles []OrganizationRole `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"authorized_roles,omitempty"`
}

func (x *UserCanRemoveOrganizationMemberResponse) Reset() {
	*x = UserCanRemoveOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanRemoveOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanRemoveOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanRemoveOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanRemoveOrganizationMemberResponse.ProtoReflect.Descriptor instead.
func (*UserCanRemoveOrganizationMemberResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{11}
}

func (x *UserCanRemoveOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.AuthorizedRoles
	}
	return nil
}

type UserCanDeleteOrganizationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
}

func (x *UserCanDeleteOrganizationRequest) Reset() {
	*x = UserCanDeleteOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteOrganizationRequest) ProtoMessage() {}

func (x *UserCanDeleteOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanDeleteOrganizationRequest.ProtoReflect.Descriptor instead.
func (*UserCanDeleteOrganizationRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{12}
}

func (x *UserCanDeleteOrganizationRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type UserCanDeleteOrganizationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanDeleteOrganizationResponse) Reset() {
	*x = UserCanDeleteOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteOrganizationResponse) ProtoMessage() {}

func (x *UserCanDeleteOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanDeleteOrganizationResponse.ProtoReflect.Descriptor instead.
func (*UserCanDeleteOrganizationResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{13}
}

func (x *UserCanDeleteOrganizationResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanDeleteRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *UserCanDeleteRepositoryRequest) Reset() {
	*x = UserCanDeleteRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteRepositoryRequest) ProtoMessage() {}

func (x *UserCanDeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanDeleteRepositoryRequest.ProtoReflect.Descriptor instead.
func (*UserCanDeleteRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{14}
}

func (x *UserCanDeleteRepositoryRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type UserCanDeleteRepositoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanDeleteRepositoryResponse) Reset() {
	*x = UserCanDeleteRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteRepositoryResponse) ProtoMessage() {}

func (x *UserCanDeleteRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanDeleteRepositoryResponse.ProtoReflect.Descriptor instead.
func (*UserCanDeleteRepositoryResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{15}
}

func (x *UserCanDeleteRepositoryResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanDeleteUserRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UserCanDeleteUserRequest) Reset() {
	*x = UserCanDeleteUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteUserRequest) ProtoMessage() {}

func (x *UserCanDeleteUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanDeleteUserRequest.ProtoReflect.Descriptor instead.
func (*UserCanDeleteUserRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{16}
}

type UserCanDeleteUserResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanDeleteUserResponse) Reset() {
	*x = UserCanDeleteUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteUserResponse) ProtoMessage() {}

func (x *UserCanDeleteUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanDeleteUserResponse.ProtoReflect.Descriptor instead.
func (*UserCanDeleteUserResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{17}
}

func (x *UserCanDeleteUserResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanSeeServerAdminPanelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UserCanSeeServerAdminPanelRequest) Reset() {
	*x = UserCanSeeServerAdminPanelRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeServerAdminPanelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeServerAdminPanelRequest) ProtoMessage() {}

func (x *UserCanSeeServerAdminPanelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanSeeServerAdminPanelRequest.ProtoReflect.Descriptor instead.
func (*UserCanSeeServerAdminPanelRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{18}
}

type UserCanSeeServerAdminPanelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanSeeServerAdminPanelResponse) Reset() {
	*x = UserCanSeeServerAdminPanelResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeServerAdminPanelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeServerAdminPanelResponse) ProtoMessage() {}

func (x *UserCanSeeServerAdminPanelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanSeeServerAdminPanelResponse.ProtoReflect.Descriptor instead.
func (*UserCanSeeServerAdminPanelResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{19}
}

func (x *UserCanSeeServerAdminPanelResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

type UserCanManageRepositoryContributorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *UserCanManageRepositoryContributorsRequest) Reset() {
	*x = UserCanManageRepositoryContributorsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanManageRepositoryContributorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanManageRepositoryContributorsRequest) ProtoMessage() {}

func (x *UserCanManageRepositoryContributorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanManageRepositoryContributorsRequest.ProtoReflect.Descriptor instead.
func (*UserCanManageRepositoryContributorsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{20}
}

func (x *UserCanManageRepositoryContributorsRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type UserCanManageRepositoryContributorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of roles that the user is authorized to manage, empty list means the user is
	// not authorized to manage any contributors.
	AuthorizedRoles []RepositoryRole `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"authorized_roles,omitempty"`
}

func (x *UserCanManageRepositoryContributorsResponse) Reset() {
	*x = UserCanManageRepositoryContributorsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanManageRepositoryContributorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanManageRepositoryContributorsResponse) ProtoMessage() {}

func (x *UserCanManageRepositoryContributorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanManageRepositoryContributorsResponse.ProtoReflect.Descriptor instead.
func (*UserCanManageRepositoryContributorsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{21}
}

func (x *UserCanManageRepositoryContributorsResponse) GetAuthorizedRoles() []RepositoryRole {
	if x != nil {
		return x.AuthorizedRoles
	}
	return nil
}

type UserCanReviewCommitsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *UserCanReviewCommitsRequest) Reset() {
	*x = UserCanReviewCommitsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanReviewCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanReviewCommitsRequest) ProtoMessage() {}

func (x *UserCanReviewCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanReviewCommitsRequest.ProtoReflect.Descriptor instead.
func (*UserCanReviewCommitsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{22}
}

func (x *UserCanReviewCommitsRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

type UserCanReviewCommitsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Authorized bool `protobuf:"varint,1,opt,name=authorized,proto3" json:"authorized,omitempty"`
}

func (x *UserCanReviewCommitsResponse) Reset() {
	*x = UserCanReviewCommitsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanReviewCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanReviewCommitsResponse) ProtoMessage() {}

func (x *UserCanReviewCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCanReviewCommitsResponse.ProtoReflect.Descriptor instead.
func (*UserCanReviewCommitsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP(), []int{23}
}

func (x *UserCanReviewCommitsResponse) GetAuthorized() bool {
	if x != nil {
		return x.Authorized
	}
	return false
}

var File_buf_alpha_registry_v1alpha1_authz_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc = []byte{
	0x0a, 0x27, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x7a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x55,
	0x0a, 0x2a, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x2b, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x22, 0x4a, 0x0a, 0x23, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53,
	0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64,
	0x22, 0x46, 0x0a, 0x24, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x50, 0x0a, 0x25, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x48, 0x0a, 0x26, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x22, 0x4e, 0x0a, 0x23, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41,
	0x64, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0x80, 0x01, 0x0a, 0x24, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x41, 0x64, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a,
	0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x51, 0x0a, 0x26, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x27, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73,
	0x22, 0x51, 0x0a, 0x26, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x27, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x58, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x4b, 0x0a, 0x20, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a,
	0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x43, 0x0a, 0x21, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x45, 0x0a, 0x1e, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x49, 0x64, 0x22, 0x41, 0x0a, 0x1f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x3b, 0x0a, 0x19, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x23,
	0x0a, 0x21, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x22, 0x44, 0x0a, 0x22, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x51, 0x0a, 0x2a, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x85, 0x01, 0x0a,
	0x2b, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x10,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x52,
	0x6f, 0x6c, 0x65, 0x73, 0x22, 0x42, 0x0a, 0x1b, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x3e, 0x0a, 0x1c, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x32, 0xfd, 0x0f, 0x0a, 0x0c, 0x41, 0x75, 0x74,
	0x68, 0x7a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x23, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x47, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xa8, 0x01, 0x0a, 0x1c, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x53, 0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x53, 0x65, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0xae, 0x01, 0x0a, 0x1e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x53, 0x65, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xa8, 0x01, 0x0a, 0x1c, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x41, 0x64, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x40, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41, 0x64, 0x64, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x41, 0x64,
	0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01,
	0x12, 0xb1, 0x01, 0x0a, 0x1f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x12, 0xb1, 0x01, 0x0a, 0x1f, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x9f, 0x01, 0x0a, 0x19, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x99, 0x01, 0x0a, 0x17, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x87, 0x01, 0x0a, 0x11, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x35, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43,
	0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01,
	0x12, 0xa2, 0x01, 0x0a, 0x1a, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x12,
	0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x6e, 0x53, 0x65, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x50, 0x61, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xbd, 0x01, 0x0a, 0x23, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x47, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x90, 0x01, 0x0a, 0x14, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61,
	0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x38,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x61, 0x6e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x97, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0a, 0x41, 0x75,
	0x74, 0x68, 0x7a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f,
	0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75,
	0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c,
	0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_authz_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_authz_proto_rawDescData = file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_authz_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_authz_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_authz_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_authz_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_authz_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_buf_alpha_registry_v1alpha1_authz_proto_goTypes = []any{
	(*UserCanCreateOrganizationRepositoryRequest)(nil),  // 0: buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest
	(*UserCanCreateOrganizationRepositoryResponse)(nil), // 1: buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse
	(*UserCanSeeRepositorySettingsRequest)(nil),         // 2: buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest
	(*UserCanSeeRepositorySettingsResponse)(nil),        // 3: buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse
	(*UserCanSeeOrganizationSettingsRequest)(nil),       // 4: buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest
	(*UserCanSeeOrganizationSettingsResponse)(nil),      // 5: buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse
	(*UserCanAddOrganizationMemberRequest)(nil),         // 6: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest
	(*UserCanAddOrganizationMemberResponse)(nil),        // 7: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse
	(*UserCanUpdateOrganizationMemberRequest)(nil),      // 8: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest
	(*UserCanUpdateOrganizationMemberResponse)(nil),     // 9: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse
	(*UserCanRemoveOrganizationMemberRequest)(nil),      // 10: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest
	(*UserCanRemoveOrganizationMemberResponse)(nil),     // 11: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse
	(*UserCanDeleteOrganizationRequest)(nil),            // 12: buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest
	(*UserCanDeleteOrganizationResponse)(nil),           // 13: buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse
	(*UserCanDeleteRepositoryRequest)(nil),              // 14: buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest
	(*UserCanDeleteRepositoryResponse)(nil),             // 15: buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse
	(*UserCanDeleteUserRequest)(nil),                    // 16: buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest
	(*UserCanDeleteUserResponse)(nil),                   // 17: buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse
	(*UserCanSeeServerAdminPanelRequest)(nil),           // 18: buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest
	(*UserCanSeeServerAdminPanelResponse)(nil),          // 19: buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse
	(*UserCanManageRepositoryContributorsRequest)(nil),  // 20: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest
	(*UserCanManageRepositoryContributorsResponse)(nil), // 21: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse
	(*UserCanReviewCommitsRequest)(nil),                 // 22: buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest
	(*UserCanReviewCommitsResponse)(nil),                // 23: buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse
	(OrganizationRole)(0),                               // 24: buf.alpha.registry.v1alpha1.OrganizationRole
	(RepositoryRole)(0),                                 // 25: buf.alpha.registry.v1alpha1.RepositoryRole
}
var file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs = []int32{
	24, // 0: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	24, // 1: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	24, // 2: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	25, // 3: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	0,  // 4: buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository:input_type -> buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest
	2,  // 5: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest
	4,  // 6: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest
	6,  // 7: buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest
	8,  // 8: buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest
	10, // 9: buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest
	12, // 10: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest
	14, // 11: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest
	16, // 12: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest
	18, // 13: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest
	20, // 14: buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors:input_type -> buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest
	22, // 15: buf.alpha.registry.v1alpha1.AuthzService.UserCanReviewCommits:input_type -> buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest
	1,  // 16: buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository:output_type -> buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse
	3,  // 17: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse
	5,  // 18: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse
	7,  // 19: buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse
	9,  // 20: buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse
	11, // 21: buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse
	13, // 22: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse
	15, // 23: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse
	17, // 24: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse
	19, // 25: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse
	21, // 26: buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors:output_type -> buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse
	23, // 27: buf.alpha.registry.v1alpha1.AuthzService.UserCanReviewCommits:output_type -> buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse
	16, // [16:28] is the sub-list for method output_type
	4,  // [4:16] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_authz_proto_init() }
func file_buf_alpha_registry_v1alpha1_authz_proto_init() {
	if File_buf_alpha_registry_v1alpha1_authz_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_authz_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_authz_proto = out.File
	file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_authz_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs = nil
}
