// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/audit/v1alpha1/event.proto

package auditv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ActorType is the type of actor that caused the audited event.
type ActorType int32

const (
	ActorType_ACTOR_TYPE_UNSPECIFIED ActorType = 0
	ActorType_ACTOR_TYPE_USER        ActorType = 1
	ActorType_ACTOR_TYPE_SYSTEM      ActorType = 2
)

// Enum value maps for ActorType.
var (
	ActorType_name = map[int32]string{
		0: "ACTOR_TYPE_UNSPECIFIED",
		1: "ACTOR_TYPE_USER",
		2: "ACTOR_TYPE_SYSTEM",
	}
	ActorType_value = map[string]int32{
		"ACTOR_TYPE_UNSPECIFIED": 0,
		"ACTOR_TYPE_USER":        1,
		"ACTOR_TYPE_SYSTEM":      2,
	}
)

func (x ActorType) Enum() *ActorType {
	p := new(ActorType)
	*p = x
	return p
}

func (x ActorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActorType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[0].Descriptor()
}

func (ActorType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[0]
}

func (x ActorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActorType.Descriptor instead.
func (ActorType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{0}
}

// ResourceType is the type of the resource that was affected by the audited
// event.
type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_UNSPECIFIED                ResourceType = 0
	ResourceType_RESOURCE_TYPE_USER                       ResourceType = 1
	ResourceType_RESOURCE_TYPE_ORGANIZATION               ResourceType = 2
	ResourceType_RESOURCE_TYPE_ORGANIZATION_MEMBER        ResourceType = 3
	ResourceType_RESOURCE_TYPE_ORGANIZATION_IDP_GROUP     ResourceType = 9
	ResourceType_RESOURCE_TYPE_REPOSITORY                 ResourceType = 4
	ResourceType_RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR     ResourceType = 5
	ResourceType_RESOURCE_TYPE_REPOSITORY_COMMIT          ResourceType = 6
	ResourceType_RESOURCE_TYPE_CURATED_PLUGIN             ResourceType = 8
	ResourceType_RESOURCE_TYPE_TOKEN                      ResourceType = 10
	ResourceType_RESOURCE_TYPE_SCIM_TOKEN                 ResourceType = 11
	ResourceType_RESOURCE_TYPE_REPOSITORY_LABEL           ResourceType = 12
	ResourceType_RESOURCE_TYPE_SERVER                     ResourceType = 13
	ResourceType_RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT ResourceType = 14
)

// Enum value maps for ResourceType.
var (
	ResourceType_name = map[int32]string{
		0:  "RESOURCE_TYPE_UNSPECIFIED",
		1:  "RESOURCE_TYPE_USER",
		2:  "RESOURCE_TYPE_ORGANIZATION",
		3:  "RESOURCE_TYPE_ORGANIZATION_MEMBER",
		9:  "RESOURCE_TYPE_ORGANIZATION_IDP_GROUP",
		4:  "RESOURCE_TYPE_REPOSITORY",
		5:  "RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR",
		6:  "RESOURCE_TYPE_REPOSITORY_COMMIT",
		8:  "RESOURCE_TYPE_CURATED_PLUGIN",
		10: "RESOURCE_TYPE_TOKEN",
		11: "RESOURCE_TYPE_SCIM_TOKEN",
		12: "RESOURCE_TYPE_REPOSITORY_LABEL",
		13: "RESOURCE_TYPE_SERVER",
		14: "RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT",
	}
	ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED":                0,
		"RESOURCE_TYPE_USER":                       1,
		"RESOURCE_TYPE_ORGANIZATION":               2,
		"RESOURCE_TYPE_ORGANIZATION_MEMBER":        3,
		"RESOURCE_TYPE_ORGANIZATION_IDP_GROUP":     9,
		"RESOURCE_TYPE_REPOSITORY":                 4,
		"RESOURCE_TYPE_REPOSITORY_CONTRIBUTOR":     5,
		"RESOURCE_TYPE_REPOSITORY_COMMIT":          6,
		"RESOURCE_TYPE_CURATED_PLUGIN":             8,
		"RESOURCE_TYPE_TOKEN":                      10,
		"RESOURCE_TYPE_SCIM_TOKEN":                 11,
		"RESOURCE_TYPE_REPOSITORY_LABEL":           12,
		"RESOURCE_TYPE_SERVER":                     13,
		"RESOURCE_TYPE_DEVICE_AUTHORIZATION_GRANT": 14,
	}
)

func (x ResourceType) Enum() *ResourceType {
	p := new(ResourceType)
	*p = x
	return p
}

func (x ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[1].Descriptor()
}

func (ResourceType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[1]
}

func (x ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceType.Descriptor instead.
func (ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{1}
}

// EventType is the type of audited event.
type EventType int32

const (
	EventType_EVENT_TYPE_UNSPECIFIED                           EventType = 0
	EventType_EVENT_TYPE_ORGANIZATION_CREATED                  EventType = 1
	EventType_EVENT_TYPE_ORGANIZATION_DELETED                  EventType = 2
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ADDED             EventType = 3
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED      EventType = 4
	EventType_EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED           EventType = 5
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED          EventType = 21
	EventType_EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED        EventType = 22
	EventType_EVENT_TYPE_REPOSITORY_CREATED                    EventType = 6
	EventType_EVENT_TYPE_REPOSITORY_DELETED                    EventType = 7
	EventType_EVENT_TYPE_REPOSITORY_COMMIT_PUSHED              EventType = 8
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED          EventType = 9
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED   EventType = 10
	EventType_EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED        EventType = 11
	EventType_EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED         EventType = 12
	EventType_EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED EventType = 40
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_PLUGIN_CREATED EventType = 13
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	EventType_EVENT_TYPE_PLUGIN_DELETED                         EventType = 14
	EventType_EVENT_TYPE_CURATED_PLUGIN_CREATED                 EventType = 20
	EventType_EVENT_TYPE_CURATED_PLUGIN_DELETED                 EventType = 31
	EventType_EVENT_TYPE_USER_CREATED                           EventType = 15
	EventType_EVENT_TYPE_USER_DELETED                           EventType = 16
	EventType_EVENT_TYPE_USER_DEACTIVATED                       EventType = 17
	EventType_EVENT_TYPE_USER_LOGGED_IN                         EventType = 18
	EventType_EVENT_TYPE_USER_LOGGED_OUT                        EventType = 19
	EventType_EVENT_TYPE_TOKEN_CREATED                          EventType = 23
	EventType_EVENT_TYPE_TOKEN_DELETED                          EventType = 24
	EventType_EVENT_TYPE_USER_REACTIVATED                       EventType = 25
	EventType_EVENT_TYPE_SCIM_TOKEN_CREATED                     EventType = 26
	EventType_EVENT_TYPE_SCIM_TOKEN_DELETED                     EventType = 27
	EventType_EVENT_TYPE_REPOSITORY_COMMIT_DELETED              EventType = 28
	EventType_EVENT_TYPE_REPOSITORY_LABEL_CREATED               EventType = 29
	EventType_EVENT_TYPE_REPOSITORY_LABEL_MOVED                 EventType = 30
	EventType_EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED              EventType = 38
	EventType_EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED            EventType = 39
	EventType_EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED  EventType = 32
	EventType_EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED EventType = 33
	EventType_EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED      EventType = 34
	EventType_EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED       EventType = 35
	EventType_EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED      EventType = 36
	EventType_EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP          EventType = 37
	EventType_EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED    EventType = 41
	EventType_EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED      EventType = 42
)

// Enum value maps for EventType.
var (
	EventType_name = map[int32]string{
		0:  "EVENT_TYPE_UNSPECIFIED",
		1:  "EVENT_TYPE_ORGANIZATION_CREATED",
		2:  "EVENT_TYPE_ORGANIZATION_DELETED",
		3:  "EVENT_TYPE_ORGANIZATION_MEMBER_ADDED",
		4:  "EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED",
		5:  "EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED",
		21: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED",
		22: "EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED",
		6:  "EVENT_TYPE_REPOSITORY_CREATED",
		7:  "EVENT_TYPE_REPOSITORY_DELETED",
		8:  "EVENT_TYPE_REPOSITORY_COMMIT_PUSHED",
		9:  "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED",
		10: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED",
		11: "EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED",
		12: "EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED",
		40: "EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED",
		13: "EVENT_TYPE_PLUGIN_CREATED",
		14: "EVENT_TYPE_PLUGIN_DELETED",
		20: "EVENT_TYPE_CURATED_PLUGIN_CREATED",
		31: "EVENT_TYPE_CURATED_PLUGIN_DELETED",
		15: "EVENT_TYPE_USER_CREATED",
		16: "EVENT_TYPE_USER_DELETED",
		17: "EVENT_TYPE_USER_DEACTIVATED",
		18: "EVENT_TYPE_USER_LOGGED_IN",
		19: "EVENT_TYPE_USER_LOGGED_OUT",
		23: "EVENT_TYPE_TOKEN_CREATED",
		24: "EVENT_TYPE_TOKEN_DELETED",
		25: "EVENT_TYPE_USER_REACTIVATED",
		26: "EVENT_TYPE_SCIM_TOKEN_CREATED",
		27: "EVENT_TYPE_SCIM_TOKEN_DELETED",
		28: "EVENT_TYPE_REPOSITORY_COMMIT_DELETED",
		29: "EVENT_TYPE_REPOSITORY_LABEL_CREATED",
		30: "EVENT_TYPE_REPOSITORY_LABEL_MOVED",
		38: "EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED",
		39: "EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED",
		32: "EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED",
		33: "EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED",
		34: "EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED",
		35: "EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED",
		36: "EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED",
		37: "EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP",
		41: "EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED",
		42: "EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED",
	}
	EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":                            0,
		"EVENT_TYPE_ORGANIZATION_CREATED":                   1,
		"EVENT_TYPE_ORGANIZATION_DELETED":                   2,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ADDED":              3,
		"EVENT_TYPE_ORGANIZATION_MEMBER_ROLE_CHANGED":       4,
		"EVENT_TYPE_ORGANIZATION_MEMBER_REMOVED":            5,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_ADDED":           21,
		"EVENT_TYPE_ORGANIZATION_IDP_GROUP_REMOVED":         22,
		"EVENT_TYPE_REPOSITORY_CREATED":                     6,
		"EVENT_TYPE_REPOSITORY_DELETED":                     7,
		"EVENT_TYPE_REPOSITORY_COMMIT_PUSHED":               8,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ADDED":           9,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_ROLE_CHANGED":    10,
		"EVENT_TYPE_REPOSITORY_CONTRIBUTOR_REMOVED":         11,
		"EVENT_TYPE_REPOSITORY_VISIBILITY_CHANGED":          12,
		"EVENT_TYPE_REPOSITORY_DEFAULT_LABEL_NAME_CHANGED":  40,
		"EVENT_TYPE_PLUGIN_CREATED":                         13,
		"EVENT_TYPE_PLUGIN_DELETED":                         14,
		"EVENT_TYPE_CURATED_PLUGIN_CREATED":                 20,
		"EVENT_TYPE_CURATED_PLUGIN_DELETED":                 31,
		"EVENT_TYPE_USER_CREATED":                           15,
		"EVENT_TYPE_USER_DELETED":                           16,
		"EVENT_TYPE_USER_DEACTIVATED":                       17,
		"EVENT_TYPE_USER_LOGGED_IN":                         18,
		"EVENT_TYPE_USER_LOGGED_OUT":                        19,
		"EVENT_TYPE_TOKEN_CREATED":                          23,
		"EVENT_TYPE_TOKEN_DELETED":                          24,
		"EVENT_TYPE_USER_REACTIVATED":                       25,
		"EVENT_TYPE_SCIM_TOKEN_CREATED":                     26,
		"EVENT_TYPE_SCIM_TOKEN_DELETED":                     27,
		"EVENT_TYPE_REPOSITORY_COMMIT_DELETED":              28,
		"EVENT_TYPE_REPOSITORY_LABEL_CREATED":               29,
		"EVENT_TYPE_REPOSITORY_LABEL_MOVED":                 30,
		"EVENT_TYPE_REPOSITORY_LABEL_ARCHIVED":              38,
		"EVENT_TYPE_REPOSITORY_LABEL_UNARCHIVED":            39,
		"EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_ENABLED":  32,
		"EVENT_TYPE_SERVER_BREAKING_CHANGE_POLICY_DISABLED": 33,
		"EVENT_TYPE_REPOSITORY_DEFAULT_BRANCH_CHANGED":      34,
		"EVENT_TYPE_SERVER_UNIQUENESS_POLICY_ENABLED":       35,
		"EVENT_TYPE_SERVER_UNIQUENESS_POLICY_DISABLED":      36,
		"EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP":          37,
		"EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_APPROVED":    41,
		"EVENT_TYPE_DEVICE_AUTHORIZATION_GRANT_DENIED":      42,
	}
)

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[2].Descriptor()
}

func (EventType) Type() protoreflect.EnumType {
	return &file_buf_alpha_audit_v1alpha1_event_proto_enumTypes[2]
}

func (x EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventType.Descriptor instead.
func (EventType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{2}
}

// Actor is the actor who caused the audited event.
type Actor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of actor who caused the audited event.
	Type ActorType `protobuf:"varint,1,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.ActorType" json:"type,omitempty"`
	// Id of the actor who caused the audited event.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the actor who caused the audited event.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Actor) Reset() {
	*x = Actor{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Actor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Actor) ProtoMessage() {}

func (x *Actor) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Actor.ProtoReflect.Descriptor instead.
func (*Actor) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{0}
}

func (x *Actor) GetType() ActorType {
	if x != nil {
		return x.Type
	}
	return ActorType_ACTOR_TYPE_UNSPECIFIED
}

func (x *Actor) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Actor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Resource is the affected resource by the audited event.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of resource that was affected by the audited event.
	Type ResourceType `protobuf:"varint,1,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.ResourceType" json:"type,omitempty"`
	// Id of the affected resource by the audited event.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the affected resource by the audited event.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{1}
}

func (x *Resource) GetType() ResourceType {
	if x != nil {
		return x.Type
	}
	return ResourceType_RESOURCE_TYPE_UNSPECIFIED
}

func (x *Resource) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// EventMetadata provides additional details about the audited event.
type EventMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// UserAgent is the User-Agent header associated with the request that triggered the audited event, if any.
	UserAgent string `protobuf:"bytes,1,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// IP is the IP address associated with the request that triggered the audited event, if any.
	Ip string `protobuf:"bytes,2,opt,name=ip,proto3" json:"ip,omitempty"`
	// TraceID is the ID of the trace associated with the audited event, if any.
	TraceId string `protobuf:"bytes,3,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
}

func (x *EventMetadata) Reset() {
	*x = EventMetadata{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EventMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventMetadata) ProtoMessage() {}

func (x *EventMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventMetadata.ProtoReflect.Descriptor instead.
func (*EventMetadata) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{2}
}

func (x *EventMetadata) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

func (x *EventMetadata) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *EventMetadata) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

// Event is an audited action that happened in the BSR, with the information of
// what happened, when it happened, who did it, which resource was affected, and
// more contextual information on the event.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique id of the audited event.
	EventId string `protobuf:"bytes,1,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	// Type of the audited event. It specifies "what" happened.
	Type EventType `protobuf:"varint,2,opt,name=type,proto3,enum=buf.alpha.audit.v1alpha1.EventType" json:"type,omitempty"`
	// Actor of the audited event. It specifies "who" did it.
	Actor *Actor `protobuf:"bytes,3,opt,name=actor,proto3" json:"actor,omitempty"`
	// Resource of the audited event. It specifies "which resource" was affected.
	Resource *Resource `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	// Time of the audited event. It specifies "when" it happened.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Metadata about the audited event. It specifies any additional details about the audited event.
	Metadata *EventMetadata `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Payload of the audited event. It specifies additional context on the event.
	//
	// Types that are assignable to Payload:
	//
	//	*Event_OrganizationCreated
	//	*Event_OrganizationDeleted
	//	*Event_OrganizationMemberAdded
	//	*Event_OrganizationMemberRoleChanged
	//	*Event_OrganizationMemberRemoved
	//	*Event_RepositoryCreated
	//	*Event_RepositoryDeleted
	//	*Event_RepositoryCommitPushed
	//	*Event_RepositoryContributorAdded
	//	*Event_RepositoryContributorRoleChanged
	//	*Event_RepositoryContributorRemoved
	//	*Event_RepositoryVisibilityChanged
	//	*Event_RepositoryDefaultLabelNameChanged
	//	*Event_UserCreated
	//	*Event_UserDeactivated
	//	*Event_UserDeleted
	//	*Event_UserLoggedIn
	//	*Event_UserLoggedOut
	//	*Event_CuratedPluginCreated
	//	*Event_IdpGroupAdded
	//	*Event_IdpGroupRemoved
	//	*Event_TokenCreated
	//	*Event_TokenDeleted
	//	*Event_UserReactivated
	//	*Event_ScimTokenCreated
	//	*Event_ScimTokenDeleted
	//	*Event_RepositoryCommitDeleted
	//	*Event_RepositoryLabelCreated
	//	*Event_RepositoryLabelMoved
	//	*Event_RepositoryLabelArchived
	//	*Event_RepositoryLabelUnarchived
	//	*Event_CuratedPluginDeleted
	//	*Event_PayloadServerBreakingChangePolicyEnabled
	//	*Event_PayloadServerBreakingChangePolicyDisabled
	//	*Event_RepositoryDefaultBranchChanged
	//	*Event_PayloadServerUniquenessPolicyEnabled
	//	*Event_PayloadServerUniquenessPolicyDisabled
	//	*Event_UserAutoMergedFromNewIdp
	//	*Event_DeviceAuthorizationGrantApproved
	//	*Event_DeviceAuthorizationGrantDenied
	Payload isEvent_Payload `protobuf_oneof:"payload"`
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{3}
}

func (x *Event) GetEventId() string {
	if x != nil {
		return x.EventId
	}
	return ""
}

func (x *Event) GetType() EventType {
	if x != nil {
		return x.Type
	}
	return EventType_EVENT_TYPE_UNSPECIFIED
}

func (x *Event) GetActor() *Actor {
	if x != nil {
		return x.Actor
	}
	return nil
}

func (x *Event) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *Event) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *Event) GetMetadata() *EventMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (m *Event) GetPayload() isEvent_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *Event) GetOrganizationCreated() *PayloadOrganizationCreated {
	if x, ok := x.GetPayload().(*Event_OrganizationCreated); ok {
		return x.OrganizationCreated
	}
	return nil
}

func (x *Event) GetOrganizationDeleted() *PayloadOrganizationDeleted {
	if x, ok := x.GetPayload().(*Event_OrganizationDeleted); ok {
		return x.OrganizationDeleted
	}
	return nil
}

func (x *Event) GetOrganizationMemberAdded() *PayloadOrganizationMemberAdded {
	if x, ok := x.GetPayload().(*Event_OrganizationMemberAdded); ok {
		return x.OrganizationMemberAdded
	}
	return nil
}

func (x *Event) GetOrganizationMemberRoleChanged() *PayloadOrganizationMemberRoleChanged {
	if x, ok := x.GetPayload().(*Event_OrganizationMemberRoleChanged); ok {
		return x.OrganizationMemberRoleChanged
	}
	return nil
}

func (x *Event) GetOrganizationMemberRemoved() *PayloadOrganizationMemberRemoved {
	if x, ok := x.GetPayload().(*Event_OrganizationMemberRemoved); ok {
		return x.OrganizationMemberRemoved
	}
	return nil
}

func (x *Event) GetRepositoryCreated() *PayloadRepositoryCreated {
	if x, ok := x.GetPayload().(*Event_RepositoryCreated); ok {
		return x.RepositoryCreated
	}
	return nil
}

func (x *Event) GetRepositoryDeleted() *PayloadRepositoryDeleted {
	if x, ok := x.GetPayload().(*Event_RepositoryDeleted); ok {
		return x.RepositoryDeleted
	}
	return nil
}

func (x *Event) GetRepositoryCommitPushed() *PayloadRepositoryCommitPushed {
	if x, ok := x.GetPayload().(*Event_RepositoryCommitPushed); ok {
		return x.RepositoryCommitPushed
	}
	return nil
}

func (x *Event) GetRepositoryContributorAdded() *PayloadRepositoryContributorAdded {
	if x, ok := x.GetPayload().(*Event_RepositoryContributorAdded); ok {
		return x.RepositoryContributorAdded
	}
	return nil
}

func (x *Event) GetRepositoryContributorRoleChanged() *PayloadRepositoryContributorRoleChanged {
	if x, ok := x.GetPayload().(*Event_RepositoryContributorRoleChanged); ok {
		return x.RepositoryContributorRoleChanged
	}
	return nil
}

func (x *Event) GetRepositoryContributorRemoved() *PayloadRepositoryContributorRemoved {
	if x, ok := x.GetPayload().(*Event_RepositoryContributorRemoved); ok {
		return x.RepositoryContributorRemoved
	}
	return nil
}

func (x *Event) GetRepositoryVisibilityChanged() *PayloadRepositoryVisibilityChanged {
	if x, ok := x.GetPayload().(*Event_RepositoryVisibilityChanged); ok {
		return x.RepositoryVisibilityChanged
	}
	return nil
}

func (x *Event) GetRepositoryDefaultLabelNameChanged() *PayloadRepositoryDefaultLabelNameChanged {
	if x, ok := x.GetPayload().(*Event_RepositoryDefaultLabelNameChanged); ok {
		return x.RepositoryDefaultLabelNameChanged
	}
	return nil
}

func (x *Event) GetUserCreated() *PayloadUserCreated {
	if x, ok := x.GetPayload().(*Event_UserCreated); ok {
		return x.UserCreated
	}
	return nil
}

func (x *Event) GetUserDeactivated() *PayloadUserDeactivated {
	if x, ok := x.GetPayload().(*Event_UserDeactivated); ok {
		return x.UserDeactivated
	}
	return nil
}

func (x *Event) GetUserDeleted() *PayloadUserDeleted {
	if x, ok := x.GetPayload().(*Event_UserDeleted); ok {
		return x.UserDeleted
	}
	return nil
}

func (x *Event) GetUserLoggedIn() *PayloadUserLoggedIn {
	if x, ok := x.GetPayload().(*Event_UserLoggedIn); ok {
		return x.UserLoggedIn
	}
	return nil
}

func (x *Event) GetUserLoggedOut() *PayloadUserLoggedOut {
	if x, ok := x.GetPayload().(*Event_UserLoggedOut); ok {
		return x.UserLoggedOut
	}
	return nil
}

func (x *Event) GetCuratedPluginCreated() *PayloadCuratedPluginCreated {
	if x, ok := x.GetPayload().(*Event_CuratedPluginCreated); ok {
		return x.CuratedPluginCreated
	}
	return nil
}

func (x *Event) GetIdpGroupAdded() *PayloadOrganizationIDPGroupAdded {
	if x, ok := x.GetPayload().(*Event_IdpGroupAdded); ok {
		return x.IdpGroupAdded
	}
	return nil
}

func (x *Event) GetIdpGroupRemoved() *PayloadOrganizationIDPGroupRemoved {
	if x, ok := x.GetPayload().(*Event_IdpGroupRemoved); ok {
		return x.IdpGroupRemoved
	}
	return nil
}

func (x *Event) GetTokenCreated() *PayloadTokenCreated {
	if x, ok := x.GetPayload().(*Event_TokenCreated); ok {
		return x.TokenCreated
	}
	return nil
}

func (x *Event) GetTokenDeleted() *PayloadTokenDeleted {
	if x, ok := x.GetPayload().(*Event_TokenDeleted); ok {
		return x.TokenDeleted
	}
	return nil
}

func (x *Event) GetUserReactivated() *PayloadUserReactivated {
	if x, ok := x.GetPayload().(*Event_UserReactivated); ok {
		return x.UserReactivated
	}
	return nil
}

func (x *Event) GetScimTokenCreated() *PayloadSCIMTokenCreated {
	if x, ok := x.GetPayload().(*Event_ScimTokenCreated); ok {
		return x.ScimTokenCreated
	}
	return nil
}

func (x *Event) GetScimTokenDeleted() *PayloadSCIMTokenDeleted {
	if x, ok := x.GetPayload().(*Event_ScimTokenDeleted); ok {
		return x.ScimTokenDeleted
	}
	return nil
}

func (x *Event) GetRepositoryCommitDeleted() *PayloadRepositoryCommitDeleted {
	if x, ok := x.GetPayload().(*Event_RepositoryCommitDeleted); ok {
		return x.RepositoryCommitDeleted
	}
	return nil
}

func (x *Event) GetRepositoryLabelCreated() *PayloadRepositoryLabelCreated {
	if x, ok := x.GetPayload().(*Event_RepositoryLabelCreated); ok {
		return x.RepositoryLabelCreated
	}
	return nil
}

func (x *Event) GetRepositoryLabelMoved() *PayloadRepositoryLabelMoved {
	if x, ok := x.GetPayload().(*Event_RepositoryLabelMoved); ok {
		return x.RepositoryLabelMoved
	}
	return nil
}

func (x *Event) GetRepositoryLabelArchived() *PayloadRepositoryLabelArchived {
	if x, ok := x.GetPayload().(*Event_RepositoryLabelArchived); ok {
		return x.RepositoryLabelArchived
	}
	return nil
}

func (x *Event) GetRepositoryLabelUnarchived() *PayloadRepositoryLabelUnarchived {
	if x, ok := x.GetPayload().(*Event_RepositoryLabelUnarchived); ok {
		return x.RepositoryLabelUnarchived
	}
	return nil
}

func (x *Event) GetCuratedPluginDeleted() *PayloadCuratedPluginDeleted {
	if x, ok := x.GetPayload().(*Event_CuratedPluginDeleted); ok {
		return x.CuratedPluginDeleted
	}
	return nil
}

func (x *Event) GetPayloadServerBreakingChangePolicyEnabled() *PayloadServerBreakingChangePolicyEnabled {
	if x, ok := x.GetPayload().(*Event_PayloadServerBreakingChangePolicyEnabled); ok {
		return x.PayloadServerBreakingChangePolicyEnabled
	}
	return nil
}

func (x *Event) GetPayloadServerBreakingChangePolicyDisabled() *PayloadServerBreakingChangePolicyDisabled {
	if x, ok := x.GetPayload().(*Event_PayloadServerBreakingChangePolicyDisabled); ok {
		return x.PayloadServerBreakingChangePolicyDisabled
	}
	return nil
}

func (x *Event) GetRepositoryDefaultBranchChanged() *PayloadRepositoryDefaultBranchChanged {
	if x, ok := x.GetPayload().(*Event_RepositoryDefaultBranchChanged); ok {
		return x.RepositoryDefaultBranchChanged
	}
	return nil
}

func (x *Event) GetPayloadServerUniquenessPolicyEnabled() *PayloadServerUniquenessPolicyEnabled {
	if x, ok := x.GetPayload().(*Event_PayloadServerUniquenessPolicyEnabled); ok {
		return x.PayloadServerUniquenessPolicyEnabled
	}
	return nil
}

func (x *Event) GetPayloadServerUniquenessPolicyDisabled() *PayloadServerUniquenessPolicyDisabled {
	if x, ok := x.GetPayload().(*Event_PayloadServerUniquenessPolicyDisabled); ok {
		return x.PayloadServerUniquenessPolicyDisabled
	}
	return nil
}

func (x *Event) GetUserAutoMergedFromNewIdp() *PayloadUserAutoMergedFromNewIdP {
	if x, ok := x.GetPayload().(*Event_UserAutoMergedFromNewIdp); ok {
		return x.UserAutoMergedFromNewIdp
	}
	return nil
}

func (x *Event) GetDeviceAuthorizationGrantApproved() *PayloadDeviceAuthorizationGrantApproved {
	if x, ok := x.GetPayload().(*Event_DeviceAuthorizationGrantApproved); ok {
		return x.DeviceAuthorizationGrantApproved
	}
	return nil
}

func (x *Event) GetDeviceAuthorizationGrantDenied() *PayloadDeviceAuthorizationGrantDenied {
	if x, ok := x.GetPayload().(*Event_DeviceAuthorizationGrantDenied); ok {
		return x.DeviceAuthorizationGrantDenied
	}
	return nil
}

type isEvent_Payload interface {
	isEvent_Payload()
}

type Event_OrganizationCreated struct {
	OrganizationCreated *PayloadOrganizationCreated `protobuf:"bytes,7,opt,name=organization_created,json=organizationCreated,proto3,oneof"`
}

type Event_OrganizationDeleted struct {
	OrganizationDeleted *PayloadOrganizationDeleted `protobuf:"bytes,8,opt,name=organization_deleted,json=organizationDeleted,proto3,oneof"`
}

type Event_OrganizationMemberAdded struct {
	OrganizationMemberAdded *PayloadOrganizationMemberAdded `protobuf:"bytes,9,opt,name=organization_member_added,json=organizationMemberAdded,proto3,oneof"`
}

type Event_OrganizationMemberRoleChanged struct {
	OrganizationMemberRoleChanged *PayloadOrganizationMemberRoleChanged `protobuf:"bytes,10,opt,name=organization_member_role_changed,json=organizationMemberRoleChanged,proto3,oneof"`
}

type Event_OrganizationMemberRemoved struct {
	OrganizationMemberRemoved *PayloadOrganizationMemberRemoved `protobuf:"bytes,11,opt,name=organization_member_removed,json=organizationMemberRemoved,proto3,oneof"`
}

type Event_RepositoryCreated struct {
	RepositoryCreated *PayloadRepositoryCreated `protobuf:"bytes,12,opt,name=repository_created,json=repositoryCreated,proto3,oneof"`
}

type Event_RepositoryDeleted struct {
	RepositoryDeleted *PayloadRepositoryDeleted `protobuf:"bytes,13,opt,name=repository_deleted,json=repositoryDeleted,proto3,oneof"`
}

type Event_RepositoryCommitPushed struct {
	RepositoryCommitPushed *PayloadRepositoryCommitPushed `protobuf:"bytes,14,opt,name=repository_commit_pushed,json=repositoryCommitPushed,proto3,oneof"`
}

type Event_RepositoryContributorAdded struct {
	RepositoryContributorAdded *PayloadRepositoryContributorAdded `protobuf:"bytes,15,opt,name=repository_contributor_added,json=repositoryContributorAdded,proto3,oneof"`
}

type Event_RepositoryContributorRoleChanged struct {
	RepositoryContributorRoleChanged *PayloadRepositoryContributorRoleChanged `protobuf:"bytes,16,opt,name=repository_contributor_role_changed,json=repositoryContributorRoleChanged,proto3,oneof"`
}

type Event_RepositoryContributorRemoved struct {
	RepositoryContributorRemoved *PayloadRepositoryContributorRemoved `protobuf:"bytes,17,opt,name=repository_contributor_removed,json=repositoryContributorRemoved,proto3,oneof"`
}

type Event_RepositoryVisibilityChanged struct {
	RepositoryVisibilityChanged *PayloadRepositoryVisibilityChanged `protobuf:"bytes,18,opt,name=repository_visibility_changed,json=repositoryVisibilityChanged,proto3,oneof"`
}

type Event_RepositoryDefaultLabelNameChanged struct {
	RepositoryDefaultLabelNameChanged *PayloadRepositoryDefaultLabelNameChanged `protobuf:"bytes,46,opt,name=repository_default_label_name_changed,json=repositoryDefaultLabelNameChanged,proto3,oneof"`
}

type Event_UserCreated struct {
	UserCreated *PayloadUserCreated `protobuf:"bytes,21,opt,name=user_created,json=userCreated,proto3,oneof"`
}

type Event_UserDeactivated struct {
	UserDeactivated *PayloadUserDeactivated `protobuf:"bytes,22,opt,name=user_deactivated,json=userDeactivated,proto3,oneof"`
}

type Event_UserDeleted struct {
	UserDeleted *PayloadUserDeleted `protobuf:"bytes,23,opt,name=user_deleted,json=userDeleted,proto3,oneof"`
}

type Event_UserLoggedIn struct {
	UserLoggedIn *PayloadUserLoggedIn `protobuf:"bytes,24,opt,name=user_logged_in,json=userLoggedIn,proto3,oneof"`
}

type Event_UserLoggedOut struct {
	UserLoggedOut *PayloadUserLoggedOut `protobuf:"bytes,25,opt,name=user_logged_out,json=userLoggedOut,proto3,oneof"`
}

type Event_CuratedPluginCreated struct {
	CuratedPluginCreated *PayloadCuratedPluginCreated `protobuf:"bytes,26,opt,name=curated_plugin_created,json=curatedPluginCreated,proto3,oneof"`
}

type Event_IdpGroupAdded struct {
	IdpGroupAdded *PayloadOrganizationIDPGroupAdded `protobuf:"bytes,27,opt,name=idp_group_added,json=idpGroupAdded,proto3,oneof"`
}

type Event_IdpGroupRemoved struct {
	IdpGroupRemoved *PayloadOrganizationIDPGroupRemoved `protobuf:"bytes,28,opt,name=idp_group_removed,json=idpGroupRemoved,proto3,oneof"`
}

type Event_TokenCreated struct {
	TokenCreated *PayloadTokenCreated `protobuf:"bytes,29,opt,name=token_created,json=tokenCreated,proto3,oneof"`
}

type Event_TokenDeleted struct {
	TokenDeleted *PayloadTokenDeleted `protobuf:"bytes,30,opt,name=token_deleted,json=tokenDeleted,proto3,oneof"`
}

type Event_UserReactivated struct {
	UserReactivated *PayloadUserReactivated `protobuf:"bytes,31,opt,name=user_reactivated,json=userReactivated,proto3,oneof"`
}

type Event_ScimTokenCreated struct {
	ScimTokenCreated *PayloadSCIMTokenCreated `protobuf:"bytes,32,opt,name=scim_token_created,json=scimTokenCreated,proto3,oneof"`
}

type Event_ScimTokenDeleted struct {
	ScimTokenDeleted *PayloadSCIMTokenDeleted `protobuf:"bytes,33,opt,name=scim_token_deleted,json=scimTokenDeleted,proto3,oneof"`
}

type Event_RepositoryCommitDeleted struct {
	RepositoryCommitDeleted *PayloadRepositoryCommitDeleted `protobuf:"bytes,34,opt,name=repository_commit_deleted,json=repositoryCommitDeleted,proto3,oneof"`
}

type Event_RepositoryLabelCreated struct {
	RepositoryLabelCreated *PayloadRepositoryLabelCreated `protobuf:"bytes,35,opt,name=repository_label_created,json=repositoryLabelCreated,proto3,oneof"`
}

type Event_RepositoryLabelMoved struct {
	RepositoryLabelMoved *PayloadRepositoryLabelMoved `protobuf:"bytes,36,opt,name=repository_label_moved,json=repositoryLabelMoved,proto3,oneof"`
}

type Event_RepositoryLabelArchived struct {
	RepositoryLabelArchived *PayloadRepositoryLabelArchived `protobuf:"bytes,44,opt,name=repository_label_archived,json=repositoryLabelArchived,proto3,oneof"`
}

type Event_RepositoryLabelUnarchived struct {
	RepositoryLabelUnarchived *PayloadRepositoryLabelUnarchived `protobuf:"bytes,45,opt,name=repository_label_unarchived,json=repositoryLabelUnarchived,proto3,oneof"`
}

type Event_CuratedPluginDeleted struct {
	CuratedPluginDeleted *PayloadCuratedPluginDeleted `protobuf:"bytes,37,opt,name=curated_plugin_deleted,json=curatedPluginDeleted,proto3,oneof"`
}

type Event_PayloadServerBreakingChangePolicyEnabled struct {
	PayloadServerBreakingChangePolicyEnabled *PayloadServerBreakingChangePolicyEnabled `protobuf:"bytes,38,opt,name=payload_server_breaking_change_policy_enabled,json=payloadServerBreakingChangePolicyEnabled,proto3,oneof"`
}

type Event_PayloadServerBreakingChangePolicyDisabled struct {
	PayloadServerBreakingChangePolicyDisabled *PayloadServerBreakingChangePolicyDisabled `protobuf:"bytes,39,opt,name=payload_server_breaking_change_policy_disabled,json=payloadServerBreakingChangePolicyDisabled,proto3,oneof"`
}

type Event_RepositoryDefaultBranchChanged struct {
	RepositoryDefaultBranchChanged *PayloadRepositoryDefaultBranchChanged `protobuf:"bytes,40,opt,name=repository_default_branch_changed,json=repositoryDefaultBranchChanged,proto3,oneof"`
}

type Event_PayloadServerUniquenessPolicyEnabled struct {
	PayloadServerUniquenessPolicyEnabled *PayloadServerUniquenessPolicyEnabled `protobuf:"bytes,41,opt,name=payload_server_uniqueness_policy_enabled,json=payloadServerUniquenessPolicyEnabled,proto3,oneof"`
}

type Event_PayloadServerUniquenessPolicyDisabled struct {
	PayloadServerUniquenessPolicyDisabled *PayloadServerUniquenessPolicyDisabled `protobuf:"bytes,42,opt,name=payload_server_uniqueness_policy_disabled,json=payloadServerUniquenessPolicyDisabled,proto3,oneof"`
}

type Event_UserAutoMergedFromNewIdp struct {
	UserAutoMergedFromNewIdp *PayloadUserAutoMergedFromNewIdP `protobuf:"bytes,43,opt,name=user_auto_merged_from_new_idp,json=userAutoMergedFromNewIdp,proto3,oneof"`
}

type Event_DeviceAuthorizationGrantApproved struct {
	DeviceAuthorizationGrantApproved *PayloadDeviceAuthorizationGrantApproved `protobuf:"bytes,47,opt,name=device_authorization_grant_approved,json=deviceAuthorizationGrantApproved,proto3,oneof"`
}

type Event_DeviceAuthorizationGrantDenied struct {
	DeviceAuthorizationGrantDenied *PayloadDeviceAuthorizationGrantDenied `protobuf:"bytes,48,opt,name=device_authorization_grant_denied,json=deviceAuthorizationGrantDenied,proto3,oneof"`
}

func (*Event_OrganizationCreated) isEvent_Payload() {}

func (*Event_OrganizationDeleted) isEvent_Payload() {}

func (*Event_OrganizationMemberAdded) isEvent_Payload() {}

func (*Event_OrganizationMemberRoleChanged) isEvent_Payload() {}

func (*Event_OrganizationMemberRemoved) isEvent_Payload() {}

func (*Event_RepositoryCreated) isEvent_Payload() {}

func (*Event_RepositoryDeleted) isEvent_Payload() {}

func (*Event_RepositoryCommitPushed) isEvent_Payload() {}

func (*Event_RepositoryContributorAdded) isEvent_Payload() {}

func (*Event_RepositoryContributorRoleChanged) isEvent_Payload() {}

func (*Event_RepositoryContributorRemoved) isEvent_Payload() {}

func (*Event_RepositoryVisibilityChanged) isEvent_Payload() {}

func (*Event_RepositoryDefaultLabelNameChanged) isEvent_Payload() {}

func (*Event_UserCreated) isEvent_Payload() {}

func (*Event_UserDeactivated) isEvent_Payload() {}

func (*Event_UserDeleted) isEvent_Payload() {}

func (*Event_UserLoggedIn) isEvent_Payload() {}

func (*Event_UserLoggedOut) isEvent_Payload() {}

func (*Event_CuratedPluginCreated) isEvent_Payload() {}

func (*Event_IdpGroupAdded) isEvent_Payload() {}

func (*Event_IdpGroupRemoved) isEvent_Payload() {}

func (*Event_TokenCreated) isEvent_Payload() {}

func (*Event_TokenDeleted) isEvent_Payload() {}

func (*Event_UserReactivated) isEvent_Payload() {}

func (*Event_ScimTokenCreated) isEvent_Payload() {}

func (*Event_ScimTokenDeleted) isEvent_Payload() {}

func (*Event_RepositoryCommitDeleted) isEvent_Payload() {}

func (*Event_RepositoryLabelCreated) isEvent_Payload() {}

func (*Event_RepositoryLabelMoved) isEvent_Payload() {}

func (*Event_RepositoryLabelArchived) isEvent_Payload() {}

func (*Event_RepositoryLabelUnarchived) isEvent_Payload() {}

func (*Event_CuratedPluginDeleted) isEvent_Payload() {}

func (*Event_PayloadServerBreakingChangePolicyEnabled) isEvent_Payload() {}

func (*Event_PayloadServerBreakingChangePolicyDisabled) isEvent_Payload() {}

func (*Event_RepositoryDefaultBranchChanged) isEvent_Payload() {}

func (*Event_PayloadServerUniquenessPolicyEnabled) isEvent_Payload() {}

func (*Event_PayloadServerUniquenessPolicyDisabled) isEvent_Payload() {}

func (*Event_UserAutoMergedFromNewIdp) isEvent_Payload() {}

func (*Event_DeviceAuthorizationGrantApproved) isEvent_Payload() {}

func (*Event_DeviceAuthorizationGrantDenied) isEvent_Payload() {}

type PayloadOrganizationCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadOrganizationCreated) Reset() {
	*x = PayloadOrganizationCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationCreated) ProtoMessage() {}

func (x *PayloadOrganizationCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationCreated.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{4}
}

type PayloadOrganizationDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadOrganizationDeleted) Reset() {
	*x = PayloadOrganizationDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationDeleted) ProtoMessage() {}

func (x *PayloadOrganizationDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationDeleted.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{5}
}

type PayloadOrganizationMemberAdded struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// organization_id is the id of the organization with the new member.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// organization_name is the name of the organization with the new member.
	OrganizationName string `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// member_role is the role granted to the member added to the organization.
	MemberRole v1alpha1.OrganizationRole `protobuf:"varint,3,opt,name=member_role,json=memberRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"member_role,omitempty"`
	// member_role_source is the source of the role granted to the member.
	MemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,4,opt,name=member_role_source,json=memberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource" json:"member_role_source,omitempty"`
}

func (x *PayloadOrganizationMemberAdded) Reset() {
	*x = PayloadOrganizationMemberAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberAdded) ProtoMessage() {}

func (x *PayloadOrganizationMemberAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationMemberAdded.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationMemberAdded) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{6}
}

func (x *PayloadOrganizationMemberAdded) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberAdded) GetOrganizationName() string {
	if x != nil {
		return x.OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberAdded) GetMemberRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.MemberRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberAdded) GetMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.MemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

type PayloadOrganizationMemberRoleChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// organization_id is the id of the organization within which the role was changed.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// organization_name is the name of the organization within which the role was changed.
	OrganizationName string `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// old_role is the old role of the member whose role was changed.
	OldRole v1alpha1.OrganizationRole `protobuf:"varint,3,opt,name=old_role,json=oldRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"old_role,omitempty"`
	// new_role is the new role of the member whose role was changed.
	NewRole v1alpha1.OrganizationRole `protobuf:"varint,4,opt,name=new_role,json=newRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"new_role,omitempty"`
	// old_member_role_source is the old source of the role granted to the member.
	OldMemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,5,opt,name=old_member_role_source,json=oldMemberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource" json:"old_member_role_source,omitempty"`
	// new_member_role_source is the new source of the role granted to the member.
	NewMemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,6,opt,name=new_member_role_source,json=newMemberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource" json:"new_member_role_source,omitempty"`
}

func (x *PayloadOrganizationMemberRoleChanged) Reset() {
	*x = PayloadOrganizationMemberRoleChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRoleChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRoleChanged) ProtoMessage() {}

func (x *PayloadOrganizationMemberRoleChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationMemberRoleChanged.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationMemberRoleChanged) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{7}
}

func (x *PayloadOrganizationMemberRoleChanged) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRoleChanged) GetOrganizationName() string {
	if x != nil {
		return x.OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRoleChanged) GetOldRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.OldRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetNewRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.NewRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetOldMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.OldMemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

func (x *PayloadOrganizationMemberRoleChanged) GetNewMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.NewMemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

type PayloadOrganizationMemberRemoved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// organization_id is the id of the organization that the member was removed from.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// organization_name is the name of the organization that the member was removed from.
	OrganizationName string `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// member_role is the role that the member had when removed from the organization.
	MemberRole v1alpha1.OrganizationRole `protobuf:"varint,3,opt,name=member_role,json=memberRole,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole" json:"member_role,omitempty"`
	// member_role_source is the source of the role granted to the member.
	MemberRoleSource v1alpha1.OrganizationRoleSource `protobuf:"varint,4,opt,name=member_role_source,json=memberRoleSource,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRoleSource" json:"member_role_source,omitempty"`
}

func (x *PayloadOrganizationMemberRemoved) Reset() {
	*x = PayloadOrganizationMemberRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationMemberRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationMemberRemoved) ProtoMessage() {}

func (x *PayloadOrganizationMemberRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationMemberRemoved.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationMemberRemoved) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{8}
}

func (x *PayloadOrganizationMemberRemoved) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationMemberRemoved) GetOrganizationName() string {
	if x != nil {
		return x.OrganizationName
	}
	return ""
}

func (x *PayloadOrganizationMemberRemoved) GetMemberRole() v1alpha1.OrganizationRole {
	if x != nil {
		return x.MemberRole
	}
	return v1alpha1.OrganizationRole(0)
}

func (x *PayloadOrganizationMemberRemoved) GetMemberRoleSource() v1alpha1.OrganizationRoleSource {
	if x != nil {
		return x.MemberRoleSource
	}
	return v1alpha1.OrganizationRoleSource(0)
}

type PayloadOrganizationIDPGroupAdded struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// organization_id is the id of the organization with the new IDP group.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// organization_name is the name of the organization with the new IDP group.
	OrganizationName string `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
}

func (x *PayloadOrganizationIDPGroupAdded) Reset() {
	*x = PayloadOrganizationIDPGroupAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupAdded) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationIDPGroupAdded.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationIDPGroupAdded) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{9}
}

func (x *PayloadOrganizationIDPGroupAdded) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupAdded) GetOrganizationName() string {
	if x != nil {
		return x.OrganizationName
	}
	return ""
}

type PayloadOrganizationIDPGroupRemoved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// organization_id is the id of the organization with the removed IDP group.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// organization_name is the name of the organization with the removed IDP group.
	OrganizationName string `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
}

func (x *PayloadOrganizationIDPGroupRemoved) Reset() {
	*x = PayloadOrganizationIDPGroupRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadOrganizationIDPGroupRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadOrganizationIDPGroupRemoved) ProtoMessage() {}

func (x *PayloadOrganizationIDPGroupRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadOrganizationIDPGroupRemoved.ProtoReflect.Descriptor instead.
func (*PayloadOrganizationIDPGroupRemoved) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{10}
}

func (x *PayloadOrganizationIDPGroupRemoved) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *PayloadOrganizationIDPGroupRemoved) GetOrganizationName() string {
	if x != nil {
		return x.OrganizationName
	}
	return ""
}

type PayloadRepositoryCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility" json:"visibility,omitempty"`
	// default_label_name is the name of the default label for the repository.
	// If empty, the repository was created with the default label name of 'main'.
	DefaultLabelName string `protobuf:"bytes,4,opt,name=default_label_name,json=defaultLabelName,proto3" json:"default_label_name,omitempty"`
}

func (x *PayloadRepositoryCreated) Reset() {
	*x = PayloadRepositoryCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCreated) ProtoMessage() {}

func (x *PayloadRepositoryCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryCreated.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{11}
}

func (x *PayloadRepositoryCreated) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCreated) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCreated) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.Visibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryCreated) GetDefaultLabelName() string {
	if x != nil {
		return x.DefaultLabelName
	}
	return ""
}

type PayloadRepositoryDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// visibility is the visibility of the repository.
	Visibility v1alpha1.Visibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility" json:"visibility,omitempty"`
}

func (x *PayloadRepositoryDeleted) Reset() {
	*x = PayloadRepositoryDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDeleted) ProtoMessage() {}

func (x *PayloadRepositoryDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryDeleted.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{12}
}

func (x *PayloadRepositoryDeleted) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDeleted) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDeleted) GetVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.Visibility
	}
	return v1alpha1.Visibility(0)
}

type PayloadRepositoryCommitPushed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository within which the commit was created.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository within which the commit was created.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// tags are the tags included in the push. Optional.
	Tags []string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	// draft_name is the name of the draft. Optional.
	DraftName string `protobuf:"bytes,6,opt,name=draft_name,json=draftName,proto3" json:"draft_name,omitempty"`
	// manifest_digest is the module's manifest digest.
	ManifestDigest string `protobuf:"bytes,7,opt,name=manifest_digest,json=manifestDigest,proto3" json:"manifest_digest,omitempty"`
	// b5_digest is the module's b5 digest.
	B5Digest string `protobuf:"bytes,8,opt,name=b5_digest,json=b5Digest,proto3" json:"b5_digest,omitempty"`
}

func (x *PayloadRepositoryCommitPushed) Reset() {
	*x = PayloadRepositoryCommitPushed{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCommitPushed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCommitPushed) ProtoMessage() {}

func (x *PayloadRepositoryCommitPushed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryCommitPushed.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryCommitPushed) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{13}
}

func (x *PayloadRepositoryCommitPushed) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *PayloadRepositoryCommitPushed) GetDraftName() string {
	if x != nil {
		return x.DraftName
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetManifestDigest() string {
	if x != nil {
		return x.ManifestDigest
	}
	return ""
}

func (x *PayloadRepositoryCommitPushed) GetB5Digest() string {
	if x != nil {
		return x.B5Digest
	}
	return ""
}

type PayloadRepositoryContributorAdded struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository with the new contributor.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository with the new contributor.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// contributor_role is the role granted to the contributor added to the repository.
	ContributorRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=contributor_role,json=contributorRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"contributor_role,omitempty"`
}

func (x *PayloadRepositoryContributorAdded) Reset() {
	*x = PayloadRepositoryContributorAdded{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorAdded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorAdded) ProtoMessage() {}

func (x *PayloadRepositoryContributorAdded) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryContributorAdded.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryContributorAdded) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{14}
}

func (x *PayloadRepositoryContributorAdded) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorAdded) GetContributorRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.ContributorRole
	}
	return v1alpha1.RepositoryRole(0)
}

type PayloadRepositoryContributorRoleChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository within which the role was changed.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository within which the role was changed.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// old_role is the old role of the contributor whose role was changed.
	OldRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=old_role,json=oldRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"old_role,omitempty"`
	// new_role is the new role of the contributor whose role was changed.
	NewRole v1alpha1.RepositoryRole `protobuf:"varint,6,opt,name=new_role,json=newRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"new_role,omitempty"`
}

func (x *PayloadRepositoryContributorRoleChanged) Reset() {
	*x = PayloadRepositoryContributorRoleChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRoleChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRoleChanged) ProtoMessage() {}

func (x *PayloadRepositoryContributorRoleChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryContributorRoleChanged.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryContributorRoleChanged) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{15}
}

func (x *PayloadRepositoryContributorRoleChanged) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRoleChanged) GetOldRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.OldRole
	}
	return v1alpha1.RepositoryRole(0)
}

func (x *PayloadRepositoryContributorRoleChanged) GetNewRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.NewRole
	}
	return v1alpha1.RepositoryRole(0)
}

type PayloadRepositoryContributorRemoved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository that the contributor was removed from.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository that the contributor was removed from.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// contributor_role is the role that the contributor had when removed from the repository.
	ContributorRole v1alpha1.RepositoryRole `protobuf:"varint,5,opt,name=contributor_role,json=contributorRole,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole" json:"contributor_role,omitempty"`
}

func (x *PayloadRepositoryContributorRemoved) Reset() {
	*x = PayloadRepositoryContributorRemoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryContributorRemoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryContributorRemoved) ProtoMessage() {}

func (x *PayloadRepositoryContributorRemoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryContributorRemoved.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryContributorRemoved) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{16}
}

func (x *PayloadRepositoryContributorRemoved) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryContributorRemoved) GetContributorRole() v1alpha1.RepositoryRole {
	if x != nil {
		return x.ContributorRole
	}
	return v1alpha1.RepositoryRole(0)
}

type PayloadRepositoryVisibilityChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// old_visibility is the old visibility of the repository.
	OldVisibility v1alpha1.Visibility `protobuf:"varint,3,opt,name=old_visibility,json=oldVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility" json:"old_visibility,omitempty"`
	// new_visibility is the new visibility of the repository.
	NewVisibility v1alpha1.Visibility `protobuf:"varint,4,opt,name=new_visibility,json=newVisibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility" json:"new_visibility,omitempty"`
}

func (x *PayloadRepositoryVisibilityChanged) Reset() {
	*x = PayloadRepositoryVisibilityChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryVisibilityChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryVisibilityChanged) ProtoMessage() {}

func (x *PayloadRepositoryVisibilityChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryVisibilityChanged.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryVisibilityChanged) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{17}
}

func (x *PayloadRepositoryVisibilityChanged) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryVisibilityChanged) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryVisibilityChanged) GetOldVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.OldVisibility
	}
	return v1alpha1.Visibility(0)
}

func (x *PayloadRepositoryVisibilityChanged) GetNewVisibility() v1alpha1.Visibility {
	if x != nil {
		return x.NewVisibility
	}
	return v1alpha1.Visibility(0)
}

type PayloadRepositoryDefaultLabelNameChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// old_default_label_name is the old default label name of the repository.
	OldDefaultLabelName string `protobuf:"bytes,3,opt,name=old_default_label_name,json=oldDefaultLabelName,proto3" json:"old_default_label_name,omitempty"`
	// new_default_label_name is the new default label name of the repository.
	NewDefaultLabelName string `protobuf:"bytes,4,opt,name=new_default_label_name,json=newDefaultLabelName,proto3" json:"new_default_label_name,omitempty"`
}

func (x *PayloadRepositoryDefaultLabelNameChanged) Reset() {
	*x = PayloadRepositoryDefaultLabelNameChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDefaultLabelNameChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDefaultLabelNameChanged) ProtoMessage() {}

func (x *PayloadRepositoryDefaultLabelNameChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryDefaultLabelNameChanged.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryDefaultLabelNameChanged) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{18}
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetOldDefaultLabelName() string {
	if x != nil {
		return x.OldDefaultLabelName
	}
	return ""
}

func (x *PayloadRepositoryDefaultLabelNameChanged) GetNewDefaultLabelName() string {
	if x != nil {
		return x.NewDefaultLabelName
	}
	return ""
}

type PayloadRepositoryDefaultBranchChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// old_default_branch is the old default branch of the repository.
	OldDefaultBranch string `protobuf:"bytes,3,opt,name=old_default_branch,json=oldDefaultBranch,proto3" json:"old_default_branch,omitempty"`
	// new_default_branch is the new default branch of the repository.
	NewDefaultBranch string `protobuf:"bytes,4,opt,name=new_default_branch,json=newDefaultBranch,proto3" json:"new_default_branch,omitempty"`
}

func (x *PayloadRepositoryDefaultBranchChanged) Reset() {
	*x = PayloadRepositoryDefaultBranchChanged{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryDefaultBranchChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryDefaultBranchChanged) ProtoMessage() {}

func (x *PayloadRepositoryDefaultBranchChanged) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryDefaultBranchChanged.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryDefaultBranchChanged) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{19}
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetOldDefaultBranch() string {
	if x != nil {
		return x.OldDefaultBranch
	}
	return ""
}

func (x *PayloadRepositoryDefaultBranchChanged) GetNewDefaultBranch() string {
	if x != nil {
		return x.NewDefaultBranch
	}
	return ""
}

type PayloadUserCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserCreated) Reset() {
	*x = PayloadUserCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserCreated) ProtoMessage() {}

func (x *PayloadUserCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserCreated.ProtoReflect.Descriptor instead.
func (*PayloadUserCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{20}
}

type PayloadUserReactivated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserReactivated) Reset() {
	*x = PayloadUserReactivated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserReactivated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserReactivated) ProtoMessage() {}

func (x *PayloadUserReactivated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserReactivated.ProtoReflect.Descriptor instead.
func (*PayloadUserReactivated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{21}
}

type PayloadUserDeactivated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserDeactivated) Reset() {
	*x = PayloadUserDeactivated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserDeactivated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserDeactivated) ProtoMessage() {}

func (x *PayloadUserDeactivated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserDeactivated.ProtoReflect.Descriptor instead.
func (*PayloadUserDeactivated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{22}
}

type PayloadUserDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserDeleted) Reset() {
	*x = PayloadUserDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserDeleted) ProtoMessage() {}

func (x *PayloadUserDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserDeleted.ProtoReflect.Descriptor instead.
func (*PayloadUserDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{23}
}

type PayloadUserLoggedIn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserLoggedIn) Reset() {
	*x = PayloadUserLoggedIn{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserLoggedIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserLoggedIn) ProtoMessage() {}

func (x *PayloadUserLoggedIn) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserLoggedIn.ProtoReflect.Descriptor instead.
func (*PayloadUserLoggedIn) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{24}
}

type PayloadUserLoggedOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserLoggedOut) Reset() {
	*x = PayloadUserLoggedOut{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserLoggedOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserLoggedOut) ProtoMessage() {}

func (x *PayloadUserLoggedOut) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserLoggedOut.ProtoReflect.Descriptor instead.
func (*PayloadUserLoggedOut) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{25}
}

// PayloadUserAutoMergedFromNewIdP is the payload for the audit event
// EVENT_TYPE_USER_AUTO_MERGED_FROM_NEW_IDP. It has no additional information
// to be included, since the new user is automatically merged to an existing user
// without the new user being created.
type PayloadUserAutoMergedFromNewIdP struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadUserAutoMergedFromNewIdP) Reset() {
	*x = PayloadUserAutoMergedFromNewIdP{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadUserAutoMergedFromNewIdP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadUserAutoMergedFromNewIdP) ProtoMessage() {}

func (x *PayloadUserAutoMergedFromNewIdP) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadUserAutoMergedFromNewIdP.ProtoReflect.Descriptor instead.
func (*PayloadUserAutoMergedFromNewIdP) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{26}
}

type PayloadCuratedPluginCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the plugin.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the plugin.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
}

func (x *PayloadCuratedPluginCreated) Reset() {
	*x = PayloadCuratedPluginCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadCuratedPluginCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadCuratedPluginCreated) ProtoMessage() {}

func (x *PayloadCuratedPluginCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadCuratedPluginCreated.ProtoReflect.Descriptor instead.
func (*PayloadCuratedPluginCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{27}
}

func (x *PayloadCuratedPluginCreated) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadCuratedPluginCreated) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

type PayloadCuratedPluginDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the plugin.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the plugin.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
}

func (x *PayloadCuratedPluginDeleted) Reset() {
	*x = PayloadCuratedPluginDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadCuratedPluginDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadCuratedPluginDeleted) ProtoMessage() {}

func (x *PayloadCuratedPluginDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadCuratedPluginDeleted.ProtoReflect.Descriptor instead.
func (*PayloadCuratedPluginDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{28}
}

func (x *PayloadCuratedPluginDeleted) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadCuratedPluginDeleted) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

type PayloadTokenCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the token.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// token_expiry_time is the expiry time of the token.
	TokenExpiryTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=token_expiry_time,json=tokenExpiryTime,proto3" json:"token_expiry_time,omitempty"`
}

func (x *PayloadTokenCreated) Reset() {
	*x = PayloadTokenCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadTokenCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadTokenCreated) ProtoMessage() {}

func (x *PayloadTokenCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadTokenCreated.ProtoReflect.Descriptor instead.
func (*PayloadTokenCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{29}
}

func (x *PayloadTokenCreated) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadTokenCreated) GetTokenExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.TokenExpiryTime
	}
	return nil
}

type PayloadTokenDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the token.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
}

func (x *PayloadTokenDeleted) Reset() {
	*x = PayloadTokenDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadTokenDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadTokenDeleted) ProtoMessage() {}

func (x *PayloadTokenDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadTokenDeleted.ProtoReflect.Descriptor instead.
func (*PayloadTokenDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{30}
}

func (x *PayloadTokenDeleted) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

type PayloadSCIMTokenCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// token_expiry_time is the expiry time of the token.
	TokenExpiryTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=token_expiry_time,json=tokenExpiryTime,proto3" json:"token_expiry_time,omitempty"`
}

func (x *PayloadSCIMTokenCreated) Reset() {
	*x = PayloadSCIMTokenCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSCIMTokenCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSCIMTokenCreated) ProtoMessage() {}

func (x *PayloadSCIMTokenCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadSCIMTokenCreated.ProtoReflect.Descriptor instead.
func (*PayloadSCIMTokenCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{31}
}

func (x *PayloadSCIMTokenCreated) GetTokenExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.TokenExpiryTime
	}
	return nil
}

type PayloadSCIMTokenDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadSCIMTokenDeleted) Reset() {
	*x = PayloadSCIMTokenDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadSCIMTokenDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadSCIMTokenDeleted) ProtoMessage() {}

func (x *PayloadSCIMTokenDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadSCIMTokenDeleted.ProtoReflect.Descriptor instead.
func (*PayloadSCIMTokenDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{32}
}

type PayloadRepositoryCommitDeleted struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository from which the commit will be deleted.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository from which the commit will be deleted.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository from which the commit will be deleted.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository from which the commit will be deleted.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// draft_name is the name of the draft. Optional.
	DraftName string `protobuf:"bytes,5,opt,name=draft_name,json=draftName,proto3" json:"draft_name,omitempty"`
}

func (x *PayloadRepositoryCommitDeleted) Reset() {
	*x = PayloadRepositoryCommitDeleted{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryCommitDeleted) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryCommitDeleted) ProtoMessage() {}

func (x *PayloadRepositoryCommitDeleted) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryCommitDeleted.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryCommitDeleted) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{33}
}

func (x *PayloadRepositoryCommitDeleted) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *PayloadRepositoryCommitDeleted) GetDraftName() string {
	if x != nil {
		return x.DraftName
	}
	return ""
}

type PayloadRepositoryLabelCreated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository on which the label was created.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository on which the label was created.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository on which the label was created.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository from which the label was created.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// label_namespace is the namespace of the label that was created.
	//
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	LabelNamespace string `protobuf:"bytes,5,opt,name=label_namespace,json=labelNamespace,proto3" json:"label_namespace,omitempty"`
	// commit_id is the id of the commit on which the label was created.
	CommitId string `protobuf:"bytes,6,opt,name=commit_id,json=commitId,proto3" json:"commit_id,omitempty"`
}

func (x *PayloadRepositoryLabelCreated) Reset() {
	*x = PayloadRepositoryLabelCreated{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelCreated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelCreated) ProtoMessage() {}

func (x *PayloadRepositoryLabelCreated) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryLabelCreated.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryLabelCreated) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{34}
}

func (x *PayloadRepositoryLabelCreated) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelCreated) GetLabelNamespace() string {
	if x != nil {
		return x.LabelNamespace
	}
	return ""
}

func (x *PayloadRepositoryLabelCreated) GetCommitId() string {
	if x != nil {
		return x.CommitId
	}
	return ""
}

type PayloadRepositoryLabelMoved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository on which the label was moved.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository on which the label was moved.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository on which the label was moved.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository from which the label was moved.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// label_namespace is the namespace of the label that was moved.
	//
	// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
	LabelNamespace string `protobuf:"bytes,5,opt,name=label_namespace,json=labelNamespace,proto3" json:"label_namespace,omitempty"`
	// to_commit_id is the id of the commit on which the label was moved to.
	ToCommitId string `protobuf:"bytes,6,opt,name=to_commit_id,json=toCommitId,proto3" json:"to_commit_id,omitempty"`
	// from_commit_id is the id of the commit on which the label was moved from.
	FromCommitId string `protobuf:"bytes,7,opt,name=from_commit_id,json=fromCommitId,proto3" json:"from_commit_id,omitempty"`
}

func (x *PayloadRepositoryLabelMoved) Reset() {
	*x = PayloadRepositoryLabelMoved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelMoved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelMoved) ProtoMessage() {}

func (x *PayloadRepositoryLabelMoved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryLabelMoved.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryLabelMoved) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{35}
}

func (x *PayloadRepositoryLabelMoved) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

// Deprecated: Marked as deprecated in buf/alpha/audit/v1alpha1/event.proto.
func (x *PayloadRepositoryLabelMoved) GetLabelNamespace() string {
	if x != nil {
		return x.LabelNamespace
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetToCommitId() string {
	if x != nil {
		return x.ToCommitId
	}
	return ""
}

func (x *PayloadRepositoryLabelMoved) GetFromCommitId() string {
	if x != nil {
		return x.FromCommitId
	}
	return ""
}

type PayloadRepositoryLabelArchived struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository on which the label was archived.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository on which the label was archived.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository on which the label was archived.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository from which the label was archived.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
}

func (x *PayloadRepositoryLabelArchived) Reset() {
	*x = PayloadRepositoryLabelArchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelArchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelArchived) ProtoMessage() {}

func (x *PayloadRepositoryLabelArchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryLabelArchived.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryLabelArchived) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{36}
}

func (x *PayloadRepositoryLabelArchived) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelArchived) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

type PayloadRepositoryLabelUnarchived struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// owner_id is the id of the owner of the repository on which the label was unarchived.
	OwnerId string `protobuf:"bytes,1,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// owner_name is the name of the owner of the repository on which the label was unarchived.
	OwnerName string `protobuf:"bytes,2,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// repository_id is the id of the repository on which the label was unarchived.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// repository_name is the name of the repository from which the label was unarchived.
	RepositoryName string `protobuf:"bytes,4,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
}

func (x *PayloadRepositoryLabelUnarchived) Reset() {
	*x = PayloadRepositoryLabelUnarchived{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadRepositoryLabelUnarchived) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadRepositoryLabelUnarchived) ProtoMessage() {}

func (x *PayloadRepositoryLabelUnarchived) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadRepositoryLabelUnarchived.ProtoReflect.Descriptor instead.
func (*PayloadRepositoryLabelUnarchived) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{37}
}

func (x *PayloadRepositoryLabelUnarchived) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *PayloadRepositoryLabelUnarchived) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

type PayloadServerBreakingChangePolicyEnabled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// category is the category of breaking changes.
	Category v1alpha1.BreakingChangeCategory `protobuf:"varint,1,opt,name=category,proto3,enum=buf.alpha.registry.v1alpha1.BreakingChangeCategory" json:"category,omitempty"`
	// ignore_unstable_packages tracks breaking change enforcement for unstable packages.
	IgnoreUnstablePackages *bool `protobuf:"varint,2,opt,name=ignore_unstable_packages,json=ignoreUnstablePackages,proto3,oneof" json:"ignore_unstable_packages,omitempty"`
}

func (x *PayloadServerBreakingChangePolicyEnabled) Reset() {
	*x = PayloadServerBreakingChangePolicyEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerBreakingChangePolicyEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerBreakingChangePolicyEnabled) ProtoMessage() {}

func (x *PayloadServerBreakingChangePolicyEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadServerBreakingChangePolicyEnabled.ProtoReflect.Descriptor instead.
func (*PayloadServerBreakingChangePolicyEnabled) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{38}
}

func (x *PayloadServerBreakingChangePolicyEnabled) GetCategory() v1alpha1.BreakingChangeCategory {
	if x != nil {
		return x.Category
	}
	return v1alpha1.BreakingChangeCategory(0)
}

func (x *PayloadServerBreakingChangePolicyEnabled) GetIgnoreUnstablePackages() bool {
	if x != nil && x.IgnoreUnstablePackages != nil {
		return *x.IgnoreUnstablePackages
	}
	return false
}

type PayloadServerBreakingChangePolicyDisabled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadServerBreakingChangePolicyDisabled) Reset() {
	*x = PayloadServerBreakingChangePolicyDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerBreakingChangePolicyDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerBreakingChangePolicyDisabled) ProtoMessage() {}

func (x *PayloadServerBreakingChangePolicyDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadServerBreakingChangePolicyDisabled.ProtoReflect.Descriptor instead.
func (*PayloadServerBreakingChangePolicyDisabled) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{39}
}

type PayloadServerUniquenessPolicyEnabled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadServerUniquenessPolicyEnabled) Reset() {
	*x = PayloadServerUniquenessPolicyEnabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerUniquenessPolicyEnabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerUniquenessPolicyEnabled) ProtoMessage() {}

func (x *PayloadServerUniquenessPolicyEnabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadServerUniquenessPolicyEnabled.ProtoReflect.Descriptor instead.
func (*PayloadServerUniquenessPolicyEnabled) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{40}
}

type PayloadServerUniquenessPolicyDisabled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PayloadServerUniquenessPolicyDisabled) Reset() {
	*x = PayloadServerUniquenessPolicyDisabled{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadServerUniquenessPolicyDisabled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadServerUniquenessPolicyDisabled) ProtoMessage() {}

func (x *PayloadServerUniquenessPolicyDisabled) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadServerUniquenessPolicyDisabled.ProtoReflect.Descriptor instead.
func (*PayloadServerUniquenessPolicyDisabled) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{41}
}

type PayloadDeviceAuthorizationGrantApproved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// client_id is the id of the registered oauth2 client of the grant.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
}

func (x *PayloadDeviceAuthorizationGrantApproved) Reset() {
	*x = PayloadDeviceAuthorizationGrantApproved{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadDeviceAuthorizationGrantApproved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadDeviceAuthorizationGrantApproved) ProtoMessage() {}

func (x *PayloadDeviceAuthorizationGrantApproved) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadDeviceAuthorizationGrantApproved.ProtoReflect.Descriptor instead.
func (*PayloadDeviceAuthorizationGrantApproved) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{42}
}

func (x *PayloadDeviceAuthorizationGrantApproved) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

type PayloadDeviceAuthorizationGrantDenied struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// client_id is the id of the registered oauth2 client of the grant.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
}

func (x *PayloadDeviceAuthorizationGrantDenied) Reset() {
	*x = PayloadDeviceAuthorizationGrantDenied{}
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PayloadDeviceAuthorizationGrantDenied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PayloadDeviceAuthorizationGrantDenied) ProtoMessage() {}

func (x *PayloadDeviceAuthorizationGrantDenied) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PayloadDeviceAuthorizationGrantDenied.ProtoReflect.Descriptor instead.
func (*PayloadDeviceAuthorizationGrantDenied) Descriptor() ([]byte, []int) {
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP(), []int{43}
}

func (x *PayloadDeviceAuthorizationGrantDenied) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

var File_buf_alpha_audit_v1alpha1_event_proto protoreflect.FileDescriptor

var file_buf_alpha_audit_v1alpha1_event_proto_rawDesc = []byte{
	0x0a, 0x24, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x1a, 0x27, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x64, 0x0a, 0x05, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x37, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x59, 0x0a, 0x0d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0xa2, 0x28,
	0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x37, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x05, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x3e, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x69, 0x0a, 0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x69, 0x0a,
	0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x76, 0x0a, 0x19, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f,
	0x61, 0x64, 0x64, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x41, 0x64, 0x64, 0x65, 0x64, 0x48, 0x00, 0x52, 0x17, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64,
	0x12, 0x89, 0x01, 0x0a, 0x20, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52, 0x1d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x7c, 0x0a, 0x1b,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x19, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x63, 0x0a, 0x12, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x63, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x75, 0x73, 0x68, 0x65, 0x64,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x16, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x50, 0x75, 0x73, 0x68, 0x65, 0x64, 0x12, 0x7f, 0x0a, 0x1c, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64, 0x48, 0x00, 0x52, 0x1a,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64, 0x12, 0x92, 0x01, 0x0a, 0x23, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52, 0x20, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12,
	0x85, 0x01, 0x0a, 0x1e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x1c, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52,
	0x1b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x96, 0x01, 0x0a,
	0x25, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x48, 0x00, 0x52, 0x21, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x51, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65,
	0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x64, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x44, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x12, 0x51, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x75,
	0x73, 0x65, 0x72, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x0e, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x18, 0x18, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49,
	0x6e, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49,
	0x6e, 0x12, 0x58, 0x0a, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64,
	0x5f, 0x6f, 0x75, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x12, 0x6d, 0x0a, 0x16, 0x63,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x75,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x48, 0x00, 0x52, 0x14, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x64, 0x0a, 0x0f, 0x69, 0x64,
	0x70, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x65, 0x64, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x44, 0x50, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x64, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x0d, 0x69, 0x64, 0x70, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x64, 0x65, 0x64,
	0x12, 0x6a, 0x0a, 0x11, 0x69, 0x64, 0x70, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x72, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x50, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x64, 0x70,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x0d,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x1d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x54, 0x0a, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x1f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x52, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x12, 0x73, 0x63, 0x69, 0x6d, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x20, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x10, 0x73, 0x63, 0x69, 0x6d, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x12, 0x73, 0x63,
	0x69, 0x6d, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x10, 0x73, 0x63, 0x69,
	0x6d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x76, 0x0a,
	0x19, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x17, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x48, 0x00, 0x52, 0x16, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x6d, 0x0a, 0x16, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6d,
	0x6f, 0x76, 0x65, 0x64, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x76, 0x0a, 0x19, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x17, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x64, 0x12, 0x7c, 0x0a, 0x1b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x75, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64,
	0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x64, 0x48, 0x00, 0x52, 0x19, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12,
	0x6d, 0x0a, 0x16, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x14, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0xa5,
	0x01, 0x0a, 0x2d, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x28, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0xa8, 0x01, 0x0a, 0x2e, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x29, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x1e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x12, 0x98, 0x01, 0x0a, 0x28, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x29, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x24, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x9b, 0x01, 0x0a, 0x29,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x48, 0x00, 0x52, 0x25, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x7c, 0x0a, 0x1d, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x6e, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x70, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65,
	0x64, 0x46, 0x72, 0x6f, 0x6d, 0x4e, 0x65, 0x77, 0x49, 0x64, 0x50, 0x48, 0x00, 0x52, 0x18, 0x75,
	0x73, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x46, 0x72, 0x6f,
	0x6d, 0x4e, 0x65, 0x77, 0x49, 0x64, 0x70, 0x12, 0x92, 0x01, 0x0a, 0x23, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x18,
	0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x20, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x8c, 0x01, 0x0a,
	0x21, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x6e, 0x69,
	0x65, 0x64, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72,
	0x61, 0x6e, 0x74, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x48, 0x00, 0x52, 0x1e, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4a, 0x04, 0x08, 0x13, 0x10, 0x14, 0x4a, 0x04, 0x08, 0x14,
	0x10, 0x15, 0x52, 0x0e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x52, 0x0e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0xa9,
	0x02, 0x0a, 0x1e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x41, 0x64, 0x64, 0x65,
	0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x12, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f,
	0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe4, 0x03, 0x0a, 0x24, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x6f, 0x6c, 0x64,
	0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6f, 0x6c, 0x64, 0x52,
	0x6f, 0x6c, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x68, 0x0a,
	0x16, 0x6f, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x13, 0x6f, 0x6c, 0x64, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x68, 0x0a, 0x16, 0x6e, 0x65, 0x77, 0x5f, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x13, 0x6e, 0x65,
	0x77, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0xab, 0x02, 0x0a, 0x20, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x2b, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0b,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65,
	0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x61, 0x0a, 0x12,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x10, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x78, 0x0a, 0x20, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x50, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64,
	0x64, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x22, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x44, 0x50, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12,
	0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x18, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a,
	0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x18, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x22, 0xa0, 0x02, 0x0a, 0x1d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x50,
	0x75, 0x73, 0x68, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x72, 0x61, 0x66, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x35, 0x5f,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x35,
	0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x83, 0x02, 0x0a, 0x21, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x6f, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0xc1, 0x02, 0x0a,
	0x27, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x46, 0x0a, 0x08, 0x6f, 0x6c, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x07, 0x6f, 0x6c, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x46, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f,
	0x72, 0x6f, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x52, 0x6f, 0x6c, 0x65,
	0x22, 0x85, 0x02, 0x0a, 0x23, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x56, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x6f, 0x72, 0x5f,
	0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x6f, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x22, 0xfe, 0x01, 0x0a, 0x22, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12,
	0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x6f, 0x6c, 0x64,
	0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x6f, 0x6c, 0x64, 0x56,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x4e, 0x0a, 0x0e, 0x6e, 0x65, 0x77,
	0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x6e, 0x65, 0x77, 0x56,
	0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xce, 0x01, 0x0a, 0x28, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x33, 0x0a, 0x16, 0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x6f, 0x6c, 0x64, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x25, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c,
	0x0a, 0x12, 0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x6c, 0x64, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x2c, 0x0a, 0x12,
	0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x22, 0x14, 0x0a, 0x12, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x22, 0x18, 0x0a, 0x16, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x52,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x22, 0x18, 0x0a, 0x16, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x22, 0x14, 0x0a, 0x12, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x15, 0x0a, 0x13, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49,
	0x6e, 0x22, 0x16, 0x0a, 0x14, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x22, 0x21, 0x0a, 0x1f, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x73, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x4e, 0x65, 0x77, 0x49, 0x64, 0x50, 0x22, 0x57, 0x0a, 0x1b,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x57, 0x0a, 0x1b, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x78,
	0x0a, 0x13, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x46, 0x0a, 0x11, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x30, 0x0a, 0x13, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12,
	0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x22, 0x61, 0x0a, 0x17, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x46, 0x0a, 0x11, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x19, 0x0a,
	0x17, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x43, 0x49, 0x4d, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0xc7, 0x01, 0x0a, 0x1e, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x72, 0x61, 0x66, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0xf1, 0x01, 0x0a, 0x1d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x22, 0x9a, 0x02, 0x0a, 0x1b, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x4d, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b,
	0x0a, 0x0f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x74,
	0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x74, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a,
	0x0e, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x49, 0x64, 0x22, 0xa8, 0x01, 0x0a, 0x1e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xaa,
	0x01, 0x0a, 0x20, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x28,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65,
	0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x18, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x16, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x88, 0x01, 0x01, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x2b, 0x0a, 0x29, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x22, 0x26, 0x0a, 0x24, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x27, 0x0a, 0x25, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x22, 0x46, 0x0a, 0x27, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x44, 0x0a, 0x25, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x44, 0x65,
	0x6e, 0x69, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x2a, 0x53, 0x0a, 0x09, 0x41, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x43,
	0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x15, 0x0a, 0x11, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x59,
	0x53, 0x54, 0x45, 0x4d, 0x10, 0x02, 0x2a, 0x84, 0x04, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x1e,
	0x0a, 0x1a, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x25,
	0x0a, 0x21, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d,
	0x42, 0x45, 0x52, 0x10, 0x03, 0x12, 0x28, 0x0a, 0x24, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x44, 0x50, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x09, 0x12,
	0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x04, 0x12, 0x28, 0x0a,
	0x24, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52,
	0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x49,
	0x42, 0x55, 0x54, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54,
	0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x06, 0x12, 0x20, 0x0a, 0x1c,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55,
	0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x10, 0x08, 0x12, 0x17,
	0x0a, 0x13, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x0a, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x49, 0x4d, 0x5f, 0x54, 0x4f,
	0x4b, 0x45, 0x4e, 0x10, 0x0b, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52,
	0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x10, 0x0c, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x52, 0x10, 0x0d, 0x12, 0x2c, 0x0a, 0x28, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48,
	0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x10,
	0x0e, 0x22, 0x04, 0x08, 0x07, 0x10, 0x07, 0x2a, 0x14, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x2a, 0xee, 0x0d,
	0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x28, 0x0a, 0x24, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d,
	0x42, 0x45, 0x52, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x2f, 0x0a, 0x2b, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x52, 0x4f,
	0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x04, 0x12, 0x2a, 0x0a, 0x26,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x52,
	0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x05, 0x12, 0x2b, 0x0a, 0x27, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x44, 0x50, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x41, 0x44,
	0x44, 0x45, 0x44, 0x10, 0x15, 0x12, 0x2d, 0x0a, 0x29, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x49, 0x44, 0x50, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56,
	0x45, 0x44, 0x10, 0x16, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59,
	0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x27, 0x0a, 0x23, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54,
	0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x45,
	0x44, 0x10, 0x08, 0x12, 0x2b, 0x0a, 0x27, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e,
	0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x4f, 0x52, 0x5f, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x09,
	0x12, 0x32, 0x0a, 0x2e, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52,
	0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x49,
	0x42, 0x55, 0x54, 0x4f, 0x52, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x44, 0x10, 0x0a, 0x12, 0x2d, 0x0a, 0x29, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x4f,
	0x4e, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45,
	0x44, 0x10, 0x0b, 0x12, 0x2c, 0x0a, 0x28, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x56, 0x49, 0x53,
	0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10,
	0x0c, 0x12, 0x34, 0x0a, 0x30, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55,
	0x4c, 0x54, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x28, 0x12, 0x21, 0x0a, 0x19, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x0d, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x21, 0x0a, 0x19, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x0e, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x25, 0x0a,
	0x21, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x52, 0x41,
	0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x14, 0x12, 0x25, 0x0a, 0x21, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x1f, 0x12, 0x1b, 0x0a, 0x17, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x44, 0x10, 0x10, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x11, 0x12, 0x1d, 0x0a, 0x19, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4c, 0x4f, 0x47, 0x47, 0x45, 0x44,
	0x5f, 0x49, 0x4e, 0x10, 0x12, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4c, 0x4f, 0x47, 0x47, 0x45, 0x44, 0x5f,
	0x4f, 0x55, 0x54, 0x10, 0x13, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x17, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x18, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x19, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x53, 0x43, 0x49, 0x4d, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x1a, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x49, 0x4d, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x1b, 0x12, 0x28, 0x0a, 0x24, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52,
	0x59, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x1c, 0x12, 0x27, 0x0a, 0x23, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x1d, 0x12, 0x25, 0x0a, 0x21, 0x45,
	0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49,
	0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x56, 0x45, 0x44,
	0x10, 0x1e, 0x12, 0x28, 0x0a, 0x24, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x44, 0x10, 0x26, 0x12, 0x2a, 0x0a, 0x26,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x41, 0x52,
	0x43, 0x48, 0x49, 0x56, 0x45, 0x44, 0x10, 0x27, 0x12, 0x34, 0x0a, 0x30, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x42, 0x52,
	0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x20, 0x12, 0x35,
	0x0a, 0x31, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x45, 0x52, 0x5f, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x21, 0x12, 0x30, 0x0a, 0x2c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x44,
	0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x42, 0x52, 0x41, 0x4e, 0x43, 0x48, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x22, 0x12, 0x2f, 0x0a, 0x2b, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x49,
	0x51, 0x55, 0x45, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x23, 0x12, 0x30, 0x0a, 0x2c, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x49, 0x51, 0x55, 0x45, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x24, 0x12, 0x2c, 0x0a, 0x28, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x55,
	0x54, 0x4f, 0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x44, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x4e,
	0x45, 0x57, 0x5f, 0x49, 0x44, 0x50, 0x10, 0x25, 0x12, 0x32, 0x0a, 0x2e, 0x45, 0x56, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x55,
	0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x4e,
	0x54, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x29, 0x12, 0x30, 0x0a, 0x2c,
	0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x2a, 0x42, 0x82,
	0x02, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42,
	0x0a, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67,
	0x65, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x3b, 0x61, 0x75, 0x64, 0x69, 0x74, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x41, 0xaa, 0x02, 0x18, 0x42, 0x75, 0x66, 0x2e, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0xca, 0x02, 0x18, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c,
	0x41, 0x75, 0x64, 0x69, 0x74, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02,
	0x24, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0x3a, 0x3a, 0x41, 0x75, 0x64, 0x69, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_audit_v1alpha1_event_proto_rawDescOnce sync.Once
	file_buf_alpha_audit_v1alpha1_event_proto_rawDescData = file_buf_alpha_audit_v1alpha1_event_proto_rawDesc
)

func file_buf_alpha_audit_v1alpha1_event_proto_rawDescGZIP() []byte {
	file_buf_alpha_audit_v1alpha1_event_proto_rawDescOnce.Do(func() {
		file_buf_alpha_audit_v1alpha1_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_audit_v1alpha1_event_proto_rawDescData)
	})
	return file_buf_alpha_audit_v1alpha1_event_proto_rawDescData
}

var file_buf_alpha_audit_v1alpha1_event_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_alpha_audit_v1alpha1_event_proto_msgTypes = make([]protoimpl.MessageInfo, 44)
var file_buf_alpha_audit_v1alpha1_event_proto_goTypes = []any{
	(ActorType)(0),                                    // 0: buf.alpha.audit.v1alpha1.ActorType
	(ResourceType)(0),                                 // 1: buf.alpha.audit.v1alpha1.ResourceType
	(EventType)(0),                                    // 2: buf.alpha.audit.v1alpha1.EventType
	(*Actor)(nil),                                     // 3: buf.alpha.audit.v1alpha1.Actor
	(*Resource)(nil),                                  // 4: buf.alpha.audit.v1alpha1.Resource
	(*EventMetadata)(nil),                             // 5: buf.alpha.audit.v1alpha1.EventMetadata
	(*Event)(nil),                                     // 6: buf.alpha.audit.v1alpha1.Event
	(*PayloadOrganizationCreated)(nil),                // 7: buf.alpha.audit.v1alpha1.PayloadOrganizationCreated
	(*PayloadOrganizationDeleted)(nil),                // 8: buf.alpha.audit.v1alpha1.PayloadOrganizationDeleted
	(*PayloadOrganizationMemberAdded)(nil),            // 9: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded
	(*PayloadOrganizationMemberRoleChanged)(nil),      // 10: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged
	(*PayloadOrganizationMemberRemoved)(nil),          // 11: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved
	(*PayloadOrganizationIDPGroupAdded)(nil),          // 12: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded
	(*PayloadOrganizationIDPGroupRemoved)(nil),        // 13: buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved
	(*PayloadRepositoryCreated)(nil),                  // 14: buf.alpha.audit.v1alpha1.PayloadRepositoryCreated
	(*PayloadRepositoryDeleted)(nil),                  // 15: buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted
	(*PayloadRepositoryCommitPushed)(nil),             // 16: buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushed
	(*PayloadRepositoryContributorAdded)(nil),         // 17: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded
	(*PayloadRepositoryContributorRoleChanged)(nil),   // 18: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged
	(*PayloadRepositoryContributorRemoved)(nil),       // 19: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved
	(*PayloadRepositoryVisibilityChanged)(nil),        // 20: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged
	(*PayloadRepositoryDefaultLabelNameChanged)(nil),  // 21: buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChanged
	(*PayloadRepositoryDefaultBranchChanged)(nil),     // 22: buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChanged
	(*PayloadUserCreated)(nil),                        // 23: buf.alpha.audit.v1alpha1.PayloadUserCreated
	(*PayloadUserReactivated)(nil),                    // 24: buf.alpha.audit.v1alpha1.PayloadUserReactivated
	(*PayloadUserDeactivated)(nil),                    // 25: buf.alpha.audit.v1alpha1.PayloadUserDeactivated
	(*PayloadUserDeleted)(nil),                        // 26: buf.alpha.audit.v1alpha1.PayloadUserDeleted
	(*PayloadUserLoggedIn)(nil),                       // 27: buf.alpha.audit.v1alpha1.PayloadUserLoggedIn
	(*PayloadUserLoggedOut)(nil),                      // 28: buf.alpha.audit.v1alpha1.PayloadUserLoggedOut
	(*PayloadUserAutoMergedFromNewIdP)(nil),           // 29: buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdP
	(*PayloadCuratedPluginCreated)(nil),               // 30: buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreated
	(*PayloadCuratedPluginDeleted)(nil),               // 31: buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeleted
	(*PayloadTokenCreated)(nil),                       // 32: buf.alpha.audit.v1alpha1.PayloadTokenCreated
	(*PayloadTokenDeleted)(nil),                       // 33: buf.alpha.audit.v1alpha1.PayloadTokenDeleted
	(*PayloadSCIMTokenCreated)(nil),                   // 34: buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated
	(*PayloadSCIMTokenDeleted)(nil),                   // 35: buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeleted
	(*PayloadRepositoryCommitDeleted)(nil),            // 36: buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeleted
	(*PayloadRepositoryLabelCreated)(nil),             // 37: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreated
	(*PayloadRepositoryLabelMoved)(nil),               // 38: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMoved
	(*PayloadRepositoryLabelArchived)(nil),            // 39: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchived
	(*PayloadRepositoryLabelUnarchived)(nil),          // 40: buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchived
	(*PayloadServerBreakingChangePolicyEnabled)(nil),  // 41: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled
	(*PayloadServerBreakingChangePolicyDisabled)(nil), // 42: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabled
	(*PayloadServerUniquenessPolicyEnabled)(nil),      // 43: buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabled
	(*PayloadServerUniquenessPolicyDisabled)(nil),     // 44: buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabled
	(*PayloadDeviceAuthorizationGrantApproved)(nil),   // 45: buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApproved
	(*PayloadDeviceAuthorizationGrantDenied)(nil),     // 46: buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDenied
	(*timestamppb.Timestamp)(nil),                     // 47: google.protobuf.Timestamp
	(v1alpha1.OrganizationRole)(0),                    // 48: buf.alpha.registry.v1alpha1.OrganizationRole
	(v1alpha1.OrganizationRoleSource)(0),              // 49: buf.alpha.registry.v1alpha1.OrganizationRoleSource
	(v1alpha1.Visibility)(0),                          // 50: buf.alpha.registry.v1alpha1.Visibility
	(v1alpha1.RepositoryRole)(0),                      // 51: buf.alpha.registry.v1alpha1.RepositoryRole
	(v1alpha1.BreakingChangeCategory)(0),              // 52: buf.alpha.registry.v1alpha1.BreakingChangeCategory
}
var file_buf_alpha_audit_v1alpha1_event_proto_depIdxs = []int32{
	0,  // 0: buf.alpha.audit.v1alpha1.Actor.type:type_name -> buf.alpha.audit.v1alpha1.ActorType
	1,  // 1: buf.alpha.audit.v1alpha1.Resource.type:type_name -> buf.alpha.audit.v1alpha1.ResourceType
	2,  // 2: buf.alpha.audit.v1alpha1.Event.type:type_name -> buf.alpha.audit.v1alpha1.EventType
	3,  // 3: buf.alpha.audit.v1alpha1.Event.actor:type_name -> buf.alpha.audit.v1alpha1.Actor
	4,  // 4: buf.alpha.audit.v1alpha1.Event.resource:type_name -> buf.alpha.audit.v1alpha1.Resource
	47, // 5: buf.alpha.audit.v1alpha1.Event.event_time:type_name -> google.protobuf.Timestamp
	5,  // 6: buf.alpha.audit.v1alpha1.Event.metadata:type_name -> buf.alpha.audit.v1alpha1.EventMetadata
	7,  // 7: buf.alpha.audit.v1alpha1.Event.organization_created:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationCreated
	8,  // 8: buf.alpha.audit.v1alpha1.Event.organization_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationDeleted
	9,  // 9: buf.alpha.audit.v1alpha1.Event.organization_member_added:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded
	10, // 10: buf.alpha.audit.v1alpha1.Event.organization_member_role_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged
	11, // 11: buf.alpha.audit.v1alpha1.Event.organization_member_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved
	14, // 12: buf.alpha.audit.v1alpha1.Event.repository_created:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCreated
	15, // 13: buf.alpha.audit.v1alpha1.Event.repository_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted
	16, // 14: buf.alpha.audit.v1alpha1.Event.repository_commit_pushed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCommitPushed
	17, // 15: buf.alpha.audit.v1alpha1.Event.repository_contributor_added:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded
	18, // 16: buf.alpha.audit.v1alpha1.Event.repository_contributor_role_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged
	19, // 17: buf.alpha.audit.v1alpha1.Event.repository_contributor_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved
	20, // 18: buf.alpha.audit.v1alpha1.Event.repository_visibility_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged
	21, // 19: buf.alpha.audit.v1alpha1.Event.repository_default_label_name_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultLabelNameChanged
	23, // 20: buf.alpha.audit.v1alpha1.Event.user_created:type_name -> buf.alpha.audit.v1alpha1.PayloadUserCreated
	25, // 21: buf.alpha.audit.v1alpha1.Event.user_deactivated:type_name -> buf.alpha.audit.v1alpha1.PayloadUserDeactivated
	26, // 22: buf.alpha.audit.v1alpha1.Event.user_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadUserDeleted
	27, // 23: buf.alpha.audit.v1alpha1.Event.user_logged_in:type_name -> buf.alpha.audit.v1alpha1.PayloadUserLoggedIn
	28, // 24: buf.alpha.audit.v1alpha1.Event.user_logged_out:type_name -> buf.alpha.audit.v1alpha1.PayloadUserLoggedOut
	30, // 25: buf.alpha.audit.v1alpha1.Event.curated_plugin_created:type_name -> buf.alpha.audit.v1alpha1.PayloadCuratedPluginCreated
	12, // 26: buf.alpha.audit.v1alpha1.Event.idp_group_added:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupAdded
	13, // 27: buf.alpha.audit.v1alpha1.Event.idp_group_removed:type_name -> buf.alpha.audit.v1alpha1.PayloadOrganizationIDPGroupRemoved
	32, // 28: buf.alpha.audit.v1alpha1.Event.token_created:type_name -> buf.alpha.audit.v1alpha1.PayloadTokenCreated
	33, // 29: buf.alpha.audit.v1alpha1.Event.token_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadTokenDeleted
	24, // 30: buf.alpha.audit.v1alpha1.Event.user_reactivated:type_name -> buf.alpha.audit.v1alpha1.PayloadUserReactivated
	34, // 31: buf.alpha.audit.v1alpha1.Event.scim_token_created:type_name -> buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated
	35, // 32: buf.alpha.audit.v1alpha1.Event.scim_token_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadSCIMTokenDeleted
	36, // 33: buf.alpha.audit.v1alpha1.Event.repository_commit_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryCommitDeleted
	37, // 34: buf.alpha.audit.v1alpha1.Event.repository_label_created:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelCreated
	38, // 35: buf.alpha.audit.v1alpha1.Event.repository_label_moved:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelMoved
	39, // 36: buf.alpha.audit.v1alpha1.Event.repository_label_archived:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelArchived
	40, // 37: buf.alpha.audit.v1alpha1.Event.repository_label_unarchived:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryLabelUnarchived
	31, // 38: buf.alpha.audit.v1alpha1.Event.curated_plugin_deleted:type_name -> buf.alpha.audit.v1alpha1.PayloadCuratedPluginDeleted
	41, // 39: buf.alpha.audit.v1alpha1.Event.payload_server_breaking_change_policy_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled
	42, // 40: buf.alpha.audit.v1alpha1.Event.payload_server_breaking_change_policy_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyDisabled
	22, // 41: buf.alpha.audit.v1alpha1.Event.repository_default_branch_changed:type_name -> buf.alpha.audit.v1alpha1.PayloadRepositoryDefaultBranchChanged
	43, // 42: buf.alpha.audit.v1alpha1.Event.payload_server_uniqueness_policy_enabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyEnabled
	44, // 43: buf.alpha.audit.v1alpha1.Event.payload_server_uniqueness_policy_disabled:type_name -> buf.alpha.audit.v1alpha1.PayloadServerUniquenessPolicyDisabled
	29, // 44: buf.alpha.audit.v1alpha1.Event.user_auto_merged_from_new_idp:type_name -> buf.alpha.audit.v1alpha1.PayloadUserAutoMergedFromNewIdP
	45, // 45: buf.alpha.audit.v1alpha1.Event.device_authorization_grant_approved:type_name -> buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantApproved
	46, // 46: buf.alpha.audit.v1alpha1.Event.device_authorization_grant_denied:type_name -> buf.alpha.audit.v1alpha1.PayloadDeviceAuthorizationGrantDenied
	48, // 47: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded.member_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	49, // 48: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberAdded.member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	48, // 49: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.old_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	48, // 50: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.new_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	49, // 51: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.old_member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	49, // 52: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRoleChanged.new_member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	48, // 53: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved.member_role:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	49, // 54: buf.alpha.audit.v1alpha1.PayloadOrganizationMemberRemoved.member_role_source:type_name -> buf.alpha.registry.v1alpha1.OrganizationRoleSource
	50, // 55: buf.alpha.audit.v1alpha1.PayloadRepositoryCreated.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	50, // 56: buf.alpha.audit.v1alpha1.PayloadRepositoryDeleted.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	51, // 57: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorAdded.contributor_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	51, // 58: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged.old_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	51, // 59: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRoleChanged.new_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	51, // 60: buf.alpha.audit.v1alpha1.PayloadRepositoryContributorRemoved.contributor_role:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	50, // 61: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged.old_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	50, // 62: buf.alpha.audit.v1alpha1.PayloadRepositoryVisibilityChanged.new_visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	47, // 63: buf.alpha.audit.v1alpha1.PayloadTokenCreated.token_expiry_time:type_name -> google.protobuf.Timestamp
	47, // 64: buf.alpha.audit.v1alpha1.PayloadSCIMTokenCreated.token_expiry_time:type_name -> google.protobuf.Timestamp
	52, // 65: buf.alpha.audit.v1alpha1.PayloadServerBreakingChangePolicyEnabled.category:type_name -> buf.alpha.registry.v1alpha1.BreakingChangeCategory
	66, // [66:66] is the sub-list for method output_type
	66, // [66:66] is the sub-list for method input_type
	66, // [66:66] is the sub-list for extension type_name
	66, // [66:66] is the sub-list for extension extendee
	0,  // [0:66] is the sub-list for field type_name
}

func init() { file_buf_alpha_audit_v1alpha1_event_proto_init() }
func file_buf_alpha_audit_v1alpha1_event_proto_init() {
	if File_buf_alpha_audit_v1alpha1_event_proto != nil {
		return
	}
	file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[3].OneofWrappers = []any{
		(*Event_OrganizationCreated)(nil),
		(*Event_OrganizationDeleted)(nil),
		(*Event_OrganizationMemberAdded)(nil),
		(*Event_OrganizationMemberRoleChanged)(nil),
		(*Event_OrganizationMemberRemoved)(nil),
		(*Event_RepositoryCreated)(nil),
		(*Event_RepositoryDeleted)(nil),
		(*Event_RepositoryCommitPushed)(nil),
		(*Event_RepositoryContributorAdded)(nil),
		(*Event_RepositoryContributorRoleChanged)(nil),
		(*Event_RepositoryContributorRemoved)(nil),
		(*Event_RepositoryVisibilityChanged)(nil),
		(*Event_RepositoryDefaultLabelNameChanged)(nil),
		(*Event_UserCreated)(nil),
		(*Event_UserDeactivated)(nil),
		(*Event_UserDeleted)(nil),
		(*Event_UserLoggedIn)(nil),
		(*Event_UserLoggedOut)(nil),
		(*Event_CuratedPluginCreated)(nil),
		(*Event_IdpGroupAdded)(nil),
		(*Event_IdpGroupRemoved)(nil),
		(*Event_TokenCreated)(nil),
		(*Event_TokenDeleted)(nil),
		(*Event_UserReactivated)(nil),
		(*Event_ScimTokenCreated)(nil),
		(*Event_ScimTokenDeleted)(nil),
		(*Event_RepositoryCommitDeleted)(nil),
		(*Event_RepositoryLabelCreated)(nil),
		(*Event_RepositoryLabelMoved)(nil),
		(*Event_RepositoryLabelArchived)(nil),
		(*Event_RepositoryLabelUnarchived)(nil),
		(*Event_CuratedPluginDeleted)(nil),
		(*Event_PayloadServerBreakingChangePolicyEnabled)(nil),
		(*Event_PayloadServerBreakingChangePolicyDisabled)(nil),
		(*Event_RepositoryDefaultBranchChanged)(nil),
		(*Event_PayloadServerUniquenessPolicyEnabled)(nil),
		(*Event_PayloadServerUniquenessPolicyDisabled)(nil),
		(*Event_UserAutoMergedFromNewIdp)(nil),
		(*Event_DeviceAuthorizationGrantApproved)(nil),
		(*Event_DeviceAuthorizationGrantDenied)(nil),
	}
	file_buf_alpha_audit_v1alpha1_event_proto_msgTypes[38].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_audit_v1alpha1_event_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_alpha_audit_v1alpha1_event_proto_goTypes,
		DependencyIndexes: file_buf_alpha_audit_v1alpha1_event_proto_depIdxs,
		EnumInfos:         file_buf_alpha_audit_v1alpha1_event_proto_enumTypes,
		MessageInfos:      file_buf_alpha_audit_v1alpha1_event_proto_msgTypes,
	}.Build()
	File_buf_alpha_audit_v1alpha1_event_proto = out.File
	file_buf_alpha_audit_v1alpha1_event_proto_rawDesc = nil
	file_buf_alpha_audit_v1alpha1_event_proto_goTypes = nil
	file_buf_alpha_audit_v1alpha1_event_proto_depIdxs = nil
}
