/*-
 * Copyright (c) 2008 Iain Hibbert
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/un.h>

#include <bluetooth.h>
#include <err.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qprogressbar.h>
#include <qsocketnotifier.h>
#include <qspinbox.h>
#include <qtimer.h>

#include "pindialog.h"

PINDialog::PINDialog()
{

	setupUi(this);
	connect( randomButton, SIGNAL(clicked()), this, SLOT(randompin()) );
}

PINDialog::~PINDialog()
{
}

void PINDialog::tickle()
{
    	int p;
    
    	p = progressBar->value();
    	if (p < progressBar->maximum())
		progressBar->setValue( p + 1 );
    	else
		reject();
}

void PINDialog::randompin()
{
	char pin[HCI_PIN_SIZE + 1];
	int i;

	memset(pin, 0, sizeof(pin));

	for (i = 0 ; i < randomLength->value() ; i++)
		pin[i] = '0' + (random() % 10);
		    
	pinLineEdit->setText( pin );
}
