// distribution boxbackup-0.11.1 (svn version: 2821_2827)
// Box Backup, http://www.boxbackup.org/
// 
// Copyright (c) 2003-2010, Ben Summers and contributors.
// All rights reserved.
// 
// Note that this project uses mixed licensing. Any file with this license
// attached, or where the code LICENSE-GPL appears on the first line, falls
// under the "Box Backup GPL" license. See the file COPYING.txt for more
// information about this license.
// 
// ---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
// [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any software that can be downloaded from
// the OpenSSL website [http://www.openssl.org] under either the
// "OpenSSL License" or the "Original SSLeay License", and to distribute
// the linked executables under the terms of the "Box Backup GPL" license.
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
// or Microsoft Windows Software Development Kit (SDK), including
// vssapi.lib, that can be downloaded from the Microsoft website
// [*.microsoft.com], and to distribute the linked executables under the
// terms of the "Box Backup GPL" license.
// --------------------------------------------------------------------------
//
// File
//		Name:    BackupStoreContants.h
//		Purpose: constants for the backup system
//		Created: 2003/08/28
//
// --------------------------------------------------------------------------

#ifndef BACKUPSTORECONSTANTS__H
#define BACKUPSTORECONSTANTS__H

#define BACKUPSTORE_ROOT_DIRECTORY_ID	1

#define BACKUP_STORE_SERVER_VERSION		1

// Minimum size for a chunk to be compressed
#define BACKUP_FILE_MIN_COMPRESSED_CHUNK_SIZE	256

// min and max sizes for blocks
#define BACKUP_FILE_MIN_BLOCK_SIZE				4096
#define BACKUP_FILE_MAX_BLOCK_SIZE				(512*1024)

// Increase the block size if there are more than this number of blocks
#define BACKUP_FILE_INCREASE_BLOCK_SIZE_AFTER 	4096

// Avoid creating blocks smaller than this
#define	BACKUP_FILE_AVOID_BLOCKS_LESS_THAN		128

// Maximum number of sizes to do an rsync-like scan for
#define BACKUP_FILE_DIFF_MAX_BLOCK_SIZES		64

// When doing rsync scans, do not scan for blocks smaller than
#define BACKUP_FILE_DIFF_MIN_BLOCK_SIZE			128

// A limit to stop diffing running out of control: If more than this
// times the number of blocks in the original index are found, stop
// looking. This stops really bad cases of diffing files containing
// all the same byte using huge amounts of memory and processor time.
// This is a multiple of the number of blocks in the diff from file.
#define BACKUP_FILE_DIFF_MAX_BLOCK_FIND_MULTIPLE	4096

#endif // BACKUPSTORECONSTANTS__H

