/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * wikilinks.c - 19.07.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>

#include "plugin.h"

#include "bk_edit_icon.h"
#include "bk_edit_dialog_info.h"

static FILE *file;
static GString *level;

int init (plugin *plug)
{
	plug->name        = "WikiLinks Export";
	plug->short_name  = "WikiLinks";
	plug->description = "";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_SAVE;

	plug->cleanup = cleanup;

	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	level = g_string_new ("*");

	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

	return PLUGIN_OK;
}


void save_end (void)
{
	g_string_free (level, TRUE);

	fclose (file);
}


void save_separator (bk_edit_tree_data *node_data)
{
	fprintf (file, "----\n");
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	fprintf (file, "%s [%s %s]\n", level->str, node_data->elements[URI], node_data->elements[NAME]);
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	fprintf (file, "%s %s\n", level->str, node_data->elements[NAME]);

	g_string_append_c (level, '*');
}


void save_folder_out (void)
{
	g_string_erase (level, 0, 1);
}

