/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * sitebar_misc.c - 27.05.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 'SiteBar : Bookmark Sidebar'
 * <http://sitebar.sourceforge.net/>
 *
 */

#include <stdlib.h>

#include "sitebar_misc.h"


char *encode_colons (char *text)
{
	char *new_text;

	char *from = text;
	char *to;

	int colons = 0;

	while (*from != '\0')
	{
		if (*from == ':')
		{
			colons++;
		}

		from++;
	}

	if (colons == 0)
	{
		return NULL;
	}

	new_text = (char *) malloc ((colons * 5) + (from - text) + 1);
	if (new_text == NULL)
	{
		return NULL;
	}

	from = text;
	to = new_text;

	while (*from != '\0')
	{
		if (*from == ':')
		{
			*to++ = '&';
			*to++ = '#';
			*to++ = '5';
			*to++ = '8';
			*to++ = ';';
		}
		else
		{
			*to++ = *from;
		}

		from++;
	}
	*to = '\0';

	return new_text;
}


char *decode_colons (char *text)
{
	return NULL;
}

