/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * sitebar.c - 26.07.2007 - v0.2 - ::bk_edit:: header
 *             27.05.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 'SiteBar : Bookmark Sidebar'
 * <http://sitebar.sourceforge.net/>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"
#include "g_stack.h"
#include "sitebar_misc.h"

#include "bk_edit_icon.h"
#include "bk_edit_dialog_info.h"

static FILE *file;

static char *parent;
static g_stack *parent_stack;
static GList *parent_collector;

int init (plugin *plug)
{
	plug->name        = "SiteBar Export";
	plug->short_name  = "SiteBar";
	plug->description = "SiteBar export plugin (http://sitebar.sourceforge.net/)";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_SAVE;

	plug->cleanup = cleanup;

	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	parent = strdup ("root");
	if (parent == NULL)
	{
		return PLUGIN_KO;
	}

	parent_stack = g_stack_new (parent_stack);
	if (parent_stack == NULL)
	{
		fprintf (stderr, "%s[%d]: g_stack_new ()\n", __FILE__, __LINE__);
		return PLUGIN_KO;
	}

	parent_collector = NULL;

	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

	fprintf (file, "::bk_edit::\n");

	return PLUGIN_OK;
}


void save_end (void)
{
	GList *iter = parent_collector;
	while (iter != NULL)
	{
		free (iter->data);
		iter = iter->next;
	}
	g_list_free (parent_collector);

	g_stack_delete (parent_stack);

	fclose (file);
}


void save_separator (bk_edit_tree_data *node_data)
{
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	char *name = encode_colons (node_data->elements[NAME]);
	char *comment = encode_colons (node_data->elements[COMMENT]);
	char *owner = "";

	fprintf (file, "0::0::%s::%s::%s::%s::%s\n",
			parent,
			owner,
			name == NULL ? node_data->elements[NAME] : name,
			comment == NULL ? node_data->elements[COMMENT] : comment,
			node_data->elements[URI]);

	if (name != NULL)
	{
		free (name);
	}

	if (comment != NULL)
	{
		free (comment);
	}
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	char *name = encode_colons (node_data->elements[NAME]);
	char *comment = encode_colons (node_data->elements[COMMENT]);
	char *owner = "";

	if (g_stack_push (parent_stack, (void *) parent) != G_STACK_OK)
	{
		fprintf (stderr, "%s[%d]: g_stack_push ()\n", __FILE__, __LINE__);
		return;
	}

	fprintf (file, "1::0::%s::%s::%s::%s\n",
			parent,
			owner,
			name == NULL ? node_data->elements[NAME] : name,
			comment == NULL ? node_data->elements[COMMENT] : comment);

	parent = strdup (name == NULL ? node_data->elements[NAME] : name);
	parent_collector = g_list_append (parent_collector, parent);

	if (name != NULL)
	{
		free (name);
	}

	if (comment != NULL)
	{
		free (comment);
	}
}


void save_folder_out (void)
{
	if ((parent = (char *) g_stack_pop (parent_stack)) == 0)
	{
		fprintf (stderr, "%s[%d]: g_stack_pop ()\n", __FILE__, __LINE__);
		return;
	}
}

