/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * opera7.c - 25.04.2003 - v0.1 - opera.c => opera7.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"

#include "bk_edit_tree.h"
#include "bk_edit_icon.h"
#include "bk_edit_data.h"
#include "bk_edit_misc.h"
#include "bk_edit_dialog_info.h"

#include "opera7_misc.h"
#include "opera7_parse.h"

extern opera_parse *opera;

extern FILE *yyin;
extern int yyparse (void);
extern int yyrestart (FILE *);

static FILE *file;
static int level = 1;
static int opera_parse_error = OPERA_PARSE_OK;


int init (plugin *plug)
{
	plug->name        = "Opera 7";
	plug->short_name  = "Opera7";
	plug->description = "Opera 7";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_LOAD | PLUGIN_SAVE | PLUGIN_EDIT;

	plug->cleanup = cleanup;

	plug->load            = load;
	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	plug->edit_ui = edit_ui_new (plug);
	plug->edit_ui_new = edit_ui_new;
	plug->edit_ui_delete = edit_ui_delete;
	plug->edit_ui_set = edit_ui_set;
	plug->edit_ui_get = edit_ui_get;

	plug->bookmark_edit_dialog_style.name            = SHOW;
	plug->bookmark_edit_dialog_style.uri             = SHOW;
	plug->bookmark_edit_dialog_style.comment         = SHOW;
	plug->bookmark_edit_dialog_style.add_date        = SHOW;
	plug->bookmark_edit_dialog_style.last_visit      = SHOW;
	plug->bookmark_edit_dialog_style.order           = SHOW;
	plug->bookmark_edit_dialog_style.short_name      = SHOW;
	plug->bookmark_edit_dialog_style.nickname        = SHOW;
	plug->bookmark_edit_dialog_style.on_personalbar  = SHOW;
	plug->bookmark_edit_dialog_style.personalbar_pos = SHOW;
	plug->bookmark_edit_dialog_style.active          = SHOW;
	plug->bookmark_edit_dialog_style.in_panel        = SHOW;
	plug->bookmark_edit_dialog_style.panel_pos       = SHOW;

	plug->folder_edit_dialog_style.name            = SHOW;
	plug->folder_edit_dialog_style.comment         = SHOW;
	plug->folder_edit_dialog_style.add_date        = SHOW;
	plug->folder_edit_dialog_style.last_visit      = SHOW;
	plug->folder_edit_dialog_style.order           = SHOW;
	plug->folder_edit_dialog_style.short_name      = SHOW;
 	plug->folder_edit_dialog_style.nickname        = SHOW;
 	plug->folder_edit_dialog_style.trash_folder    = SHOW;
 	plug->folder_edit_dialog_style.on_personalbar  = SHOW;
 	plug->folder_edit_dialog_style.personalbar_pos = SHOW;
 	plug->folder_edit_dialog_style.active          = SHOW;
 	plug->folder_edit_dialog_style.in_panel        = SHOW;
 	plug->folder_edit_dialog_style.panel_pos       = SHOW;
 	plug->folder_edit_dialog_style.linkbar_folder  = SHOW;
 	plug->folder_edit_dialog_style.linkbar_stop    = SHOW;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int load (char *filename)
{
	int ret;

	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	opera = (opera_parse *) malloc (sizeof (opera_parse));
	if (opera == NULL)
	{
		fprintf (stderr, "%s[%d]: out of memory (fatal error).", __FILE__, __LINE__);
		return PLUGIN_OUT_OF_MEMORY;
	}

	opera->filename = strdup (filename);
	if (opera->filename == NULL)
	{
		fprintf (stderr, "%s[%d]: out of memory (fatal error).", __FILE__, __LINE__);
		return PLUGIN_OUT_OF_MEMORY;
	}

	yyin = fopen (opera->filename, "r");
	if (yyin == NULL)
	{
		fprintf (stderr, "%s[%d]: no such file: %s (error).\n", __FILE__, __LINE__, opera->filename);
		return PLUGIN_NO_SUCH_FILE;
	}

	node_data.elements[NAME] = opera->filename;
	bk_edit_tree_add_root_node (&node_data);

	if (opera_parse_error != OPERA_PARSE_OK)
	{
		yyrestart (yyin);
	}

	if ((ret = yyparse ()) != OPERA_PARSE_OK)
	{
		opera_parse_error = OPERA_PARSE_KO;
		return PLUGIN_PARSE_ERROR;
	}

	free (opera->filename);
	free (opera);

	opera_parse_error = OPERA_PARSE_OK;
	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

        fprintf (file, "Opera Hotlist version 2.0\nOptions: encoding = utf8, version=3\n\n");

	return PLUGIN_OK;
}


void save_end (void)
{
	fclose (file);
}


void save_separator (bk_edit_tree_data *node_data)
{
	/* void */
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	int i;
	char *comment;
	char *attr[ELEMENTS];
	memset (&attr, 0, sizeof (attr));

	comment = opera_text_encode (node_data->elements[COMMENT]);

	attr[NAME]       = node_data->elements[NAME][0]       == '\0' ? g_strdup ("") : g_strdup (node_data->elements[NAME]);
	attr[URI]        = node_data->elements[URI][0]        == '\0' ? g_strdup ("") : g_strdup (node_data->elements[URI]);
	attr[COMMENT]    = node_data->elements[COMMENT][0]    == '\0' ? g_strdup ("") : g_strdup_printf ("\tDESCRIPTION=%s\n", comment);
	attr[ADD_DATE]   = node_data->elements[ADD_DATE][0]   == '\0' ? g_strdup ("") : g_strdup_printf ("\tCREATED=%s\n", node_data->elements[ADD_DATE]);
	attr[LAST_VISIT] = (node_data->elements[LAST_VISIT][0] == '\0') || (!strcmp (node_data->elements[LAST_VISIT], "0")) ? g_strdup ("") : g_strdup_printf ("\tVISITED=%s\n", node_data->elements[LAST_VISIT]);
	attr[ORDER]      = node_data->elements[ORDER][0]      == '\0' ? g_strdup ("") : g_strdup_printf ("\tORDER=%s\n", node_data->elements[ORDER]);
	attr[SHORT_NAME] = node_data->elements[SHORT_NAME][0] == '\0' ? g_strdup ("") : g_strdup_printf ("\tSHORT NAME=%s\n", node_data->elements[SHORT_NAME]);
	attr[NICKNAME]   = node_data->elements[NICKNAME][0]   == '\0' ? g_strdup ("") : g_strdup_printf ("\tNICKNAME=%s\n", node_data->elements[NICKNAME]);

	/* Opera 7 */
	attr[ON_PERSONALBAR]  = node_data->elements[ON_PERSONALBAR][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("\tON PERSONALBAR=%s\n", node_data->elements[ON_PERSONALBAR]);
	attr[PERSONALBAR_POS] = node_data->elements[PERSONALBAR_POS][0] == '\0' ? g_strdup ("") : g_strdup_printf ("\tPERSONALBAR_POS=%s\n", node_data->elements[PERSONALBAR_POS]);
	attr[ACTIVE]          = node_data->elements[ACTIVE][0]          == '\0' ? g_strdup ("") : g_strdup_printf ("\tACTIVE=%s\n", node_data->elements[ACTIVE]);
	attr[IN_PANEL]        = node_data->elements[IN_PANEL][0]        == '\0' ? g_strdup ("") : g_strdup_printf ("\tIN PANEL=%s\n", node_data->elements[IN_PANEL]);
	attr[PANEL_POS]       = node_data->elements[PANEL_POS][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("\tPANEL_POS=%s\n", node_data->elements[PANEL_POS]);

	fprintf (file, "#URL\n"
			"\tNAME=%s\n"
			"\tURL=%s\n"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s\n",
			attr[NAME],
			attr[URI],
			attr[ADD_DATE],
			attr[LAST_VISIT],
			attr[ORDER],
			attr[COMMENT],
			attr[SHORT_NAME],
			attr[NICKNAME],
			attr[ON_PERSONALBAR],
			attr[PERSONALBAR_POS],
			attr[ACTIVE],
			attr[IN_PANEL],
			attr[PANEL_POS]);

	for (i = NAME; i < ELEMENTS; i++)
	{
		if (attr[i] != NULL)
		{
			free (attr[i]);
		}
	}

	free (comment);
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	int i;
	char *comment;
	char *attr[ELEMENTS];
	memset (&attr, 0, sizeof (attr));

	comment = opera_text_encode (node_data->elements[COMMENT]);

	attr[NAME]       = node_data->elements[NAME][0]       == '\0' ? g_strdup ("") : g_strdup (node_data->elements[NAME]);
	attr[COMMENT]    = node_data->elements[COMMENT][0]    == '\0' ? g_strdup ("") : g_strdup_printf ("\tDESCRIPTION=%s\n", comment);
	attr[ADD_DATE]   = node_data->elements[ADD_DATE][0]   == '\0' ? g_strdup ("") : g_strdup_printf ("\tCREATED=%s\n", node_data->elements[ADD_DATE]);
	attr[LAST_VISIT] = (node_data->elements[LAST_VISIT][0] == '\0') || (!strcmp (node_data->elements[LAST_VISIT], "0")) ? g_strdup ("") : g_strdup_printf ("\tVISITED=%s\n", node_data->elements[LAST_VISIT]);
	attr[ORDER]      = node_data->elements[ORDER][0]      == '\0' ? g_strdup ("") : g_strdup_printf ("\tORDER=%s\n", node_data->elements[ORDER]);
	attr[SHORT_NAME] = node_data->elements[SHORT_NAME][0] == '\0' ? g_strdup ("") : g_strdup_printf ("\tSHORT NAME=%s\n", node_data->elements[SHORT_NAME]);
	attr[NICKNAME]   = node_data->elements[NICKNAME][0]   == '\0' ? g_strdup ("") : g_strdup_printf ("\tNICKNAME=%s\n", node_data->elements[NICKNAME]);

	/* Opera 7 */
	attr[TRASH_FOLDER]    = node_data->elements[TRASH_FOLDER][0]    == '\0' ? g_strdup ("") : g_strdup_printf ("\tTRASH FOLDER=%s\n", node_data->elements[TRASH_FOLDER]);
	attr[ON_PERSONALBAR]  = node_data->elements[ON_PERSONALBAR][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("\tON PERSONALBAR=%s\n", node_data->elements[ON_PERSONALBAR]);
	attr[PERSONALBAR_POS] = node_data->elements[PERSONALBAR_POS][0] == '\0' ? g_strdup ("") : g_strdup_printf ("\tPERSONALBAR_POS=%s\n", node_data->elements[PERSONALBAR_POS]);
	attr[ACTIVE]          = node_data->elements[ACTIVE][0]          == '\0' ? g_strdup ("") : g_strdup_printf ("\tACTIVE=%s\n", node_data->elements[ACTIVE]);
	attr[IN_PANEL]        = node_data->elements[IN_PANEL][0]        == '\0' ? g_strdup ("") : g_strdup_printf ("\tIN PANEL=%s\n", node_data->elements[IN_PANEL]);
	attr[PANEL_POS]       = node_data->elements[PANEL_POS][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("\tPANEL_POS=%s\n", node_data->elements[PANEL_POS]);
	attr[LINKBAR_FOLDER]  = node_data->elements[LINKBAR_FOLDER][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("\tLINKBAR FOLDER=%s\n", node_data->elements[LINKBAR_FOLDER]);
	attr[LINKBAR_STOP]    = node_data->elements[LINKBAR_STOP][0]    == '\0' ? g_strdup ("") : g_strdup_printf ("\tLINKBAR STOP=%s\n", node_data->elements[LINKBAR_STOP]);

	fprintf (file, "#FOLDER\n"
			"\tNAME=%s\n"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s\n",
			attr[NAME],
			attr[ADD_DATE],
			attr[LAST_VISIT],
			attr[ORDER],
			attr[COMMENT],
			attr[SHORT_NAME],
			attr[NICKNAME],
			attr[TRASH_FOLDER],
			attr[ON_PERSONALBAR],
			attr[PERSONALBAR_POS],
			attr[ACTIVE],
			attr[IN_PANEL],
			attr[PANEL_POS],
			attr[LINKBAR_FOLDER],
			attr[LINKBAR_STOP]);

	++level;

	for (i = NAME; i < ELEMENTS; i++)
	{
		if (attr[i] != NULL)
		{
			free (attr[i]);
		}
	}

	free (comment);
}


void save_folder_out (void)
{
	--level;

	fprintf (file, "\n-\n\n");
}

