%{

/*
 * Copyright (C) 2002-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * opera_parse.yacc - 06.03.2003 - v0.2 - bugfix - missing semi-colon
 *                      (reported by David Solomonoff <ds@bmec.hscbklyn.edu>)
 *                    08.03.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>
#include <string.h>

#include "opera_parse.h"

#define YYSTYPE char *

extern opera_parse *opera;

%}

%token OPERA_HOTLIST


/* folder attributes */
%token FOLDER


/* bookmark attributes */
%token BOOKMARK


%token NAME
%token URL
%token CREATED
%token VISITED
%token ORDER
%token EXPANDED
%token DESCRIPTION
%token SHORT_NAME
%token NICKNAME


%token FOLDER_LEAVE
%token LITERAL

%start start

%%

/************************************************************************
 * header
 ************************************************************************/

start: OPERA_HOTLIST content
     ;

content: content folder       { int ret; if ((ret = folder (opera->f_attr)) != OPERA_PARSE_OK ) { return ret; } if ((ret = folder_reset ()) != OPERA_PARSE_OK) { return ret; } }
       | content bookmark     { int ret; if ((ret = bookmark (opera->b_attr)) != OPERA_PARSE_OK ) { return ret; } if ((ret = bookmark_reset ()) != OPERA_PARSE_OK) { return ret; } }
       | content FOLDER_LEAVE { int ret; if ((ret = folder_end ()) != OPERA_PARSE_OK ) { return ret; } }
       | /* void */
       ;

/************************************************************************
 * bookmark
 ************************************************************************/

bookmark: BOOKMARK { int ret; if ((ret = bookmark_new ()) != OPERA_PARSE_OK) { return ret; } } bookmark_attr
        | /* void */
        ;

bookmark_attr: bookmark_attr NAME        literal { opera->b_attr.name = $3; }
             | bookmark_attr URL         literal { opera->b_attr.url = $3; }
             | bookmark_attr CREATED     literal { opera->b_attr.created = $3; }
	     | bookmark_attr VISITED     literal { opera->b_attr.visited = $3; }
	     | bookmark_attr ORDER       literal { opera->b_attr.order = $3; }
	     | bookmark_attr DESCRIPTION literal { opera->b_attr.description = $3; }
	     | bookmark_attr SHORT_NAME  literal { opera->b_attr.short_name = $3; }
	     | bookmark_attr NICKNAME    literal { opera->b_attr.nickname = $3; }
	     | /* void */
	     ;



/************************************************************************
 * folder
 ************************************************************************/

folder: FOLDER { int ret; if ((ret = folder_new ()) != OPERA_PARSE_OK) { return ret; } } folder_attr
      | /* void */
      ;

folder_attr: folder_attr NAME        literal { opera->f_attr.name = $3; }
           | folder_attr CREATED     literal { opera->f_attr.created = $3; }
           | folder_attr VISITED     literal { opera->f_attr.visited = $3; }
	   | folder_attr ORDER       literal { opera->f_attr.order = $3; }
	   | folder_attr DESCRIPTION literal { opera->f_attr.description = $3; }
	   | folder_attr EXPANDED    literal { free ($3); }
	   | folder_attr SHORT_NAME  literal { opera->f_attr.short_name = $3; }
	   | folder_attr NICKNAME    literal { opera->f_attr.nickname = $3; }
	   | /* void */
           ;


/************************************************************************
 * misc
 ************************************************************************/

literal: LITERAL { $$ = $1; }
       | /* void */ { $$ = NULL; }
       ;

%%

