%{

/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * nn4_parse.yacc - 06.03.2003 - v0.6 - bugfix - missing semi-colon
 *                    (reported by David Solomonoff <ds@bmec.hscbklyn.edu>)
 *                  26.02.2002 - v0.4 - bk_parse.yacc => nn4_parse.yacc
 *                  17.02.2002 - v0.3 - bugfix - forgotten parser keywords
 *                    (reported by Steffen Pohle <stpohle@gmx.net>)
 *                  09.08.2001 - v0.2 - mozilla support
 *                  08.01.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>
#include <string.h>

#include "nn4_parse.h"

#define YYSTYPE char *

extern nn4_parse *nn4;

%}

%token DOCTYPE
%token TITLE_BEGIN TITLE_END
%token H1_BEGIN H1_END

%token DT_BEGIN DT_END
%token DL_BEGIN DL_END
%token DD_BEGIN DD_END
%token H3_BEGIN H3_END
%token A_BEGIN A_END

%token CLOSE EQUALS DOUBLE_QUOTE LITERAL TEXT NUMBER HR CHARACTER

/* heading attributes */
%token FOLDED_

/* anchor attributes */
%token HREF_
%token URI_
%token ADD_DATE_
%token LAST_VISIT_
%token LAST_MODIFIED_
%token ALIASID_
%token ALIASOF_

%start start

%%

/************************************************************************
 * header
 ************************************************************************/

start: DOCTYPE title header definition_list
     ;

title: TITLE_BEGIN literal { if ((nn4->title = strdup ($2)) == NULL) { return NN4_PARSE_OUT_OF_MEMORY; } } TITLE_END
     ;

header: H1_BEGIN literal { int ret; if ((ret = title_do_something ($2)) != NN4_PARSE_OK) { return ret; } } H1_END
      ;



/************************************************************************
 * definition list
 ************************************************************************/

definition_list: definition_list DL_BEGIN dl_content { int ret; if ((ret = heading_end ()) != NN4_PARSE_OK) { return ret; } } DL_END
               | /* void */
               ;

dl_content: dl_content definition_term
	  | dl_content definition_list
          | /* void */
          ;

definition_term: DT_BEGIN dt_content
               | HR { int ret; if ((ret = separator_do_something ()) != NN4_PARSE_OK) { return ret; }	}
               ;

dt_content: heading dt_end definition_description { int ret; nn4->h_attr.comment = $3; if ((ret = heading_do_something (nn4->h_attr)) != NN4_PARSE_OK) { return ret; } if ((ret = heading_reset ()) != NN4_PARSE_OK) { return ret; } }
          | anchor  dt_end definition_description { int ret; nn4->a_attr.comment = $3; if ((ret = anchor_do_something (nn4->a_attr)) != NN4_PARSE_OK) { return ret; } if ((ret = anchor_reset ()) != NN4_PARSE_OK) { return ret; } }
	  | /* void */
	  ;

dt_end: DT_END
      | /* void */
      ;

definition_description: DD_BEGIN literal dd_end { $$ = $2; }
                      | /* void */              { $$ = NULL; }
		      ;

dd_end: DD_END
      | /* void */
      ;



/************************************************************************
 * anchor
 ************************************************************************/

anchor: A_BEGIN { int ret; if ((ret = anchor_new ()) != NN4_PARSE_OK) { return ret; } } anchor_attr CLOSE literal { nn4->a_attr.name = $5; } A_END
      | /* void */
      ;

anchor_attr: anchor_attr HREF_          EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->a_attr.href          = $5; }
           | anchor_attr ADD_DATE_      EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->a_attr.add_date      = $5; }
           | anchor_attr LAST_VISIT_    EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->a_attr.last_visit    = $5; }
	   | anchor_attr LAST_MODIFIED_ EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->a_attr.last_modified = $5; }
	   | anchor_attr ALIASID_       EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->a_attr.aliasid       = $5; }
	   | anchor_attr ALIASOF_       EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->a_attr.aliasof       = $5; }
	   | /* void */
	   ;



/************************************************************************
 * heading
 ************************************************************************/

heading: H3_BEGIN { int ret; if ((ret = heading_new ()) != NN4_PARSE_OK) { return ret; } } heading_attr CLOSE literal { nn4->h_attr.name = $5; } H3_END
       ;


heading_attr: heading_attr FOLDED_
            | heading_attr ADD_DATE_ EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { nn4->h_attr.add_date = $5; }
            | /* void */
            ;



/************************************************************************
 * misc
 ************************************************************************/

literal: LITERAL    { $$ = $1;   }
       | /* void */ { $$ = NULL; }
       ;

%%

