/*
 * Copyright (C) 2001-2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * nn4_parse.c - 26.02.2002 - v0.3 - bk_parse.c => nn4_parse.c
 *               09.08.2001 - v0.2 - mozilla support
 *               08.01.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "bk_edit_icon.h"
#include "bk_edit_tree.h"
#include "bk_edit_dialog_info.h"

#include "nn4_parse.h"

nn4_parse *nn4;

/* callback functions */
int title_do_something (char *title)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	nn4->heading = strdup (title);

	node_data.elements[NAME]    = nn4->title;
	node_data.elements[URI]     = nn4->heading;
	node_data.elements[COMMENT] = nn4->filename;

	bk_edit_tree_add_root_node (&node_data);

	return NN4_PARSE_OK;
}

int anchor_new (void)
{
	memset (&nn4->a_attr, 0, sizeof (nn4->a_attr));

	return NN4_PARSE_OK;
}


int anchor_reset (void)
{
	if (nn4->a_attr.name          != NULL) free (nn4->a_attr.name);
	if (nn4->a_attr.href          != NULL) free (nn4->a_attr.href);
	if (nn4->a_attr.comment       != NULL) free (nn4->a_attr.comment);
	if (nn4->a_attr.add_date      != NULL) free (nn4->a_attr.add_date);
	if (nn4->a_attr.last_visit    != NULL) free (nn4->a_attr.last_visit);
	if (nn4->a_attr.last_modified != NULL) free (nn4->a_attr.last_modified);
	if (nn4->a_attr.aliasid       != NULL) free (nn4->a_attr.aliasid);
	if (nn4->a_attr.aliasof       != NULL) free (nn4->a_attr.aliasof);

	return NN4_PARSE_OK;
}


int anchor_do_something (anchor_attr a_attr)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME]          = a_attr.name;
	node_data.elements[URI]           = a_attr.href;
	node_data.elements[COMMENT]       = a_attr.comment;
	node_data.elements[ADD_DATE]      = a_attr.add_date;
	node_data.elements[LAST_VISIT]    = a_attr.last_visit;
	node_data.elements[LAST_MODIFIED] = a_attr.last_modified;
	node_data.elements[ALIASID]       = a_attr.aliasid;
	node_data.elements[ALIASOF]       = a_attr.aliasof;

	if (node_data.elements[COMMENT] != NULL)
	{
		node_data.elements[COMMENT] = g_strchomp (node_data.elements[COMMENT]);
	}

	bk_edit_tree_add_bookmark_node (&node_data);

	return NN4_PARSE_OK;
}


int heading_new (void)
{
	memset (&nn4->h_attr, 0, sizeof (nn4->h_attr));

	return NN4_PARSE_OK;
}


int heading_reset (void)
{
	if (nn4->h_attr.name     != NULL) free (nn4->h_attr.name);
	if (nn4->h_attr.comment  != NULL) free (nn4->h_attr.comment);
	if (nn4->h_attr.add_date != NULL) free (nn4->h_attr.add_date);

	return NN4_PARSE_OK;
}


int heading_end (void)
{
	bk_edit_tree_leave_folder ();

	return NN4_PARSE_OK;
}


int heading_do_something (heading_attr h_attr)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME]     = h_attr.name;
	node_data.elements[COMMENT]  = h_attr.comment;
	node_data.elements[ADD_DATE] = h_attr.add_date;

	if (node_data.elements[COMMENT] != NULL)
	{
		node_data.elements[COMMENT] = g_strchomp (node_data.elements[COMMENT]);
	}

	bk_edit_tree_add_folder_node (&node_data);

	return NN4_PARSE_OK;
}


int separator_do_something (void)
{
	bk_edit_tree_data node_data;
	memset (&node_data, 0, sizeof (node_data));

	node_data.elements[NAME] = "-----------------";

	bk_edit_tree_add_separator (&node_data);

	return NN4_PARSE_OK;
}


void parse_yyerror (char *file, int line, char *error_message, char *yytext)
{
	gchar *error = g_strdup_printf ("%s in file %s at line %d before `%s'.\n", error_message, nn4->filename, line, yytext);
	bk_edit_dialog_info ("bk edit - error", error, icon_warning);
	g_print ("%s", error);
}

