/*
 * Copyright (C) 2002-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * nn4.c - 19.08.2003 - v0.3 - bugfix - added missing <p> tag to file format
 *           (reported by Terry Feldman <tfeldman@lclink.com>)
 *         23.12.2002 - v0.2 - plugin api clean-up
 *         26.02.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"

#include "bk_edit_tree.h"
#include "bk_edit_icon.h"
#include "bk_edit_data.h"
#include "bk_edit_misc.h"
#include "bk_edit_dialog_info.h"

#include "nn4_parse.h"

extern nn4_parse *nn4;

extern FILE *yyin;
extern int yyparse (void);
extern int yyrestart (FILE *);

static FILE *file;
static int level = 1;
static int nn4_parse_error = NN4_PARSE_OK;


int init (plugin *plug)
{
	plug->name        = "Netscape Navigator 3/4";
	plug->short_name  = "Netscape";
	plug->description = "Netscape Navigator 3+ and Netscape Navigator 4+";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_LOAD | PLUGIN_SAVE | PLUGIN_EDIT;

	plug->cleanup = cleanup;

	plug->load            = load;
	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	plug->edit_ui = edit_ui_new (plug);
	plug->edit_ui_new = edit_ui_new;
	plug->edit_ui_delete = edit_ui_delete;
	plug->edit_ui_set = edit_ui_set;
	plug->edit_ui_get = edit_ui_get;

	plug->bookmark_edit_dialog_style.name          = SHOW;
	plug->bookmark_edit_dialog_style.uri           = SHOW;
	plug->bookmark_edit_dialog_style.comment       = SHOW;
	plug->bookmark_edit_dialog_style.add_date      = SHOW;
	plug->bookmark_edit_dialog_style.last_visit    = SHOW;
	plug->bookmark_edit_dialog_style.last_modified = SHOW;
	plug->bookmark_edit_dialog_style.aliasid       = SHOW;
	plug->bookmark_edit_dialog_style.aliasof       = SHOW;

	plug->folder_edit_dialog_style.name     = SHOW;
	plug->folder_edit_dialog_style.comment  = SHOW;
	plug->folder_edit_dialog_style.add_date = SHOW;

	plug->root_edit_dialog_style.name = SHOW;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int load (char *filename)
{
	int ret;

	nn4 = (nn4_parse *) malloc (sizeof (nn4_parse));
	if (nn4 == NULL)
	{
		fprintf (stderr, "%s[%d]: out of memory (fatal error).", __FILE__, __LINE__);
		return PLUGIN_OUT_OF_MEMORY;
	}

	nn4->filename = strdup (filename);
	if (nn4->filename == NULL)
	{
		fprintf (stderr, "%s[%d]: out of memory (fatal error).", __FILE__, __LINE__);
		return PLUGIN_OUT_OF_MEMORY;
	}

	yyin = fopen (nn4->filename, "r");
	if (yyin == NULL)
	{
		fprintf (stderr, "%s[%d]: no such file: %s (error).\n", __FILE__, __LINE__, nn4->filename);
		return PLUGIN_NO_SUCH_FILE;
	}

	if (nn4_parse_error != NN4_PARSE_OK)
	{
		yyrestart (yyin);
	}

	if ((ret = yyparse ()) != NN4_PARSE_OK)
	{
		nn4_parse_error = NN4_PARSE_KO;
		return PLUGIN_PARSE_ERROR;
	}

	free (nn4->title);
	free (nn4->heading);
	free (nn4->filename);
	free (nn4);

	nn4_parse_error = NN4_PARSE_OK;
	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

        fprintf (file, "<!DOCTYPE NETSCAPE-Bookmark-file-1>\n"
			"<TITLE>%s</TITLE>\n"
			"<H1>%s</H1>\n"
			"<DL><p>\n", node_data->elements[URI], node_data->elements[NAME]);

	return PLUGIN_OK;
}


void save_end (void)
{
	fprintf (file, "</DL><p>\n");
	fclose (file);
}


void save_separator (bk_edit_tree_data *node_data)
{
	fprintf (file, "%*s<HR>\n", level * 4, "");
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	int i;
	char *attr[ELEMENTS];
	memset (&attr, 0, sizeof (attr));

	attr[ALIASID]       = node_data->elements[ALIASID][0]       == '\0' ? g_strdup ("") : g_strdup_printf (" ALIASID=\"%s\"", node_data->elements[ALIASID]);
	attr[ALIASOF]       = node_data->elements[ALIASOF][0]       == '\0' ? g_strdup ("") : g_strdup_printf (" ALIASOF=\"%s\"", node_data->elements[ALIASOF]);
	attr[ADD_DATE]      = node_data->elements[ADD_DATE][0]      == '\0' ? g_strdup ("") : g_strdup_printf (" ADD_DATE=\"%s\"", node_data->elements[ADD_DATE]);
	attr[LAST_VISIT]    = node_data->elements[LAST_VISIT][0]    == '\0' ? g_strdup ("") : g_strdup_printf (" LAST_VISIT=\"%s\"", node_data->elements[LAST_VISIT]);
	attr[LAST_MODIFIED] = node_data->elements[LAST_MODIFIED][0] == '\0' ? g_strdup ("") : g_strdup_printf (" LAST_MODIFIED=\"%s\"", node_data->elements[LAST_MODIFIED]);

	fprintf (file, "%*s<DT><A HREF=\"%s\""
			"%s"
			"%s"
			"%s"
			"%s"
			"%s>%s</A>\n",
			level * 4, "",
			node_data->elements[URI],
			attr[ALIASID],
			attr[ALIASOF],
			attr[ADD_DATE],
			attr[LAST_VISIT],
			attr[LAST_MODIFIED],
			node_data->elements[NAME]);

	if (node_data->elements[COMMENT][0] != '\0')
	{
		fprintf (file, "%*s<DD>%s\n", level * 4, "", node_data->elements[COMMENT]);
	}

	for (i = NAME; i < ELEMENTS; i++)
	{
		if (attr[i] != NULL)
		{
			free (attr[i]);
		}
	}
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	int i;
	char *attr[ELEMENTS];
	memset (&attr, 0, sizeof (attr));

	attr[ADD_DATE] = node_data->elements[ADD_DATE][0] == '\0' ? g_strdup ("") : g_strdup_printf (" ADD_DATE=\"%s\"", node_data->elements[ADD_DATE]);

	fprintf (file, "%*s<DT><H3 FOLDED%s>%s</H3>\n",
			level * 4, "",
			attr[ADD_DATE],
			node_data->elements[NAME]);

	if (node_data->elements[COMMENT][0] != '\0')
	{
		fprintf (file, "%*s<DD>%s\n", level * 4, "", node_data->elements[COMMENT]);
	}

	fprintf (file, "%*s<DL><p>\n", level * 4, "");

	++level;

	for (i = NAME; i < ELEMENTS; i++)
	{
		if (attr[i] != NULL)
		{
			free (attr[i]);
		}
	}
}


void save_folder_out (void)
{
	--level;

	fprintf (file, "%*s</DL><p>\n", level * 4, "");
}

