%{

/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * moz_parse.yacc - 19.05.2003 - v0.7 - Mozilla v1.4 support
 *                  06.03.2003 - v0.6 - bugfix - missing semi-colon
 *                    (reported by David Solomonoff <ds@bmec.hscbklyn.edu>)
 *                  06.12.2002 - v0.5 - make it compatible with Mozilla v1.0, v1.1 and v1.2
 *                  26.02.2002 - v0.4 - bk_parse.yacc => moz_parse.yacc
 *                  17.02.2002 - v0.3 - bugfix - forgotten parser keywords
 *                    (reported by Steffen Pohle <stpohle@gmx.net>)
 *                  09.08.2001 - v0.2 - mozilla support
 *                  08.01.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>
#include <string.h>

#include "moz_parse.h"

#define YYSTYPE char *

extern moz_parse *moz;

%}

%token DOCTYPE
%token TITLE_BEGIN TITLE_END
%token H1_BEGIN H1_END

%token DT_BEGIN DT_END
%token DL_BEGIN DL_END
%token DD_BEGIN DD_END
%token H3_BEGIN H3_END
%token A_BEGIN A_END

%token CLOSE EQUALS DOUBLE_QUOTE LITERAL TEXT NUMBER HR CHARACTER

/* heading attributes */
/* netscape 4 */
%token FOLDED_
%token ID_
/* netscape 6 / mozilla */
%token PERSONAL_TOOLBAR_FOLDER_
%token NEW_BOOKMARK_FOLDER_
%token NEW_SEARCH_FOLDER_
%token FOLDER_GROUP_

/* anchor attributes */
/* netscape 4 */
%token HREF_
%token URI_
%token ADD_DATE_
%token LAST_VISIT_
%token LAST_MODIFIED_
%token ALIASID_
%token ALIASOF_
/* netscape 6 / mozilla */
%token LAST_CHARSET_
%token SHORTCUTURL_
%token SCHEDULE_
%token LAST_PING_
%token PING_ETAG_
%token PING_LAST_MODIFIED_
%token PING_CONTENT_LEN_
%token PING_STATUS_
%token ICON_

%start start

%%

/************************************************************************
 * header
 ************************************************************************/

start: DOCTYPE title header definition_list
     ;

title: TITLE_BEGIN literal { if ((moz->title = strdup ($2)) == NULL) { return MOZ_PARSE_OUT_OF_MEMORY; } } TITLE_END
     ;

header: H1_BEGIN literal { int ret; if ((ret = title_do_something ($2)) != MOZ_PARSE_OK) { return ret; } } H1_END
      ;



/************************************************************************
 * definition list
 ************************************************************************/

definition_list: definition_list DL_BEGIN dl_content { int ret; if ((ret = heading_end ()) != MOZ_PARSE_OK) { return ret; } } DL_END
               | /* void */
               ;

dl_content: dl_content definition_term
	  | dl_content definition_list
          | /* void */
          ;

definition_term: DT_BEGIN dt_content
               | HR { int ret; if ((ret = separator_do_something ()) != MOZ_PARSE_OK) { return ret; } }
               ;

dt_content: heading dt_end definition_description { int ret; moz->h_attr.comment = $3; if ((ret = heading_do_something (moz->h_attr)) != MOZ_PARSE_OK) { return ret; } if ((ret = heading_reset ()) != MOZ_PARSE_OK) { return ret; } }
          | anchor  dt_end definition_description { int ret; moz->a_attr.comment = $3; if ((ret = anchor_do_something (moz->a_attr)) != MOZ_PARSE_OK) { return ret; } if ((ret = anchor_reset ()) != MOZ_PARSE_OK) { return ret; } }
	  | /* void */
	  ;

dt_end: DT_END
      | /* void */
      ;

definition_description: DD_BEGIN literal dd_end { $$ = $2; }
                      | /* void */              { $$ = NULL; }
		      ;

dd_end: DD_END
      | /* void */
      ;



/************************************************************************
 * anchor
 ************************************************************************/

anchor: A_BEGIN { int ret; if ((ret = anchor_new ()) != MOZ_PARSE_OK) { return ret; } } anchor_attr CLOSE literal { moz->a_attr.name = $5; } A_END
      | /* void */
      ;

anchor_attr: anchor_attr HREF_               EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.href               = $5; }
           | anchor_attr ADD_DATE_           EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.add_date           = $5; }
           | anchor_attr LAST_VISIT_         EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.last_visit         = $5; }
	   | anchor_attr LAST_MODIFIED_      EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.last_modified      = $5; }
	   | anchor_attr ALIASID_            EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.aliasid            = $5; }
	   | anchor_attr ALIASOF_            EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.aliasof            = $5; }
	   | anchor_attr LAST_CHARSET_       EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.last_charset       = $5; }
       	   | anchor_attr SHORTCUTURL_        EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.shortcuturl        = $5; }
	   | anchor_attr SCHEDULE_           EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.schedule           = $5; }
	   | anchor_attr LAST_PING_          EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.last_ping          = $5; }
           | anchor_attr PING_ETAG_          EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.ping_etag          = $5; }
           | anchor_attr PING_LAST_MODIFIED_ EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.ping_last_modified = $5; }
           | anchor_attr PING_CONTENT_LEN_   EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.ping_content_len   = $5; }
	   | anchor_attr PING_STATUS_        EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.ping_status        = $5; }
	   | anchor_attr ICON_               EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.icon               = $5; }
	   | anchor_attr ID_                 EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->a_attr.id                 = $5; }
	   | /* void */
	   ;



/************************************************************************
 * heading
 ************************************************************************/

heading: H3_BEGIN { int ret; if ((ret = heading_new ()) != MOZ_PARSE_OK) { return ret; } } heading_attr CLOSE literal { moz->h_attr.name = $5; } H3_END
       ;


heading_attr: heading_attr FOLDED_
            | heading_attr ADD_DATE_                EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.add_date            = $5; }
            | heading_attr LAST_MODIFIED_           EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.last_modified       = $5; }
	    | heading_attr ID_                      EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.id                  = $5; }
	    | heading_attr PERSONAL_TOOLBAR_FOLDER_ EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.personal_folder     = $5; }
	    | heading_attr NEW_BOOKMARK_FOLDER_     EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.new_bookmark_folder = $5; }
	    | heading_attr NEW_SEARCH_FOLDER_       EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.new_search_folder   = $5; }
	    | heading_attr FOLDER_GROUP_            EQUALS DOUBLE_QUOTE literal DOUBLE_QUOTE { moz->h_attr.folder_group        = $5; }
            | /* void */
            ;



/************************************************************************
 * misc
 ************************************************************************/

literal: LITERAL    { $$ = $1;   }
       | /* void */ { $$ = NULL; }
       ;

%%

