#ifndef LINKS2_PARSE_H
#define LINKS2_PARSE_H

#define LINKS2_PARSE_OK                    0
#define LINKS2_PARSE_KO                    10
#define LINKS2_PARSE_NO_SUCH_FILE          20
#define LINKS2_PARSE_OUT_OF_MEMORY         30
#define LINKS2_PARSE_FOLDER_STACK_OVERRUN  40
#define LINKS2_PARSE_FOLDER_STACK_UNDERRUN 50

/************************************************************************
 * anchor
 ************************************************************************/

typedef struct anchor_attr_tag
{
	char *name;
	char *href;
} anchor_attr;

/************************************************************************
 * heading
 ************************************************************************/

typedef struct heading_attr_tag
{
	char *name;
} heading_attr;

/************************************************************************
 * parse
 ************************************************************************/

typedef struct links2_parse_tag
{
	anchor_attr  a_attr;
	heading_attr h_attr;

	char *title;
	char *heading;
	char *filename;
} links2_parse;


typedef struct pattern_tag
{
	char *text;
	int   text_ptr;
	int   length;
} pattern;

/* callback functions */
int title_do_something (char *title);

int anchor_new (void);
int anchor_reset (void);
int anchor_do_something (anchor_attr a_attr);

int heading_new (void);
int heading_reset (void);
int heading_end (void);
int heading_do_something (heading_attr h_attr);

void parse_yyerror (char *file, int line, char *error_message, char *yytext);

#endif
