/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * html.c - 29.11.2003 - v0.3 - XHTML compliance
 *          17.07.2003 - v0.2 - HTML tags are now lowercase
 *          06.05.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "plugin.h"
#include "g_stack.h"

#include "bk_edit_icon.h"
#include "bk_edit_dialog_info.h"

enum
{
	INSIDE_UL = 42,
	OUTSIDE_UL,
	INSIDE_LI,
	OUTSIDE_LI
};

static FILE *file;
static int level = 1;
static g_stack *ul_stack;
static g_stack *li_stack;
static int ul_state = OUTSIDE_UL;
static int li_state = OUTSIDE_LI;


int init (plugin *plug)
{
	plug->name        = "HTML Export";
	plug->short_name  = "HTML";
	plug->description = "";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_SAVE;

	plug->cleanup = cleanup;

	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	ul_state = OUTSIDE_UL;
	li_state = OUTSIDE_LI;
	
	ul_stack = g_stack_new (ul_stack);
	if (ul_stack == NULL)
	{
		fprintf (stderr, "%s[%d]: g_stack_new ()\n", __FILE__, __LINE__);
		return PLUGIN_KO;
	}

	li_stack = g_stack_new (li_stack);
	if (li_stack == NULL)
	{
		fprintf (stderr, "%s[%d]: g_stack_new ()\n", __FILE__, __LINE__);
		return PLUGIN_KO;
	}

	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

	fprintf (file, "<html>\n"
			"<head>\n"
			"<title></title>\n"
			"</head>\n"
			"<body>\n"
			"<dl>\n"
			"<dd>\n");

	return PLUGIN_OK;
}


void save_end (void)
{
	if (li_state == INSIDE_LI)
	{
		fprintf (file, "%*s</li>\n",  level * 4, "");
	}

	if (ul_state == INSIDE_UL)
	{
		fprintf (file, "%*s</ul>\n",  level * 4, "");
	}

	fprintf (file, "</dd>\n"
			"</dl>\n"
			"</body>\n"
			"</html>\n");
	fclose (file);

	g_stack_delete (ul_stack);
	g_stack_delete (li_stack);
}


void save_separator (bk_edit_tree_data *node_data)
{
	fprintf (file, "%*s<hr>\n", level * 4, "");
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	if (ul_state == OUTSIDE_UL)
	{
		ul_state = INSIDE_UL;

		fprintf (file, "%*s<ul>\n",  level * 4, "");
	}
	else if (li_state == INSIDE_LI)
	{
		li_state = OUTSIDE_LI;

		fprintf (file, "%*s</li>\n",  level * 4, "");
	}

	fprintf (file, "%*s<li><a href=\"%s\">%s</a></li>\n",
			level * 4, "",
			node_data->elements[URI],
			node_data->elements[NAME]);
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	if (ul_state == OUTSIDE_UL)
	{
		ul_state = INSIDE_UL;

		fprintf (file, "%*s<ul>\n",  level * 4, "");
	}

	if (g_stack_push (ul_stack, (void *) ul_state) != G_STACK_OK)
	{
		fprintf (stderr, "%s[%d]: g_stack_push ()\n", __FILE__, __LINE__);
		return;
	}
	ul_state = OUTSIDE_UL;

	if (li_state == OUTSIDE_LI)
	{
		li_state = INSIDE_LI;

		fprintf (file, "%*s<li>\n",  level * 4, "");
	}
	
	if (g_stack_push (li_stack, (void *) li_state) != G_STACK_OK)
	{
		fprintf (stderr, "%s[%d]: g_stack_push ()\n", __FILE__, __LINE__);
		return;
	}
	li_state = OUTSIDE_LI;

	fprintf (file, "%*s<dl>\n"
			"%*s<dt>%s</dt>\n"
			"%*s<dd>\n",
			level * 4, "",
			level * 4, "",
			node_data->elements[NAME],
			level * 4, "");

	++level;
}


void save_folder_out (void)
{
	if (li_state == INSIDE_LI)
	{
		fprintf (file, "%*s</li>\n",  level * 4, "");
	}

	if ((li_state = (int) g_stack_pop (li_stack)) == 0)
	{
		fprintf (stderr, "%s[%d]: g_stack_pop ()\n", __FILE__, __LINE__);
		return;
	}

	if (ul_state == INSIDE_UL)
	{
		fprintf (file, "%*s</ul>\n",  level * 4, "");
	}

	if ((ul_state = (int) g_stack_pop (ul_stack)) == 0)
	{
		fprintf (stderr, "%s[%d]: g_stack_pop ()\n", __FILE__, __LINE__);
		return;
	}

	--level;

	fprintf (file, "%*s</dd>\n"
			"%*s</dl>\n", level * 4, "", level * 4, "");
}
