/*
 * Copyright (C) 2002-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * galeon.c - 17.07.2003 - v0.3 -
 *            23.12.2002 - v0.2 - plugin api clean-up
 *            05.09.2002 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 'The XML Bookmark Exchange Language Resource Page'
 * <http://pyxml.sourceforge.net/topics/xbel/>
 *
 * 'Galeon: the web, only the web'
 * <http://galeon.sourceforge.net/>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libxml/parser.h>
#include <libxml/parserInternals.h>

#include "galeon.h"
#include "plugin.h"

#include "bk_edit_tree.h"
#include "bk_edit_icon.h"
#include "bk_edit_data.h"
#include "bk_edit_misc.h"
#include "bk_edit_dialog_info.h"


static FILE *file;
static int level = 1;

static int convert_node_data_to_UTF8 (bk_edit_tree_data *from, bk_edit_tree_data *to);
static void dealloc_UTF8_node_data (bk_edit_tree_data *node_data);
static void dealloc_attr (char *attr[]);

int init (plugin *plug)
{
	plug->name        = "Galeon 1.2.5 (XBEL)";
	plug->short_name  = "Galeon";
	plug->description = "Galeon & The XML Bookmark Exchange Language 1.0";
	plug->author      = "<clfuit00@fht-esslingen.de>";

	plug->type = PLUGIN_LOAD | PLUGIN_SAVE | PLUGIN_EDIT;

	plug->cleanup = cleanup;

	plug->load            = load;
	plug->save_begin      = save_begin;
	plug->save_end        = save_end;
	plug->save_separator  = save_separator;
	plug->save_bookmark   = save_bookmark;
	plug->save_folder_in  = save_folder_in;
	plug->save_folder_out = save_folder_out;

	plug->edit_ui = edit_ui_new (plug);
	plug->edit_ui_new = edit_ui_new;
	plug->edit_ui_delete = edit_ui_delete;
	plug->edit_ui_set = edit_ui_set;
	plug->edit_ui_get = edit_ui_get;

	plug->root_edit_dialog_style.name           = SHOW;
	plug->root_edit_dialog_style.id             = SHOW;
	plug->root_edit_dialog_style.add_date       = SHOW;
	plug->root_edit_dialog_style.last_modified  = SHOW;
	plug->root_edit_dialog_style.last_visit     = SHOW;
	plug->root_edit_dialog_style.version        = SHOW;
	plug->root_edit_dialog_style.metadata_owner = SHOW;

	plug->bookmark_edit_dialog_style.name           = SHOW;
	plug->bookmark_edit_dialog_style.comment        = SHOW;
	plug->bookmark_edit_dialog_style.id             = SHOW;
	plug->bookmark_edit_dialog_style.add_date       = SHOW;
	plug->bookmark_edit_dialog_style.uri            = SHOW;
	plug->bookmark_edit_dialog_style.last_visit     = SHOW;
	plug->bookmark_edit_dialog_style.last_modified  = SHOW;
	plug->bookmark_edit_dialog_style.ref            = SHOW;
	plug->bookmark_edit_dialog_style.nickname       = SHOW;
	plug->bookmark_edit_dialog_style.pixmap         = SHOW;
	plug->bookmark_edit_dialog_style.smarturl       = SHOW;
	plug->bookmark_edit_dialog_style.create_context = SHOW;
	plug->bookmark_edit_dialog_style.metadata_owner = SHOW;

	plug->folder_edit_dialog_style.name           = SHOW;
	plug->folder_edit_dialog_style.comment        = SHOW;
	plug->folder_edit_dialog_style.add_date       = SHOW;
	plug->folder_edit_dialog_style.id             = SHOW;
	plug->folder_edit_dialog_style.last_visit     = SHOW;
	plug->folder_edit_dialog_style.last_modified  = SHOW;
	plug->folder_edit_dialog_style.create_toolbar = SHOW;
	plug->folder_edit_dialog_style.create_context = SHOW;
	plug->folder_edit_dialog_style.toolbar_style  = SHOW;
	plug->folder_edit_dialog_style.pixmap         = SHOW;
	plug->folder_edit_dialog_style.metadata_owner = SHOW;

	return PLUGIN_OK;
}


int cleanup (plugin *plug)
{
	return PLUGIN_OK;
}


int load (char *filename)
{
	if (galeon_dom_parser (filename) != GALEON_PARSER_OK)
	{
		return PLUGIN_KO;
	}

	return PLUGIN_OK;
}


int save_begin (char *filename, bk_edit_tree_data *node_data)
{
	char *attr[ELEMENTS];

	bk_edit_tree_data node_data_UTF8;
	convert_node_data_to_UTF8 (node_data, &node_data_UTF8);

	memset (&attr, 0, sizeof (attr));

	file = fopen (filename, "w");
	if (file == NULL)
	{
		bk_edit_dialog_info ("bk edit - error", "Open failed.", icon_warning);
		return PLUGIN_OPEN_FAILED;
	}

	attr[NAME]           = node_data_UTF8.elements[NAME][0]           == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<title>%s</title>\n", level * 2, "", node_data_UTF8.elements[NAME]);
	attr[METADATA_OWNER] = node_data_UTF8.elements[METADATA_OWNER][0] == '\0' ? g_strdup (" owner=\"http://galeon.sourceforge.net/\">\n") : g_strdup_printf (" owner=\"%s\">\n", node_data_UTF8.elements[METADATA_OWNER]);
	attr[DEFAULT_FOLDER] = node_data_UTF8.elements[DEFAULT_FOLDER][0] == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<default_folder>%s</default_folder>\n", level * 2 + 4, "", node_data_UTF8.elements[DEFAULT_FOLDER]);
	attr[LAST_MODIFIED]  = node_data_UTF8.elements[LAST_MODIFIED][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_modified>%s</time_modified>\n", level * 2 + 4, "", node_data_UTF8.elements[LAST_MODIFIED]);
	attr[ADD_DATE]       = node_data_UTF8.elements[ADD_DATE][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_added>%s</time_added>\n", level * 2 + 4, "", node_data_UTF8.elements[ADD_DATE]);
	attr[LAST_VISIT]     = node_data_UTF8.elements[LAST_VISIT][0]     == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_visited>%s</time_visited>\n", level * 2 + 4, "", node_data_UTF8.elements[LAST_VISIT]);

	fprintf (file, "<?xml version=\"1.0\"?>\n"
			"<!DOCTYPE xbel PUBLIC \"+//IDN python.org//DTD XML Bookmark Exchange Language 1.0//EN//XML\" \"http://www.python.org/topics/xml/dtds/xbel-1.0.dtd\">\n"
			"<xbel version=\"1.0\">\n"
			"%*s<info>\n"
			"%*s<metadata%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%*s</metadata>\n"
			"%*s</info>\n"
			"%s",
			level * 2, "",
			level * 2 + 2, "", attr[METADATA_OWNER],
			attr[DEFAULT_FOLDER],
			attr[LAST_MODIFIED],
			attr[ADD_DATE],
			attr[LAST_VISIT],
			level * 2 + 2, "",
			level * 2, "",
			attr[NAME]);

	dealloc_UTF8_node_data (&node_data_UTF8);
	dealloc_attr (attr);

	return PLUGIN_OK;
}


void save_end (void)
{
	fprintf (file, "</xbel>");

	fclose (file);
}


void save_separator (bk_edit_tree_data *node_data)
{
	fprintf (file, "%*s<separator/>\n", level * 2, "");
}


void save_bookmark (bk_edit_tree_data *node_data)
{
	char *attr[ELEMENTS];

	bk_edit_tree_data node_data_UTF8;
	convert_node_data_to_UTF8 (node_data, &node_data_UTF8);

	memset (&attr, 0, sizeof (attr));

	if (node_data->elements[REF][0] != '\0')
	{
		fprintf (file, "%*s<alias ref=\"%s\"/>\n", level * 2, "", node_data->elements[REF]);
	}
	else
	{
		attr[ID]             = node_data_UTF8.elements[ID][0]             == '\0' ? g_strdup ("") : g_strdup_printf (" id=\"%s\"", node_data_UTF8.elements[ID]);
		attr[REF]            = node_data_UTF8.elements[REF][0]            == '\0' ? g_strdup ("") : g_strdup_printf (" ref=\"%s\"", node_data_UTF8.elements[REF]);
		attr[NAME]           = node_data_UTF8.elements[NAME][0]           == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<title>%s</title>\n", level * 2 + 2, "", node_data_UTF8.elements[NAME]);
		attr[COMMENT]        = node_data_UTF8.elements[COMMENT][0]        == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<desc>%s</desc>\n", level * 2 + 2, "", node_data_UTF8.elements[COMMENT]);
		attr[METADATA_OWNER] = node_data_UTF8.elements[METADATA_OWNER][0] == '\0' ? g_strdup (" owner=\"http://galeon.sourceforge.net/\">\n") : g_strdup_printf (" owner=\"%s\">\n", node_data_UTF8.elements[METADATA_OWNER]);
		attr[PIXMAP]         = node_data_UTF8.elements[PIXMAP][0]         == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<pixmap>%s</pixmap>\n", level * 2 + 6, "", node_data_UTF8.elements[PIXMAP]);
		attr[CREATE_CONTEXT] = node_data_UTF8.elements[CREATE_CONTEXT][0] == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<create_context>%s</create_context>\n", level * 2 + 6, "", node_data_UTF8.elements[CREATE_CONTEXT]);
		attr[LAST_VISIT]     = node_data_UTF8.elements[LAST_VISIT][0]     == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_visited>%s</time_visited>\n", level * 2 + 6, "", node_data_UTF8.elements[LAST_VISIT]);
		attr[LAST_MODIFIED]  = node_data_UTF8.elements[LAST_MODIFIED][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_modified>%s</time_modified>\n", level * 2 + 6, "", node_data_UTF8.elements[LAST_MODIFIED]);
		attr[ADD_DATE]       = node_data_UTF8.elements[ADD_DATE][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_added>%s</time_added>\n", level * 2 + 6, "", node_data_UTF8.elements[ADD_DATE]);
		attr[NICKNAME]       = node_data_UTF8.elements[NICKNAME][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<nick>%s</nick>\n", level * 2 + 6, "", node_data_UTF8.elements[NICKNAME]);
		attr[SMARTURL]       = node_data_UTF8.elements[SMARTURL][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<smarturl>%s</smarturl>\n", level * 2 + 6, "", node_data_UTF8.elements[SMARTURL]);

		fprintf (file, "%*s<bookmark href=\"%s\"%s%s>\n" "%s"
				"%s"
				"%*s<info>\n"
				"%*s<metadata%s"
				"%s"
				"%s"
				"%s"
				"%s"
				"%s"
				"%s"
				"%s"
				"%*s</metadata>\n"
				"%*s</info>\n"
				"%*s</bookmark>\n",
				level * 2, "", node_data_UTF8.elements[URI], attr[ID], attr[REF],
				attr[NAME],
				attr[COMMENT],
				level * 2 + 2, "",
				level * 2 + 4, "", attr[METADATA_OWNER],
				attr[NICKNAME],
				attr[PIXMAP],
				attr[LAST_VISIT],
				attr[LAST_MODIFIED],
				attr[ADD_DATE],
				attr[SMARTURL],
				attr[CREATE_CONTEXT],
				level * 2 + 4, "",
				level * 2 + 2, "",
				level * 2, "");
	}

	dealloc_UTF8_node_data (&node_data_UTF8);
	dealloc_attr (attr);
}


void save_folder_in (bk_edit_tree_data *node_data)
{
	char *attr[ELEMENTS];

	bk_edit_tree_data node_data_UTF8;
	convert_node_data_to_UTF8 (node_data, &node_data_UTF8);

	memset (&attr, 0, sizeof (attr));

	attr[ID]             = node_data_UTF8.elements[ID][0]             == '\0' ? g_strdup ("") : g_strdup_printf (" id=\"%s\"", node_data_UTF8.elements[ID]);
	attr[NAME]           = node_data_UTF8.elements[NAME][0]           == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<title>%s</title>\n", level * 2 + 2, "", node_data_UTF8.elements[NAME]);
	attr[COMMENT]        = node_data_UTF8.elements[COMMENT][0]        == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<desc>%s</desc>\n", level * 2 + 2, "", node_data_UTF8.elements[COMMENT]);
	attr[METADATA_OWNER] = node_data_UTF8.elements[METADATA_OWNER][0] == '\0' ? g_strdup (" owner=\"http://galeon.sourceforge.net/\">\n") : g_strdup_printf (" owner=\"%s\">\n", node_data_UTF8.elements[METADATA_OWNER]);
	attr[PIXMAP]         = node_data_UTF8.elements[PIXMAP][0]         == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<pixmap>%s</pixmap>\n", level * 2 + 6, "", node_data_UTF8.elements[PIXMAP]);
	attr[CREATE_TOOLBAR] = node_data_UTF8.elements[CREATE_TOOLBAR][0] == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<create_toolbar>%s</create_toolbar>\n", level * 2 + 6, "", node_data_UTF8.elements[CREATE_TOOLBAR]);
	attr[CREATE_CONTEXT] = node_data_UTF8.elements[CREATE_CONTEXT][0] == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<create_context>%s</create_context>\n", level * 2 + 6, "", node_data_UTF8.elements[CREATE_CONTEXT]);
	attr[TOOLBAR_STYLE]  = node_data_UTF8.elements[TOOLBAR_STYLE][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<toolbar_style>%s</toolbar_style>\n", level * 2 + 6, "", node_data_UTF8.elements[TOOLBAR_STYLE]);
	attr[LAST_VISIT]     = node_data_UTF8.elements[LAST_VISIT][0]     == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_visited>%s</visit_visited>\n", level * 2 + 6, "", node_data_UTF8.elements[LAST_VISIT]);
	attr[LAST_MODIFIED]  = node_data_UTF8.elements[LAST_MODIFIED][0]  == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_modified>%s</time_modified>\n", level * 2 + 6, "", node_data_UTF8.elements[LAST_MODIFIED]);
	attr[ADD_DATE]       = node_data_UTF8.elements[ADD_DATE][0]       == '\0' ? g_strdup ("") : g_strdup_printf ("%*s<time_added>%s</time_added>\n", level * 2 + 6, "", node_data_UTF8.elements[ADD_DATE]);


	fprintf (file, "%*s<folder folded=\"yes\"%s>\n"
			"%s"
			"%s"
			"%*s<info>\n"
			"%*s<metadata%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%s"
			"%*s</metadata>\n"
			"%*s</info>\n",
			level * 2, "", attr[ID],
			attr[NAME],
			attr[COMMENT],
			level * 2 + 2, "",
			level * 2 + 4, "", attr[METADATA_OWNER],
			attr[PIXMAP],
			attr[CREATE_TOOLBAR],
			attr[CREATE_CONTEXT],
			attr[TOOLBAR_STYLE],
			attr[LAST_VISIT],
			attr[LAST_MODIFIED],
			attr[ADD_DATE],
			level * 2 + 4, "",
			level * 2 + 2, "");

	++level;

	dealloc_UTF8_node_data (&node_data_UTF8);
	dealloc_attr (attr);
}


void save_folder_out (void)
{
	--level;

	fprintf (file, "%*s</folder>\n", level * 2, "");
}


static int convert_node_data_to_UTF8 (bk_edit_tree_data *from, bk_edit_tree_data *to)
{
	int i;

	for (i = NAME; i < ELEMENTS; i++)
	{
		if (from->elements[i][0] == '\0')
		{
			to->elements[i] = strdup ("");

			continue;
		}

		if (i == METADATA)
		{
			to->elements[i] = strdup (from->elements[i]);

			continue;
		}

		if (from->elements[i] != NULL)
		{
			int from_size = strlen (from->elements[i]);
			int to_size = from_size * 10; /* this should be enough */
			int temp_size = to_size;

			unsigned char *t, *tt;

			char buffer[10];

			bk_edit_tree_data temp;

			to->elements[i] = NULL;

			temp.elements[i] = malloc (temp_size);
			if (temp.elements[i] == NULL)
			{
				fprintf (stderr, "%s[%d]: malloc: NULL\n", __FILE__, __LINE__);
				continue;
			}

			if (isolat1ToUTF8 (temp.elements[i], &temp_size, from->elements[i], &from_size) < 0)
			{
				fprintf (stderr, "%s[%d]: isolat1ToUTF8\n", __FILE__, __LINE__);
				continue;
			}
			temp.elements[i][temp_size] = '\0';

			t = tt = xmlEncodeSpecialChars (NULL, temp.elements[i]);
			if (t == NULL)
			{
				fprintf (stderr, "%s[%d]: xmlEncodeSpecialChars: NULL\n", __FILE__, __LINE__);
				continue;
			}

			while (*t != '\0')
			{
				if ((*t >= 0x20) && (*t < 0x80))
				{
					buffer[0] = *t;
					buffer[1] = '\0';
				}
				else
				{
					/*
					 * http://www.w3.org/TR/REC-xml#charsets
					 * Char ::= #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]
					 */
					if (*t < 0x20)
					{
						switch (*t)
						{
							case 0x09:
							case 0x0A:
							case 0x0D:
							{
								break;
							}

							default:
							{
								*t = ' ';
							}
						}
					}

					snprintf (buffer, sizeof (buffer), "&#%d;", *t);
				}

				to->elements[i] = xmlStrcat (to->elements[i], buffer);

				t++;
			}

			free (tt);
			free (temp.elements[i]);
		}
	}

	return GALEON_PARSER_OK;
}


static void dealloc_attr (char *attr[])
{
	int i;

	for (i = 0; i < ELEMENTS; i++)
	{
		if (attr[i] != NULL)
		{
			free (attr[i]);
		}
	}
}


static void dealloc_UTF8_node_data (bk_edit_tree_data *node_data)
{
	int i;

	for (i = 0; i < ELEMENTS; i++)
	{
		if (node_data->elements[i] != NULL)
		{
			free (node_data->elements[i]);
		}
	}
}

