/*
 * Copyright (C) 2001 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * stack.c - 8.1.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "g_stack.h"


g_stack *g_stack_new (g_stack *stack)
{
	stack = (g_stack *) malloc (sizeof (g_stack));
	if (stack == NULL)
	{
		return NULL;
	}

	stack->stack_pointer = 0;

	return stack;
}


void g_stack_delete (g_stack *stack)
{
	free (stack);
}


void *g_stack_pop (g_stack *stack)
{
	if (stack->stack_pointer != 0)
	{
		return stack->stack[--stack->stack_pointer];
	}
	else
	{
		return NULL; /* empty */
	}
}


int g_stack_push (g_stack *stack, void *item)
{
	if (stack->stack_pointer < G_STACK_SIZE)
	{
		stack->stack[stack->stack_pointer++] = item;

		return G_STACK_OK;
	}
	else
	{
		return G_STACK_FULL;
	}
}

