/*
 * Copyright (C) 2002 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * dialog_options.c - 07.03.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include <gdk/gdkx.h>

#include "dialog_options.h"


/* This is taken from xmms-1.2.7/xmms/hints.c */
void dialog_options_sticky_set (GtkWidget *window, gboolean sticky)
{
	XEvent xev;
	int prev_error;
	long state = 0;
	Atom xa_win_state = gdk_atom_intern(XA_WIN_STATE, FALSE);

	if (sticky)
		state = WIN_STATE_STICKY;

	prev_error = gdk_error_warnings;
	gdk_error_warnings = 0;

	if (GTK_WIDGET_MAPPED(window))
	{
		xev.type = ClientMessage;
		xev.xclient.type = ClientMessage;
		xev.xclient.window = GDK_WINDOW_XWINDOW(window->window);
		xev.xclient.message_type = xa_win_state;
		xev.xclient.format = 32;
		xev.xclient.data.l[0] = WIN_STATE_STICKY;
		xev.xclient.data.l[1] = state;

		XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
			   SubstructureNotifyMask, (XEvent *) &xev);
	}
	else
	{
		long data[2];

		data[0] = state;
		XChangeProperty(GDK_DISPLAY(),
				GDK_WINDOW_XWINDOW(window->window),
				xa_win_state, XA_CARDINAL, 32, PropModeReplace,
				(unsigned char *) data, 1);
	}
	gdk_error_warnings = prev_error;
}


void dialog_options_always_on_top_set (GtkWidget *window, gboolean always)
{
	XEvent xev;
	int prev_error;
	long layer = WIN_LAYER_ONTOP;
	Atom xa_win_layer = gdk_atom_intern(XA_WIN_LAYER, FALSE);

	if (always == FALSE)
		layer = WIN_LAYER_NORMAL;

	prev_error = gdk_error_warnings;
	gdk_error_warnings = 0;

	if (GTK_WIDGET_MAPPED(window))
	{
		xev.type = ClientMessage;
		xev.xclient.type = ClientMessage;
		xev.xclient.window = GDK_WINDOW_XWINDOW(window->window);
		xev.xclient.message_type = xa_win_layer;
		xev.xclient.format = 32;
		xev.xclient.data.l[0] = layer;

		XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
			   SubstructureNotifyMask, (XEvent *) & xev);
	}
	else
	{
		long data[1];

		data[0] = layer;
		XChangeProperty(GDK_DISPLAY(),
				GDK_WINDOW_XWINDOW(window->window),
				xa_win_layer, XA_CARDINAL, 32, PropModeReplace,
				(unsigned char *) data,	1);
	}
	gdk_error_warnings = prev_error;
}

