/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * command_line.c - 10.07.2003 - v0.2 - converting capability
 *                  03.03.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <string.h>
#include <stdlib.h>

#include <getopt.h>

#include "plugin.h"
#include "config.h"
#include "command_line.h"

extern plugins *plugs;

static struct option options[] = {
	{ "load",        required_argument, NULL, OPTION_LOAD        },
	{ "load-plugin", required_argument, NULL, OPTION_LOAD_PLUGIN },
	{ "save",        required_argument, NULL, OPTION_SAVE        },
	{ "save-plugin", required_argument, NULL, OPTION_SAVE_PLUGIN },
	{ "help",        no_argument,       NULL, OPTION_HELP        },
	{ "version",     no_argument,       NULL, OPTION_VERSION     },
	{ 0, 0, 0, 0 }
};


command_line_options *command_line_new (int argc, char *argv[])
{
	int option;

	command_line_options *o = (command_line_options *) malloc (sizeof (command_line_options));
	if (o == NULL)
	{
		return NULL;
	}
	memset (o, 0, sizeof (command_line_options));

	opterr = 0;
	do
	{
		option = getopt_long (argc, argv, "", options, NULL);

		switch (option)
		{
			case OPTION_LOAD:
			{
				o->load = strdup (optarg);
				break;
			}

			case OPTION_LOAD_PLUGIN:
			{
				if (!strcmp (optarg, "list"))
				{
					GList *l = plugs->list;

					printf ("\nAvailable import plugins:\n");
					while (l)
					{
						plugin *p = (plugin *) l->data;

						if (p->type & PLUGIN_LOAD)
						{
							printf ("  %-25s%s\n", p->short_name, p->name);
						}

						l = l->next;
					}
					printf ("\n");

					exit (EXIT_SUCCESS);
				}

				o->load_plugin = strdup (optarg);
				break;
			}

			case OPTION_SAVE:
			{
				o->save = strdup (optarg);
				break;
			}

			case OPTION_SAVE_PLUGIN:
			{
				if (!strcmp (optarg, "list"))
				{
					GList *l = plugs->list;

					printf ("\nAvailable export plugins:\n");
					while (l)
					{
						plugin *p = (plugin *) l->data;

						if (p->type & PLUGIN_SAVE)
						{
							printf ("  %-25s%s\n", p->short_name, p->name);
						}

						l = l->next;
					}
					printf ("\n");

					exit (EXIT_SUCCESS);
				}

				o->save_plugin = strdup (optarg);
				break;

			}

			case OPTION_HELP:
			{
				printf ("%s", HELP);
				exit (EXIT_SUCCESS);
			}

			case OPTION_VERSION:
			{
				printf ("bk_edit %s\n", BK_EDIT_VERSION);
				exit (EXIT_SUCCESS);
			}
		}
	}
	while (option != -1);

	if (o->load != NULL)
	{
		if (o->load_plugin == NULL)
		{
			printf ("Option `--load-plugin <plugin>' is required when using the `--load <file>` option.\n");
			exit (EXIT_FAILURE);
		}
	}

	if (o->load_plugin != NULL)
	{
		if (o->load == NULL)
		{
			free (o->load_plugin);

			o->load_plugin = NULL;
		}
	}

	return o;
}


void command_line_delete (command_line_options *o)
{
	if (o->load != NULL)
	{
		free (o->load);
	}

	if (o->load_plugin != NULL)
	{
		free (o->load_plugin);
	}

	free (o);
}

