#ifndef BK_EDIT_UNDO_H
#define BK_EDIT_UNDO_H

#define BK_EDIT_UNDO_OK            0
#define BK_EDIT_UNDO_OUT_OF_MEMORY 1
#define BK_EDIT_UNDO_STACK_FULL    2

#include <gtk/gtk.h>

#include "bk_edit_data.h"

#include "g_stack.h"

enum bk_edit_undo_type { UNDO_EDIT, UNDO_NEW, UNDO_DELETE, UNDO_MOVE, UNDO_CUT, UNDO_PASTE };


typedef struct bk_edit_undo_edit_item_tag
{
	int id;

	bk_edit_tree_data node_data;
} bk_edit_undo_edit_item;


typedef struct bk_edit_undo_new_item_tag
{
	int id;

	GHashTable *order_table;
} bk_edit_undo_new_item;


typedef struct bk_edit_undo_delete_item_tag
{
	int id_parent;
	int id_sibling;

	GNode *nodes;
	GHashTable *order_table;
} bk_edit_undo_delete_item;


typedef struct bk_edit_undo_move_item_tag
{
	int id_old_parent;
	int id_old_sibling;

	int id;

	GHashTable *target_order_table;
	GHashTable *source_order_table;
} bk_edit_undo_move_item;


typedef struct bk_edit_undo_cut_item_tag
{
	int id_parent;
	int id_sibling;

	GNode *nodes;
} bk_edit_undo_cut_item;


typedef struct bk_edit_undo_paste_item_tag
{
	int id;
} bk_edit_undo_paste_item;


typedef struct bk_edit_undo_item_tag
{
	enum bk_edit_undo_type undo_type;

	union undo_data_tag
	{
		bk_edit_undo_edit_item   *undo_edit;
		bk_edit_undo_new_item    *undo_new;
		bk_edit_undo_delete_item *undo_delete;
		bk_edit_undo_move_item   *undo_move;
		bk_edit_undo_cut_item    *undo_cut;
		bk_edit_undo_paste_item  *undo_paste;
	} undo_data;
} bk_edit_undo_item;


typedef struct bk_edit_undo_tag
{
	g_stack *undo_stack;
} bk_edit_undo;


bk_edit_undo *bk_edit_undo_new (bk_edit_undo *undo);
void          bk_edit_undo_delete (bk_edit_undo *udno);

void bk_edit_undo_undo (void);

int bk_edit_undo_add_edit_item (GtkCTreeNode *node, bk_edit_tree_data *node_data);
int bk_edit_undo_add_move_item (GtkCTreeNode *node, GtkCTreeNode *new_parent, GtkCTreeNode *new_sibling);

int bk_edit_undo_add_delete_or_cut_item (GtkCTreeNode *node, enum bk_edit_undo_type type);
int bk_edit_undo_add_delete_item (GtkCTreeNode *node);
int bk_edit_undo_add_cut_item (GtkCTreeNode *node);

int bk_edit_undo_add_new_or_paste_item (GtkCTreeNode *node, bk_edit_tree_data *node_data, enum bk_edit_undo_type type);
int bk_edit_undo_add_new_item (GtkCTreeNode *node, bk_edit_tree_data *node_data);
int bk_edit_undo_add_paste_item (GtkCTreeNode *node, bk_edit_tree_data *node_data);

gint bk_edit_undo_cmp (gconstpointer node_data, gconstpointer id);

gboolean bk_edit_undo_traverse_gnode (GNode *node, gpointer data);

#endif
