/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_recent_document.c - 23.05.2003 - v0.2 - modify indicator rewrite
 *                             01.03.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <string.h>

#include <gtk/gtk.h>

#include "config.h"

#include "bk_edit_icon.h"
#include "bk_edit_menu.h"
#include "bk_edit_file.h"
#include "bk_edit_undo.h"
#include "bk_edit_modify_indicator.h"

#include "bk_edit_dialog_box.h"
#include "bk_edit_dialog_main.h"

extern config *conf;

extern bk_edit_undo *undo;
extern bk_edit_dialog_main dialog_main;
extern bk_edit_modify_indicator *modify_indicator;

static void ok (GtkWidget *dialog, void *which);


void bk_edit_recent_document (gpointer callback_data, guint callback_action, GtkWidget *widget)
{
	if (bk_edit_modify_indicator_is_modified (modify_indicator, CURRENT_UNDO_STACK_ENTRY) == IS_NOT_MODIFIED)
	{
		ok (NULL, (void *) callback_action);
	}
	else
	{
		bk_edit_dialog_box ("bk edit - warning", "This will discard all unsaved data.", icon_warning, ok, NULL, (void *) callback_action);
	}
}


void bk_edit_recent_document_add (char *filename, char *plugin_name)
{
	GList *list = config_recent_documents_list_get (conf);
	GList *l = list, *ll;

	int size = config_recent_documents_list_size_get (conf);

	int menubar_size;
	GtkItemFactoryEntry *menubar_items;

	config_recent_document *doc = (config_recent_document *) malloc (sizeof (config_recent_document));

	doc->filename = strdup (filename);
	doc->plugin = strdup (plugin_name);

	list = g_list_prepend (list, doc);

	while (l)
	{
		ll = l->next;

		if (--size < 0)
		{
			list = g_list_remove_link (list, l);

			config_recent_documents_list_free (conf, l);
		}
		else if (!strcmp (((config_recent_document *) l->data)->filename, filename))
		{
			list = g_list_remove_link (list, l);

			config_recent_documents_list_free (conf, l);
		}

		l = ll;
	}

	config_recent_documents_list_set (conf, list);
	config_recent_documents_list_free (conf, list);

	gtk_item_factory_delete_item (dialog_main.menubar_factory, "/File");
	gtk_item_factory_delete_item (dialog_main.menubar_factory, "/Edit");
	gtk_item_factory_delete_item (dialog_main.menubar_factory, "/Sort");
	gtk_item_factory_delete_item (dialog_main.menubar_factory, "/Misc");
	gtk_item_factory_delete_item (dialog_main.menubar_factory, "/Help");

	menubar_size = bk_edit_menubar_build (&menubar_items);
	gtk_item_factory_create_items (dialog_main.menubar_factory, menubar_size, menubar_items, NULL);
	bk_edit_menubar_free (menubar_items, menubar_size);
	bk_edit_menubar_update_shortcuts ();
}


static void ok (GtkWidget *dialog, void *which)
{
	GList *list = config_recent_documents_list_get (conf);
	GList *l = list;

	while (l)
	{
		if (((int) which)-- == 0)
		{
			break;
		}

		l = l->next;
	}

	if (l == NULL)
	{
		config_recent_documents_list_free (conf, list);
		return;
	}

	bk_edit_file_direct_open (((config_recent_document *) l->data)->filename, ((config_recent_document *) l->data)->plugin);
}

