#ifndef BK_EDIT_MODIFY_INDICATOR_H
#define BK_EDIT_MODIFY_INDICATOR_H

#include <gtk/gtk.h>

#define CURRENT_UNDO_STACK_ENTRY (undo->undo_stack->stack_pointer == 0 ? NULL : undo->undo_stack->stack[undo->undo_stack->stack_pointer - 1])

enum
{
	IS_NOT_MODIFIED = 0,
	IS_MODIFIED = 1
};

typedef struct bk_edit_modify_indicator_tag
{
	void *trigger_value;

	GtkWindow *window;
} bk_edit_modify_indicator;

bk_edit_modify_indicator *bk_edit_modify_indicator_new (void *trigger_value, GtkWindow *window);
void bk_edit_modify_indicator_delete (bk_edit_modify_indicator *indicator);

void bk_edit_modify_indicator_set (bk_edit_modify_indicator *indicator, void *trigger_value);
void bk_edit_modify_indicator_update (bk_edit_modify_indicator *indicator, void *trigger_value);
int bk_edit_modify_indicator_is_modified (bk_edit_modify_indicator *indicator, void *trigger_value);

#endif
