/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_modify_indicator.c - 23.05.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <stdlib.h>

#include "bk_edit_file.h"
#include "bk_edit_modify_indicator.h"


static void indicator_show (bk_edit_modify_indicator *indicator);
static void indicator_hide (bk_edit_modify_indicator *indicator);


bk_edit_modify_indicator *bk_edit_modify_indicator_new (void *trigger_value, GtkWindow *window)
{
	bk_edit_modify_indicator *indicator = (bk_edit_modify_indicator *) malloc (sizeof (bk_edit_modify_indicator));
	if (indicator == NULL)
	{
		return NULL;
	}

	indicator->trigger_value = trigger_value;
	indicator->window = window;

	return indicator;
}


void bk_edit_modify_indicator_delete (bk_edit_modify_indicator *indicator)
{
	free (indicator);
}


void bk_edit_modify_indicator_set (bk_edit_modify_indicator *indicator, void *trigger_value)
{
	indicator->trigger_value = trigger_value;
}


void bk_edit_modify_indicator_update (bk_edit_modify_indicator *indicator, void *trigger_value)
{
	if (indicator->trigger_value == trigger_value)
	{
		indicator_hide (indicator);
	}
	else
	{
		indicator_show (indicator);
	}
}


int bk_edit_modify_indicator_is_modified (bk_edit_modify_indicator *indicator, void *trigger_value)
{
	if (indicator->trigger_value == trigger_value)
	{
		return IS_NOT_MODIFIED;
	}

	return IS_MODIFIED;
}


static void indicator_show (bk_edit_modify_indicator *indicator)
{
	char *title;

	if (indicator->window == NULL)
	{
		return;
	}

	title = g_strdup_printf ("bk edit%s%s%s",
			bk_edit_file_get_currently_opened_file ()->name != NULL ? " - " : "",
			bk_edit_file_get_currently_opened_file ()->name != NULL ? g_basename (bk_edit_file_get_currently_opened_file ()->name) : "",
			" (modified)");

	gtk_window_set_title (indicator->window, title);

	free (title);
}


static void indicator_hide (bk_edit_modify_indicator *indicator)
{
	char *title;

	if (indicator->window == NULL)
	{
		return;
	}

	title = g_strdup_printf ("bk edit%s%s",
			bk_edit_file_get_currently_opened_file ()->name != NULL ? " - " : "",
			bk_edit_file_get_currently_opened_file ()->name != NULL ? g_basename (bk_edit_file_get_currently_opened_file ()->name) : "");

	gtk_window_set_title (indicator->window, title);

	free (title);
}

