/*
 * Copyright (C) 2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_find.c - 12.02.2003 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <string.h>

#include <gtk/gtk.h>

#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "bk_edit_tree.h"
#include "bk_edit_data.h"
#include "bk_edit_misc.h"
#include "bk_edit_icon.h"
#include "bk_edit_dialog_main.h"
#include "bk_edit_dialog_find.h"

extern bk_attribute_string bk_attribute_strings[];

extern bk_edit_tree tree;
extern bk_edit_dialog_main dialog_main;
extern bk_edit_dialog_find dialog_find;

static void find (GtkWidget *widget, gpointer null);
static void clear (GtkWidget *widget, gpointer null);
static gint compare (gconstpointer next, gconstpointer id);
static gint compare_id (gconstpointer next, gconstpointer id);
static void key_pressed (GtkWidget *widget, GdkEventKey *event, gpointer *null);
static void row_selected (GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer null);


void bk_edit_dialog_find_show (void)
{
	if (dialog_find.dialog == NULL)
	{
		int i;

		gchar *list_titles[] = { "Bookmarks" };

		GtkWidget *box, *label, *button_box, *button_box_close, *scroll, *menu;

		dialog_find.dialog = gtk_window_new (GTK_WINDOW_DIALOG);
		gtk_window_position (GTK_WINDOW (dialog_find.dialog), GTK_WIN_POS_MOUSE);
		gtk_window_set_title (GTK_WINDOW (dialog_find.dialog), "bk edit - find");
		gtk_window_set_policy (GTK_WINDOW (dialog_find.dialog), TRUE, TRUE, FALSE);
		gtk_widget_set_usize (GTK_WIDGET (dialog_find.dialog), 400, 285);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_find.dialog), 4);
		gtk_signal_connect_object (GTK_OBJECT (dialog_find.dialog), "delete_event",
				GTK_SIGNAL_FUNC (gtk_widget_hide), GTK_OBJECT (dialog_find.dialog));
		gtk_signal_connect (GTK_OBJECT (dialog_find.dialog), "key_press_event",
				GTK_SIGNAL_FUNC (key_pressed), NULL);
		gtk_widget_realize (dialog_find.dialog);

		/* content */
		dialog_find.content = gtk_vbox_new (FALSE, 4);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_find.content), 4);

		/* entry & label */
		dialog_find.entry = gtk_entry_new ();
		label = gtk_label_new ("Find:");

		box = gtk_hbox_new (FALSE, 4);
		gtk_box_pack_start (GTK_BOX (box), label, FALSE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (box), dialog_find.entry, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (dialog_find.content), box, FALSE, TRUE, 0);

		/* search in */
		label = gtk_label_new ("Search in:");
		dialog_find.search_in = gtk_option_menu_new ();

		menu = gtk_menu_new ();

		for (i = 0; bk_attribute_strings[i].string != NULL; i++)
		{
			GtkWidget *menu_item = gtk_menu_item_new_with_label (bk_attribute_strings[i].string);
			gtk_menu_append (GTK_MENU (menu), menu_item);
			gtk_widget_show (menu_item);
		}
		gtk_option_menu_set_menu (GTK_OPTION_MENU (dialog_find.search_in), menu);

		box = gtk_hbox_new (FALSE, 4);
		gtk_box_pack_start (GTK_BOX (box), label, FALSE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (box), dialog_find.search_in, TRUE, TRUE, 0);

		gtk_box_pack_start (GTK_BOX (dialog_find.content), box, FALSE, TRUE, 0);

		/* result list */
		dialog_find.list = gtk_clist_new_with_titles (1, list_titles);
		gtk_clist_set_row_height (GTK_CLIST (dialog_find.list), 19);
		gtk_clist_set_shadow_type (GTK_CLIST (dialog_find.list), GTK_SHADOW_IN);
		gtk_clist_set_selection_mode (GTK_CLIST (dialog_find.list), GTK_SELECTION_SINGLE);
		gtk_clist_column_titles_active (GTK_CLIST (dialog_find.list));

		gtk_signal_connect_object (GTK_OBJECT (dialog_find.list), "select-row",
				GTK_SIGNAL_FUNC (row_selected), NULL);

		scroll = gtk_scrolled_window_new (NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
							GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

		gtk_container_add (GTK_CONTAINER (scroll), dialog_find.list);
		gtk_box_pack_start (GTK_BOX (dialog_find.content), scroll, TRUE, TRUE, 0);

		/* find & close & clear */
		dialog_find.find = gtk_button_new_with_label ("Find");
		GTK_WIDGET_SET_FLAGS (dialog_find.find, GTK_CAN_DEFAULT);
		gtk_signal_connect_object (GTK_OBJECT (dialog_find.find), "clicked",
						GTK_SIGNAL_FUNC (find),
						NULL);

		dialog_find.clear = gtk_button_new_with_label ("Clear");
		GTK_WIDGET_SET_FLAGS (dialog_find.clear, GTK_CAN_DEFAULT);
		gtk_signal_connect_object (GTK_OBJECT (dialog_find.clear), "clicked",
						GTK_SIGNAL_FUNC (clear),
						NULL);

		dialog_find.close = gtk_button_new_with_label ("Close");
		GTK_WIDGET_SET_FLAGS (dialog_find.close, GTK_CAN_DEFAULT);
		gtk_signal_connect_object (GTK_OBJECT (dialog_find.close), "clicked",
						GTK_SIGNAL_FUNC (gtk_widget_hide),
						GTK_OBJECT (dialog_find.dialog));

		button_box = gtk_hbutton_box_new ();
		gtk_button_box_set_layout (GTK_BUTTON_BOX (button_box), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (button_box), 10);
		gtk_container_add (GTK_CONTAINER (button_box), dialog_find.find);
		gtk_container_add (GTK_CONTAINER (button_box), dialog_find.clear);

		button_box_close = gtk_hbutton_box_new ();
		gtk_button_box_set_layout (GTK_BUTTON_BOX (button_box_close), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (button_box_close), 0);
		gtk_container_add (GTK_CONTAINER (button_box_close), dialog_find.close);

		box = gtk_hbox_new (FALSE, 4);
		gtk_box_pack_start (GTK_BOX (box), button_box, FALSE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (box), button_box_close, TRUE, TRUE, 0);

		/* */
		gtk_box_pack_start (GTK_BOX (dialog_find.content), box, FALSE, TRUE, 0);
		gtk_container_add (GTK_CONTAINER (dialog_find.dialog), dialog_find.content);

		/* */
		gtk_widget_grab_default (dialog_find.find);
		gtk_widget_show_all (dialog_find.dialog);
	}

	gtk_widget_grab_focus (dialog_find.entry);

	/* raise */
	gtk_widget_show (dialog_find.dialog);
	gdk_window_show (dialog_find.dialog->window);
}


static void key_pressed (GtkWidget *widget, GdkEventKey *event, gpointer *null)
{
	if (event == NULL)
	{
		return;
	}

	switch (event->keyval)
	{
		case GDK_KP_Enter:
		case GDK_Return:
		{
			if (GTK_WIDGET_HAS_DEFAULT (dialog_find.find))
			{
				find (NULL, NULL);
			}
			break;
		}

		case GDK_Escape:
		{
			gtk_widget_hide (dialog_find.dialog);
			break;
		}
	}
}


static void find (GtkWidget *widget, gpointer null)
{
	search_for sf;

	int id;
	char *search_in = bk_edit_misc_get_menu_option (GTK_OPTION_MENU (dialog_find.search_in));
	GList *results, *iter;

	for (id = 0; bk_attribute_strings[id].string != NULL; id++)
	{
		if (!strcmp (search_in, bk_attribute_strings[id].string))
		{
			sf.search_in = id;
			break;
		}
	}

	sf.text = gtk_entry_get_text (GTK_ENTRY (dialog_find.entry));

	results = gtk_ctree_find_all_by_row_data_custom (GTK_CTREE (tree.tree), NULL, (gpointer) &sf, compare);

	gtk_clist_freeze (GTK_CLIST (dialog_find.list));
	gtk_clist_clear (GTK_CLIST (dialog_find.list));

	for (iter = results; iter != NULL; iter = g_list_next (iter))
	{
		int row;
		char *text[1];

		GtkCTreeNode *node = (GtkCTreeNode *) iter->data;
		bk_edit_tree_data *node_data = (bk_edit_tree_data *) gtk_ctree_node_get_row_data (GTK_CTREE (tree.tree), node);

		text[0] = node_data->elements[NAME];
		row = gtk_clist_append (GTK_CLIST (dialog_find.list), text);
		gtk_clist_set_row_data (GTK_CLIST (dialog_find.list), row, (gpointer) node_data->id);

		switch (node_data->type)
		{
			case BOOKMARK:
			{
				gtk_clist_set_pixtext (GTK_CLIST (dialog_find.list), row, 0, node_data->elements[NAME], 4, bookmark_item_pix, bookmark_item_mask);
				break;
			}

			case TOP:
			case FOLDER:
			{
				gtk_clist_set_pixtext (GTK_CLIST (dialog_find.list), row, 0, node_data->elements[NAME], 4, bookmark_folder_open_pix, bookmark_folder_open_mask);
				break;
			}

			case SEPARATOR:
			{
				break;
			}
		}
	}

	gtk_clist_thaw (GTK_CLIST (dialog_find.list));

	g_list_free (results);
}


static void clear (GtkWidget *widget, gpointer null)
{
	gtk_clist_freeze (GTK_CLIST (dialog_find.list));
	gtk_clist_clear (GTK_CLIST (dialog_find.list));
	gtk_clist_thaw (GTK_CLIST (dialog_find.list));

	gtk_entry_set_text (GTK_ENTRY (dialog_find.entry), "");
}


static gint compare (gconstpointer next, gconstpointer sf)
{
	bk_edit_tree_data *node_data = (bk_edit_tree_data *) next;

	if (bk_edit_misc_strcasestr (node_data->elements[((search_for *) sf)->search_in], ((search_for *) sf)->text) == NULL)
	{
		return TRUE;
	}

	return FALSE;
}


static void row_selected (GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer null)
{
	int id = (int) gtk_clist_get_row_data (GTK_CLIST (dialog_find.list), row);

	GtkCTreeNode *node = gtk_ctree_find_by_row_data_custom (GTK_CTREE (tree.tree), NULL, (gpointer) id, compare_id);
	if (node != NULL)
	{
		GtkCTreeNode *traverse = node;
		while (GTK_CTREE_ROW (traverse)->parent != NULL)
		{
			bk_edit_tree_data *node_data;
			traverse = GTK_CTREE_ROW (traverse)->parent;

			node_data = (bk_edit_tree_data *) gtk_ctree_node_get_row_data (GTK_CTREE (tree.tree), traverse);
			gtk_ctree_expand (GTK_CTREE (tree.tree), traverse);
		}

		gtk_ctree_node_moveto (GTK_CTREE (tree.tree), node, 0, 0, 0);
		gtk_ctree_select (GTK_CTREE (tree.tree), node);
	}
}


static gint compare_id (gconstpointer next, gconstpointer id)
{
	bk_edit_tree_data *node_data = (bk_edit_tree_data *) next;

	if (node_data->id == (int) id)
	{
		return FALSE;
	}

	return TRUE;
}

