/*
 * Copyright (C) 2001-2003 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_edit.c - 01.03.2003 - v0.8 - some ui improvements
 *                         11.02.2003 - v0.7 - enter => ok, escape => cancel
 *                         23.12.2002 - v0.6 - plugin api clean-up
 *                         06.12.2002 - v0.5 - make it compatible with Mozilla v1.0, v1.1 and v1.2
 *                         05.09.2002 - v0.4 - galeon 1.2.5 plugin
 *                         08.03.2002 - v0.3 - opera 6 plugin
 *                         26.02.2002 - v0.3 - plugin functionality
 *                         08.08.2001 - v0.2 - mozilla suppport
 *                         24.07.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <time.h>
#include <stdlib.h>
#include <string.h>

#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"
#include "plugin.h"

#include "bk_edit_tree.h"
#include "bk_edit_icon.h"
#include "bk_edit_misc.h"
#include "bk_edit_edit.h"

#include "bk_edit_dialog_main.h"
#include "bk_edit_dialog_edit.h"
#include "bk_edit_dialog_info.h"
#include "bk_edit_dialog_config.h"

extern config *conf;
extern plugins *plugs;

extern bk_edit_tree tree;
extern bk_edit_dialog_main dialog_main;
extern bk_edit_dialog_edit dialog_edit;
extern bk_edit_dialog_config dialog_config;

extern char *selected_plugin;

static GtkWidget *plugin_menu_option;

static void switch_notebook_page (GtkNotebook *notebook, GtkNotebookPage *page, gint new_page, bk_edit_tree_data *node_data);
static void update_file_type (GtkMenuItem *menu_item, gpointer user_data);
static void key_pressed (GtkWidget *widget, GdkEventKey *event, gpointer *data);


void bk_edit_dialog_edit_show (gchar *title, GtkCTreeNode *node, bk_edit_tree_data *node_data)
{
	GList *iter;
	GtkWidget *current_page;

	if (dialog_edit.dialog == NULL)
	{
		GtkWidget *menu, *menu_option, *menu_item;
		GtkWidget *hbox;
		GtkWidget *label;

		/* dialog_edit.dialog */
		dialog_edit.dialog = gtk_window_new (GTK_WINDOW_DIALOG);
		gtk_window_position (GTK_WINDOW (dialog_edit.dialog), GTK_WIN_POS_MOUSE);
		gtk_window_set_transient_for (GTK_WINDOW (dialog_edit.dialog), GTK_WINDOW (dialog_main.dialog));
		gtk_window_set_modal (GTK_WINDOW (dialog_edit.dialog), TRUE);
		gtk_window_set_title (GTK_WINDOW (dialog_edit.dialog), title);
		gtk_window_set_policy (GTK_WINDOW (dialog_edit.dialog), TRUE, TRUE, FALSE);
		gtk_widget_set_usize (GTK_WIDGET (dialog_edit.dialog), -1, 500);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_edit.dialog), 4);
		gtk_signal_connect_object (GTK_OBJECT (dialog_edit.dialog), "delete_event",
				GTK_SIGNAL_FUNC (gtk_widget_hide), GTK_OBJECT (dialog_edit.dialog));
		gtk_widget_realize (dialog_edit.dialog);

		/* enter & escape */
		dialog_edit.enter_callback_handle = gtk_signal_connect (GTK_OBJECT (dialog_edit.dialog),
				"key_press_event", GTK_SIGNAL_FUNC (key_pressed), (gpointer) node);

		/* content */
		dialog_edit.content = gtk_vbox_new (FALSE, 1);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_edit.content), 4);

		/* dialog_edit.notebook */
                dialog_edit.notebook = gtk_notebook_new ();

		/* plugin */
		hbox = gtk_hbox_new (FALSE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (hbox), 4);

		label = gtk_label_new ("File Type: ");
		menu = gtk_menu_new ();
		menu_option = plugin_menu_option = gtk_option_menu_new ();

		for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
		{
			if (((plugin *) iter->data)->type & PLUGIN_EDIT)
			{
		                GtkWidget *tab_label = gtk_label_new (((plugin *) iter->data)->short_name);
				gtk_notebook_append_page (GTK_NOTEBOOK (dialog_edit.notebook), ((plugin *) iter->data)->edit_ui, tab_label);

				menu_item = gtk_menu_item_new_with_label (((plugin *) iter->data)->name);
				gtk_menu_append (GTK_MENU (menu), menu_item);
				gtk_widget_show (menu_item);
				gtk_signal_connect (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (update_file_type), (gpointer) dialog_edit.notebook);
			}
		}
		gtk_option_menu_set_menu (GTK_OPTION_MENU (menu_option), menu);

		gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), menu_option, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (dialog_edit.content), hbox, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (dialog_edit.content), dialog_edit.notebook, TRUE, TRUE, 0);

		/* ok */
		dialog_edit.ok = gtk_button_new_with_label ("Ok");
		GTK_WIDGET_SET_FLAGS (dialog_edit.ok, GTK_CAN_DEFAULT);
		dialog_edit.ok_callback_handle = gtk_signal_connect_object (GTK_OBJECT (dialog_edit.ok), "clicked",
						GTK_SIGNAL_FUNC (bk_edit_edit_ok),
						(gpointer) node);
		gtk_signal_connect_object (GTK_OBJECT (dialog_edit.ok), "clicked",
						GTK_SIGNAL_FUNC (gtk_widget_hide),
						GTK_OBJECT (dialog_edit.dialog));

		/* cancle */
		dialog_edit.cancel = gtk_button_new_with_label ("Cancel");
		GTK_WIDGET_SET_FLAGS (dialog_edit.cancel, GTK_CAN_DEFAULT);
		gtk_signal_connect_object (GTK_OBJECT (dialog_edit.cancel), "clicked",
						GTK_SIGNAL_FUNC (gtk_widget_hide),
						GTK_OBJECT (dialog_edit.dialog));

		/* box */
		dialog_edit.button_box = gtk_hbutton_box_new ();
		gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_edit.button_box), GTK_BUTTONBOX_DEFAULT_STYLE);
		gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_edit.button_box), 5);

		/* pack */
		gtk_container_add (GTK_CONTAINER (dialog_edit.button_box), dialog_edit.ok);
		gtk_container_add (GTK_CONTAINER (dialog_edit.button_box), dialog_edit.cancel);

		gtk_box_pack_start (GTK_BOX (dialog_edit.content), dialog_edit.button_box, FALSE, FALSE, 5);
		gtk_container_add (GTK_CONTAINER (dialog_edit.dialog), dialog_edit.content);

		/* */
		gtk_widget_grab_default (dialog_edit.ok);

		/* */
		gtk_widget_show_all (dialog_edit.dialog);

		dialog_edit.switch_page_callback_handle = gtk_signal_connect (GTK_OBJECT (dialog_edit.notebook), "switch_page", GTK_SIGNAL_FUNC (switch_notebook_page), (gpointer *) node_data);
	}
	else
	{
		gtk_signal_disconnect (GTK_OBJECT (dialog_edit.ok), dialog_edit.ok_callback_handle);
		dialog_edit.ok_callback_handle = gtk_signal_connect_object (GTK_OBJECT (dialog_edit.ok), "clicked", GTK_SIGNAL_FUNC (bk_edit_edit_ok), (gpointer) node);

		gtk_signal_disconnect (GTK_OBJECT (dialog_edit.dialog), dialog_edit.enter_callback_handle);
		dialog_edit.enter_callback_handle = gtk_signal_connect (GTK_OBJECT (dialog_edit.dialog), "key_press_event", GTK_SIGNAL_FUNC (key_pressed), (gpointer) node);

		gtk_widget_grab_focus (dialog_edit.ok);

		gtk_signal_disconnect (GTK_OBJECT (dialog_edit.notebook), dialog_edit.switch_page_callback_handle);
		dialog_edit.switch_page_callback_handle = gtk_signal_connect (GTK_OBJECT (dialog_edit.notebook), "switch_page", GTK_SIGNAL_FUNC (switch_notebook_page), (gpointer *) node_data);
	}

	if (selected_plugin == NULL)
	{
		selected_plugin = strdup (config_browser_type_get (conf));
	}

	gtk_notebook_set_page (GTK_NOTEBOOK (dialog_edit.notebook),
		bk_edit_misc_set_menu_option (GTK_OPTION_MENU (plugin_menu_option), selected_plugin));

	/* Fill in the node_data into the corresponding GtkNotebook page. */
	current_page = gtk_notebook_get_nth_page (GTK_NOTEBOOK (dialog_edit.notebook), gtk_notebook_get_current_page (GTK_NOTEBOOK (dialog_edit.notebook)));
	for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
	{
		plugin *plug = (plugin *) iter->data;
		if (current_page == plug->edit_ui)
		{
			plug->edit_ui_set (plug, node_data);
			break;
		}
	}

	/* raise */
	gtk_widget_show (dialog_edit.dialog);
	gdk_window_show (dialog_edit.dialog->window);
}


static void switch_notebook_page (GtkNotebook *notebook, GtkNotebookPage *page, gint new_page, bk_edit_tree_data *node_data)
{
	int i;

	GList *iter;
	gchar *plugin_name;

	plugin *from = NULL, *to = NULL;

	GtkWidget *new = gtk_notebook_get_nth_page (notebook, new_page);
	GtkWidget *old = gtk_notebook_get_nth_page (notebook, gtk_notebook_get_current_page (notebook));

	bk_edit_tree_data *data = (bk_edit_tree_data *) malloc (sizeof (bk_edit_tree_data));

	data->id = node_data->id;
	data->type = node_data->type;
	for (i = 0; i < ELEMENTS; i++)
	{
		data->elements[i] = strdup (node_data->elements[i]);
	}

	gtk_option_menu_set_history (GTK_OPTION_MENU (plugin_menu_option), new_page);

	/* plugin */
	plugin_name = bk_edit_misc_get_menu_option (GTK_OPTION_MENU (plugin_menu_option));

	if (selected_plugin != NULL)
	{
		free (selected_plugin);
	}
	selected_plugin = strdup (plugin_name);

	for (iter = plugs->list; iter != NULL; iter = g_list_next (iter))
	{
		plugin *plug = (plugin *) iter->data;
		if (new == plug->edit_ui)
		{
			to = plug;
		}
		else if (old == plug->edit_ui)
		{
			from = plug;
		}
	}

	from->edit_ui_get (from, data);
	to->edit_ui_set (to, data);

	for (i = 0; i < ELEMENTS; i++)
	{
		free (data->elements[i]);
	}
}


static void update_file_type (GtkMenuItem *menu_item, gpointer user_data)
{
	GtkWidget *notebook = (GtkWidget *) user_data;

	/* plugin */
	gtk_notebook_set_page (GTK_NOTEBOOK (notebook), g_list_index (GTK_MENU_SHELL (GTK_OPTION_MENU (plugin_menu_option)->menu)->children, gtk_menu_get_active (GTK_MENU (GTK_OPTION_MENU (plugin_menu_option)->menu))));
}


static void key_pressed (GtkWidget *widget, GdkEventKey *event, gpointer *data)
{
	GtkCTreeNode *node = (GtkCTreeNode *) data;

	if (event == NULL)
	{
		return;
	}

	switch (event->keyval)
	{
		case GDK_KP_Enter:
		case GDK_Return:
		{
			if (GTK_IS_TEXT ((GTK_WINDOW (widget)->focus_widget)))
			{
				return;
			}

			if (GTK_WIDGET_HAS_DEFAULT (dialog_edit.ok))
			{
				gtk_widget_grab_focus (dialog_edit.notebook);
				bk_edit_edit_ok (node);
				gtk_widget_hide (dialog_edit.dialog);
			}
			break;
		}

		case GDK_Escape:
		{
			gtk_widget_hide (dialog_edit.dialog);
			break;
		}
	}
}

