/*
 * Copyright (C) 2001 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * be_edit_dialog_clipboard.c - 26.10.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <string.h>
#include <stdlib.h>

#include "bk_edit_ccp.h"
#include "bk_edit_tree.h"
#include "bk_edit_icon.h"

#include "bk_edit_dialog_clipboard.h"

extern bk_edit_ccp ccp;
extern bk_edit_dialog_clipboard dialog_clipboard;

void bk_edit_dialog_clipboard_show (void)
{
	if (dialog_clipboard.dialog == NULL)
	{
		gchar *tree_title[] = { " Name " };

		/* dialog window */
		dialog_clipboard.dialog = gtk_window_new (GTK_WINDOW_DIALOG);
		gtk_window_set_title (GTK_WINDOW (dialog_clipboard.dialog), "bk edit - clipboard");
		gtk_window_position (GTK_WINDOW (dialog_clipboard.dialog), GTK_WIN_POS_MOUSE);
		gtk_window_set_policy (GTK_WINDOW (dialog_clipboard.dialog), FALSE, FALSE, TRUE);
		gtk_widget_set_usize (GTK_WIDGET (dialog_clipboard.dialog), 400, 200);
		gtk_container_set_border_width (GTK_CONTAINER (dialog_clipboard.dialog), 4);
		gtk_signal_connect_object (GTK_OBJECT (dialog_clipboard.dialog), "delete_event",
			GTK_SIGNAL_FUNC (gtk_widget_hide_all), GTK_OBJECT (dialog_clipboard.dialog));
		gtk_widget_realize (dialog_clipboard.dialog);

		/* box */
		dialog_clipboard.box = gtk_vbox_new (FALSE, 1);

		/* scrollbar container */
		dialog_clipboard.scroll = gtk_scrolled_window_new (NULL, NULL);
		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (dialog_clipboard.scroll),
							GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

		/* tree */
		dialog_clipboard.tree = gtk_ctree_new_with_titles (1, 0, tree_title);
		gtk_clist_set_shadow_type (GTK_CLIST (dialog_clipboard.tree), GTK_SHADOW_IN);
		gtk_clist_set_selection_mode (GTK_CLIST (dialog_clipboard.tree), GTK_SELECTION_SINGLE);
		gtk_clist_set_row_height (GTK_CLIST (dialog_clipboard.tree), 19);
		gtk_clist_column_titles_active (GTK_CLIST (dialog_clipboard.tree));

		/* pack */
		gtk_container_add (GTK_CONTAINER (dialog_clipboard.scroll), dialog_clipboard.tree);
		gtk_box_pack_start (GTK_BOX (dialog_clipboard.box), dialog_clipboard.scroll, TRUE, TRUE, 0);
		gtk_container_add (GTK_CONTAINER (dialog_clipboard.dialog), dialog_clipboard.box);
	}

	/* */
	gtk_widget_show_all (dialog_clipboard.dialog);

	/* raise */
	gdk_window_show (dialog_clipboard.dialog->window);

	/* */
	bk_edit_dialog_clipboard_update ();
}


void bk_edit_dialog_clipboard_update (void)
{
	if (dialog_clipboard.dialog == NULL)
	{
		return;
	}

	if (ccp.ccp_node == NULL)
	{
		return;
	}

	if (!GTK_WIDGET_VISIBLE (dialog_clipboard.dialog))
	{
		return;
	}

	gtk_clist_freeze (GTK_CLIST (dialog_clipboard.tree));
	gtk_clist_clear (GTK_CLIST (dialog_clipboard.tree));
	gtk_ctree_insert_gnode (GTK_CTREE (dialog_clipboard.tree), NULL, NULL, ccp.ccp_node, bk_edit_dialog_clipboard_gnode_to_tree, NULL);
	gtk_clist_thaw (GTK_CLIST (dialog_clipboard.tree));
}


gboolean bk_edit_dialog_clipboard_gnode_to_tree (GtkCTree *ctree, guint depth, GNode *gnode, GtkCTreeNode *cnode, gpointer data)
{
	char *name = strdup (((bk_edit_tree_data *) gnode->data)->elements[NAME]);

	gtk_ctree_node_set_row_data_full (GTK_CTREE (ctree), cnode, name, bk_edit_clipboard_tree_destroy);

	switch (((bk_edit_tree_data *) gnode->data)->type)
	{
		case BOOKMARK:
		{
			gtk_ctree_set_node_info (GTK_CTREE (ctree), cnode, name, 4, bookmark_item_pix, bookmark_item_mask, bookmark_item_pix, bookmark_item_mask, TRUE, FALSE);
			break;
		}

		case TOP:
		{
			gtk_ctree_set_node_info (GTK_CTREE (ctree), cnode, name, 4, bookmark_folder_closed_pix, bookmark_folder_closed_mask, bookmark_folder_open_pix, bookmark_folder_open_mask, FALSE, FALSE);
			break;
		}

		case FOLDER:
		{
			gtk_ctree_set_node_info (GTK_CTREE (ctree), cnode, name, 4, bookmark_folder_closed_pix, bookmark_folder_closed_mask, bookmark_folder_open_pix, bookmark_folder_open_mask, FALSE, TRUE);
			break;
		}

		case SEPARATOR:
		{
			gtk_ctree_set_node_info (GTK_CTREE (ctree), cnode, name, 4, NULL, NULL, NULL, NULL, TRUE, FALSE);
			break;
		}
	}

	return TRUE;
}


void bk_edit_clipboard_tree_destroy (gpointer data)
{
	free (data);
}

