/*
 * Copyright (C) 2001 Clemens Fuchslocher <clfuit00@fht-esslingen.de>
 *
 * bk_edit_dialog_about.c - 24.07.2001 - v0.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <gtk/gtk.h>

#include "config.h"

void bk_edit_dialog_about (void)
{
	GtkWidget *about, *frame, *box, *mainbox, *separator;
	GtkWidget *ok, *ok_box;

	GtkWidget *title_label, *title_box;
	GtkStyle  *title_label_style, *title_box_style;

	GtkWidget *info_label, *info_box;
	GtkStyle  *info_label_style, *info_box_style;

	GdkColor black = { 0,      0,      0,      0 };
	GdkColor white = { 0, 0xFFFF, 0xFFFF, 0xFFFF };
	GdkColor green = { 0, 0x7600, 0xA100, 0x8400 };

	/* about */
	about = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_window_set_title (GTK_WINDOW (about), "bk edit - about");
	gtk_window_position (GTK_WINDOW (about), GTK_WIN_POS_CENTER);
	gtk_window_set_policy (GTK_WINDOW (about), FALSE, FALSE, TRUE);
	gtk_widget_set_usize (GTK_WIDGET (about), 500, 300);
	gtk_container_set_border_width (GTK_CONTAINER (about), 4);
	gtk_signal_connect_object (GTK_OBJECT (about), "destroy",
					GTK_SIGNAL_FUNC (gtk_widget_destroy),
					GTK_OBJECT (about));

	/* mainbox */
	mainbox = gtk_vbox_new (FALSE, 1);

	/* frame */
	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 4);

	/* box */
	box = gtk_vbox_new (FALSE, 0);

	/* title_box */
	title_box = gtk_event_box_new ();

	/* title_box_style */
	title_box_style = gtk_style_new ();
	title_box_style->bg[GTK_STATE_NORMAL] = black;
	gtk_widget_set_style (title_box, title_box_style);

	/* title_label */
	title_label = gtk_label_new ("bk edit " BK_EDIT_VERSION);
	gtk_widget_set_usize (title_label, -1, 30);

	/* title_label_style */
	title_label_style = gtk_style_new ();
	gdk_font_unref (title_label_style->font);
	title_label_style->font = gdk_font_load ("-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*");
	if (!title_label_style->font) title_label_style->font = gdk_font_load ("fixed");
	title_label_style->fg[GTK_STATE_NORMAL] = white;
	gtk_widget_set_style (title_label, title_label_style);

	/* info_box */
	info_box = gtk_event_box_new ();

	/* info_box_style */
	info_box_style = gtk_style_new ();
	info_box_style->bg[GTK_STATE_NORMAL] = green;
	gtk_widget_set_style (info_box, info_box_style);

	/* info_label */
	info_label = gtk_label_new (BK_EDIT_LICENSE);

	gtk_label_set_justify (GTK_LABEL (info_label), GTK_JUSTIFY_LEFT);

	/* info_label_style */
	info_label_style = gtk_style_new ();
	gdk_font_unref (info_label_style->font);
	info_label_style->font = gdk_font_load ("-adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*");
	if (!info_label_style->font) info_label_style->font = gdk_font_load ("fixed");
	info_label_style->fg[GTK_STATE_NORMAL] = black;
	gtk_widget_set_style (info_label, info_label_style);

	/* separator */
	separator = gtk_hseparator_new ();

	/* ok */
	ok = gtk_button_new_with_label ("Close");
	GTK_WIDGET_SET_FLAGS (ok, GTK_CAN_DEFAULT);
	gtk_signal_connect_object (GTK_OBJECT (ok), "clicked",
					GTK_SIGNAL_FUNC (gtk_widget_destroy),
					GTK_OBJECT (about));

	/* ok_box */
	ok_box = gtk_hbutton_box_new ();
	gtk_button_box_set_layout (GTK_BUTTON_BOX (ok_box), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (ok_box), 5);

	/* */
	gtk_container_add (GTK_CONTAINER (title_box), title_label);
	gtk_box_pack_start (GTK_BOX (box), title_box, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (info_box), info_label);
	gtk_box_pack_end (GTK_BOX (box), info_box, TRUE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (frame), box);
	gtk_box_pack_start (GTK_BOX (mainbox), frame, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (mainbox), separator, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (ok_box), ok);
	gtk_box_pack_start (GTK_BOX (mainbox), ok_box, FALSE, FALSE, 5);
	gtk_container_add (GTK_CONTAINER (about), mainbox);

	/* */
	gtk_widget_grab_default (ok);

	/* */
	gtk_widget_show_all (about);

	/* */
	gtk_style_unref (title_label_style);
	gtk_style_unref (title_box_style);
	gtk_style_unref (info_label_style);
	gtk_style_unref (info_box_style);
}
