/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* mkobextodo.c
 */

#include <obexformat.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define MAXNAME                  24

static int ofs;
static int cr;
static int size;
static char* text;

static void addChar(int c)
{
  if(ofs>size-3) {
    size*=2;
    text=realloc(text,size);
  }
  if(c=='\n') {
    if(!cr) text[ofs++]='\r';
  } else {
    if(cr) text[ofs++]='\n';
  }
  text[ofs++]=c;
  cr= c=='\r';
}

static void addStr(const char* s)
{
  while(*s) addChar(*s++);
}

static void endInput(void)
{
  if(cr) text[ofs++]='\n';
}

int main(int argc, char** argv)
{
  int c,n;
  int usage=0;
  char* name=0;
  char* date=0;
  char datebuf[9];
  time_t t;
  struct tm* lt;

  while((c=getopt(argc,argv,"n:d:h"))!=-1) {
    switch(c) {
    case 'n': name=optarg; break;
    case 'd': date=optarg; break;
    case 'h': usage=1; break;
    case '?': usage=1; break;
    }
  }

  if(usage) {
    fprintf(stderr,"Format Palm Pilot todo item from stdin or command line\n");
    fprintf(stderr,"Usage: %s [-n name] [-d [[[cc]yy]mm]dd] [text ...]\n",argv[0]);
    return 0;
  }

  n=date ? strlen(date) : 0;
  if(n>8 || (n&1)) {
    fprintf(stderr,"Bad date format\n");
    exit(-1);
  }

  time(&t);
  lt=localtime(&t);

  sprintf(datebuf,"%04d%02d%02d",lt->tm_year+1900,lt->tm_mon+1,lt->tm_mday);
  if(n>0) strcpy(datebuf+8-n,date);

  size=1024;
  text=malloc(size);

  addStr("BEGIN:VCALENDAR\n");
  addStr("VERSION:1.0\nBEGIN:VTODO\n");
  addStr("CATEGORIES:X-Unfiled\nDUE:");
  addStr(datebuf);
  addStr("\nSTATUS:NEEDS ACTION\n");
  addStr("PRIORITY:1\nDESCRIPTION:");

  if(optind<argc) {
    while(optind<argc) {
      addStr(argv[optind++]);
      if(optind<argc) addChar(' ');
    }
  } else {
    while((c=getchar())!=EOF) addChar(c);
  }

  addStr("\nEND:VTODO\nEND:VCALENDAR\n");

  endInput();

  if(name) {
    int nlen=strlen(name);
    if(nlen>MAXNAME) nlen=MAXNAME;
    putName(name,nlen);
  }

  putClass(0x746f646f); /* 'todo' */
  putEndOfBody(text,ofs);

  return 0;
}
