import java.io.*;
import java.net.*;

public class SendToSocket {
  public static void main(String[] args) {
    if (args.length < 2) {
      System.out.println("Usage: SendToSocket host port [file]");
      System.exit(1);
    }
    try {
      Socket s = 
	new Socket(InetAddress.getByName(args[0]), Integer.parseInt(args[1]));
      OutputStream out = s.getOutputStream();
      InputStream in = 
	args.length > 2 ? new FileInputStream(args[2]) : System.in;
      byte[] buf = new byte[4096];
      int len;
      while ((len = in.read(buf)) >= 0) {
	out.write(buf, 0, len);
      }
      out.flush();
      out.close();
      in.close();
    } catch (Exception e) {
      System.err.println("Error:" + e);
    }
  }  
}

