/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "fasta.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc member in a bl_fasta_t structure.
 *      Use this function to set desc in a bl_fasta_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      desc is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_desc        The new value for desc
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      char *          new_desc;
 *
 *      if ( bl_fasta_set_desc(&bl_fasta, new_desc)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_desc(
	    bl_fasta_t *bl_fasta_ptr,
	    char * new_desc
	)

{
    if ( new_desc == NULL )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->desc = new_desc;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of desc member in a bl_fasta_t
 *      structure. Use this function to set bl_fasta_ptr->desc[c]
 *      in a bl_fasta_t object from non-member functions.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      c               Subscript to the desc array
 *      new_desc_element The new value for desc[c]
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      size_t          c;
 *      char *          new_desc_element;
 *
 *      if ( bl_fasta_set_desc_ae(&bl_fasta, c, new_desc_element)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTA_SET_DESC_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_desc_ae(
	    bl_fasta_t *bl_fasta_ptr,
	    size_t c,
	    char  new_desc_element
	)

{
    if ( false )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->desc[c] = new_desc_element;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc member in a bl_fasta_t structure.
 *      Use this function to set desc in a bl_fasta_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_desc to bl_fasta_ptr->desc.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_desc        The new value for desc
 *      array_size      Size of the desc array.
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      char *          new_desc;
 *      size_t          array_size;
 *
 *      if ( bl_fasta_set_desc_cpy(&bl_fasta, new_desc, array_size)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTA_SET_DESC(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_desc_cpy(
	    bl_fasta_t *bl_fasta_ptr,
	    char * new_desc,
	    size_t array_size
	)

{
    if ( new_desc == NULL )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_fasta_ptr->desc, new_desc, array_size);
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq member in a bl_fasta_t structure.
 *      Use this function to set seq in a bl_fasta_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seq is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_seq         The new value for seq
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      char *          new_seq;
 *
 *      if ( bl_fasta_set_seq(&bl_fasta, new_seq)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_seq(
	    bl_fasta_t *bl_fasta_ptr,
	    char * new_seq
	)

{
    if ( new_seq == NULL )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->seq = new_seq;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for an array element of seq member in a bl_fasta_t
 *      structure. Use this function to set bl_fasta_ptr->seq[c]
 *      in a bl_fasta_t object from non-member functions.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      c               Subscript to the seq array
 *      new_seq_element The new value for seq[c]
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      size_t          c;
 *      char *          new_seq_element;
 *
 *      if ( bl_fasta_set_seq_ae(&bl_fasta, c, new_seq_element)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTA_SET_SEQ_AE(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_seq_ae(
	    bl_fasta_t *bl_fasta_ptr,
	    size_t c,
	    char  new_seq_element
	)

{
    if ( false )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->seq[c] = new_seq_element;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq member in a bl_fasta_t structure.
 *      Use this function to set seq in a bl_fasta_t object
 *      from non-member functions.  This function copies the array pointed to
 *      by new_seq to bl_fasta_ptr->seq.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_seq         The new value for seq
 *      array_size      Size of the seq array.
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      char *          new_seq;
 *      size_t          array_size;
 *
 *      if ( bl_fasta_set_seq_cpy(&bl_fasta, new_seq, array_size)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      BL_FASTA_SET_SEQ(3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_seq_cpy(
	    bl_fasta_t *bl_fasta_ptr,
	    char * new_seq,
	    size_t array_size
	)

{
    if ( new_seq == NULL )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	// FIXME: Assuming char array is a null-terminated string
	strlcpy(bl_fasta_ptr->seq, new_seq, array_size);
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc_array_size member in a bl_fasta_t structure.
 *      Use this function to set desc_array_size in a bl_fasta_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      desc_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_desc_array_size The new value for desc_array_size
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      size_t          new_desc_array_size;
 *
 *      if ( bl_fasta_set_desc_array_size(&bl_fasta, new_desc_array_size)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_desc_array_size(
	    bl_fasta_t *bl_fasta_ptr,
	    size_t new_desc_array_size
	)

{
    if ( false )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->desc_array_size = new_desc_array_size;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq_array_size member in a bl_fasta_t structure.
 *      Use this function to set seq_array_size in a bl_fasta_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seq_array_size is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_seq_array_size The new value for seq_array_size
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      size_t          new_seq_array_size;
 *
 *      if ( bl_fasta_set_seq_array_size(&bl_fasta, new_seq_array_size)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_seq_array_size(
	    bl_fasta_t *bl_fasta_ptr,
	    size_t new_seq_array_size
	)

{
    if ( false )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->seq_array_size = new_seq_array_size;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for desc_len member in a bl_fasta_t structure.
 *      Use this function to set desc_len in a bl_fasta_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      desc_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_desc_len    The new value for desc_len
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      size_t          new_desc_len;
 *
 *      if ( bl_fasta_set_desc_len(&bl_fasta, new_desc_len)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_desc_len(
	    bl_fasta_t *bl_fasta_ptr,
	    size_t new_desc_len
	)

{
    if ( false )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->desc_len = new_desc_len;
	return BL_FASTA_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/fasta.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for seq_len member in a bl_fasta_t structure.
 *      Use this function to set seq_len in a bl_fasta_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      seq_len is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_fasta_ptr    Pointer to the structure to set
 *      new_seq_len     The new value for seq_len
 *
 *  Returns:
 *      BL_FASTA_DATA_OK if the new value is acceptable and assigned
 *      BL_FASTA_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_fasta_t      bl_fasta;
 *      size_t          new_seq_len;
 *
 *      if ( bl_fasta_set_seq_len(&bl_fasta, new_seq_len)
 *              == BL_FASTA_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from fasta.h
 ***************************************************************************/

int     bl_fasta_set_seq_len(
	    bl_fasta_t *bl_fasta_ptr,
	    size_t new_seq_len
	)

{
    if ( false )
	return BL_FASTA_DATA_OUT_OF_RANGE;
    else
    {
	bl_fasta_ptr->seq_len = new_seq_len;
	return BL_FASTA_DATA_OK;
    }
}
