/***************************************************************************
 *  This file is automatically generated by gen-get-set.  Be sure to keep
 *  track of any manual changes.
 *
 *  These generated functions are not expected to be perfect.  Check and
 *  edit as needed before adding to your code.
 ***************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdbool.h>        // In case of bool
#include <stdint.h>         // In case of int64_t, etc
#include <xtend/string.h>   // strlcpy() on Linux
#include "align.h"


/***************************************************************************
 *  Library:
 *      #include <biolibc/align.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for min_match member in a bl_align_t structure.
 *      Use this function to set min_match in a bl_align_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      min_match is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_align_ptr    Pointer to the structure to set
 *      new_min_match   The new value for min_match
 *
 *  Returns:
 *      BL_ALIGN_DATA_OK if the new value is acceptable and assigned
 *      BL_ALIGN_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_align_t      bl_align;
 *      size_t          new_min_match;
 *
 *      if ( bl_align_set_min_match(&bl_align, new_min_match)
 *              == BL_ALIGN_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from align.h
 ***************************************************************************/

int     bl_align_set_min_match(
	    bl_align_t *bl_align_ptr,
	    size_t new_min_match
	)

{
    if ( false )
	return BL_ALIGN_DATA_OUT_OF_RANGE;
    else
    {
	bl_align_ptr->min_match = new_min_match;
	return BL_ALIGN_DATA_OK;
    }
}


/***************************************************************************
 *  Library:
 *      #include <biolibc/align.h>
 *      -lbiolibc -lxtend
 *
 *  Description:
 *      Mutator for max_mismatch_percent member in a bl_align_t structure.
 *      Use this function to set max_mismatch_percent in a bl_align_t object
 *      from non-member functions.  This function performs a direct
 *      assignment for scalar or pointer structure members.  If
 *      max_mismatch_percent is a pointer, data previously pointed to should
 *      be freed before calling this function to avoid memory
 *      leaks.
 *
 *  Arguments:
 *      bl_align_ptr    Pointer to the structure to set
 *      new_max_mismatch_percent The new value for max_mismatch_percent
 *
 *  Returns:
 *      BL_ALIGN_DATA_OK if the new value is acceptable and assigned
 *      BL_ALIGN_DATA_OUT_OF_RANGE otherwise
 *
 *  Examples:
 *      bl_align_t      bl_align;
 *      unsigned        new_max_mismatch_percent;
 *
 *      if ( bl_align_set_max_mismatch_percent(&bl_align, new_max_mismatch_percent)
 *              == BL_ALIGN_DATA_OK )
 *      {
 *      }
 *
 *  See also:
 *      (3)
 *
 *  History: 
 *  Date        Name        Modification
 *  2022-02-07  gen-get-set Auto-generated from align.h
 ***************************************************************************/

int     bl_align_set_max_mismatch_percent(
	    bl_align_t *bl_align_ptr,
	    unsigned new_max_mismatch_percent
	)

{
    if ( false )
	return BL_ALIGN_DATA_OUT_OF_RANGE;
    else
    {
	bl_align_ptr->max_mismatch_percent = new_max_mismatch_percent;
	return BL_ALIGN_DATA_OK;
    }
}
