;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Effect/effect.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 13:46:44 1995                          */
;*    Last change :  Wed Jun  7 05:41:25 2017 (serrano)                */
;*    Copyright   :  1995-2017 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The effect property                                              */
;*    -------------------------------------------------------------    */
;*    It is optional to have run the Effect pass before invoking       */
;*    this function. Nevertheless, firstly invoking Effect pass        */
;*    leads to better approximations.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_effect
   (include "Ast/node.sch")
   (export  (generic side-effect?::bool ::node)))

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (side-effect? node::node))

;*---------------------------------------------------------------------*/
;*    side-effect? ::node ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::node)
   #f)

;*---------------------------------------------------------------------*/
;*    side-effect? ::patch ...                                         */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::patch)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::var)
   (not (eq? (variable-access (var-variable node)) 'read)))

;*---------------------------------------------------------------------*/
;*    side-effect? ::node ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::node/effect)
   (let ((effect (node/effect-side-effect node)))
      (if (boolean? effect)
	  effect
	  #t)))
 
;*---------------------------------------------------------------------*/
;*    side-effect? ::app ...                                           */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::app)
   (or (call-next-method)
       (with-access::app node (fun)
	  (let ((fun (variable-value (var-variable fun))))
	     (eq? (fun-side-effect fun) #t)))))

;*---------------------------------------------------------------------*/
;*    side-effect? ::setq ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::setq)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::fail ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::fail)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::set-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::set-ex-it)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::jump-ex-it ...                                    */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::jump-ex-it)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::box-set! ...                                      */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::box-set!)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::app-ly ...                                        */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::app-ly)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::funcall ...                                       */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::funcall)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::cast ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::cast)
   (with-access::cast node (arg)
      (side-effect? arg)))

;*---------------------------------------------------------------------*/
;*    side-effect? ::sync ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::sync)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::retblock ...                                      */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::retblock)
   (with-access::retblock node (body)
      (side-effect? body)))

;*---------------------------------------------------------------------*/
;*    side-effect? ::return ...                                        */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::return)
   #t)
