c Test program for FFT routines...
c
c This is a test program for the FFT routines.  The routines are tested
c by generating a test sequence and then applying the forward and backward
c transforms consecutively.  The result is then compared to the original 
c sequence and the relative error in the difference is displayed.  This
c error should be small; ideally, on the order of machine precision.
c
c The transform routines are tested for all positive powers of two up
c through and including Nmax.  The user should adjust the parameter
c Nmax shown in the declarations below.  Notice that the initialization
c routine FFTI only needs to be called once.  Once the routines are 
c initialized at Nmax, they are initialized for all powers of two less
c than or equal to Nmax.
c
c The test sequence is generated by a simple in-line version of a linear
c congruential pseudo-random number generator.  This in-line generator 
c should work fine on all machines for which 2**24 does not result in 
c integer overflow.  For large sequences, the period of the random 
c number generator may be exhausted, but this does not hurt the test.
c
c This test program has run successfully on the following platforms:
c      MS Dos 6.0, MS Fortran 5.1 - Nmax = 16384
c      Sun OS 4.1.3, Sun Sparcompiler f77 v3.0.1 - Nmax = 131072
c      Sun OS 4.1.3, NAGWare f90 v2.2 - Nmax = 131072
c      Sun OS 5.4 (Solaris), NAGWare f90 v2.2 - Nmax = 131072
c      Linux 1.3.9, f2c - Nmax = 16384
c      Linux 1.3.9, NAGWare f90 v2.2 - Nmax = 16384
c      MS Dos 6.0, BC-FORTRAN77 v1.3b - Nmax = 2048
c
c The values of Nmax shown above do not reflect any limits enforced by 
c these routines or the environments (except possibly in the case of
c BC-FORTRAN77).  They were simply the test values that were chosen.
c
c-----------------------------------------------
c  Steve Kifowit, 18 July 1997, 28 December 1997
c-----------------------------------------------
c
c----End of remarks, Beginning of test program code---------------------c
c
c ... Variables required by FFT routines ...
      integer  n, m, Nmax, Nmax8
cccccccccc Nmax must be a power of two
      parameter  ( Nmax = 16384 )
cccccccccc
      parameter  ( Nmax8 = Nmax / 8 )
      real  x1(Nmax), y1(Nmax), x2(Nmax), y2(Nmax)
      real  s1(Nmax8), c1(Nmax8), s3(Nmax8), c3(Nmax8)
c ... General variables ...
      integer  i
      real  u, v, relerr
c ... Variables required by pseudo-random number generator ...
      integer  im, ia, ic, iseed
      intrinsic  mod
c ... Output unit number ...
      integer  nout
c ... Data ...
      data  nout / 6 /
      data  im / 139968 /, ia / 205 /, ic / 29573 /
c iseed can have any value between 0 and 139967
      data  iseed / 13 /
c
c ... Exe. statements ...
c
c ... If writing to a file, open it ...
c     open ( unit = nout, file = 'test.out', status = 'new' )
c ... Generate test sequence ...
      do 10, i = 1, Nmax
         iseed = mod( iseed * ia + ic, im )
         x2(i) = float( iseed ) / float( im )
         iseed = mod( iseed * ia + ic, im )
	 y2(i) = float( iseed ) / float( im )
 10   continue
c ... Initialize trig tables once and for all ...
      call ffti( Nmax, s1, c1, s3, c3 )
c ... Write test remarks ...
      write ( nout, 9999 ) '*** Test of RFFT routines ***'
c ... Loop through tests of transform routines
      n = 1
      m = 0
 15   if ( n .le. Nmax ) then
         do 20, i = 1, n
            x1(i) = x2(i)
 20      continue
         call rfftf( x1, n, m, s1, c1, s3, c3, Nmax )
         call rfftb( x1, n, m, s1, c1, s3, c3, Nmax )
         u = 0.0
         v = 0.0
         do 30, i = 1, n
            u = u + ( x1(i) - x2(i) ) ** 2
            v = v + x2(i) ** 2
 30      continue
         relerr = sqrt( u ) / sqrt( v )
         write ( nout, 9998 ) n, m, relerr
         n = 2 * n
         m = m + 1
         goto 15
      endif
c ... Write test remarks ...
      write ( nout, 9999 ) '*** Test of CFFT routine ***'
c ... Loop through tests of transform routines
      n = 1
      m = 0
 45   if ( n .le. Nmax ) then
         do 50, i = 1, n
            x1(i) = x2(i)
	    y1(i) = y2(i)
 50      continue
         call cfft( x1, y1, n, m, 1, s1, c1, s3, c3, Nmax )
         call cfft( x1, y1, n, m, -1, s1, c1, s3, c3, Nmax )
         u = 0.0
         v = 0.0
         do 60, i = 1, n
            u = u + ( x1(i) - x2(i) ) ** 2 + ( y1(i) - y2(i) ) ** 2
            v = v + x2(i) ** 2 + y2(i) ** 2
 60      continue
         relerr = sqrt( u ) / sqrt( v )
         write ( nout, 9998 ) n, m, relerr
         n = 2 * n
         m = m + 1
         goto 45
      endif
c ... Format statements ...
 9999 format ( 1x, /, a, / )
 9998 format ( 1x, 'N = ', i6, 3x, 'M = ', i4, 3x, 
     +         'Relative error = ', e13.6 )
c
c ... End of test program ...
c
      end

