      SUBROUTINE ksorensenCFFT( X, Y, N, M, JOB, 
     +                         S1, C1, S3, C3, Nmax )
c
c  An in-place, split-radix complex FFT program
c  Decimation-in-frequency, cos/sin in third loop and looked-up
c  in table. Tables C1,C3,S1,S3 have length>=Nmax/8-1 and are 
c  initialized by calling subroutine FFTI.
c
c  Input/output
c      X    Array of real part of input/output (length >= N)
c      Y    Array of imaginary part of input/output (length >= N)
c      N    Transforn length is N=2**M
c      M    Transform length is N=2**M
c      JOB  Set JOB=-1 for inverse transform
c      S1  Array of sin() table (length >= Nmax/8-1)
c      C1  Array of cos() table (length >= Nmax/8-1)
c      S3  Array of sin() table (length >= Nmax/8-1)
c      C3  Array of cos() table (length >= Nmax/8-1)
c      Nmax   Transform length for which trig tables were initialized
c
c  Calls: CTSTAG - workhorse written by H.V. Sorensen (see below)
c         BITREV - bit reversal routine
c
c  The sine/cosine tables were initialized assuming a transform
c  length of Nmax (a power of two).
c
c  The initialization routine FFTI must be called prior to calling
c  this routine.  FFTI need not be called again unless Nmax is made
c  larger.
c  In place bit reversal is accomplished by calling BITREV.
c
c  This routine is a modification of the routine CTFFTSR written by 
c  H.V. Sorensen (Dec. 1984).
c
c  Modifications made by Steve Kifowit.
c    - cosmetic changes and rename -- 12/01/97
c    - quick return for N=1 -- 12/01/97
c    - removed bit reversal table -- 12/01/97
c    - bit reversal by calling BITREV -- 12/01/97
c    - forward and backward transform in one -- 12/27/97
c    - modified table lookup -- 12/27/97
c
c
c ... Scalar arguments ...
      INTEGER  N, M, JOB, Nmax
c ... Array arguments ...
      DOUBLE PRECISION  X(*), Y(*), C1(*), C3(*), S1(*), S3(*)
c ... Local scalars ...
      INTEGER  N2, N4, K, ITS, IS, ID
      DOUBLE PRECISION  XT 
c
c ... Exe. statements ...
c
c ... Quick return for N=1 ...
      IF ( N .EQ. 1 ) RETURN
c
c ... Conjugate if inverse transform ...
      IF ( JOB .EQ. -1 ) THEN
         DO 5, K = 1, N
	    Y(K) = - Y(K)
 5       CONTINUE
      ENDIF
c
c ... L shaped butterflies ...
      ITS = Nmax / N
      N2 = 2 * N
      DO 10, K = 1, M-1
	 N2 = N2 / 2
	 N4 = N2 / 4
	 CALL KSORENSENCTSTAG( N, N2, N4, ITS, X(1), X(N4+1), 
     +                X(2*N4+1),
     +                X(3*N4+1), Y(1), Y(N4+1), Y(2*N4+1), Y(3*N4+1),
     +                C1, C3, S1, S3 )
	 ITS = 2 * ITS
 10   CONTINUE
c
c ... Length two butterflies ...
      IS = 1
      ID = 4
 20   DO 30, K = IS, N, ID
	 XT = X(K)
	 X(K) = XT + X(K+1)
	 X(K+1) = XT - X(K+1)
	 XT = Y(K)
	 Y(K) = XT + Y(K+1)
	 Y(K+1) = XT - Y(K+1)
 30   CONTINUE
      IS = 2 * ID - 1
      ID = 4 * ID
      IF ( IS .LT. N ) GOTO 20
c
c ... In-place bit reversal ...
      CALL KSORENSENBITREV( X, N )
      CALL KSORENSENBITREV( Y, N )
c
c ... Conjugate and scale if inverse transform ...
      IF ( JOB .EQ. -1 ) THEN
         DO 35, K = 1, N
	    Y(K) = - Y(K) / N
	    X(K) = X(K) / N
 35      CONTINUE
      ENDIF
      RETURN
c
c ... End of subroutine cfft ...
c
      END
C
C===================================================================C
C   Subroutine CTSTAG - the work-horse of CTFFTSR                   C
C       Computes a stage of a length N split-radix transform        C
C   Author:                                                         C
C       H.V. Sorensen,   University of Pennsylvania,  Jul. 1987     C
CC                                                                 CC
CC  Reference:                                                     CC
CC      Sorensen, Heideman, Burrus :"On computing the split-radix  CC
CC      FFT", IEEE Tran. ASSP, Vol. ASSP-34, No. 1, pp. 152-156    CC
CC      Feb. 1986                                                  CC
CC      Mitra&Kaiser: "Digital Signal Processing Handbook, Chap.   CC
CC      8, page 491-610, John Wiley&Sons, 1993                     CC
CC                                                                 CC
CC      This program may be used and distributed freely as long    CC
CC      as this header is included                                 CC
CC                                                                 CC
CC=================================================================CC

      SUBROUTINE ksorensenCTSTAG( N, N2, N4, ITS, X1, X2, 
     +                   X3, X4, Y1, Y2,
     +                   Y3, Y4, CT1, CT3, ST1, ST3 )
      DOUBLE PRECISION  X1(*), X2(*), X3(*), X4(*)
      DOUBLE PRECISION  Y1(*), Y2(*), Y3(*), Y4(*)
      DOUBLE PRECISION  CT1(*), CT3(*), ST1(*), ST3(*)
      INTEGER  N, N2, N4, N8, ITS, IS, ID, I1, I2, I, IT, J, JN
      DOUBLE PRECISION  T1, T2, T3, T4, T5, SQRT2
      PARAMETER  ( SQRT2 = 0.7071067811865475244D0 )

      N8 = N4 / 2
C-------Zero butterfly----------------------------------------------C
      IS = 0
      ID = 2 * N2
 10   DO 20,  I1 = IS+1, N, ID
	 T1 = X1(I1) - X3(I1)
	 X1(I1) = X1(I1) + X3(I1)
	 T2 = Y2(I1) - Y4(I1)
	 Y2(I1) = Y2(I1) + Y4(I1)
	 X3(I1) = T1 + T2
	 T2 = T1 - T2
	 T1 = X2(I1) - X4(I1)
	 X2(I1) = X2(I1) + X4(I1)
	 X4(I1) = T2
	 T2 = Y1(I1) - Y3(I1)
	 Y1(I1) = Y1(I1) + Y3(I1)
	 Y3(I1) = T2 - T1
	 Y4(I1) = T2 + T1
 20   CONTINUE
      IS = 2 * ID - N2
      ID = 4 * ID
      IF ( IS .LT. N ) GOTO 10

      IF ( N4 - 1 ) 100, 100, 30
C-------N/8 butterfly-----------------------------------------------C
 30   IS = 0
      ID = 2 * N2
 40   DO 50, I1 = IS+1+N8, N, ID
	 T1 = X1(I1) - X3(I1)
	 X1(I1) = X1(I1) + X3(I1)
	 T2 = X2(I1) - X4(I1)
	 X2(I1) = X2(I1) + X4(I1)
	 T3 = Y1(I1) - Y3(I1)
	 Y1(I1) = Y1(I1) + Y3(I1)
	 T4 = Y2(I1) - Y4(I1)
	 Y2(I1) = Y2(I1) + Y4(I1)
	 T5 = ( T4 - T1 ) * SQRT2
	 T1 = ( T4 + T1 ) * SQRT2
	 T4 = ( T3 - T2 ) * SQRT2
	 T2 = ( T3 + T2 ) * SQRT2
	 X3(I1) = T4 + T1
	 Y3(I1) = T4 - T1
	 X4(I1) = T5 + T2
	 Y4(I1) = T5 - T2
 50   CONTINUE
      IS = 2 * ID - N2
      ID = 4 * ID
      IF ( IS .LT. N-1 ) GOTO 40

      IF ( N8 - 1 ) 100, 100, 60
C-------General butterfly. Two at a time----------------------------C
 60   IS = 1
      ID = N2 * 2
 70   DO 90, I = IS, N, ID
	 IT = 0
	 JN = I + N4
	 DO 80, J = 1, N8-1
	    IT = IT + ITS
	    I1 = I + J
	    T1 = X1(I1) - X3(I1)
	    X1(I1) = X1(I1) + X3(I1)
	    T2 = X2(I1) - X4(I1)
	    X2(I1) = X2(I1) + X4(I1)
	    T3 = Y1(I1) - Y3(I1)
	    Y1(I1) = Y1(I1) + Y3(I1)
	    T4 = Y2(I1) - Y4(I1)
	    Y2(I1) = Y2(I1) + Y4(I1)
	    T5 = T1 - T4
	    T1 = T1 + T4
	    T4 = T2 - T3
	    T2 = T2 + T3
	    X3(I1) = T1 * CT1(IT) - T4 * ST1(IT)
	    Y3(I1) = - T4 * CT1(IT) - T1 * ST1(IT)
	    X4(I1) = T5 * CT3(IT) + T2 * ST3(IT)
	    Y4(I1) = T2 * CT3(IT) - T5 * ST3(IT)
	    I2 = JN - J
	    T1 = X1(I2) - X3(I2)
	    X1(I2) = X1(I2) + X3(I2)
	    T2 = X2(I2) - X4(I2)
	    X2(I2) = X2(I2) + X4(I2)
	    T3 = Y1(I2) - Y3(I2)
	    Y1(I2) = Y1(I2) + Y3(I2)
	    T4 = Y2(I2) - Y4(I2)
	    Y2(I2) = Y2(I2) + Y4(I2)
	    T5 = T1 - T4
	    T1 = T1 + T4
	    T4 = T2 - T3
	    T2 = T2 + T3
	    X3(I2) = T1 * ST1(IT) - T4 * CT1(IT)
	    Y3(I2) = - T4 * ST1(IT) - T1 * CT1(IT)
	    X4(I2) = - T5 * ST3(IT) - T2 * CT3(IT)
	    Y4(I2) = - T2 * ST3(IT) + T5 * CT3(IT)
 80      CONTINUE
 90   CONTINUE
      IS = 2 * ID - N2 +1
      ID = 4 * ID
      IF ( IS .LT. N ) GOTO 70
 100  RETURN
      END
