      SUBROUTINE MFFTIM(C,IMSX,IVSX,IESX,NMX,NVX,NEX,TABLES,IERR)
 
*   PURPOSE:
*       THIS SUBROUTINE PERFORMS AN INVERSE FOURIER TRANSFORM ALONG
*       THE SECOND DIMENSION OF A 3-DIMENSIONAL MATRIX, USING THE
*       COOLEY-TUKEY ALGORITHM.
*       THE INPUT SEQUENCE IS ASSUMED TO HAVE BEEN SUBJECTED TO A
*       "BIT REVERSAL" PERMUTATION, THROUGH A CALL TO MFFTOM, OR
*       BECAUSE IT IS THE OUTPUT OF MFFTDM.
*       THE SEQUENCE TO BE TRANSFORMED IS C[IMSX,NMX], WHOSE COMPONENTS
*       ARE THE 2-VECTORS C(M)[IVSX,NVX [IESX,NEX]].
*       SEE REF.[1] FOR NOTATIONS.
*  EXAMPLE:
*       LET C BE A 3-D MATRIX C(N1,N2,N3), DECLARED VIA
*              DIMENSION C(NN1,N2,N3)
*       WITH NN1.GE.N1
*       THEN ITS IDFT ALONG THE SECOND DIMENSION IS OBTAINED BY
*              CALL MFFTIM(C,NN1,NN1*N2,1,N2,N3,N1,TABLES,IERR)
*  IMPLEMENTATION:
*       THE TRANSFORMATION IS IMPLEMENTED THROUGH REPEATED CALLS TO THE
*       "BUTTERFLY" TRANSFORMATION MFFT?7; PARAMETERS OF THE "BUTTERFLY"
*       ARE COMMUNICATED THROUGH THE COMMON BLOCK MFFTPA.
*  ARGUMENTS:
*    INPUT  :
*       C : ARRAY TO BE TRANSFORMED.
*       IMSX,IVSX,IESX,NMX,NVX,NEX: THESE ARGUMENTS DEFINE THE STRUCTURE
*           OF C ACCORDING TO THE DEFINITIONS ABOVE. THEY ARE UNCHANGED
*           ON OUTPUT
*       TABLES : ARRAY PREPARED BY MFFTP. IT  IS NOT CHANGED ON OUTPUT.
*                IT SHOULD BE DECLARED INTEGER TABLES(4*NM+14);
*                IT MUST BE INITIALIZED BY MFFTP BEFORE USAGE.
*    OUTPUT:
*       C : TRANSFORM OF THE ORIGINAL ARRAY;
*       IERR : ERROR CODE : =0 : SUCCESSFUL
*                         : =3 :  'TABLES' NOT CORRECTLY INITIALIZED
      COMPLEX C(*)
      INTEGER TABLES(-14:*)
      INTEGER IDERR,FACERR,TBERR
      PARAMETER (IDERR=1,FACERR=2,TBERR=3)
      COMMON /MFFTPA/  IMS,IVS,IES,NM,NV,NE,MX,LX,MLIM,MSTEP,LLIM,LSTEP,
     $ NUSTEP,IVLIM,ILIM,MD2LIM,LD2LIM
*  LOADING THE COMMON BLOCK : CONSTANTS
      IMS=IMSX
      IVS=IVSX
      IES=IESX
      NM=NMX
      NV=NVX
      NE=NEX
      IVLIM=(NV-1)*IVS
      ILIM=(NE-1)*IES
      LSTEP=IMS
*  LOADING THE COMMON BLOCK : ITERATION-DEPENDENT QUANTITIES: INITIALIZA
      LX=1
      MX=NM
      IFAC=TABLES(-1)
      IF(IFAC.GT.3)THEN
        IERR=TBERR
        RETURN
      ENDIF
*..   RADIX 2 LOOP
200   CONTINUE
      DO 210 IM=1,TABLES(-14)
        MX=MX/2
        NUSTEP=LX*LSTEP
        LLIM=NUSTEP-LSTEP
        LD2LIM=NUSTEP/2-LSTEP
        MSTEP=NUSTEP*2
        MLIM=NM*LSTEP-MSTEP
        CALL MFFTA7(C,TABLES(0))
        LX=LX+LX
210   CONTINUE
      IF(IFAC.EQ.1)RETURN
*..   RADIX 3 LOOP
300   CONTINUE
      DO 310 IM=1,TABLES(-13)
        MX=MX/3
        NUSTEP=LX*LSTEP
        LLIM=NUSTEP-LSTEP
        MSTEP=NUSTEP*3
        MLIM=NM*LSTEP-MSTEP
        CALL MFFTB7(C,TABLES(0))
        LX=LX*3
310   CONTINUE
      IF(IFAC.EQ.2)RETURN
*..   RADIX 5 LOOP
500   CONTINUE
      DO 510 IM=1,TABLES(-12)
        MX=MX/5
        NUSTEP=LX*LSTEP
        LLIM=NUSTEP-LSTEP
        MSTEP=NUSTEP*5
        MLIM=NM*LSTEP-MSTEP
        CALL MFFTC7(C,TABLES(0))
        LX=LX*5
510   CONTINUE
      END
