      SUBROUTINE MFFTB9(C,FAC)
*
*   PURPOSE:
*       ELEMENTARY COOLEY-TUKEY RADIX 3 STEP APPLIED TO A VECTOR-OF
*       2-VECTORS-OF-COMPLEX C[IMS,NM [IVS,NV [IES,NE]]].
*       SEE REF.[1] FOR NOTATIONS.
*       THIS ROUTINE CAN BE USED ONLY BY ROUTINE MFFTIM, WHICH CONTROLS
*       ITS OPERATION THROUGH THE MFFTPA COMMON
*
*   DUMMY ARGUMENTS :
*
*   C   ARRAY BEING FOURIER  TRANSFORMED
*   FAC PHASE FACTORS, PREPARED BY MFFTP; NOT MODIFIED IN OUTPUT
*
      COMMON /MFFTPA/  IMS,IVS,IES,NM,NV,NE,MX,LX,MLIM,MSTEP,LLIM,LSTEP,
     $ NUSTEP,IVLIM,ILIM,MD2LIM,LD2LIM
      INTEGER NUSTEP
      COMPLEX C(0:NUSTEP-1,0:1),FAC(0:*)
      COMPLEX T0,T1,T2,F1,F2
      REAL SIN60
      PARAMETER ( SIN60 =  8.6602540378443864E-1)
 
      IF(LX.NE.1)THEN
          DO 200 MU=0,MLIM,MSTEP
            DO 150 IV=MU,MU+IVLIM,IVS
              ILAMF=0
              DO 100 ILAM=IV,IV+ILIM
                T0=C(ILAM,1)*FAC(ILAMF)+C(ILAM,2)*FAC(ILAMF+NUSTEP)
                T2=(C(ILAM,1)*FAC(ILAMF)-C(ILAM,2)*FAC(ILAMF+NUSTEP))*
     $             SIN60
                T1=C(ILAM,0)-0.5*T0
                C(ILAM,0)=C(ILAM,0)+T0
                C(ILAM,1)=(T1+CMPLX(-AIMAG(T2),REAL(T2)))
                C(ILAM,2)=(T1-CMPLX(-AIMAG(T2),REAL(T2)))
                ILAMF=ILAMF+1
100           CONTINUE
150         CONTINUE
200       CONTINUE
      ELSE
          DO 400 MU=0,MLIM,MSTEP
            DO 350 IV=MU,MU+IVLIM,IVS
              DO 300 ILAM=IV,IV+ILIM
                T0=C(ILAM,1)+C(ILAM,2)
                T2=(C(ILAM,1)-C(ILAM,2))*SIN60
                T1=C(ILAM,0)-0.5*T0
                C(ILAM,0)=C(ILAM,0)+T0
                C(ILAM,1)=(T1+CMPLX(-AIMAG(T2),REAL(T2)))
                C(ILAM,2)=(T1-CMPLX(-AIMAG(T2),REAL(T2)))
300           CONTINUE
350         CONTINUE
400       CONTINUE
      ENDIF
      END
