C***********************************************************************
C
C                           MFFT
C
C                  Version  1.4 - May 1987
C
C***********************************************************************
C
C**AUTHORS:
C                         A. NOBILE
C
C  INTERNATIONAL SCHOOL FOR ADVANCED STUDIES - TRIESTE, ITALY
C
C                             AND
C
C                         V. ROBERTO
C
C  DEPARTMENT OF MATHEMATICS AND COMPUTER SCIENCE - UDINE, ITALY
C
C
C**PURPOSE:
C
C  MFFT IS A PACKAGE OF FORTRAN 77 SUBPROGRAMS TO PERFORM TWO-
C  THREE-, AND FOUR-DIMENSIONAL DISCRETE FOURIER TRANSFORMS (DFT)
C  THE DFT'S ARE CALCULATED IMPLEMENTING FAST FOURIER TRANSFORM (FFT)
C  ALGORITHMS IN VECTOR FORM.  THE PACKAGE IS SPECIALLY DESIGNED
C  FOR HIGH PERFORMANCES ON CRAY X-MP MACHINES.
C
C
C**USER INTERFACES:
C
C  THE PRESENT VERSION CONTAINS THE FOLLOWING USER ACCESSABLE ROUTINES:
C
C  1.  C2FFT  : 2-DIMENSIONAL TRANSFORM OF NX*NY COMPLEX DATA MATRICES
C  2.  C3FFT  : 3-DIMENSIONAL TRANSFORM OF NX*NY*NZ COMPL. DATA MATRICES
C  3.  C4FFT  : 4-DIMENSIONAL TRANSFORM OF NX*NY*NZ*NT COMPL. DATA
C  4.  R2FFT  : 2-DIMENSIONAL TRANSFORM OF NX*NY REAL DATA MATRICES
C  5.  R3FFT  : 3-DIMENSIONAL TRANSFORM OF NX*NY*NZ REAL DATA MATRICES
C  6.  R4FFT  : 4-DIMENSIONAL TRANSFORM OF NX*NY*NZ*NP REAL DATA MATRICES
C
C**DATA SIZE:
C
C  EACH DIMENSION IN THE INPUT MATRICES HAS TO BE A PRODUCT OF INTEGER
C  POWERS OF 2,3,5 (SEE THE LONG WRITE-UP, REF.[2]).
C  IN REAL TRANSFORMS, THE FIRST DIMENSION OF DATA ARRAYS HAS TO BE AN
C  EVEN NUMBER GREATER OR EQUAL TO N1+2 (WHERE N1 IS THE ACTUAL SIZE OF
C  DATA, FIRST DIMENSION).
C
C
C
C**FURTHER DETAILS:
C
C  THE THEORETICAL GROUNDS ON WHICH MFFT IS BASED, AS WELL AS THE
C  DETAILS OF ITS IMPLEMENTATION ON A CRAY X-MP CAN BE FOUND IN REF.[1]
C  THE LONG WRITE-UP IS REPORTED IN REF.[2].
C  BOTH REFERENCES CONTAIN PERFORMANCE EVALUATIONS (CPU-TIME, OPERATION
C  COUNTS, MEGAFLOP RATES).
C
C
C**REFERENCES:
C
C  [1] A.NOBILE AND V.ROBERTO:'EFFICIENT IMPLEMENTATION OF MULTIDIMEN-
C      SIONAL FAST FOURIER TRANSFORMS ON A CRAY X-MP'-
C      COMPUTER PHYSICS COMMUNICATIONS 40 (1986) 189.
C  [2] A.NOBILE AND V.ROBERTO: 'MFFT : A PACKAGE FOR TWO- AND
C      THREE-DIMENSIONAL VECTORIZED DISCRETE FOURIER TRANSFORMS'
C      COMPUTER PHYSICS COMMUNICATIONS 42 (1986) 233.
C
C
C
C
C**REQUESTS:
C
C  FOR ANY PROBLEM CONCERNING MFFT, PLEASE CONTACT:
C
C  DR. V.ROBERTO, DEPT. OF THEORETICAL PHYSICS
C                 STRADA COSTIERA, 11
C                 I - 34014  TRIESTE   (ITALY)
C
C  TELEX NO.: 460932 ICTP I
C
C  MESSAGES THROUGH EARNET TO: VITO AT ITSSISSA
C
C
C***********************************************************************
C
C

