/* setgpfa.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

typedef int integer;
#include <fftw.h>
typedef FFTW_REAL real;
typedef double doublereal;


/* Table of constant values */

static integer c__1 = 1;
static integer c__2 = 2;
static integer c__3 = 3;
static integer c__5 = 5;

/*        SUBROUTINE 'SETGPFA' */
/*        SETUP ROUTINE FOR SELF-SORTING IN-PLACE */
/*            GENERALIZED PRIME FACTOR (COMPLEX) FFT [GPFA] */

/*        CALL SETGPFA(TRIGS,N) */

/*        INPUT : */
/*        ----- */
/*        N IS THE LENGTH OF THE TRANSFORMS. N MUST BE OF THE FORM: */
/*          ----------------------------------- */
/*            N = (2**IP) * (3**IQ) * (5**IR) */
/*          ----------------------------------- */

/*        OUTPUT: */
/*        ------ */
/*        TRIGS IS A TABLE OF TWIDDLE FACTORS, */
/*          OF LENGTH 2*IPQR (REAL) WORDS, WHERE: */
/*          -------------------------------------- */
/*            IPQR = (2**IP) + (3**IQ) + (5**IR) */
/*          -------------------------------------- */

/*        WRITTEN BY CLIVE TEMPERTON 1990 */

/* ---------------------------------------------------------------------- */

/* Subroutine */ int setgpfa(real *trigs, integer n)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer pow_ii(integer *, integer *);
    double asin(doublereal), cos(doublereal), sin(doublereal);

    /* Local variables */
    static integer ifac, kink, irot, i, k;
    static real angle, twopi;
    static integer kk, ni, nj[3], ll, ip, iq, nn, ir;
    static real del;




/*     DECOMPOSE N INTO FACTORS 2,3,5 */
/*     ------------------------------ */
    /* Parameter adjustments */
    --trigs;

    /* Function Body */
    nn = n;
    ifac = 2;

    for (ll = 1; ll <= 3; ++ll) {
	kk = 0;
L10:
	if (nn % ifac != 0) {
	    goto L20;
	}
	++kk;
	nn /= ifac;
	goto L10;
L20:
	nj[ll - 1] = kk;
	ifac += ll;
/* L30: */
    }

    if (nn != 1) {
	return 1;
    }

    ip = nj[0];
    iq = nj[1];
    ir = nj[2];

/*     COMPUTE LIST OF ROTATED TWIDDLE FACTORS */
/*     --------------------------------------- */
    nj[0] = pow_ii(&c__2, &ip);
    nj[1] = pow_ii(&c__3, &iq);
    nj[2] = pow_ii(&c__5, &ir);

    twopi = asin(1.) * 4.;
    i = 1;

    for (ll = 1; ll <= 3; ++ll) {
	ni = nj[ll - 1];
	if (ni == 1) {
	    goto L60;
	}

	del = twopi / (real) ni;
	irot = n / ni;
	kink = irot % ni;
	kk = 0;

	i__1 = ni;
	for (k = 1; k <= i__1; ++k) {
	    angle = (real) kk * del;
	    trigs[i] = cos(angle);
	    trigs[i + 1] = sin(angle);
	    i += 2;
	    kk += kink;
	    if (kk > ni) {
		kk -= ni;
	    }
/* L50: */
	}
L60:
	;
    }

    return 0;
} /* setgpfa_ */

