#ifndef __FXTAUX_H
#define __FXTAUX_H

#ifndef __FXT_H
#include <fftw.h>
#endif

/*  auxiliary functions & */
/*  inline stuff and #defines for transforms ... */
/*  changed to #defines because inline funcs slowed it down */

#include <math.h>  /*  for ldexp() */

#include "sincos.h"  /*  for sincos() */


/*  fhtcnvl.cc: */
void fht_convolution_core(FFTW_REAL *x, FFTW_REAL *y, int ldn);

/*  fhtcnvla.cc: */
void fht_auto_convolution_core(FFTW_REAL *x, int ldn);

/*  fftsd4.cc: */
void dif4_fft_core(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftcl4.cc: */
void dit4_fft_core(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftwide.cc: */
void wide_fft(FFTW_REAL *fr, FFTW_REAL *fi, int n, int d, FFTW_REAL *wr, FFTW_REAL *wi, int is);
void wide_fft0(FFTW_REAL *fr, FFTW_REAL *fi, int n, int d, FFTW_REAL *wr, FFTW_REAL *wi, int is);

/*  graycode.cc: */
int graycode(int x);
int inverse_graycode(int x);
void gray_scramble(FFTW_REAL *f, int n);
void gray_scramble_up(FFTW_REAL *f, int n);
void gray_scramble0(FFTW_REAL *f, int n);


/*  walshwide.cc: */
void wide_walsh(FFTW_REAL *f, int n, int d, FFTW_REAL *w);
void wide_walsh0(FFTW_REAL *f, int n, int d, FFTW_REAL *w);


/*  sincostb.cc: */
void make_sincos_table(int n, int m, FFTW_REAL **s, FFTW_REAL **c);

/*  scramble.cc: */
void scramble(FFTW_REAL *f, int n);
void scramble_2(FFTW_REAL *fr, FFTW_REAL *fi, int n);
void scramble0(FFTW_REAL *f, int n);
void scramble0_2(FFTW_REAL *fr, FFTW_REAL *fi, int n);

#if 0
/* fft9.cc: */
void fft9(FFTW_REAL *fr, FFTW_REAL *fi);

/* fft9.cc: */
void fft9(FFTW_REAL *fr, FFTW_REAL *fi, int is);

#endif

/* fft8.cc: */
void fft8(FFTW_REAL *fr, FFTW_REAL *fi, int is);

/* fft8cl.cc: */
void fft8cc(FFTW_REAL *fr, FFTW_REAL *fi, int is);

/* fft8sd.cc: */
void fft8ss(FFTW_REAL *fr, FFTW_REAL *fi, int is);

/* -------------------------------------------- */

#define USE_SINCOS3
/*  whether split radix ffts use sincos for triple angle */
/*  else: use algebraic relation */

#define SQRT12   0.70710678118654752440084436210484
#define SQRT2    1.414213562373095048801688724209698078569


#define MAX(x,y)     ((x)>(y)?(x):(y))
#define SWAP(x,y)    {FFTW_REAL tmp=x; x=y; y=tmp;}
/* #define SWAP(x,y)    {typeof(x) tmp=x; x=y; y=tmp;}  // GNU C allows this */
/*  swap for other types: */
#define TSWAP(tp,x,y) {tp tmp=x; x=y; y=tmp;}



/*  floor(log2()): */
#define ld(x,res) \
{ \
    int kk=0, xx = x; \
    while( xx >>= 1 )  ++kk; \
    res = kk; \
}

/*  copy array: */
#define d_copy(s, d, n) \
{ \
	int mmm = n; \
    while(mmm--)  (d)[mmm]=(s)[mmm]; \
}

/*  set array to zero: */
#define d_null(d, m) \
{ \
	int nnn = m; \
    while(nnn--)	(d)[nnn]=0.0; \
}

/*  fill array with one value: */
#define d_fill(dst, m, d2) \
{ \
	int nnn = m; \
	FFTW_REAL ddd = d2; \
    while ( nnn-- )  (dst)[nnn]=ddd; \
}

/*  multiply array by s: */
#define d_multiply(f, m, s2) \
{ \
	int nnn = m; \
	FFTW_REAL sss = s2; \
    while(nnn--)   (f)[nnn]*=sss; \
}

/*  multiply array by 2^-ex: */
#define d_multiply2(f, m, ex2) \
{ \
	int nnn = m, exxxx = -ex2; \
     while(nnn--)  (f)[nnn]=ldexp((f)[nnn],exxxx); \
}


/* inline void sumdiff2(FFTW_REAL &s, FFTW_REAL &d) */
/*  */
/*  s=(s+d) */
/*  d=(s-d) */
/*  */
#define sumdiff2(s,d) { FFTW_REAL t; t=s-d; s+=d; d=t; }


#define d_sumdiff(we, wo, m) \
{ \
	int nnn = m; \
    while(nnn--)  sumdiff2(we[nnn],wo[nnn]); \
}


/* inline void sumdiff2_05(FFTW_REAL &s, FFTW_REAL &d) */
/*  */
/*  s=0.5*(s+d) */
/*  d=0.5*(s-d) */
/*  */
#define sumdiff2_05(s,d) { FFTW_REAL t; t=(s-d)*0.5; s+=d; s*=0.5; d=t; }


/* inline void sumdiff2_x(FFTW_REAL &s, FFTW_REAL &d, FFTW_REAL &x) */
/*  */
/*  s=x*(s+d) */
/*  d=x*(s-d) */
/*  */
#define sumdiff2_x(s,d,x) { FFTW_REAL t; t=(s-d)*x; s+=d; s*=x; d=t; }


/* inline void sumdiff4(FFTW_REAL a, FFTW_REAL b, FFTW_REAL &s, FFTW_REAL &d) */
/*  */
/*  NEVER call like func(a,b,a,b) (i.e. input=output) */
/*  */
#define sumdiff4(a,b,s,d) { s=a+b; d=a-b; }


/* inline void sumdiff4_05(FFTW_REAL a, FFTW_REAL b, FFTW_REAL &s, FFTW_REAL &d) */
/*  */
/*  NEVER call like func(a,b,a,b) (i.e. input=output) */
/*  */
#define sumdiff4_05(a,b,s,d) { s=(a+b)*0.5; d=(a-b)*0.5; }


/* inline void sumdiff4_x(FFTW_REAL a, FFTW_REAL b, FFTW_REAL &s, FFTW_REAL &d, FFTW_REAL &x) */
/*  */
/*  NEVER call like func(a,b,a,b,x) (i.e. input=output) */
/*  */
#define sumdiff4_x(a,b,s,d,x) { s=(a+b)*x; d=(a-b)*x; }


/* inline void csqr2(FFTW_REAL &u, FFTW_REAL &v) */
/*  */
/*  u=u*u-v*v */
/*  v=2*u*v */
/*  */
#define csqr2(u,v) { FFTW_REAL t; t=u*u-v*v; v*=(u+u); u=t; }


/* inline void csqr4(FFTW_REAL a, FFTW_REAL b, FFTW_REAL &u, FFTW_REAL &v) */
/*  */
/*  NEVER call like func(a,b,a,b) (i.e. input=output) */
/*  */
#define csqr4(a,b,u,v) { u=a*a-b*b; v=a*b; v+=v; }


/* inline void cmult4(FFTW_REAL c, FFTW_REAL s, FFTW_REAL &u, FFTW_REAL &v) */
/*  */
/*  u=u*c-v*s */
/*  v=u*s+v*c */
/*  */
#define cmult4(c,s,u,v) { FFTW_REAL t; t=u*s+v*c; u*=c; u-=v*s; v=t; }


/* inline void cmult6(FFTW_REAL c, FFTW_REAL s, FFTW_REAL c1, FFTW_REAL s1, FFTW_REAL &u, FFTW_REAL &v) */
#define cmult6(c,s,c1,s1,u,v) { u=c1*c-s1*s; v=c1*s+s1*c; }


#endif  /*  !defined __FXTAUX_H */
