
#include <math.h>
#include "fxtaux.h"

/*
 A Duhamel-Hollman split-radix dif fft
 Ref: Electronics Letters, Jan. 5, 1984
 Complex input and output data in arrays x and y
 Length is n.

 by: Dave Edelblute, edelblut@cod.nosc.mil, 05 Jan 1993
 Modified: R. Mayer
 Modified: Joerg Arndt 
*/


#define USE_SINCOS3 
/*  whether sincos is used for 3*angle */
/*  else: use algebraic relation */

/* Steven G. Johnson 7/11/97: turn USE_SINCOS3 off.  This speeds up
   things on the RS/6000.  Also, with SINCOS3 on, the performance is
   essentially the same as that of Edelblute. */
#undef USE_SINCOS3

void 
duhamel_fft(FFTW_REAL *x, FFTW_REAL *y, int ldn, int is)
{
    int n,n2;
    x--;  /*  fortran convention := on  */
    y--;

    n = (1<<ldn);

    if(n==1)  return;

    n2 = n+n;

    {
    int k; for (k=1; k<=ldn; k++)
    {
        FFTW_REAL e,a;
        int n4;
        n2 >>= 1;
        n4 = n2>>2;

        e = 2.0*3.14159265358979323846264338327/n2;
        a = 0.0;
	
	{
        int j; for (j=1; j<=n4; j++)
        {
	    double cc1,ss1,cc3,ss3;
	    int ix;

            SINCOS(cc1,ss1,a);

#if defined USE_SINCOS3 
            SINCOS(cc3,ss3,3.0*a);
#else
            cc3=4.0*cc1*(cc1*cc1-0.75); 
            ss3=4.0*ss1*(0.75-ss1*ss1);
#endif

            a = j*e;
            ix = j;

	    {
            int id=(n2<<1);

            while( ix<n )
            {
                int i0; for (i0=ix; i0<n; i0=i0+id)
                {
		    FFTW_REAL r1,r2,s1,s2,s3;
	                  int i1, i2, i3;

                    i1=i0+n4;
                    i2=i1+n4;
                    i3=i2+n4;


                    r1 = x[i0]-x[i2];
                    x[i0] += x[i2];

                    r2 = x[i1]-x[i3];
                    x[i1] += x[i3];

                    s1 = y[i0]-y[i2];
                    y[i0] += y[i2];

                    s2 = y[i1]-y[i3];
                    y[i1] += y[i3];

                    s3 = r1-s2;
                    r1 += s2;

                    s2 = r2-s1;
                    r2 += s1;

                    x[i2] =  r1*cc1-s2*ss1;
                    y[i2] = -s2*cc1-r1*ss1;

                    x[i3] =  s3*cc3+r2*ss3;
                    y[i3] =  r2*cc3-s3*ss3;
               }
               
               ix = (id<<1)-n2+j;
               id <<= 2;
            }
	    }
        }
	}
    }
    }


    /* ------------------ last stage, length=2 butterfly ----------- */
    {
     int ix,id;
     ix = 1;
     id = 4;

    while( ix<n )
    {
        int i0; for (i0=ix; i0<=n; i0+=id)
        {
            int i1=i0+1;

	    sumdiff2(x[i0],x[i1]);
	    sumdiff2(y[i0],y[i1]);
        }

        ix = (id<<1)-1;
        id <<= 2;
    }
    }


    x++;  /*  fortran convention := off */
    y++;

    scramble_2(x,y,n);

    if( is>0 )   /*  backtransform */
    {
        int k; for (k=1; k<n/2; ++k)  SWAP(x[k],x[n-k]);

        for (k=1; k<n/2; ++k)  SWAP(y[k],y[n-k]);
    }
}
/* ========================== end DUHAMEL_FFT =============================== */

