/*=====================================================================
Filename:	ComplexMath.c
Language:	Think C

Source code for complex math functions

Modifications:
	02/23/90	Gerry Beauregard	Created this file
	02/27/91	Gerry Beauregard	Switch to floats from doubles
==========================================================================*/

/*=======================================================================
Includes
=========================================================================*/
 
#include 	<math.h>
#include	"ComplexMath.h"

/*-- CAdd--------------------------------------------------------------
Complex addition
----------------------------------------------------------------------*/		
Complex CAdd(Complex a, Complex b)
{
	Complex	Sum;
	
	Sum.Re = a.Re + b.Re;
	Sum.Im = a.Im + b.Im;
	return Sum;
}

/*--CSub--------------------------------------------------------------
Complex subtraction
----------------------------------------------------------------------*/		
Complex CSub(Complex a, Complex b)
{
	Complex	Difference;
	
	Difference.Re = a.Re - b.Re;
	Difference.Im = a.Im - b.Im;
	return Difference;
}

/*--CMult--------------------------------------------------------------
Complex multiplication
----------------------------------------------------------------------*/		
Complex CMult(Complex a, Complex b)
{
	Complex	Product;
	
	Product.Re = a.Re*b.Re - a.Im*b.Im;
	Product.Im = a.Re*b.Im + a.Im*b.Re;
	return Product;
}
	
/*--CDiv--------------------------------------------------------------
Complex division
----------------------------------------------------------------------*/		
Complex CDiv(Complex a, Complex b)
{
	Polar	PolarQuotient;
	Complex	Quotient;
	
	PolarQuotient.Mag = ComplexMag(a)/ComplexMag(b);
	PolarQuotient.Phase = ComplexPhase(a) - ComplexPhase(b);
	Quotient = PolarToComplex(PolarQuotient);
	return Quotient;
}		

/*--Conj--------------------------------------------------------------
Complex conjugate
----------------------------------------------------------------------*/		
Complex Conj(Complex a)
{
	Complex	Conjugate;
	
	Conjugate = a;
	Conjugate.Im *= -1.0;
	
	return Conjugate;
}		

/*--ComplexToPolar----------------------------------------------------
Conversion from rectangular to polar form
----------------------------------------------------------------------*/		
Polar ComplexToPolar(Complex	x)
{
	Polar	Result;
	
	Result.Mag   = ComplexMag(x);
	Result.Phase = ComplexPhase(x);
	return Result;
}

/*--PolarToComplex----------------------------------------------------
Conversion from polar to rectangular form
----------------------------------------------------------------------*/		
Complex PolarToComplex(Polar x)
{
	Complex	Result;
	
	Result.Re = x.Mag * cos(x.Phase);
	Result.Im = x.Mag * sin(x.Phase);
	return Result;
}

/*--ComplexMag----------------------------------------------------
Compute magnitude of complex number
----------------------------------------------------------------------*/		
FFTW_REAL ComplexMag(Complex x)
{
	FFTW_REAL	Magnitude;

	Magnitude = sqrt(x.Re*x.Re + x.Im*x.Im);
	return Magnitude;
}

/*--ComplexPhase----------------------------------------------------
Compute the phase of a complex number
----------------------------------------------------------------------*/		
FFTW_REAL ComplexPhase(Complex x)
{
	FFTW_REAL	Phase;

	Phase = atan2(x.Im, x.Re);
	return Phase;
}

/*--RadToDeg----------------------------------------------------
Convert radians to degrees
----------------------------------------------------------------------*/		
FFTW_REAL RadToDeg(FFTW_REAL RadianPhase)
{
	FFTW_REAL	DegreePhase;

	DegreePhase = 360.0 * RadianPhase / (2.0 * MY_PI);
	return DegreePhase;
}

/*--DegToRad----------------------------------------------------
Convert degrees to radians
----------------------------------------------------------------------*/		
FFTW_REAL DegToRad(FFTW_REAL DegreePhase)
{
	FFTW_REAL	RadianPhase;

	RadianPhase = 2.0 * MY_PI * DegreePhase / 360.0;
	return RadianPhase;
}


	
