#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

#ifndef _FCOMPLEX_DECLARE_T_
typedef struct FCOMPLEX {
    float r, i;
} fcomplex;

#define _FCOMPLEX_DECLARE_T_
#endif				/* _FCOMPLEX_DECLARE_T_ */

#ifndef _FRAWTYPE_DECLARE_T_
typedef fcomplex rawtype;
#define _FRAWTYPE_DECLARE_T_
#endif				/* _FRAWTYPE_DECLARE_T_ */


// Routines used to calculate memory characteristics

long rnd2down(long x)
{
    long r = 1;

    if (!x)
	return 0;
    while (x >>= 1)
	r <<= 1;
    return r;
}

long sqrt4down(long x)
{
    long r = 1;

    if (!x)
	return 0;
    while (x >>= 2)
	r <<= 1;
    return r;
}


void main(int argc, char *argv[])
   {
   long CODESIZE;
   long Ramsize;
   long CacheL1size;
   long CacheL2size;
   long Cacheburst;
   long Cachetreshold;
   long Cacheburstblocksize;
   long Cacheblocksize;
   long Maxblocksize;
   long Memorytreshold;
   long Blocksize;
   FILE *memfile;

   printf("This program will generate the meminfo.h for the Fastfft Library.\n\n");

   memfile = fopen("meminfo.h","w+");

   fprintf(memfile,"/* The following definitions can be changed to tweak your    */\n");
   fprintf(memfile,"/* code.  But they probably won't help a whole lot.  You     */\n");
   fprintf(memfile,"/* can calculate their values by running meminit.            */\n\n");


   // Approximate code size of program in Mb:
   CODESIZE = 2;
   fprintf(memfile, "#define CODESIZE              %ld\n", CODESIZE);

   // RAM size
   // Set this to the amount of RAM you want the program to use:
   // Ramsize = 8 * (1 << 20) (where 8 is in Mb);
   printf("Enter the total computer memory you would like to allocate\n");
   printf("  to this program in Mb:\n");
   scanf("%ld", &Ramsize);
   Ramsize *= (1 << 20);
   fprintf(memfile, "#define Ramsize               %ld\n", Ramsize);

   // L1 cache size
   // 486's and Pentiums have 8KB (data) L1 cache
   CacheL1size = 8 * (1 << 10);
   fprintf(memfile, "#define CacheL1size           %ld\n", CacheL1size);

   // L2 cache size
   // set to amount of L2 cache
   printf("Enter the size of your computer's L2 cache in kb:\n");
   scanf("%ld", &CacheL2size);
   CacheL2size *= (1 << 10);
   fprintf(memfile, "#define CacheL2size           %ld\n", CacheL2size);

   // cache burst width
   // 16 bytes for 486, 32 for Pentium
   // Cacheburst = 16;
   Cacheburst = 32;
   fprintf(memfile, "#define Cacheburst            %ld\n", Cacheburst);

   // Longer numbers than this will be stored by default to disk
   Memorytreshold = 16384;
   fprintf(memfile, "#define Memorytreshold        %ld\n", Memorytreshold);

   // Efficient read/write block size
   Blocksize = 16384;

   // Set to the maximum 2^n size block of modints that fits in the memory
   Maxblocksize = rnd2down(Ramsize / sizeof(rawtype));
   fprintf(memfile, "#define Maxblocksize          %ld\n", Maxblocksize);

   // Size of matrix that fits in L2 cache
   Cachetreshold = rnd2down(CacheL2size / sizeof(rawtype));
   fprintf(memfile, "#define Cachetreshold         %ld\n", Cachetreshold);

   // Cache burst in rawtype
   Cacheburstblocksize = rnd2down(Cacheburst / sizeof(rawtype));
   fprintf(memfile, "#define Cacheburstblocksize   %ld\n", Cacheburstblocksize);

   // Transpose block size, fits in processor L1 cache
   Cacheblocksize = sqrt4down(CacheL1size / sizeof(rawtype));
   fprintf(memfile, "#define Cacheblocksize        %ld\n", Cacheblocksize);

   if (Blocksize > Memorytreshold)
   Blocksize = Memorytreshold;
   fprintf(memfile, "#define Blocksize             %ld\n", Blocksize);

   fclose(memfile);

   printf("\nResults are: \n\n");
   printf("Ramsize               = %ld\n",Ramsize);
   printf("CacheL1size           = %ld\n",CacheL1size);
   printf("CacheL2size           = %ld\n",CacheL2size);
   printf("Cacheburst            = %ld\n",Cacheburst);
   printf("Cachetreshold         = %ld\n",Cachetreshold);
   printf("Cacheburstblocksize   = %ld\n",Cacheburstblocksize);
   printf("Cacheblocksize        = %ld\n",Cacheblocksize);
   printf("Maxblocksize          = %ld\n",Maxblocksize);
   printf("Memorytreshold        = %ld\n",Memorytreshold);
   printf("Blocksize             = %ld\n",Blocksize);
   printf("\n\n");

   exit(0);
}
