// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest is a API request type for the AddPermission API operation.
type AddPermissionRequest struct {
	*aws.Request
	Input *AddPermissionInput
	Copy  func(*AddPermissionInput) AddPermissionRequest
}

// Send marshals and sends the AddPermission API request.
func (r AddPermissionRequest) Send() (*AddPermissionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*AddPermissionOutput), nil
}

// AddPermissionRequest returns a request value for making API operation for
// AWS Lambda.
//
// Adds a permission to the resource policy associated with the specified AWS
// Lambda function. You use resource policies to grant permissions to event
// sources that use push model. In a push model, event sources (such as Amazon
// S3 and custom applications) invoke your Lambda function. Each permission
// you add to the resource policy allows an event source, permission to invoke
// the Lambda function.
//
// For information about the push model, see Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
//
// If you are using versioning, the permissions you add are specific to the
// Lambda function version or alias you specify in the AddPermission request
// via the Qualifier parameter. For more information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:AddPermission action.
//
//    // Example sending a request using the AddPermissionRequest method.
//    req := client.AddPermissionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission
func (c *Lambda) AddPermissionRequest(input *AddPermissionInput) AddPermissionRequest {
	op := &aws.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	output := &AddPermissionOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return AddPermissionRequest{Request: req, Input: input, Copy: c.AddPermissionRequest}
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest is a API request type for the CreateAlias API operation.
type CreateAliasRequest struct {
	*aws.Request
	Input *CreateAliasInput
	Copy  func(*CreateAliasInput) CreateAliasRequest
}

// Send marshals and sends the CreateAlias API request.
func (r CreateAliasRequest) Send() (*UpdateAliasOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateAliasOutput), nil
}

// CreateAliasRequest returns a request value for making API operation for
// AWS Lambda.
//
// Creates an alias that points to the specified Lambda function version. For
// more information, see Introduction to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// Alias names are unique for a given function. This requires permission for
// the lambda:CreateAlias action.
//
//    // Example sending a request using the CreateAliasRequest method.
//    req := client.CreateAliasRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias
func (c *Lambda) CreateAliasRequest(input *CreateAliasInput) CreateAliasRequest {
	op := &aws.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output := &UpdateAliasOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateAliasRequest{Request: req, Input: input, Copy: c.CreateAliasRequest}
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest is a API request type for the CreateEventSourceMapping API operation.
type CreateEventSourceMappingRequest struct {
	*aws.Request
	Input *CreateEventSourceMappingInput
	Copy  func(*CreateEventSourceMappingInput) CreateEventSourceMappingRequest
}

// Send marshals and sends the CreateEventSourceMapping API request.
func (r CreateEventSourceMappingRequest) Send() (*UpdateEventSourceMappingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateEventSourceMappingOutput), nil
}

// CreateEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// Identifies a poll-based event source for a Lambda function. It can be either
// an Amazon Kinesis or DynamoDB stream, or an Amazon SQS queue. AWS Lambda
// invokes the specified function when records are posted to the event source.
//
// This association between a poll-based source and a Lambda function is called
// the event source mapping.
//
// You provide mapping information (for example, which stream or SQS queue to
// read from and which Lambda function to invoke) in the request body.
//
// Amazon Kinesis or DynamoDB stream event sources can be associated with multiple
// AWS Lambda functions and a given Lambda function can be associated with multiple
// AWS event sources. For Amazon SQS, you can configure multiple queues as event
// sources for a single Lambda function, but an SQS queue can be mapped only
// to a single Lambda function.
//
// If you are using versioning, you can specify a specific function version
// or an alias via the function name parameter. For more information about versioning,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:CreateEventSourceMapping
// action.
//
//    // Example sending a request using the CreateEventSourceMappingRequest method.
//    req := client.CreateEventSourceMappingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping
func (c *Lambda) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) CreateEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	output := &UpdateEventSourceMappingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateEventSourceMappingRequest{Request: req, Input: input, Copy: c.CreateEventSourceMappingRequest}
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest is a API request type for the CreateFunction API operation.
type CreateFunctionRequest struct {
	*aws.Request
	Input *CreateFunctionInput
	Copy  func(*CreateFunctionInput) CreateFunctionRequest
}

// Send marshals and sends the CreateFunction API request.
func (r CreateFunctionRequest) Send() (*UpdateFunctionConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateFunctionConfigurationOutput), nil
}

// CreateFunctionRequest returns a request value for making API operation for
// AWS Lambda.
//
// Creates a new Lambda function. The function metadata is created from the
// request parameters, and the code for the function is provided by a .zip file
// in the request body. If the function name already exists, the operation will
// fail. Note that the function name is case-sensitive.
//
// If you are using versioning, you can also publish a version of the Lambda
// function you are creating using the Publish parameter. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:CreateFunction action.
//
//    // Example sending a request using the CreateFunctionRequest method.
//    req := client.CreateFunctionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction
func (c *Lambda) CreateFunctionRequest(input *CreateFunctionInput) CreateFunctionRequest {
	op := &aws.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	output := &UpdateFunctionConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateFunctionRequest{Request: req, Input: input, Copy: c.CreateFunctionRequest}
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest is a API request type for the DeleteAlias API operation.
type DeleteAliasRequest struct {
	*aws.Request
	Input *DeleteAliasInput
	Copy  func(*DeleteAliasInput) DeleteAliasRequest
}

// Send marshals and sends the DeleteAlias API request.
func (r DeleteAliasRequest) Send() (*DeleteAliasOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteAliasOutput), nil
}

// DeleteAliasRequest returns a request value for making API operation for
// AWS Lambda.
//
// Deletes the specified Lambda function alias. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:DeleteAlias action.
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req := client.DeleteAliasRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias
func (c *Lambda) DeleteAliasRequest(input *DeleteAliasInput) DeleteAliasRequest {
	op := &aws.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output := &DeleteAliasOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteAliasRequest{Request: req, Input: input, Copy: c.DeleteAliasRequest}
}

const opDeleteEventSourceMapping = "DeleteEventSourceMapping"

// DeleteEventSourceMappingRequest is a API request type for the DeleteEventSourceMapping API operation.
type DeleteEventSourceMappingRequest struct {
	*aws.Request
	Input *DeleteEventSourceMappingInput
	Copy  func(*DeleteEventSourceMappingInput) DeleteEventSourceMappingRequest
}

// Send marshals and sends the DeleteEventSourceMapping API request.
func (r DeleteEventSourceMappingRequest) Send() (*UpdateEventSourceMappingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateEventSourceMappingOutput), nil
}

// DeleteEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// Removes an event source mapping. This means AWS Lambda will no longer invoke
// the function for events in the associated source.
//
// This operation requires permission for the lambda:DeleteEventSourceMapping
// action.
//
//    // Example sending a request using the DeleteEventSourceMappingRequest method.
//    req := client.DeleteEventSourceMappingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping
func (c *Lambda) DeleteEventSourceMappingRequest(input *DeleteEventSourceMappingInput) DeleteEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opDeleteEventSourceMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &DeleteEventSourceMappingInput{}
	}

	output := &UpdateEventSourceMappingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteEventSourceMappingRequest{Request: req, Input: input, Copy: c.DeleteEventSourceMappingRequest}
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest is a API request type for the DeleteFunction API operation.
type DeleteFunctionRequest struct {
	*aws.Request
	Input *DeleteFunctionInput
	Copy  func(*DeleteFunctionInput) DeleteFunctionRequest
}

// Send marshals and sends the DeleteFunction API request.
func (r DeleteFunctionRequest) Send() (*DeleteFunctionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteFunctionOutput), nil
}

// DeleteFunctionRequest returns a request value for making API operation for
// AWS Lambda.
//
// Deletes the specified Lambda function code and configuration.
//
// If you are using the versioning feature and you don't specify a function
// version in your DeleteFunction request, AWS Lambda will delete the function,
// including all its versions, and any aliases pointing to the function versions.
// To delete a specific function version, you must provide the function version
// via the Qualifier parameter. For information about function versioning, see
// AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// When you delete a function the associated resource policy is also deleted.
// You will need to delete the event source mappings explicitly.
//
// This operation requires permission for the lambda:DeleteFunction action.
//
//    // Example sending a request using the DeleteFunctionRequest method.
//    req := client.DeleteFunctionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction
func (c *Lambda) DeleteFunctionRequest(input *DeleteFunctionInput) DeleteFunctionRequest {
	op := &aws.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	output := &DeleteFunctionOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteFunctionRequest{Request: req, Input: input, Copy: c.DeleteFunctionRequest}
}

const opDeleteFunctionConcurrency = "DeleteFunctionConcurrency"

// DeleteFunctionConcurrencyRequest is a API request type for the DeleteFunctionConcurrency API operation.
type DeleteFunctionConcurrencyRequest struct {
	*aws.Request
	Input *DeleteFunctionConcurrencyInput
	Copy  func(*DeleteFunctionConcurrencyInput) DeleteFunctionConcurrencyRequest
}

// Send marshals and sends the DeleteFunctionConcurrency API request.
func (r DeleteFunctionConcurrencyRequest) Send() (*DeleteFunctionConcurrencyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteFunctionConcurrencyOutput), nil
}

// DeleteFunctionConcurrencyRequest returns a request value for making API operation for
// AWS Lambda.
//
// Removes concurrent execution limits from this function. For more information,
// see concurrent-executions.
//
//    // Example sending a request using the DeleteFunctionConcurrencyRequest method.
//    req := client.DeleteFunctionConcurrencyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency
func (c *Lambda) DeleteFunctionConcurrencyRequest(input *DeleteFunctionConcurrencyInput) DeleteFunctionConcurrencyRequest {
	op := &aws.Operation{
		Name:       opDeleteFunctionConcurrency,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &DeleteFunctionConcurrencyInput{}
	}

	output := &DeleteFunctionConcurrencyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteFunctionConcurrencyRequest{Request: req, Input: input, Copy: c.DeleteFunctionConcurrencyRequest}
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest is a API request type for the GetAccountSettings API operation.
type GetAccountSettingsRequest struct {
	*aws.Request
	Input *GetAccountSettingsInput
	Copy  func(*GetAccountSettingsInput) GetAccountSettingsRequest
}

// Send marshals and sends the GetAccountSettings API request.
func (r GetAccountSettingsRequest) Send() (*GetAccountSettingsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetAccountSettingsOutput), nil
}

// GetAccountSettingsRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns a customer's account settings.
//
// You can use this operation to retrieve Lambda limits information, such as
// code size and concurrency limits. For more information about limits, see
// AWS Lambda Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html).
// You can also retrieve resource usage statistics, such as code storage usage
// and function count.
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req := client.GetAccountSettingsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings
func (c *Lambda) GetAccountSettingsRequest(input *GetAccountSettingsInput) GetAccountSettingsRequest {
	op := &aws.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-08-19/account-settings/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output := &GetAccountSettingsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetAccountSettingsRequest{Request: req, Input: input, Copy: c.GetAccountSettingsRequest}
}

const opGetAlias = "GetAlias"

// GetAliasRequest is a API request type for the GetAlias API operation.
type GetAliasRequest struct {
	*aws.Request
	Input *GetAliasInput
	Copy  func(*GetAliasInput) GetAliasRequest
}

// Send marshals and sends the GetAlias API request.
func (r GetAliasRequest) Send() (*UpdateAliasOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateAliasOutput), nil
}

// GetAliasRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns the specified alias information such as the alias ARN, description,
// and function version it is pointing to. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:GetAlias action.
//
//    // Example sending a request using the GetAliasRequest method.
//    req := client.GetAliasRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias
func (c *Lambda) GetAliasRequest(input *GetAliasInput) GetAliasRequest {
	op := &aws.Operation{
		Name:       opGetAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &GetAliasInput{}
	}

	output := &UpdateAliasOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetAliasRequest{Request: req, Input: input, Copy: c.GetAliasRequest}
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest is a API request type for the GetEventSourceMapping API operation.
type GetEventSourceMappingRequest struct {
	*aws.Request
	Input *GetEventSourceMappingInput
	Copy  func(*GetEventSourceMappingInput) GetEventSourceMappingRequest
}

// Send marshals and sends the GetEventSourceMapping API request.
func (r GetEventSourceMappingRequest) Send() (*UpdateEventSourceMappingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateEventSourceMappingOutput), nil
}

// GetEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns configuration information for the specified event source mapping
// (see CreateEventSourceMapping).
//
// This operation requires permission for the lambda:GetEventSourceMapping action.
//
//    // Example sending a request using the GetEventSourceMappingRequest method.
//    req := client.GetEventSourceMappingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping
func (c *Lambda) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) GetEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	output := &UpdateEventSourceMappingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetEventSourceMappingRequest{Request: req, Input: input, Copy: c.GetEventSourceMappingRequest}
}

const opGetFunction = "GetFunction"

// GetFunctionRequest is a API request type for the GetFunction API operation.
type GetFunctionRequest struct {
	*aws.Request
	Input *GetFunctionInput
	Copy  func(*GetFunctionInput) GetFunctionRequest
}

// Send marshals and sends the GetFunction API request.
func (r GetFunctionRequest) Send() (*GetFunctionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetFunctionOutput), nil
}

// GetFunctionRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns the configuration information of the Lambda function and a presigned
// URL link to the .zip file you uploaded with CreateFunction so you can download
// the .zip file. Note that the URL is valid for up to 10 minutes. The configuration
// information is the same information you provided as parameters when uploading
// the function.
//
// Using the optional Qualifier parameter, you can specify a specific function
// version for which you want this information. If you don't specify this parameter,
// the API uses unqualified function ARN which return information about the
// $LATEST version of the Lambda function. For more information, see AWS Lambda
// Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunction action.
//
//    // Example sending a request using the GetFunctionRequest method.
//    req := client.GetFunctionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction
func (c *Lambda) GetFunctionRequest(input *GetFunctionInput) GetFunctionRequest {
	op := &aws.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	output := &GetFunctionOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetFunctionRequest{Request: req, Input: input, Copy: c.GetFunctionRequest}
}

const opGetFunctionConfiguration = "GetFunctionConfiguration"

// GetFunctionConfigurationRequest is a API request type for the GetFunctionConfiguration API operation.
type GetFunctionConfigurationRequest struct {
	*aws.Request
	Input *GetFunctionConfigurationInput
	Copy  func(*GetFunctionConfigurationInput) GetFunctionConfigurationRequest
}

// Send marshals and sends the GetFunctionConfiguration API request.
func (r GetFunctionConfigurationRequest) Send() (*UpdateFunctionConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateFunctionConfigurationOutput), nil
}

// GetFunctionConfigurationRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns the configuration information of the Lambda function. This the same
// information you provided as parameters when uploading the function by using
// CreateFunction.
//
// If you are using the versioning feature, you can retrieve this information
// for a specific function version by using the optional Qualifier parameter
// and specifying the function version or alias that points to it. If you don't
// provide it, the API returns information about the $LATEST version of the
// function. For more information about versioning, see AWS Lambda Function
// Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunctionConfiguration
// operation.
//
//    // Example sending a request using the GetFunctionConfigurationRequest method.
//    req := client.GetFunctionConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration
func (c *Lambda) GetFunctionConfigurationRequest(input *GetFunctionConfigurationInput) GetFunctionConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetFunctionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &GetFunctionConfigurationInput{}
	}

	output := &UpdateFunctionConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetFunctionConfigurationRequest{Request: req, Input: input, Copy: c.GetFunctionConfigurationRequest}
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest is a API request type for the GetPolicy API operation.
type GetPolicyRequest struct {
	*aws.Request
	Input *GetPolicyInput
	Copy  func(*GetPolicyInput) GetPolicyRequest
}

// Send marshals and sends the GetPolicy API request.
func (r GetPolicyRequest) Send() (*GetPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetPolicyOutput), nil
}

// GetPolicyRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns the resource policy associated with the specified Lambda function.
//
// If you are using the versioning feature, you can get the resource policy
// associated with the specific Lambda function version or alias by specifying
// the version or alias name using the Qualifier parameter. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// You need permission for the lambda:GetPolicy action.
//
//    // Example sending a request using the GetPolicyRequest method.
//    req := client.GetPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy
func (c *Lambda) GetPolicyRequest(input *GetPolicyInput) GetPolicyRequest {
	op := &aws.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output := &GetPolicyOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetPolicyRequest{Request: req, Input: input, Copy: c.GetPolicyRequest}
}

const opInvoke = "Invoke"

// InvokeRequest is a API request type for the Invoke API operation.
type InvokeRequest struct {
	*aws.Request
	Input *InvokeInput
	Copy  func(*InvokeInput) InvokeRequest
}

// Send marshals and sends the Invoke API request.
func (r InvokeRequest) Send() (*InvokeOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*InvokeOutput), nil
}

// InvokeRequest returns a request value for making API operation for
// AWS Lambda.
//
// Invokes a specific Lambda function. For an example, see Create the Lambda
// Function and Test It Manually (http://docs.aws.amazon.com/lambda/latest/dg/with-dynamodb-create-function.html#with-dbb-invoke-manually).
//
// If you are using the versioning feature, you can invoke the specific function
// version by providing function version or alias name that is pointing to the
// function version using the Qualifier parameter in the request. If you don't
// provide the Qualifier parameter, the $LATEST version of the Lambda function
// is invoked. Invocations occur at least once in response to an event and functions
// must be idempotent to handle this. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:InvokeFunction action.
//
// The TooManyRequestsException noted below will return the following: ConcurrentInvocationLimitExceeded
// will be returned if you have no functions with reserved concurrency and have
// exceeded your account concurrent limit or if a function without reserved
// concurrency exceeds the account's unreserved concurrency limit. ReservedFunctionConcurrentInvocationLimitExceeded
// will be returned when a function with reserved concurrency exceeds its configured
// concurrency limit.
//
//    // Example sending a request using the InvokeRequest method.
//    req := client.InvokeRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke
func (c *Lambda) InvokeRequest(input *InvokeInput) InvokeRequest {
	op := &aws.Operation{
		Name:       opInvoke,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/invocations",
	}

	if input == nil {
		input = &InvokeInput{}
	}

	output := &InvokeOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return InvokeRequest{Request: req, Input: input, Copy: c.InvokeRequest}
}

const opInvokeAsync = "InvokeAsync"

// InvokeAsyncRequest is a API request type for the InvokeAsync API operation.
type InvokeAsyncRequest struct {
	*aws.Request
	Input *InvokeAsyncInput
	Copy  func(*InvokeAsyncInput) InvokeAsyncRequest
}

// Send marshals and sends the InvokeAsync API request.
func (r InvokeAsyncRequest) Send() (*InvokeAsyncOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*InvokeAsyncOutput), nil
}

// InvokeAsyncRequest returns a request value for making API operation for
// AWS Lambda.
//
// This API is deprecated. We recommend you use Invoke API (see Invoke).
//
// Submits an invocation request to AWS Lambda. Upon receiving the request,
// Lambda executes the specified function asynchronously. To see the logs generated
// by the Lambda function execution, see the CloudWatch Logs console.
//
// This operation requires permission for the lambda:InvokeFunction action.
//
//    // Example sending a request using the InvokeAsyncRequest method.
//    req := client.InvokeAsyncRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsync
func (c *Lambda) InvokeAsyncRequest(input *InvokeAsyncInput) InvokeAsyncRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, InvokeAsync, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opInvokeAsync,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-11-13/functions/{FunctionName}/invoke-async/",
	}

	if input == nil {
		input = &InvokeAsyncInput{}
	}

	output := &InvokeAsyncOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return InvokeAsyncRequest{Request: req, Input: input, Copy: c.InvokeAsyncRequest}
}

const opListAliases = "ListAliases"

// ListAliasesRequest is a API request type for the ListAliases API operation.
type ListAliasesRequest struct {
	*aws.Request
	Input *ListAliasesInput
	Copy  func(*ListAliasesInput) ListAliasesRequest
}

// Send marshals and sends the ListAliases API request.
func (r ListAliasesRequest) Send() (*ListAliasesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListAliasesOutput), nil
}

// ListAliasesRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns list of aliases created for a Lambda function. For each alias, the
// response includes information such as the alias ARN, description, alias name,
// and the function version to which it points. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:ListAliases action.
//
//    // Example sending a request using the ListAliasesRequest method.
//    req := client.ListAliasesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases
func (c *Lambda) ListAliasesRequest(input *ListAliasesInput) ListAliasesRequest {
	op := &aws.Operation{
		Name:       opListAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output := &ListAliasesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListAliasesRequest{Request: req, Input: input, Copy: c.ListAliasesRequest}
}

const opListEventSourceMappings = "ListEventSourceMappings"

// ListEventSourceMappingsRequest is a API request type for the ListEventSourceMappings API operation.
type ListEventSourceMappingsRequest struct {
	*aws.Request
	Input *ListEventSourceMappingsInput
	Copy  func(*ListEventSourceMappingsInput) ListEventSourceMappingsRequest
}

// Send marshals and sends the ListEventSourceMappings API request.
func (r ListEventSourceMappingsRequest) Send() (*ListEventSourceMappingsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListEventSourceMappingsOutput), nil
}

// ListEventSourceMappingsRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns a list of event source mappings you created using the CreateEventSourceMapping
// (see CreateEventSourceMapping).
//
// For each mapping, the API returns configuration information. You can optionally
// specify filters to retrieve specific event source mappings.
//
// If you are using the versioning feature, you can get list of event source
// mappings for a specific Lambda function version or an alias as described
// in the FunctionName parameter. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:ListEventSourceMappings
// action.
//
//    // Example sending a request using the ListEventSourceMappingsRequest method.
//    req := client.ListEventSourceMappingsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings
func (c *Lambda) ListEventSourceMappingsRequest(input *ListEventSourceMappingsInput) ListEventSourceMappingsRequest {
	op := &aws.Operation{
		Name:       opListEventSourceMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSourceMappingsInput{}
	}

	output := &ListEventSourceMappingsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListEventSourceMappingsRequest{Request: req, Input: input, Copy: c.ListEventSourceMappingsRequest}
}

// Paginate pages iterates over the pages of a ListEventSourceMappingsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventSourceMappings operation.
//		req := client.ListEventSourceMappingsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListEventSourceMappingsRequest) Paginate(opts ...aws.Option) ListEventSourceMappingsPager {
	return ListEventSourceMappingsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListEventSourceMappingsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListEventSourceMappingsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListEventSourceMappingsPager struct {
	aws.Pager
}

func (p *ListEventSourceMappingsPager) CurrentPage() *ListEventSourceMappingsOutput {
	return p.Pager.CurrentPage().(*ListEventSourceMappingsOutput)
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest is a API request type for the ListFunctions API operation.
type ListFunctionsRequest struct {
	*aws.Request
	Input *ListFunctionsInput
	Copy  func(*ListFunctionsInput) ListFunctionsRequest
}

// Send marshals and sends the ListFunctions API request.
func (r ListFunctionsRequest) Send() (*ListFunctionsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListFunctionsOutput), nil
}

// ListFunctionsRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns a list of your Lambda functions. For each function, the response
// includes the function configuration information. You must use GetFunction
// to retrieve the code for your function.
//
// This operation requires permission for the lambda:ListFunctions action.
//
// If you are using the versioning feature, you can list all of your functions
// or only $LATEST versions. For information about the versioning feature, see
// AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
//    // Example sending a request using the ListFunctionsRequest method.
//    req := client.ListFunctionsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions
func (c *Lambda) ListFunctionsRequest(input *ListFunctionsInput) ListFunctionsRequest {
	op := &aws.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	output := &ListFunctionsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListFunctionsRequest{Request: req, Input: input, Copy: c.ListFunctionsRequest}
}

// Paginate pages iterates over the pages of a ListFunctionsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFunctions operation.
//		req := client.ListFunctionsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *ListFunctionsRequest) Paginate(opts ...aws.Option) ListFunctionsPager {
	return ListFunctionsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *ListFunctionsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// ListFunctionsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListFunctionsPager struct {
	aws.Pager
}

func (p *ListFunctionsPager) CurrentPage() *ListFunctionsOutput {
	return p.Pager.CurrentPage().(*ListFunctionsOutput)
}

const opListTags = "ListTags"

// ListTagsRequest is a API request type for the ListTags API operation.
type ListTagsRequest struct {
	*aws.Request
	Input *ListTagsInput
	Copy  func(*ListTagsInput) ListTagsRequest
}

// Send marshals and sends the ListTags API request.
func (r ListTagsRequest) Send() (*ListTagsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListTagsOutput), nil
}

// ListTagsRequest returns a request value for making API operation for
// AWS Lambda.
//
// Returns a list of tags assigned to a function when supplied the function
// ARN (Amazon Resource Name). For more information on Tagging, see Tagging
// Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// in the AWS Lambda Developer Guide.
//
//    // Example sending a request using the ListTagsRequest method.
//    req := client.ListTagsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags
func (c *Lambda) ListTagsRequest(input *ListTagsInput) ListTagsRequest {
	op := &aws.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output := &ListTagsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListTagsRequest{Request: req, Input: input, Copy: c.ListTagsRequest}
}

const opListVersionsByFunction = "ListVersionsByFunction"

// ListVersionsByFunctionRequest is a API request type for the ListVersionsByFunction API operation.
type ListVersionsByFunctionRequest struct {
	*aws.Request
	Input *ListVersionsByFunctionInput
	Copy  func(*ListVersionsByFunctionInput) ListVersionsByFunctionRequest
}

// Send marshals and sends the ListVersionsByFunction API request.
func (r ListVersionsByFunctionRequest) Send() (*ListVersionsByFunctionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListVersionsByFunctionOutput), nil
}

// ListVersionsByFunctionRequest returns a request value for making API operation for
// AWS Lambda.
//
// List all versions of a function. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
//    // Example sending a request using the ListVersionsByFunctionRequest method.
//    req := client.ListVersionsByFunctionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction
func (c *Lambda) ListVersionsByFunctionRequest(input *ListVersionsByFunctionInput) ListVersionsByFunctionRequest {
	op := &aws.Operation{
		Name:       opListVersionsByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &ListVersionsByFunctionInput{}
	}

	output := &ListVersionsByFunctionOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListVersionsByFunctionRequest{Request: req, Input: input, Copy: c.ListVersionsByFunctionRequest}
}

const opPublishVersion = "PublishVersion"

// PublishVersionRequest is a API request type for the PublishVersion API operation.
type PublishVersionRequest struct {
	*aws.Request
	Input *PublishVersionInput
	Copy  func(*PublishVersionInput) PublishVersionRequest
}

// Send marshals and sends the PublishVersion API request.
func (r PublishVersionRequest) Send() (*UpdateFunctionConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateFunctionConfigurationOutput), nil
}

// PublishVersionRequest returns a request value for making API operation for
// AWS Lambda.
//
// Publishes a version of your function from the current snapshot of $LATEST.
// That is, AWS Lambda takes a snapshot of the function code and configuration
// information from $LATEST and publishes a new version. The code and configuration
// cannot be modified after publication. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
//    // Example sending a request using the PublishVersionRequest method.
//    req := client.PublishVersionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion
func (c *Lambda) PublishVersionRequest(input *PublishVersionInput) PublishVersionRequest {
	op := &aws.Operation{
		Name:       opPublishVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &PublishVersionInput{}
	}

	output := &UpdateFunctionConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PublishVersionRequest{Request: req, Input: input, Copy: c.PublishVersionRequest}
}

const opPutFunctionConcurrency = "PutFunctionConcurrency"

// PutFunctionConcurrencyRequest is a API request type for the PutFunctionConcurrency API operation.
type PutFunctionConcurrencyRequest struct {
	*aws.Request
	Input *PutFunctionConcurrencyInput
	Copy  func(*PutFunctionConcurrencyInput) PutFunctionConcurrencyRequest
}

// Send marshals and sends the PutFunctionConcurrency API request.
func (r PutFunctionConcurrencyRequest) Send() (*PutFunctionConcurrencyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutFunctionConcurrencyOutput), nil
}

// PutFunctionConcurrencyRequest returns a request value for making API operation for
// AWS Lambda.
//
// Sets a limit on the number of concurrent executions available to this function.
// It is a subset of your account's total concurrent execution limit per region.
// Note that Lambda automatically reserves a buffer of 100 concurrent executions
// for functions without any reserved concurrency limit. This means if your
// account limit is 1000, you have a total of 900 available to allocate to individual
// functions. For more information, see concurrent-executions.
//
//    // Example sending a request using the PutFunctionConcurrencyRequest method.
//    req := client.PutFunctionConcurrencyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency
func (c *Lambda) PutFunctionConcurrencyRequest(input *PutFunctionConcurrencyInput) PutFunctionConcurrencyRequest {
	op := &aws.Operation{
		Name:       opPutFunctionConcurrency,
		HTTPMethod: "PUT",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &PutFunctionConcurrencyInput{}
	}

	output := &PutFunctionConcurrencyOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutFunctionConcurrencyRequest{Request: req, Input: input, Copy: c.PutFunctionConcurrencyRequest}
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest is a API request type for the RemovePermission API operation.
type RemovePermissionRequest struct {
	*aws.Request
	Input *RemovePermissionInput
	Copy  func(*RemovePermissionInput) RemovePermissionRequest
}

// Send marshals and sends the RemovePermission API request.
func (r RemovePermissionRequest) Send() (*RemovePermissionOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*RemovePermissionOutput), nil
}

// RemovePermissionRequest returns a request value for making API operation for
// AWS Lambda.
//
// You can remove individual permissions from an resource policy associated
// with a Lambda function by providing a statement ID that you provided when
// you added the permission.
//
// If you are using versioning, the permissions you remove are specific to the
// Lambda function version or alias you specify in the AddPermission request
// via the Qualifier parameter. For more information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Note that removal of a permission will cause an active event source to lose
// permission to the function.
//
// You need permission for the lambda:RemovePermission action.
//
//    // Example sending a request using the RemovePermissionRequest method.
//    req := client.RemovePermissionRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission
func (c *Lambda) RemovePermissionRequest(input *RemovePermissionInput) RemovePermissionRequest {
	op := &aws.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output := &RemovePermissionOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return RemovePermissionRequest{Request: req, Input: input, Copy: c.RemovePermissionRequest}
}

const opTagResource = "TagResource"

// TagResourceRequest is a API request type for the TagResource API operation.
type TagResourceRequest struct {
	*aws.Request
	Input *TagResourceInput
	Copy  func(*TagResourceInput) TagResourceRequest
}

// Send marshals and sends the TagResource API request.
func (r TagResourceRequest) Send() (*TagResourceOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*TagResourceOutput), nil
}

// TagResourceRequest returns a request value for making API operation for
// AWS Lambda.
//
// Creates a list of tags (key-value pairs) on the Lambda function. Requires
// the Lambda function ARN (Amazon Resource Name). If a key is specified without
// a value, Lambda creates a tag with the specified key and a value of null.
// For more information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// in the AWS Lambda Developer Guide.
//
//    // Example sending a request using the TagResourceRequest method.
//    req := client.TagResourceRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource
func (c *Lambda) TagResourceRequest(input *TagResourceInput) TagResourceRequest {
	op := &aws.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output := &TagResourceOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return TagResourceRequest{Request: req, Input: input, Copy: c.TagResourceRequest}
}

const opUntagResource = "UntagResource"

// UntagResourceRequest is a API request type for the UntagResource API operation.
type UntagResourceRequest struct {
	*aws.Request
	Input *UntagResourceInput
	Copy  func(*UntagResourceInput) UntagResourceRequest
}

// Send marshals and sends the UntagResource API request.
func (r UntagResourceRequest) Send() (*UntagResourceOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UntagResourceOutput), nil
}

// UntagResourceRequest returns a request value for making API operation for
// AWS Lambda.
//
// Removes tags from a Lambda function. Requires the function ARN (Amazon Resource
// Name). For more information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// in the AWS Lambda Developer Guide.
//
//    // Example sending a request using the UntagResourceRequest method.
//    req := client.UntagResourceRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource
func (c *Lambda) UntagResourceRequest(input *UntagResourceInput) UntagResourceRequest {
	op := &aws.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output := &UntagResourceOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return UntagResourceRequest{Request: req, Input: input, Copy: c.UntagResourceRequest}
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest is a API request type for the UpdateAlias API operation.
type UpdateAliasRequest struct {
	*aws.Request
	Input *UpdateAliasInput
	Copy  func(*UpdateAliasInput) UpdateAliasRequest
}

// Send marshals and sends the UpdateAlias API request.
func (r UpdateAliasRequest) Send() (*UpdateAliasOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateAliasOutput), nil
}

// UpdateAliasRequest returns a request value for making API operation for
// AWS Lambda.
//
// Using this API you can update the function version to which the alias points
// and the alias description. For more information, see Introduction to AWS
// Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:UpdateAlias action.
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req := client.UpdateAliasRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias
func (c *Lambda) UpdateAliasRequest(input *UpdateAliasInput) UpdateAliasRequest {
	op := &aws.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output := &UpdateAliasOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateAliasRequest{Request: req, Input: input, Copy: c.UpdateAliasRequest}
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest is a API request type for the UpdateEventSourceMapping API operation.
type UpdateEventSourceMappingRequest struct {
	*aws.Request
	Input *UpdateEventSourceMappingInput
	Copy  func(*UpdateEventSourceMappingInput) UpdateEventSourceMappingRequest
}

// Send marshals and sends the UpdateEventSourceMapping API request.
func (r UpdateEventSourceMappingRequest) Send() (*UpdateEventSourceMappingOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateEventSourceMappingOutput), nil
}

// UpdateEventSourceMappingRequest returns a request value for making API operation for
// AWS Lambda.
//
// You can update an event source mapping. This is useful if you want to change
// the parameters of the existing mapping without losing your position in the
// stream. You can change which function will receive the stream records, but
// to change the stream itself, you must create a new mapping.
//
// If you are using the versioning feature, you can update the event source
// mapping to map to a specific Lambda function version or alias as described
// in the FunctionName parameter. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// If you disable the event source mapping, AWS Lambda stops polling. If you
// enable again, it will resume polling from the time it had stopped polling,
// so you don't lose processing of any records. However, if you delete event
// source mapping and create it again, it will reset.
//
// This operation requires permission for the lambda:UpdateEventSourceMapping
// action.
//
//    // Example sending a request using the UpdateEventSourceMappingRequest method.
//    req := client.UpdateEventSourceMappingRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping
func (c *Lambda) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) UpdateEventSourceMappingRequest {
	op := &aws.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	output := &UpdateEventSourceMappingOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateEventSourceMappingRequest{Request: req, Input: input, Copy: c.UpdateEventSourceMappingRequest}
}

const opUpdateFunctionCode = "UpdateFunctionCode"

// UpdateFunctionCodeRequest is a API request type for the UpdateFunctionCode API operation.
type UpdateFunctionCodeRequest struct {
	*aws.Request
	Input *UpdateFunctionCodeInput
	Copy  func(*UpdateFunctionCodeInput) UpdateFunctionCodeRequest
}

// Send marshals and sends the UpdateFunctionCode API request.
func (r UpdateFunctionCodeRequest) Send() (*UpdateFunctionConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateFunctionConfigurationOutput), nil
}

// UpdateFunctionCodeRequest returns a request value for making API operation for
// AWS Lambda.
//
// Updates the code for the specified Lambda function. This operation must only
// be used on an existing Lambda function and cannot be used to update the function
// configuration.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionCode action.
//
//    // Example sending a request using the UpdateFunctionCodeRequest method.
//    req := client.UpdateFunctionCodeRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode
func (c *Lambda) UpdateFunctionCodeRequest(input *UpdateFunctionCodeInput) UpdateFunctionCodeRequest {
	op := &aws.Operation{
		Name:       opUpdateFunctionCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/code",
	}

	if input == nil {
		input = &UpdateFunctionCodeInput{}
	}

	output := &UpdateFunctionConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateFunctionCodeRequest{Request: req, Input: input, Copy: c.UpdateFunctionCodeRequest}
}

const opUpdateFunctionConfiguration = "UpdateFunctionConfiguration"

// UpdateFunctionConfigurationRequest is a API request type for the UpdateFunctionConfiguration API operation.
type UpdateFunctionConfigurationRequest struct {
	*aws.Request
	Input *UpdateFunctionConfigurationInput
	Copy  func(*UpdateFunctionConfigurationInput) UpdateFunctionConfigurationRequest
}

// Send marshals and sends the UpdateFunctionConfiguration API request.
func (r UpdateFunctionConfigurationRequest) Send() (*UpdateFunctionConfigurationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UpdateFunctionConfigurationOutput), nil
}

// UpdateFunctionConfigurationRequest returns a request value for making API operation for
// AWS Lambda.
//
// Updates the configuration parameters for the specified Lambda function by
// using the values provided in the request. You provide only the parameters
// you want to change. This operation must only be used on an existing Lambda
// function and cannot be used to update the function's code.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionConfiguration
// action.
//
//    // Example sending a request using the UpdateFunctionConfigurationRequest method.
//    req := client.UpdateFunctionConfigurationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration
func (c *Lambda) UpdateFunctionConfigurationRequest(input *UpdateFunctionConfigurationInput) UpdateFunctionConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateFunctionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &UpdateFunctionConfigurationInput{}
	}

	output := &UpdateFunctionConfigurationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return UpdateFunctionConfigurationRequest{Request: req, Input: input, Copy: c.UpdateFunctionConfigurationRequest}
}

// Provides limits of code size and concurrency associated with the current
// account and region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AccountLimit
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// Size, in bytes, of code/dependencies that you can zip into a deployment package
	// (uncompressed zip/jar size) for uploading. The default limit is 250 MB.
	CodeSizeUnzipped *int64 `type:"long"`

	// Size, in bytes, of a single zipped code/dependencies package you can upload
	// for your Lambda function(.zip/.jar file). Try using Amazon S3 for uploading
	// larger files. Default limit is 50 MB.
	CodeSizeZipped *int64 `type:"long"`

	// Number of simultaneous executions of your function per region. For more information
	// or to request a limit increase for concurrent executions, see Lambda Function
	// Concurrent Executions (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	// The default limit is 1000.
	ConcurrentExecutions *int64 `type:"integer"`

	// Maximum size, in bytes, of a code package you can upload per region. The
	// default size is 75 GB.
	TotalCodeSize *int64 `type:"long"`

	// The number of concurrent executions available to functions that do not have
	// concurrency limits set. For more information, see concurrent-executions.
	UnreservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountLimit) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeSizeUnzipped != nil {
		v := *s.CodeSizeUnzipped

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSizeUnzipped", protocol.Int64Value(v), metadata)
	}
	if s.CodeSizeZipped != nil {
		v := *s.CodeSizeZipped

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSizeZipped", protocol.Int64Value(v), metadata)
	}
	if s.ConcurrentExecutions != nil {
		v := *s.ConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	if s.TotalCodeSize != nil {
		v := *s.TotalCodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCodeSize", protocol.Int64Value(v), metadata)
	}
	if s.UnreservedConcurrentExecutions != nil {
		v := *s.UnreservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UnreservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides code size usage and function count associated with the current account
// and region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AccountUsage
type AccountUsage struct {
	_ struct{} `type:"structure"`

	// The number of your account's existing functions per region.
	FunctionCount *int64 `type:"long"`

	// Total size, in bytes, of the account's deployment packages per region.
	TotalCodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s AccountUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountUsage) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountUsage) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionCount != nil {
		v := *s.FunctionCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalCodeSize != nil {
		v := *s.TotalCodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCodeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermissionRequest
type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda action you want to allow in this statement. Each Lambda action
	// is a string starting with lambda: followed by the API name . For example,
	// lambda:CreateFunction. You can use wildcard (lambda:*) to grant permission
	// for all AWS Lambda actions.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// A unique token that must be supplied by the principal invoking the function.
	// This is currently only used for Alexa Smart Home functions.
	EventSourceToken *string `type:"string"`

	// Name of the Lambda function whose resource policy you are updating by adding
	// a new permission.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The principal who is getting this permission. It can be Amazon S3 service
	// Principal (s3.amazonaws.com) if you want Amazon S3 to invoke the function,
	// an AWS account ID if you are granting cross-account permission, or any valid
	// AWS service principal such as sns.amazonaws.com. For example, you might want
	// to allow a custom application in another AWS account to push events to AWS
	// Lambda by invoking your function.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// You can use this optional query parameter to describe a qualified ARN using
	// a function version or an alias name. The permission will then apply to the
	// specific qualified ARN. For example, if you specify function version 2 as
	// the qualifier, then permission applies only when request is made using qualified
	// function ARN:
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name:2
	//
	// If you specify an alias name, for example PROD, then the permission is valid
	// only for requests made using the alias ARN:
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name:PROD
	//
	// If the qualifier is not specified, the permission is valid only when requests
	// is made using unqualified function ARN.
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either or .
	RevisionId *string `type:"string"`

	// This parameter is used for S3 and SES. The AWS account ID (without a hyphen)
	// of the source owner. For example, if the SourceArn identifies a bucket, then
	// this is the bucket owner's account ID. You can use this additional condition
	// to ensure the bucket you specify is owned by a specific account (it is possible
	// the bucket owner deleted the bucket and some other AWS account created the
	// bucket). You can also use this condition to specify all sources (that is,
	// you don't specify the SourceArn) owned by a specific account.
	SourceAccount *string `type:"string"`

	// This is optional; however, when granting permission to invoke your function,
	// you should specify this field with the Amazon Resource Name (ARN) as its
	// value. This ensures that only events generated from the specified source
	// can invoke the function.
	//
	// If you add a permission without providing the source ARN, any AWS account
	// that creates a mapping to your function ARN can send events to invoke your
	// Lambda function.
	SourceArn *string `type:"string"`

	// A unique statement identifier.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddPermissionInput"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if s.StatementId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddPermissionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Action != nil {
		v := *s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventSourceToken != nil {
		v := *s.EventSourceToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceAccount != nil {
		v := *s.SourceAccount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceAccount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceArn != nil {
		v := *s.SourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatementId != nil {
		v := *s.StatementId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StatementId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermissionResponse
type AddPermissionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The permission statement you specified in the request. The response returns
	// the same as a string using a backslash ("\") as an escape character in the
	// JSON.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s AddPermissionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddPermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Statement != nil {
		v := *s.Statement

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Statement", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The parent object that implements what percentage of traffic will invoke
// each function version. For more information, see lambda-traffic-shifting-using-aliases.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AliasRoutingConfiguration
type AliasRoutingConfiguration struct {
	_ struct{} `type:"structure"`

	// Set this value to dictate what percentage of traffic will invoke the updated
	// function version. If set to an empty string, 100 percent of traffic will
	// invoke function-version. For more information, see lambda-traffic-shifting-using-aliases.
	AdditionalVersionWeights map[string]float64 `type:"map"`
}

// String returns the string representation
func (s AliasRoutingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasRoutingConfiguration) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AliasRoutingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalVersionWeights) > 0 {
		v := s.AdditionalVersionWeights

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "AdditionalVersionWeights", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAliasRequest
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Description of the alias.
	Description *string `type:"string"`

	// Name of the Lambda function for which you want to create an alias. Note that
	// the length constraint applies only to the ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Lambda function version for which you are creating the alias.
	//
	// FunctionVersion is a required field
	FunctionVersion *string `min:"1" type:"string" required:"true"`

	// Name for the alias you are creating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies an additional version your alias can point to, allowing you to
	// dictate what percentage of traffic will invoke each version. For more information,
	// see lambda-traffic-shifting-using-aliases.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAliasInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.FunctionVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionVersion"))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionVersion", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAliasInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionVersion != nil {
		v := *s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoutingConfig != nil {
		v := s.RoutingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RoutingConfig", v, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMappingRequest
type CreateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records. The default for Amazon Kinesis and Amazon
	// DynamoDB is 100 records. For SQS, the default is 1.
	BatchSize *int64 `min:"1" type:"integer"`

	// Indicates whether AWS Lambda should begin polling the event source. By default,
	// Enabled is true.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the event source. Any record added to this
	// source could cause AWS Lambda to invoke your Lambda function, it depends
	// on the BatchSize. AWS Lambda POSTs the event's records to your Lambda function
	// as JSON.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `type:"string" required:"true"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	//
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). For
	// more information about versioning, see AWS Lambda Function Versioning and
	// Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
	//
	// AWS Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail).
	//
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The position in the DynamoDB or Kinesis stream where AWS Lambda should start
	// reading. For more information, see GetShardIterator (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType)
	// in the Amazon Kinesis API Reference Guide or GetShardIterator (http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html)
	// in the Amazon DynamoDB API Reference Guide. The AT_TIMESTAMP value is supported
	// only for Kinesis streams (http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html).
	StartingPosition EventSourcePosition `type:"string" enum:"true"`

	// The timestamp of the data record from which to start reading. Used with shard
	// iterator type (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType)
	// AT_TIMESTAMP. If a record with this exact timestamp does not exist, the iterator
	// returned is for the next (later) record. If the timestamp is older than the
	// current trim horizon, the iterator returned is for the oldest untrimmed data
	// record (TRIM_HORIZON). Valid only for Kinesis streams (http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html).
	StartingPositionTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("BatchSize", 1))
	}

	if s.EventSourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventSourceArn"))
	}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StartingPosition) > 0 {
		v := s.StartingPosition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartingPosition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartingPositionTimestamp != nil {
		v := *s.StartingPositionTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartingPositionTimestamp", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunctionRequest
type CreateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The code for the Lambda function.
	//
	// Code is a required field
	Code *FunctionCode `type:"structure" required:"true"`

	// The parent object that contains the target ARN (Amazon Resource Name) of
	// an Amazon SQS queue or Amazon SNS topic. For more information, see dlq.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A short, user-defined function description. Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *Environment `type:"structure"`

	// The name you want to assign to the function you are uploading. The function
	// names appear in the console and are returned in the ListFunctions API. Function
	// names are used to specify functions to other AWS Lambda API operations, such
	// as Invoke. Note that the length constraint applies only to the ARN. If you
	// specify only the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The function within your code that Lambda calls to begin execution. For Node.js,
	// it is the module-name.export value in your function. For Java, it can be
	// package.class-name::handler or package.class-name. For more information,
	// see Lambda Function Handler (Java) (http://docs.aws.amazon.com/lambda/latest/dg/java-programming-model-handler-types.html).
	//
	// Handler is a required field
	Handler *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If not provided, AWS Lambda will use a default service
	// key.
	KMSKeyArn *string `type:"string"`

	// The amount of memory, in MB, your Lambda function is given. Lambda uses this
	// memory size to infer the amount of CPU and memory allocated to your function.
	// Your function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// This boolean parameter can be used to request AWS Lambda to create the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	// For more information, see AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The runtime environment for the Lambda function you are uploading.
	//
	// To use the Python runtime v3.6, set the value to "python3.6". To use the
	// Python runtime v2.7, set the value to "python2.7". To use the Node.js runtime
	// v6.10, set the value to "nodejs6.10". To use the Node.js runtime v4.3, set
	// the value to "nodejs4.3". To use the .NET Core runtime v1.0, set the value
	// to "dotnetcore1.0". To use the .NET Core runtime v2.0, set the value to "dotnetcore2.0".
	//
	// Node v0.10.42 is currently marked as deprecated. You must migrate existing
	// functions to the newer Node.js runtime versions available on AWS Lambda (nodejs4.3
	// or nodejs6.10) as soon as possible. Failure to do so will result in an invalid
	// parameter error being returned. Note that you will have to follow this procedure
	// for each region that contains functions written in the Node v0.10.42 runtime.
	//
	// Runtime is a required field
	Runtime Runtime `type:"string" required:"true" enum:"true"`

	// The list of tags (key-value pairs) assigned to the new function. For more
	// information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	Tags map[string]string `type:"map"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// The parent object that contains your function's tracing settings.
	TracingConfig *TracingConfig `type:"structure"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFunctionInput"}

	if s.Code == nil {
		invalidParams.Add(aws.NewErrParamRequired("Code"))
	}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.Handler == nil {
		invalidParams.Add(aws.NewErrParamRequired("Handler"))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(aws.NewErrParamMinValue("MemorySize", 128))
	}

	if s.Role == nil {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}
	if len(s.Runtime) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Runtime"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFunctionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Code != nil {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Code", v, metadata)
	}
	if s.DeadLetterConfig != nil {
		v := s.DeadLetterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeadLetterConfig", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KMSKeyArn != nil {
		v := *s.KMSKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemorySize != nil {
		v := *s.MemorySize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemorySize", protocol.Int64Value(v), metadata)
	}
	if s.Publish != nil {
		v := *s.Publish

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Publish", protocol.BoolValue(v), metadata)
	}
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Runtime) > 0 {
		v := s.Runtime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Runtime", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	if s.TracingConfig != nil {
		v := s.TracingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TracingConfig", v, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic
// you specify as your Dead Letter Queue (DLQ). For more information, see dlq.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeadLetterConfig
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic
	// you specify as your Dead Letter Queue (DLQ). dlq. For more information, see
	// dlq.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeadLetterConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetArn != nil {
		v := *s.TargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAliasRequest
type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function name for which the alias is created. Deleting an alias
	// does not delete the function version to which it is pointing. Note that the
	// length constraint applies only to the ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAliasInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAliasInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAliasOutput
type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteAliasOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAliasOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMappingRequest
type DeleteEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The event source mapping ID.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEventSourceMappingInput"}

	if s.UUID == nil {
		invalidParams.Add(aws.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrencyRequest
type DeleteFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the function you are removing concurrent execution limits from.
	// For more information, see concurrent-executions.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionConcurrencyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFunctionConcurrencyInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionConcurrencyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrencyOutput
type DeleteFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteFunctionConcurrencyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionConcurrencyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionRequest
type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function to delete.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter you can specify a function version (but not
	// the $LATEST version) to direct AWS Lambda to delete a specific function version.
	// If the function version has one or more aliases pointing to it, you will
	// get an error because you cannot have aliases pointing to it. You can delete
	// any function version but not the $LATEST, that is, you cannot specify $LATEST
	// as the value of this parameter. The $LATEST version can be deleted only when
	// you want to delete all the function versions and aliases.
	//
	// You can only specify a function version, not an alias name, using this parameter.
	// You cannot delete a function version using its alias.
	//
	// If you don't specify this parameter, AWS Lambda will delete the function,
	// including all of its versions and aliases.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFunctionInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionOutput
type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteFunctionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// The parent object that contains your environment's configuration settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Environment
type Environment struct {
	_ struct{} `type:"structure"`

	// The key-value pairs that represent your environment's configuration settings.
	Variables map[string]string `type:"map"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Environment) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Environment) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Variables) > 0 {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The parent object that contains error information associated with your configuration
// settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EnvironmentError
type EnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code returned by the environment error object.
	ErrorCode *string `type:"string"`

	// The message returned by the environment error object.
	Message *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentError) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnvironmentError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The parent object returned that contains your environment's configuration
// settings or any error information associated with your configuration settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EnvironmentResponse
type EnvironmentResponse struct {
	_ struct{} `type:"structure"`

	// The parent object that contains error information associated with your configuration
	// settings.
	Error *EnvironmentError `type:"structure"`

	// The key-value pairs returned that represent your environment's configuration
	// settings or error information.
	Variables map[string]string `type:"map"`
}

// String returns the string representation
func (s EnvironmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResponse) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnvironmentResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Error != nil {
		v := s.Error

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Error", v, metadata)
	}
	if len(s.Variables) > 0 {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The code for the Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/FunctionCode
type FunctionCode struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The contents of your zip file containing your deployment package. If you
	// are using the web API directly, the contents of the zip file must be base64-encoded.
	// If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the
	// encoding for you. For more information about creating a .zip file, see Execution
	// Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html)
	// in the AWS Lambda Developer Guide.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionCode) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FunctionCode"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionCode) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3ObjectVersion != nil {
		v := *s.S3ObjectVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3ObjectVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipFile != nil {
		v := s.ZipFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipFile", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// The object for the Lambda function location.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/FunctionCodeLocation
type FunctionCodeLocation struct {
	_ struct{} `type:"structure"`

	// The presigned URL you can use to download the function's .zip file that you
	// previously uploaded. The URL is valid for up to 10 minutes.
	Location *string `type:"string"`

	// The repository from which you can download the function.
	RepositoryType *string `type:"string"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCodeLocation) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionCodeLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryType != nil {
		v := *s.RepositoryType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RepositoryType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettingsRequest
type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAccountSettingsInput) MarshalFields(e protocol.FieldEncoder) error {

	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettingsResponse
type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Provides limits of code size and concurrency associated with the current
	// account and region.
	AccountLimit *AccountLimit `type:"structure"`

	// Provides code size usage and function count associated with the current account
	// and region.
	AccountUsage *AccountUsage `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetAccountSettingsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAccountSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountLimit != nil {
		v := s.AccountLimit

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccountLimit", v, metadata)
	}
	if s.AccountUsage != nil {
		v := s.AccountUsage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccountUsage", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAliasRequest
type GetAliasInput struct {
	_ struct{} `type:"structure"`

	// Function name for which the alias is created. An alias is a subresource that
	// exists only in the context of an existing Lambda function so you must specify
	// the function name. Note that the length constraint applies only to the ARN.
	// If you specify only the function name, it is limited to 64 characters in
	// length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias for which you want to retrieve information.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAliasInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAliasInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMappingRequest
type GetEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda assigned ID of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEventSourceMappingInput"}

	if s.UUID == nil {
		invalidParams.Add(aws.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfigurationRequest
type GetFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function for which you want to retrieve the configuration
	// information.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter you can specify a function version or an alias
	// name. If you specify function version, the API uses qualified function ARN
	// and returns information about the specific function version. If you specify
	// an alias name, the API uses the alias ARN and returns information about the
	// function version to which the alias points.
	//
	// If you don't specify this parameter, the API uses unqualified function ARN,
	// and returns information about the $LATEST function version.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFunctionConfigurationInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFunctionConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionRequest
type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function name.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Use this optional parameter to specify a function version or an alias name.
	// If you specify function version, the API uses qualified function ARN for
	// the request and returns information about the specific Lambda function version.
	// If you specify an alias name, the API uses the alias ARN and returns information
	// about the function version to which the alias points. If you don't provide
	// this parameter, the API uses unqualified function ARN and returns information
	// about the $LATEST version of the Lambda function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFunctionInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFunctionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// This response contains the object for the Lambda function location (see FunctionCodeLocation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionResponse
type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The object for the Lambda function location.
	Code *FunctionCodeLocation `type:"structure"`

	// The concurrent execution limit set for this function. For more information,
	// see concurrent-executions.
	Concurrency *PutFunctionConcurrencyOutput `type:"structure"`

	// A complex type that describes function metadata.
	Configuration *UpdateFunctionConfigurationOutput `type:"structure"`

	// Returns the list of tags associated with the function. For more information,
	// see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetFunctionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFunctionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Code", v, metadata)
	}
	if s.Concurrency != nil {
		v := s.Concurrency

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Concurrency", v, metadata)
	}
	if s.Configuration != nil {
		v := s.Configuration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Configuration", v, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicyRequest
type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// Function name whose resource policy you want to retrieve.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional query parameter to specify a function version
	// or an alias name in which case this API will return all permissions associated
	// with the specific qualified ARN. If you don't provide this parameter, the
	// API will return permissions that apply to the unqualified function ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPolicyInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicyResponse
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The resource policy associated with the specified function. The response
	// returns the same as a string using a backslash ("\") as an escape character
	// in the JSON.
	Policy *string `type:"string"`

	// Represents the latest updated revision of the function or alias.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsyncRequest
type InvokeAsyncInput struct {
	_ struct{} `deprecated:"true" type:"structure" payload:"InvokeArgs"`

	// The Lambda function name. Note that the length constraint applies only to
	// the ARN. If you specify only the function name, it is limited to 64 characters
	// in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// JSON that you want to provide to your Lambda function as input.
	//
	// InvokeArgs is a required field
	InvokeArgs io.ReadSeeker `type:"blob" required:"true"`
}

// String returns the string representation
func (s InvokeAsyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeAsyncInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InvokeAsyncInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.InvokeArgs == nil {
		invalidParams.Add(aws.NewErrParamRequired("InvokeArgs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeAsyncInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvokeArgs != nil {
		v := s.InvokeArgs

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "InvokeArgs", protocol.ReadSeekerStream{V: v}, metadata)
	}
	return nil
}

// Upon success, it returns empty response. Otherwise, throws an exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsyncResponse
type InvokeAsyncOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	responseMetadata aws.Response

	// It will be 202 upon success.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeAsyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s InvokeAsyncOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeAsyncOutput) MarshalFields(e protocol.FieldEncoder) error {
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvocationRequest
type InvokeInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Using the ClientContext you can pass client-specific information to the Lambda
	// function you are invoking. You can then process the client information in
	// your Lambda function as you choose through the context variable. For an example
	// of a ClientContext JSON, see PutEvents (http://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html)
	// in the Amazon Mobile Analytics API Reference and User Guide.
	//
	// The ClientContext JSON must be base64-encoded and has a maximum size of 3583
	// bytes.
	ClientContext *string `location:"header" locationName:"X-Amz-Client-Context" type:"string"`

	// The Lambda function name.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// By default, the Invoke API assumes RequestResponse invocation type. You can
	// optionally request asynchronous execution by specifying Event as the InvocationType.
	// You can also use this parameter to request AWS Lambda to not execute the
	// function but do some verification, such as if the caller is authorized to
	// invoke the function and if the inputs are valid. You request this by specifying
	// DryRun as the InvocationType. This is useful in a cross-account scenario
	// when you want to verify access to a function without running it.
	InvocationType InvocationType `location:"header" locationName:"X-Amz-Invocation-Type" type:"string" enum:"true"`

	// You can set this optional parameter to Tail in the request only if you specify
	// the InvocationType parameter with value RequestResponse. In this case, AWS
	// Lambda returns the base64-encoded last 4 KB of log data produced by your
	// Lambda function in the x-amz-log-result header.
	LogType LogType `location:"header" locationName:"X-Amz-Log-Type" type:"string" enum:"true"`

	// JSON that you want to provide to your Lambda function as input.
	Payload []byte `type:"blob"`

	// You can use this optional parameter to specify a Lambda function version
	// or alias name. If you specify a function version, the API uses the qualified
	// function ARN to invoke a specific Lambda function. If you specify an alias
	// name, the API uses the alias ARN to invoke the Lambda function version to
	// which the alias points.
	//
	// If you don't provide this parameter, then the API uses unqualified function
	// ARN which results in invocation of the $LATEST version.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s InvokeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InvokeInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ClientContext != nil {
		v := *s.ClientContext

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Client-Context", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.InvocationType) > 0 {
		v := s.InvocationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Invocation-Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.LogType) > 0 {
		v := s.LogType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Log-Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Payload != nil {
		v := s.Payload

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Payload", protocol.BytesStream(v), metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Upon success, returns an empty response. Otherwise, throws an exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvocationResponse
type InvokeOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	responseMetadata aws.Response

	// The function version that has been executed. This value is returned only
	// if the invocation type is RequestResponse. For more information, see lambda-traffic-shifting-using-aliases.
	ExecutedVersion *string `location:"header" locationName:"X-Amz-Executed-Version" min:"1" type:"string"`

	// Indicates whether an error occurred while executing the Lambda function.
	// If an error occurred this field will have one of two values; Handled or Unhandled.
	// Handled errors are errors that are reported by the function while the Unhandled
	// errors are those detected and reported by AWS Lambda. Unhandled errors include
	// out of memory errors and function timeouts. For information about how to
	// report an Handled error, see Programming Model (http://docs.aws.amazon.com/lambda/latest/dg/programming-model.html).
	FunctionError *string `location:"header" locationName:"X-Amz-Function-Error" type:"string"`

	// It is the base64-encoded logs for the Lambda function invocation. This is
	// present only if the invocation type is RequestResponse and the logs were
	// requested.
	LogResult *string `location:"header" locationName:"X-Amz-Log-Result" type:"string"`

	// It is the JSON representation of the object returned by the Lambda function.
	// This is present only if the invocation type is RequestResponse.
	//
	// In the event of a function error this field contains a message describing
	// the error. For the Handled errors the Lambda function will report this message.
	// For Unhandled errors AWS Lambda reports the message.
	Payload []byte `type:"blob"`

	// The HTTP status code will be in the 200 range for successful request. For
	// the RequestResponse invocation type this status code will be 200. For the
	// Event invocation type this status code will be 202. For the DryRun invocation
	// type the status code will be 204.
	StatusCode *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s InvokeOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExecutedVersion != nil {
		v := *s.ExecutedVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Executed-Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionError != nil {
		v := *s.FunctionError

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Function-Error", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LogResult != nil {
		v := *s.LogResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amz-Log-Result", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Payload != nil {
		v := s.Payload

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Payload", protocol.BytesStream(v), metadata)
	}
	// ignoring invalid encode state, StatusCode. StatusCode
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliasesRequest
type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Lambda function name for which the alias is created. Note that the length
	// constraint applies only to the ARN. If you specify only the function name,
	// it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// If you specify this optional parameter, the API returns only the aliases
	// that are pointing to the specific Lambda function version, otherwise the
	// API returns all of the aliases created for the Lambda function.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListAliases
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of aliases to return in response.
	// This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAliasesInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAliasesInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionVersion != nil {
		v := *s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "FunctionVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliasesResponse
type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A list of aliases.
	Aliases []UpdateAliasOutput `type:"list"`

	// A string, present if there are more aliases.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListAliasesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAliasesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Aliases) > 0 {
		v := s.Aliases

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Aliases", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappingsRequest
type ListEventSourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis or DynamoDB stream,
	// or an SQS queue. (This parameter is optional.)
	EventSourceArn *string `location:"querystring" locationName:"EventSourceArn" type:"string"`

	// The name of the Lambda function.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 characters in length.
	FunctionName *string `location:"querystring" locationName:"FunctionName" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListEventSourceMappings
	// operation. If present, specifies to continue the list from where the returning
	// call left off.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of event sources to return
	// in response. This value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListEventSourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventSourceMappingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListEventSourceMappingsInput"}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListEventSourceMappingsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains a list of event sources (see EventSourceMappingConfiguration)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappingsResponse
type ListEventSourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// An array of EventSourceMappingConfiguration objects.
	EventSourceMappings []UpdateEventSourceMappingOutput `type:"list"`

	// A string, present if there are more event source mappings.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListEventSourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListEventSourceMappingsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListEventSourceMappingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EventSourceMappings) > 0 {
		v := s.EventSourceMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EventSourceMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsRequest
type ListFunctionsInput struct {
	_ struct{} `type:"structure"`

	// Optional string. If not specified, only the unqualified functions ARNs (Amazon
	// Resource Names) will be returned.
	//
	// Valid value:
	//
	// ALL: Will return all versions, including $LATEST which will have fully qualified
	// ARNs (Amazon Resource Names).
	FunctionVersion FunctionVersion `location:"querystring" locationName:"FunctionVersion" type:"string" enum:"true"`

	// Optional string. An opaque pagination token returned from a previous ListFunctions
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional string. If not specified, will return only regular function versions
	// (i.e., non-replicated versions).
	//
	// Valid values are:
	//
	// The region from which the functions are replicated. For example, if you specify
	// us-east-1, only functions replicated from that region will be returned.
	//
	// ALL: Will return all functions from any region. If specified, you also must
	// specify a valid FunctionVersion parameter.
	MasterRegion *string `location:"querystring" locationName:"MasterRegion" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda functions to
	// return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFunctionsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFunctionsInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.FunctionVersion) > 0 {
		v := s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "FunctionVersion", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MasterRegion != nil {
		v := *s.MasterRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MasterRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains a list of AWS Lambda function configurations (see FunctionConfiguration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsResponse
type ListFunctionsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A list of Lambda functions.
	Functions []UpdateFunctionConfigurationOutput `type:"list"`

	// A string, present if there are more functions.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListFunctionsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFunctionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Functions) > 0 {
		v := s.Functions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Functions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTagsRequest
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the function. For more information, see
	// Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTagsInput"}

	if s.Resource == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTagsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Resource != nil {
		v := *s.Resource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTagsResponse
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The list of tags assigned to the function. For more information, see Tagging
	// Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListTagsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTagsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunctionRequest
type ListVersionsByFunctionInput struct {
	_ struct{} `type:"structure"`

	// Function name whose versions to list. You can specify a function name (for
	// example, Thumbnail) or you can specify Amazon Resource Name (ARN) of the
	// function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Optional string. An opaque pagination token returned from a previous ListVersionsByFunction
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda function versions
	// to return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVersionsByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVersionsByFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListVersionsByFunctionInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListVersionsByFunctionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunctionResponse
type ListVersionsByFunctionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// A string, present if there are more function versions.
	NextMarker *string `type:"string"`

	// A list of Lambda function versions.
	Versions []UpdateFunctionConfigurationOutput `type:"list"`
}

// String returns the string representation
func (s ListVersionsByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListVersionsByFunctionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListVersionsByFunctionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Versions) > 0 {
		v := s.Versions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Versions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersionRequest
type PublishVersionInput struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the deployment package you want to publish. This provides
	// validation on the code you are publishing. If you provide this parameter,
	// the value must match the SHA256 of the $LATEST version for the publication
	// to succeed. You can use the DryRun parameter of UpdateFunctionCode to verify
	// the hash value that will be returned before publishing your new version.
	CodeSha256 *string `type:"string"`

	// The description for the version you are publishing. If not provided, AWS
	// Lambda copies the description from the $LATEST version.
	Description *string `type:"string"`

	// The Lambda function name. You can specify a function name (for example, Thumbnail)
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// arn:aws:lambda:us-west-2:account-id:function:ThumbNail). AWS Lambda also
	// allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either or .
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s PublishVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PublishVersionInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublishVersionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.CodeSha256 != nil {
		v := *s.CodeSha256

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSha256", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrencyRequest
type PutFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the function you are setting concurrent execution limits on.
	// For more information, see concurrent-executions.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The concurrent execution limit reserved for this function. For more information,
	// see concurrent-executions.
	//
	// ReservedConcurrentExecutions is a required field
	ReservedConcurrentExecutions *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PutFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFunctionConcurrencyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutFunctionConcurrencyInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.ReservedConcurrentExecutions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReservedConcurrentExecutions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutFunctionConcurrencyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ReservedConcurrentExecutions != nil {
		v := *s.ReservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Concurrency
type PutFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The number of concurrent executions reserved for this function. For more
	// information, see concurrent-executions.
	ReservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s PutFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutFunctionConcurrencyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutFunctionConcurrencyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReservedConcurrentExecutions != nil {
		v := *s.ReservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermissionRequest
type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// Lambda function whose resource policy you want to remove a permission from.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional parameter to remove permission associated with
	// a specific function version or function alias. If you don't specify this
	// parameter, the API removes permission associated with the unqualified function
	// ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either or .
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// Statement ID of the permission to remove.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemovePermissionInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if s.StatementId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemovePermissionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatementId != nil {
		v := *s.StatementId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "StatementId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermissionOutput
type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s RemovePermissionOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemovePermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResourceRequest
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the Lambda function. For more information,
	// see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`

	// The list of tags (key-value pairs) you are assigning to the Lambda function.
	// For more information, see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Tags is a required field
	Tags map[string]string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagResourceInput"}

	if s.Resource == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resource"))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagResourceInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Resource != nil {
		v := *s.Resource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResourceOutput
type TagResourceOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s TagResourceOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagResourceOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// The parent object that contains your function's tracing settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TracingConfig
type TracingConfig struct {
	_ struct{} `type:"structure"`

	// Can be either PassThrough or Active. If PassThrough, Lambda will only trace
	// the request from an upstream service if it contains a tracing header with
	// "sampled=1". If Active, Lambda will respect any tracing header it receives
	// from an upstream service. If no tracing header is received, Lambda will call
	// X-Ray for a tracing decision.
	Mode TracingMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s TracingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TracingConfig) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TracingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Parent object of the tracing information associated with your Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TracingConfigResponse
type TracingConfigResponse struct {
	_ struct{} `type:"structure"`

	// The tracing mode associated with your Lambda function.
	Mode TracingMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s TracingConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TracingConfigResponse) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TracingConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResourceRequest
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the function. For more information, see
	// Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`

	// The list of tag keys to be deleted from the function. For more information,
	// see Tagging Lambda Functions (http://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// in the AWS Lambda Developer Guide.
	//
	// TagKeys is a required field
	TagKeys []string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagResourceInput"}

	if s.Resource == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resource"))
	}

	if s.TagKeys == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UntagResourceInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Resource != nil {
		v := *s.Resource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TagKeys) > 0 {
		v := s.TagKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "tagKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResourceOutput
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UntagResourceOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UntagResourceOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAliasRequest
type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// You can change the description of the alias using this parameter.
	Description *string `type:"string"`

	// The function name for which the alias is created. Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this parameter you can change the Lambda function version to which
	// the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// The alias name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either or .
	RevisionId *string `type:"string"`

	// Specifies an additional version your alias can point to, allowing you to
	// dictate what percentage of traffic will invoke each version. For more information,
	// see lambda-traffic-shifting-using-aliases.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAliasInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionVersion", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAliasInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionVersion != nil {
		v := *s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoutingConfig != nil {
		v := s.RoutingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RoutingConfig", v, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides configuration information about a Lambda function version alias.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAliasOutput
type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// Lambda function ARN that is qualified using the alias name as the suffix.
	// For example, if you create an alias called BETA that points to a helloworld
	// function version, the ARN is arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA.
	AliasArn *string `type:"string"`

	// Alias description.
	Description *string `type:"string"`

	// Function version to which the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// Alias name.
	Name *string `min:"1" type:"string"`

	// Represents the latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// Specifies an additional function versions the alias points to, allowing you
	// to dictate what percentage of traffic will invoke each version. For more
	// information, see lambda-traffic-shifting-using-aliases.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateAliasOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAliasOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AliasArn != nil {
		v := *s.AliasArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AliasArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionVersion != nil {
		v := *s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoutingConfig != nil {
		v := s.RoutingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RoutingConfig", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMappingRequest
type UpdateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of stream records that can be sent to your Lambda function
	// for a single invocation.
	BatchSize *int64 `min:"1" type:"integer"`

	// Specifies whether AWS Lambda should actively poll the stream or not. If disabled,
	// AWS Lambda will not poll the stream.
	Enabled *bool `type:"boolean"`

	// The Lambda function to which you want the stream records sent.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). For
	// more information about versioning, see AWS Lambda Function Versioning and
	// Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
	//
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `min:"1" type:"string"`

	// The event source mapping identifier.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventSourceMappingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("BatchSize", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.UUID == nil {
		invalidParams.Add(aws.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEventSourceMappingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes mapping between an Amazon Kinesis or DynamoDB stream or an Amazon
// SQS queue and a Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMappingOutput
type UpdateEventSourceMappingOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis or DynamoDB stream or
	// the SQS queue that is the source of events.
	EventSourceArn *string `type:"string"`

	// The Lambda function to invoke when AWS Lambda detects an event on the poll-based
	// source.
	FunctionArn *string `type:"string"`

	// The UTC time string indicating the last time the event mapping was updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be Creating, Enabled, Disabled,
	// Enabling, Disabling, Updating, or Deleting.
	State *string `type:"string"`

	// The reason the event source mapping is in its current state. It is either
	// user-requested or an AWS Lambda-initiated state transition.
	StateTransitionReason *string `type:"string"`

	// The AWS Lambda assigned opaque identifier for the mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s UpdateEventSourceMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateEventSourceMappingOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEventSourceMappingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastProcessingResult != nil {
		v := *s.LastProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateTransitionReason != nil {
		v := *s.StateTransitionReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateTransitionReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCodeRequest
type UpdateFunctionCodeInput struct {
	_ struct{} `type:"structure"`

	// This boolean parameter can be used to test your request to AWS Lambda to
	// update the Lambda function and publish a version as an atomic operation.
	// It will do all necessary computation and validation of your code but will
	// not upload it or a publish a version. Each time this operation is invoked,
	// the CodeSha256 hash value of the provided code will also be computed and
	// returned in the response.
	DryRun *bool `type:"boolean"`

	// The existing Lambda function name whose code you want to replace.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// This boolean parameter can be used to request AWS Lambda to update the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either or .
	RevisionId *string `type:"string"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS Region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The contents of your zip file containing your deployment package. If you
	// are using the web API directly, the contents of the zip file must be base64-encoded.
	// If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the
	// encoding for you. For more information about creating a .zip file, see Execution
	// Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html).
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s UpdateFunctionCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionCodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFunctionCodeInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFunctionCodeInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DryRun != nil {
		v := *s.DryRun

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DryRun", protocol.BoolValue(v), metadata)
	}
	if s.Publish != nil {
		v := *s.Publish

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Publish", protocol.BoolValue(v), metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3ObjectVersion != nil {
		v := *s.S3ObjectVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3ObjectVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipFile != nil {
		v := s.ZipFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipFile", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfigurationRequest
type UpdateFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The parent object that contains the target ARN (Amazon Resource Name) of
	// an Amazon SQS queue or Amazon SNS topic. For more information, see dlq.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A short user-defined function description. AWS Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *Environment `type:"structure"`

	// The name of the Lambda function.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function that Lambda calls to begin executing your function. For Node.js,
	// it is the module-name.export value in your function.
	Handler *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If you elect to use the AWS Lambda default service
	// key, pass in an empty string ("") for this parameter.
	KMSKeyArn *string `type:"string"`

	// The amount of memory, in MB, your Lambda function is given. AWS Lambda uses
	// this memory size to infer the amount of CPU allocated to your function. Your
	// function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// An optional value you can use to ensure you are updating the latest update
	// of the function version or alias. If the RevisionID you pass doesn't match
	// the latest RevisionId of the function or alias, it will fail with an error
	// message, advising you to retrieve the latest function version or alias RevisionID
	// using either or .
	RevisionId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda will assume when
	// it executes your function.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	//
	// To use the Python runtime v3.6, set the value to "python3.6". To use the
	// Python runtime v2.7, set the value to "python2.7". To use the Node.js runtime
	// v6.10, set the value to "nodejs6.10". To use the Node.js runtime v4.3, set
	// the value to "nodejs4.3". To use the .NET Core runtime v1.0, set the value
	// to "dotnetcore1.0". To use the .NET Core runtime v2.0, set the value to "dotnetcore2.0".
	//
	// Node v0.10.42 is currently marked as deprecated. You must migrate existing
	// functions to the newer Node.js runtime versions available on AWS Lambda (nodejs4.3
	// or nodejs6.10) as soon as possible. Failure to do so will result in an invalid
	// parameter error being returned. Note that you will have to follow this procedure
	// for each region that contains functions written in the Node v0.10.42 runtime.
	Runtime Runtime `type:"string" enum:"true"`

	// The function execution time at which AWS Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// The parent object that contains your function's tracing settings.
	TracingConfig *TracingConfig `type:"structure"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFunctionConfigurationInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(aws.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFunctionConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DeadLetterConfig != nil {
		v := s.DeadLetterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeadLetterConfig", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KMSKeyArn != nil {
		v := *s.KMSKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemorySize != nil {
		v := *s.MemorySize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemorySize", protocol.Int64Value(v), metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Runtime) > 0 {
		v := s.Runtime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Runtime", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	if s.TracingConfig != nil {
		v := s.TracingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TracingConfig", v, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A complex type that describes function metadata.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCodeOutput
type UpdateFunctionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// It is the SHA256 hash of your function deployment package.
	CodeSha256 *string `type:"string"`

	// The size, in bytes, of the function .zip file you uploaded.
	CodeSize *int64 `type:"long"`

	// The parent object that contains the target ARN (Amazon Resource Name) of
	// an Amazon SQS queue or Amazon SNS topic. For more information, see dlq.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The user-provided description.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *EnvironmentResponse `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the function.
	FunctionArn *string `type:"string"`

	// The name of the function. Note that the length constraint applies only to
	// the ARN. If you specify only the function name, it is limited to 64 characters
	// in length.
	FunctionName *string `min:"1" type:"string"`

	// The function Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If empty, it means you are using the AWS Lambda default
	// service key.
	KMSKeyArn *string `type:"string"`

	// The time stamp of the last time you updated the function. The time stamp
	// is conveyed as a string complying with ISO-8601 in this way YYYY-MM-DDThh:mm:ssTZD
	// (e.g., 1997-07-16T19:20:30+01:00). For more information, see Date and Time
	// Formats (https://www.w3.org/TR/NOTE-datetime).
	LastModified *string `type:"string"`

	// Returns the ARN (Amazon Resource Name) of the master function.
	MasterArn *string `type:"string"`

	// The memory size, in MB, you configured for the function. Must be a multiple
	// of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// Represents the latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime Runtime `type:"string" enum:"true"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// The parent object that contains your function's tracing settings.
	TracingConfig *TracingConfigResponse `type:"structure"`

	// The version of the Lambda function.
	Version *string `min:"1" type:"string"`

	// VPC configuration associated with your Lambda function.
	VpcConfig *VpcConfigResponse `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UpdateFunctionConfigurationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFunctionConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeSha256 != nil {
		v := *s.CodeSha256

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSha256", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CodeSize != nil {
		v := *s.CodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSize", protocol.Int64Value(v), metadata)
	}
	if s.DeadLetterConfig != nil {
		v := s.DeadLetterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeadLetterConfig", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KMSKeyArn != nil {
		v := *s.KMSKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MasterArn != nil {
		v := *s.MasterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MasterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemorySize != nil {
		v := *s.MemorySize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemorySize", protocol.Int64Value(v), metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Runtime) > 0 {
		v := s.Runtime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Runtime", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	if s.TracingConfig != nil {
		v := s.TracingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TracingConfig", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

// If your Lambda function accesses resources in a VPC, you provide this parameter
// identifying the list of security group IDs and subnet IDs. These must belong
// to the same VPC. You must provide at least one security group and one subnet
// ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/VpcConfig
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security groups IDs in your VPC.
	SecurityGroupIds []string `type:"list"`

	// A list of one or more subnet IDs in your VPC.
	SubnetIds []string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.SecurityGroupIds) > 0 {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SubnetIds) > 0 {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// VPC configuration associated with your Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/VpcConfigResponse
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// A list of security group IDs associated with the Lambda function.
	SecurityGroupIds []string `type:"list"`

	// A list of subnet IDs associated with the Lambda function.
	SubnetIds []string `type:"list"`

	// The VPC ID associated with you Lambda function.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.SecurityGroupIds) > 0 {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SubnetIds) > 0 {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type EventSourcePosition string

// Enum values for EventSourcePosition
const (
	EventSourcePositionTrimHorizon EventSourcePosition = "TRIM_HORIZON"
	EventSourcePositionLatest      EventSourcePosition = "LATEST"
	EventSourcePositionAtTimestamp EventSourcePosition = "AT_TIMESTAMP"
)

func (enum EventSourcePosition) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum EventSourcePosition) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type FunctionVersion string

// Enum values for FunctionVersion
const (
	FunctionVersionAll FunctionVersion = "ALL"
)

func (enum FunctionVersion) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FunctionVersion) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type InvocationType string

// Enum values for InvocationType
const (
	InvocationTypeEvent           InvocationType = "Event"
	InvocationTypeRequestResponse InvocationType = "RequestResponse"
	InvocationTypeDryRun          InvocationType = "DryRun"
)

func (enum InvocationType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum InvocationType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type LogType string

// Enum values for LogType
const (
	LogTypeNone LogType = "None"
	LogTypeTail LogType = "Tail"
)

func (enum LogType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum LogType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Runtime string

// Enum values for Runtime
const (
	RuntimeNodejs       Runtime = "nodejs"
	RuntimeNodejs43     Runtime = "nodejs4.3"
	RuntimeNodejs610    Runtime = "nodejs6.10"
	RuntimeNodejs810    Runtime = "nodejs8.10"
	RuntimeJava8        Runtime = "java8"
	RuntimePython27     Runtime = "python2.7"
	RuntimePython36     Runtime = "python3.6"
	RuntimeDotnetcore10 Runtime = "dotnetcore1.0"
	RuntimeDotnetcore20 Runtime = "dotnetcore2.0"
	RuntimeDotnetcore21 Runtime = "dotnetcore2.1"
	RuntimeNodejs43Edge Runtime = "nodejs4.3-edge"
	RuntimeGo1X         Runtime = "go1.x"
)

func (enum Runtime) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Runtime) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ThrottleReason string

// Enum values for ThrottleReason
const (
	ThrottleReasonConcurrentInvocationLimitExceeded                 ThrottleReason = "ConcurrentInvocationLimitExceeded"
	ThrottleReasonFunctionInvocationRateLimitExceeded               ThrottleReason = "FunctionInvocationRateLimitExceeded"
	ThrottleReasonReservedFunctionConcurrentInvocationLimitExceeded ThrottleReason = "ReservedFunctionConcurrentInvocationLimitExceeded"
	ThrottleReasonReservedFunctionInvocationRateLimitExceeded       ThrottleReason = "ReservedFunctionInvocationRateLimitExceeded"
	ThrottleReasonCallerRateLimitExceeded                           ThrottleReason = "CallerRateLimitExceeded"
)

func (enum ThrottleReason) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ThrottleReason) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type TracingMode string

// Enum values for TracingMode
const (
	TracingModeActive      TracingMode = "Active"
	TracingModePassThrough TracingMode = "PassThrough"
)

func (enum TracingMode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum TracingMode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
