// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

const opAssociateKmsKey = "AssociateKmsKey"

// AssociateKmsKeyRequest is a API request type for the AssociateKmsKey API operation.
type AssociateKmsKeyRequest struct {
	*aws.Request
	Input *AssociateKmsKeyInput
	Copy  func(*AssociateKmsKeyInput) AssociateKmsKeyRequest
}

// Send marshals and sends the AssociateKmsKey API request.
func (r AssociateKmsKeyRequest) Send() (*AssociateKmsKeyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*AssociateKmsKeyOutput), nil
}

// AssociateKmsKeyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Associates the specified AWS Key Management Service (AWS KMS) customer master
// key (CMK) with the specified log group.
//
// Associating an AWS KMS CMK with a log group overrides any existing associations
// between the log group and a CMK. After a CMK is associated with a log group,
// all newly ingested data for the log group is encrypted using the CMK. This
// association is stored as long as the data encrypted with the CMK is still
// within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs to decrypt
// this data whenever it is requested.
//
// Note that it can take up to 5 minutes for this operation to take effect.
//
// If you attempt to associate a CMK with a log group but the CMK does not exist
// or the CMK is disabled, you will receive an InvalidParameterException error.
//
//    // Example sending a request using the AssociateKmsKeyRequest method.
//    req := client.AssociateKmsKeyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKey
func (c *CloudWatchLogs) AssociateKmsKeyRequest(input *AssociateKmsKeyInput) AssociateKmsKeyRequest {
	op := &aws.Operation{
		Name:       opAssociateKmsKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateKmsKeyInput{}
	}

	output := &AssociateKmsKeyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return AssociateKmsKeyRequest{Request: req, Input: input, Copy: c.AssociateKmsKeyRequest}
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest is a API request type for the CancelExportTask API operation.
type CancelExportTaskRequest struct {
	*aws.Request
	Input *CancelExportTaskInput
	Copy  func(*CancelExportTaskInput) CancelExportTaskRequest
}

// Send marshals and sends the CancelExportTask API request.
func (r CancelExportTaskRequest) Send() (*CancelExportTaskOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CancelExportTaskOutput), nil
}

// CancelExportTaskRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Cancels the specified export task.
//
// The task must be in the PENDING or RUNNING state.
//
//    // Example sending a request using the CancelExportTaskRequest method.
//    req := client.CancelExportTaskRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CancelExportTask
func (c *CloudWatchLogs) CancelExportTaskRequest(input *CancelExportTaskInput) CancelExportTaskRequest {
	op := &aws.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	output := &CancelExportTaskOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return CancelExportTaskRequest{Request: req, Input: input, Copy: c.CancelExportTaskRequest}
}

const opCreateExportTask = "CreateExportTask"

// CreateExportTaskRequest is a API request type for the CreateExportTask API operation.
type CreateExportTaskRequest struct {
	*aws.Request
	Input *CreateExportTaskInput
	Copy  func(*CreateExportTaskInput) CreateExportTaskRequest
}

// Send marshals and sends the CreateExportTask API request.
func (r CreateExportTaskRequest) Send() (*CreateExportTaskOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateExportTaskOutput), nil
}

// CreateExportTaskRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates an export task, which allows you to efficiently export data from
// a log group to an Amazon S3 bucket.
//
// This is an asynchronous call. If all the required information is provided,
// this operation initiates an export task and responds with the ID of the task.
// After the task has started, you can use DescribeExportTasks to get the status
// of the export task. Each account can only have one active (RUNNING or PENDING)
// export task at a time. To cancel an export task, use CancelExportTask.
//
// You can export logs from multiple log groups or multiple time ranges to the
// same S3 bucket. To separate out log data for each export task, you can specify
// a prefix to be used as the Amazon S3 key prefix for all exported objects.
//
//    // Example sending a request using the CreateExportTaskRequest method.
//    req := client.CreateExportTaskRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateExportTask
func (c *CloudWatchLogs) CreateExportTaskRequest(input *CreateExportTaskInput) CreateExportTaskRequest {
	op := &aws.Operation{
		Name:       opCreateExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExportTaskInput{}
	}

	output := &CreateExportTaskOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return CreateExportTaskRequest{Request: req, Input: input, Copy: c.CreateExportTaskRequest}
}

const opCreateLogGroup = "CreateLogGroup"

// CreateLogGroupRequest is a API request type for the CreateLogGroup API operation.
type CreateLogGroupRequest struct {
	*aws.Request
	Input *CreateLogGroupInput
	Copy  func(*CreateLogGroupInput) CreateLogGroupRequest
}

// Send marshals and sends the CreateLogGroup API request.
func (r CreateLogGroupRequest) Send() (*CreateLogGroupOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateLogGroupOutput), nil
}

// CreateLogGroupRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates a log group with the specified name.
//
// You can create up to 5000 log groups per account.
//
// You must use the following guidelines when naming a log group:
//
//    * Log group names must be unique within a region for an AWS account.
//
//    * Log group names can be between 1 and 512 characters long.
//
//    * Log group names consist of the following characters: a-z, A-Z, 0-9,
//    '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
//
// If you associate a AWS Key Management Service (AWS KMS) customer master key
// (CMK) with the log group, ingested data is encrypted using the CMK. This
// association is stored as long as the data encrypted with the CMK is still
// within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs to decrypt
// this data whenever it is requested.
//
// If you attempt to associate a CMK with the log group but the CMK does not
// exist or the CMK is disabled, you will receive an InvalidParameterException
// error.
//
//    // Example sending a request using the CreateLogGroupRequest method.
//    req := client.CreateLogGroupRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogGroup
func (c *CloudWatchLogs) CreateLogGroupRequest(input *CreateLogGroupInput) CreateLogGroupRequest {
	op := &aws.Operation{
		Name:       opCreateLogGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLogGroupInput{}
	}

	output := &CreateLogGroupOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return CreateLogGroupRequest{Request: req, Input: input, Copy: c.CreateLogGroupRequest}
}

const opCreateLogStream = "CreateLogStream"

// CreateLogStreamRequest is a API request type for the CreateLogStream API operation.
type CreateLogStreamRequest struct {
	*aws.Request
	Input *CreateLogStreamInput
	Copy  func(*CreateLogStreamInput) CreateLogStreamRequest
}

// Send marshals and sends the CreateLogStream API request.
func (r CreateLogStreamRequest) Send() (*CreateLogStreamOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*CreateLogStreamOutput), nil
}

// CreateLogStreamRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates a log stream for the specified log group.
//
// There is no limit on the number of log streams that you can create for a
// log group.
//
// You must use the following guidelines when naming a log stream:
//
//    * Log stream names must be unique within the log group.
//
//    * Log stream names can be between 1 and 512 characters long.
//
//    * The ':' (colon) and '*' (asterisk) characters are not allowed.
//
//    // Example sending a request using the CreateLogStreamRequest method.
//    req := client.CreateLogStreamRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogStream
func (c *CloudWatchLogs) CreateLogStreamRequest(input *CreateLogStreamInput) CreateLogStreamRequest {
	op := &aws.Operation{
		Name:       opCreateLogStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLogStreamInput{}
	}

	output := &CreateLogStreamOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return CreateLogStreamRequest{Request: req, Input: input, Copy: c.CreateLogStreamRequest}
}

const opDeleteDestination = "DeleteDestination"

// DeleteDestinationRequest is a API request type for the DeleteDestination API operation.
type DeleteDestinationRequest struct {
	*aws.Request
	Input *DeleteDestinationInput
	Copy  func(*DeleteDestinationInput) DeleteDestinationRequest
}

// Send marshals and sends the DeleteDestination API request.
func (r DeleteDestinationRequest) Send() (*DeleteDestinationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteDestinationOutput), nil
}

// DeleteDestinationRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified destination, and eventually disables all the subscription
// filters that publish to it. This operation does not delete the physical resource
// encapsulated by the destination.
//
//    // Example sending a request using the DeleteDestinationRequest method.
//    req := client.DeleteDestinationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDestination
func (c *CloudWatchLogs) DeleteDestinationRequest(input *DeleteDestinationInput) DeleteDestinationRequest {
	op := &aws.Operation{
		Name:       opDeleteDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDestinationInput{}
	}

	output := &DeleteDestinationOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteDestinationRequest{Request: req, Input: input, Copy: c.DeleteDestinationRequest}
}

const opDeleteLogGroup = "DeleteLogGroup"

// DeleteLogGroupRequest is a API request type for the DeleteLogGroup API operation.
type DeleteLogGroupRequest struct {
	*aws.Request
	Input *DeleteLogGroupInput
	Copy  func(*DeleteLogGroupInput) DeleteLogGroupRequest
}

// Send marshals and sends the DeleteLogGroup API request.
func (r DeleteLogGroupRequest) Send() (*DeleteLogGroupOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteLogGroupOutput), nil
}

// DeleteLogGroupRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified log group and permanently deletes all the archived
// log events associated with the log group.
//
//    // Example sending a request using the DeleteLogGroupRequest method.
//    req := client.DeleteLogGroupRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogGroup
func (c *CloudWatchLogs) DeleteLogGroupRequest(input *DeleteLogGroupInput) DeleteLogGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteLogGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLogGroupInput{}
	}

	output := &DeleteLogGroupOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteLogGroupRequest{Request: req, Input: input, Copy: c.DeleteLogGroupRequest}
}

const opDeleteLogStream = "DeleteLogStream"

// DeleteLogStreamRequest is a API request type for the DeleteLogStream API operation.
type DeleteLogStreamRequest struct {
	*aws.Request
	Input *DeleteLogStreamInput
	Copy  func(*DeleteLogStreamInput) DeleteLogStreamRequest
}

// Send marshals and sends the DeleteLogStream API request.
func (r DeleteLogStreamRequest) Send() (*DeleteLogStreamOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteLogStreamOutput), nil
}

// DeleteLogStreamRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified log stream and permanently deletes all the archived
// log events associated with the log stream.
//
//    // Example sending a request using the DeleteLogStreamRequest method.
//    req := client.DeleteLogStreamRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogStream
func (c *CloudWatchLogs) DeleteLogStreamRequest(input *DeleteLogStreamInput) DeleteLogStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteLogStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLogStreamInput{}
	}

	output := &DeleteLogStreamOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteLogStreamRequest{Request: req, Input: input, Copy: c.DeleteLogStreamRequest}
}

const opDeleteMetricFilter = "DeleteMetricFilter"

// DeleteMetricFilterRequest is a API request type for the DeleteMetricFilter API operation.
type DeleteMetricFilterRequest struct {
	*aws.Request
	Input *DeleteMetricFilterInput
	Copy  func(*DeleteMetricFilterInput) DeleteMetricFilterRequest
}

// Send marshals and sends the DeleteMetricFilter API request.
func (r DeleteMetricFilterRequest) Send() (*DeleteMetricFilterOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteMetricFilterOutput), nil
}

// DeleteMetricFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified metric filter.
//
//    // Example sending a request using the DeleteMetricFilterRequest method.
//    req := client.DeleteMetricFilterRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteMetricFilter
func (c *CloudWatchLogs) DeleteMetricFilterRequest(input *DeleteMetricFilterInput) DeleteMetricFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteMetricFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMetricFilterInput{}
	}

	output := &DeleteMetricFilterOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteMetricFilterRequest{Request: req, Input: input, Copy: c.DeleteMetricFilterRequest}
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest is a API request type for the DeleteResourcePolicy API operation.
type DeleteResourcePolicyRequest struct {
	*aws.Request
	Input *DeleteResourcePolicyInput
	Copy  func(*DeleteResourcePolicyInput) DeleteResourcePolicyRequest
}

// Send marshals and sends the DeleteResourcePolicy API request.
func (r DeleteResourcePolicyRequest) Send() (*DeleteResourcePolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteResourcePolicyOutput), nil
}

// DeleteResourcePolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes a resource policy from this account. This revokes the access of the
// identities in that policy to put log events to this account.
//
//    // Example sending a request using the DeleteResourcePolicyRequest method.
//    req := client.DeleteResourcePolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteResourcePolicy
func (c *CloudWatchLogs) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) DeleteResourcePolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output := &DeleteResourcePolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteResourcePolicyRequest{Request: req, Input: input, Copy: c.DeleteResourcePolicyRequest}
}

const opDeleteRetentionPolicy = "DeleteRetentionPolicy"

// DeleteRetentionPolicyRequest is a API request type for the DeleteRetentionPolicy API operation.
type DeleteRetentionPolicyRequest struct {
	*aws.Request
	Input *DeleteRetentionPolicyInput
	Copy  func(*DeleteRetentionPolicyInput) DeleteRetentionPolicyRequest
}

// Send marshals and sends the DeleteRetentionPolicy API request.
func (r DeleteRetentionPolicyRequest) Send() (*DeleteRetentionPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteRetentionPolicyOutput), nil
}

// DeleteRetentionPolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified retention policy.
//
// Log events do not expire if they belong to log groups without a retention
// policy.
//
//    // Example sending a request using the DeleteRetentionPolicyRequest method.
//    req := client.DeleteRetentionPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteRetentionPolicy
func (c *CloudWatchLogs) DeleteRetentionPolicyRequest(input *DeleteRetentionPolicyInput) DeleteRetentionPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRetentionPolicyInput{}
	}

	output := &DeleteRetentionPolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteRetentionPolicyRequest{Request: req, Input: input, Copy: c.DeleteRetentionPolicyRequest}
}

const opDeleteSubscriptionFilter = "DeleteSubscriptionFilter"

// DeleteSubscriptionFilterRequest is a API request type for the DeleteSubscriptionFilter API operation.
type DeleteSubscriptionFilterRequest struct {
	*aws.Request
	Input *DeleteSubscriptionFilterInput
	Copy  func(*DeleteSubscriptionFilterInput) DeleteSubscriptionFilterRequest
}

// Send marshals and sends the DeleteSubscriptionFilter API request.
func (r DeleteSubscriptionFilterRequest) Send() (*DeleteSubscriptionFilterOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DeleteSubscriptionFilterOutput), nil
}

// DeleteSubscriptionFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Deletes the specified subscription filter.
//
//    // Example sending a request using the DeleteSubscriptionFilterRequest method.
//    req := client.DeleteSubscriptionFilterRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilter
func (c *CloudWatchLogs) DeleteSubscriptionFilterRequest(input *DeleteSubscriptionFilterInput) DeleteSubscriptionFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteSubscriptionFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubscriptionFilterInput{}
	}

	output := &DeleteSubscriptionFilterOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DeleteSubscriptionFilterRequest{Request: req, Input: input, Copy: c.DeleteSubscriptionFilterRequest}
}

const opDescribeDestinations = "DescribeDestinations"

// DescribeDestinationsRequest is a API request type for the DescribeDestinations API operation.
type DescribeDestinationsRequest struct {
	*aws.Request
	Input *DescribeDestinationsInput
	Copy  func(*DescribeDestinationsInput) DescribeDestinationsRequest
}

// Send marshals and sends the DescribeDestinations API request.
func (r DescribeDestinationsRequest) Send() (*DescribeDestinationsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeDestinationsOutput), nil
}

// DescribeDestinationsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists all your destinations. The results are ASCII-sorted by destination
// name.
//
//    // Example sending a request using the DescribeDestinationsRequest method.
//    req := client.DescribeDestinationsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations
func (c *CloudWatchLogs) DescribeDestinationsRequest(input *DescribeDestinationsInput) DescribeDestinationsRequest {
	op := &aws.Operation{
		Name:       opDescribeDestinations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDestinationsInput{}
	}

	output := &DescribeDestinationsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeDestinationsRequest{Request: req, Input: input, Copy: c.DescribeDestinationsRequest}
}

// Paginate pages iterates over the pages of a DescribeDestinationsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDestinations operation.
//		req := client.DescribeDestinationsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeDestinationsRequest) Paginate(opts ...aws.Option) DescribeDestinationsPager {
	return DescribeDestinationsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeDestinationsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeDestinationsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeDestinationsPager struct {
	aws.Pager
}

func (p *DescribeDestinationsPager) CurrentPage() *DescribeDestinationsOutput {
	return p.Pager.CurrentPage().(*DescribeDestinationsOutput)
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest is a API request type for the DescribeExportTasks API operation.
type DescribeExportTasksRequest struct {
	*aws.Request
	Input *DescribeExportTasksInput
	Copy  func(*DescribeExportTasksInput) DescribeExportTasksRequest
}

// Send marshals and sends the DescribeExportTasks API request.
func (r DescribeExportTasksRequest) Send() (*DescribeExportTasksOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeExportTasksOutput), nil
}

// DescribeExportTasksRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the specified export tasks. You can list all your export tasks or filter
// the results based on task ID or task status.
//
//    // Example sending a request using the DescribeExportTasksRequest method.
//    req := client.DescribeExportTasksRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasks
func (c *CloudWatchLogs) DescribeExportTasksRequest(input *DescribeExportTasksInput) DescribeExportTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output := &DescribeExportTasksOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeExportTasksRequest{Request: req, Input: input, Copy: c.DescribeExportTasksRequest}
}

const opDescribeLogGroups = "DescribeLogGroups"

// DescribeLogGroupsRequest is a API request type for the DescribeLogGroups API operation.
type DescribeLogGroupsRequest struct {
	*aws.Request
	Input *DescribeLogGroupsInput
	Copy  func(*DescribeLogGroupsInput) DescribeLogGroupsRequest
}

// Send marshals and sends the DescribeLogGroups API request.
func (r DescribeLogGroupsRequest) Send() (*DescribeLogGroupsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeLogGroupsOutput), nil
}

// DescribeLogGroupsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the specified log groups. You can list all your log groups or filter
// the results by prefix. The results are ASCII-sorted by log group name.
//
//    // Example sending a request using the DescribeLogGroupsRequest method.
//    req := client.DescribeLogGroupsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups
func (c *CloudWatchLogs) DescribeLogGroupsRequest(input *DescribeLogGroupsInput) DescribeLogGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeLogGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLogGroupsInput{}
	}

	output := &DescribeLogGroupsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeLogGroupsRequest{Request: req, Input: input, Copy: c.DescribeLogGroupsRequest}
}

// Paginate pages iterates over the pages of a DescribeLogGroupsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLogGroups operation.
//		req := client.DescribeLogGroupsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeLogGroupsRequest) Paginate(opts ...aws.Option) DescribeLogGroupsPager {
	return DescribeLogGroupsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeLogGroupsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeLogGroupsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeLogGroupsPager struct {
	aws.Pager
}

func (p *DescribeLogGroupsPager) CurrentPage() *DescribeLogGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeLogGroupsOutput)
}

const opDescribeLogStreams = "DescribeLogStreams"

// DescribeLogStreamsRequest is a API request type for the DescribeLogStreams API operation.
type DescribeLogStreamsRequest struct {
	*aws.Request
	Input *DescribeLogStreamsInput
	Copy  func(*DescribeLogStreamsInput) DescribeLogStreamsRequest
}

// Send marshals and sends the DescribeLogStreams API request.
func (r DescribeLogStreamsRequest) Send() (*DescribeLogStreamsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeLogStreamsOutput), nil
}

// DescribeLogStreamsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the log streams for the specified log group. You can list all the log
// streams or filter the results by prefix. You can also control how the results
// are ordered.
//
// This operation has a limit of five transactions per second, after which transactions
// are throttled.
//
//    // Example sending a request using the DescribeLogStreamsRequest method.
//    req := client.DescribeLogStreamsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreams
func (c *CloudWatchLogs) DescribeLogStreamsRequest(input *DescribeLogStreamsInput) DescribeLogStreamsRequest {
	op := &aws.Operation{
		Name:       opDescribeLogStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLogStreamsInput{}
	}

	output := &DescribeLogStreamsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeLogStreamsRequest{Request: req, Input: input, Copy: c.DescribeLogStreamsRequest}
}

// Paginate pages iterates over the pages of a DescribeLogStreamsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLogStreams operation.
//		req := client.DescribeLogStreamsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeLogStreamsRequest) Paginate(opts ...aws.Option) DescribeLogStreamsPager {
	return DescribeLogStreamsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeLogStreamsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeLogStreamsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeLogStreamsPager struct {
	aws.Pager
}

func (p *DescribeLogStreamsPager) CurrentPage() *DescribeLogStreamsOutput {
	return p.Pager.CurrentPage().(*DescribeLogStreamsOutput)
}

const opDescribeMetricFilters = "DescribeMetricFilters"

// DescribeMetricFiltersRequest is a API request type for the DescribeMetricFilters API operation.
type DescribeMetricFiltersRequest struct {
	*aws.Request
	Input *DescribeMetricFiltersInput
	Copy  func(*DescribeMetricFiltersInput) DescribeMetricFiltersRequest
}

// Send marshals and sends the DescribeMetricFilters API request.
func (r DescribeMetricFiltersRequest) Send() (*DescribeMetricFiltersOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeMetricFiltersOutput), nil
}

// DescribeMetricFiltersRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the specified metric filters. You can list all the metric filters or
// filter the results by log name, prefix, metric name, or metric namespace.
// The results are ASCII-sorted by filter name.
//
//    // Example sending a request using the DescribeMetricFiltersRequest method.
//    req := client.DescribeMetricFiltersRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters
func (c *CloudWatchLogs) DescribeMetricFiltersRequest(input *DescribeMetricFiltersInput) DescribeMetricFiltersRequest {
	op := &aws.Operation{
		Name:       opDescribeMetricFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMetricFiltersInput{}
	}

	output := &DescribeMetricFiltersOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeMetricFiltersRequest{Request: req, Input: input, Copy: c.DescribeMetricFiltersRequest}
}

// Paginate pages iterates over the pages of a DescribeMetricFiltersRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeMetricFilters operation.
//		req := client.DescribeMetricFiltersRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeMetricFiltersRequest) Paginate(opts ...aws.Option) DescribeMetricFiltersPager {
	return DescribeMetricFiltersPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeMetricFiltersInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeMetricFiltersPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeMetricFiltersPager struct {
	aws.Pager
}

func (p *DescribeMetricFiltersPager) CurrentPage() *DescribeMetricFiltersOutput {
	return p.Pager.CurrentPage().(*DescribeMetricFiltersOutput)
}

const opDescribeResourcePolicies = "DescribeResourcePolicies"

// DescribeResourcePoliciesRequest is a API request type for the DescribeResourcePolicies API operation.
type DescribeResourcePoliciesRequest struct {
	*aws.Request
	Input *DescribeResourcePoliciesInput
	Copy  func(*DescribeResourcePoliciesInput) DescribeResourcePoliciesRequest
}

// Send marshals and sends the DescribeResourcePolicies API request.
func (r DescribeResourcePoliciesRequest) Send() (*DescribeResourcePoliciesOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeResourcePoliciesOutput), nil
}

// DescribeResourcePoliciesRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the resource policies in this account.
//
//    // Example sending a request using the DescribeResourcePoliciesRequest method.
//    req := client.DescribeResourcePoliciesRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePolicies
func (c *CloudWatchLogs) DescribeResourcePoliciesRequest(input *DescribeResourcePoliciesInput) DescribeResourcePoliciesRequest {
	op := &aws.Operation{
		Name:       opDescribeResourcePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourcePoliciesInput{}
	}

	output := &DescribeResourcePoliciesOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeResourcePoliciesRequest{Request: req, Input: input, Copy: c.DescribeResourcePoliciesRequest}
}

const opDescribeSubscriptionFilters = "DescribeSubscriptionFilters"

// DescribeSubscriptionFiltersRequest is a API request type for the DescribeSubscriptionFilters API operation.
type DescribeSubscriptionFiltersRequest struct {
	*aws.Request
	Input *DescribeSubscriptionFiltersInput
	Copy  func(*DescribeSubscriptionFiltersInput) DescribeSubscriptionFiltersRequest
}

// Send marshals and sends the DescribeSubscriptionFilters API request.
func (r DescribeSubscriptionFiltersRequest) Send() (*DescribeSubscriptionFiltersOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DescribeSubscriptionFiltersOutput), nil
}

// DescribeSubscriptionFiltersRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the subscription filters for the specified log group. You can list
// all the subscription filters or filter the results by prefix. The results
// are ASCII-sorted by filter name.
//
//    // Example sending a request using the DescribeSubscriptionFiltersRequest method.
//    req := client.DescribeSubscriptionFiltersRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters
func (c *CloudWatchLogs) DescribeSubscriptionFiltersRequest(input *DescribeSubscriptionFiltersInput) DescribeSubscriptionFiltersRequest {
	op := &aws.Operation{
		Name:       opDescribeSubscriptionFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSubscriptionFiltersInput{}
	}

	output := &DescribeSubscriptionFiltersOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return DescribeSubscriptionFiltersRequest{Request: req, Input: input, Copy: c.DescribeSubscriptionFiltersRequest}
}

// Paginate pages iterates over the pages of a DescribeSubscriptionFiltersRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSubscriptionFilters operation.
//		req := client.DescribeSubscriptionFiltersRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *DescribeSubscriptionFiltersRequest) Paginate(opts ...aws.Option) DescribeSubscriptionFiltersPager {
	return DescribeSubscriptionFiltersPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *DescribeSubscriptionFiltersInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// DescribeSubscriptionFiltersPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeSubscriptionFiltersPager struct {
	aws.Pager
}

func (p *DescribeSubscriptionFiltersPager) CurrentPage() *DescribeSubscriptionFiltersOutput {
	return p.Pager.CurrentPage().(*DescribeSubscriptionFiltersOutput)
}

const opDisassociateKmsKey = "DisassociateKmsKey"

// DisassociateKmsKeyRequest is a API request type for the DisassociateKmsKey API operation.
type DisassociateKmsKeyRequest struct {
	*aws.Request
	Input *DisassociateKmsKeyInput
	Copy  func(*DisassociateKmsKeyInput) DisassociateKmsKeyRequest
}

// Send marshals and sends the DisassociateKmsKey API request.
func (r DisassociateKmsKeyRequest) Send() (*DisassociateKmsKeyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*DisassociateKmsKeyOutput), nil
}

// DisassociateKmsKeyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Disassociates the associated AWS Key Management Service (AWS KMS) customer
// master key (CMK) from the specified log group.
//
// After the AWS KMS CMK is disassociated from the log group, AWS CloudWatch
// Logs stops encrypting newly ingested data for the log group. All previously
// ingested data remains encrypted, and AWS CloudWatch Logs requires permissions
// for the CMK whenever the encrypted data is requested.
//
// Note that it can take up to 5 minutes for this operation to take effect.
//
//    // Example sending a request using the DisassociateKmsKeyRequest method.
//    req := client.DisassociateKmsKeyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DisassociateKmsKey
func (c *CloudWatchLogs) DisassociateKmsKeyRequest(input *DisassociateKmsKeyInput) DisassociateKmsKeyRequest {
	op := &aws.Operation{
		Name:       opDisassociateKmsKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateKmsKeyInput{}
	}

	output := &DisassociateKmsKeyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return DisassociateKmsKeyRequest{Request: req, Input: input, Copy: c.DisassociateKmsKeyRequest}
}

const opFilterLogEvents = "FilterLogEvents"

// FilterLogEventsRequest is a API request type for the FilterLogEvents API operation.
type FilterLogEventsRequest struct {
	*aws.Request
	Input *FilterLogEventsInput
	Copy  func(*FilterLogEventsInput) FilterLogEventsRequest
}

// Send marshals and sends the FilterLogEvents API request.
func (r FilterLogEventsRequest) Send() (*FilterLogEventsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*FilterLogEventsOutput), nil
}

// FilterLogEventsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists log events from the specified log group. You can list all the log events
// or filter the results using a filter pattern, a time range, and the name
// of the log stream.
//
// By default, this operation returns as many log events as can fit in 1 MB
// (up to 10,000 log events), or all the events found within the time range
// that you specify. If the results include a token, then there are more log
// events available, and you can get additional results by specifying the token
// in a subsequent call.
//
//    // Example sending a request using the FilterLogEventsRequest method.
//    req := client.FilterLogEventsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEvents
func (c *CloudWatchLogs) FilterLogEventsRequest(input *FilterLogEventsInput) FilterLogEventsRequest {
	op := &aws.Operation{
		Name:       opFilterLogEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &FilterLogEventsInput{}
	}

	output := &FilterLogEventsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return FilterLogEventsRequest{Request: req, Input: input, Copy: c.FilterLogEventsRequest}
}

// Paginate pages iterates over the pages of a FilterLogEventsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a FilterLogEvents operation.
//		req := client.FilterLogEventsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *FilterLogEventsRequest) Paginate(opts ...aws.Option) FilterLogEventsPager {
	return FilterLogEventsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *FilterLogEventsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// FilterLogEventsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type FilterLogEventsPager struct {
	aws.Pager
}

func (p *FilterLogEventsPager) CurrentPage() *FilterLogEventsOutput {
	return p.Pager.CurrentPage().(*FilterLogEventsOutput)
}

const opGetLogEvents = "GetLogEvents"

// GetLogEventsRequest is a API request type for the GetLogEvents API operation.
type GetLogEventsRequest struct {
	*aws.Request
	Input *GetLogEventsInput
	Copy  func(*GetLogEventsInput) GetLogEventsRequest
}

// Send marshals and sends the GetLogEvents API request.
func (r GetLogEventsRequest) Send() (*GetLogEventsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*GetLogEventsOutput), nil
}

// GetLogEventsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists log events from the specified log stream. You can list all the log
// events or filter using a time range.
//
// By default, this operation returns as many log events as can fit in a response
// size of 1MB (up to 10,000 log events). You can get additional log events
// by specifying one of the tokens in a subsequent call.
//
//    // Example sending a request using the GetLogEventsRequest method.
//    req := client.GetLogEventsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents
func (c *CloudWatchLogs) GetLogEventsRequest(input *GetLogEventsInput) GetLogEventsRequest {
	op := &aws.Operation{
		Name:       opGetLogEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextForwardToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLogEventsInput{}
	}

	output := &GetLogEventsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return GetLogEventsRequest{Request: req, Input: input, Copy: c.GetLogEventsRequest}
}

// Paginate pages iterates over the pages of a GetLogEventsRequest operation,
// calling the Next method for each page. Using the paginators Next
// method will depict whether or not there are more pages.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetLogEvents operation.
//		req := client.GetLogEventsRequest(input)
//		p := req.Paginate()
//		for p.Next() {
//			page := p.CurrentPage()
//		}
//
//		if err := p.Err(); err != nil {
//			return err
//		}
//
func (p *GetLogEventsRequest) Paginate(opts ...aws.Option) GetLogEventsPager {
	return GetLogEventsPager{
		Pager: aws.Pager{
			NewRequest: func() (*aws.Request, error) {
				var inCpy *GetLogEventsInput
				if p.Input != nil {
					tmp := *p.Input
					inCpy = &tmp
				}

				req := p.Copy(inCpy)
				req.ApplyOptions(opts...)

				return req.Request, nil
			},
		},
	}
}

// GetLogEventsPager is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetLogEventsPager struct {
	aws.Pager
}

func (p *GetLogEventsPager) CurrentPage() *GetLogEventsOutput {
	return p.Pager.CurrentPage().(*GetLogEventsOutput)
}

const opListTagsLogGroup = "ListTagsLogGroup"

// ListTagsLogGroupRequest is a API request type for the ListTagsLogGroup API operation.
type ListTagsLogGroupRequest struct {
	*aws.Request
	Input *ListTagsLogGroupInput
	Copy  func(*ListTagsLogGroupInput) ListTagsLogGroupRequest
}

// Send marshals and sends the ListTagsLogGroup API request.
func (r ListTagsLogGroupRequest) Send() (*ListTagsLogGroupOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*ListTagsLogGroupOutput), nil
}

// ListTagsLogGroupRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Lists the tags for the specified log group.
//
//    // Example sending a request using the ListTagsLogGroupRequest method.
//    req := client.ListTagsLogGroupRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsLogGroup
func (c *CloudWatchLogs) ListTagsLogGroupRequest(input *ListTagsLogGroupInput) ListTagsLogGroupRequest {
	op := &aws.Operation{
		Name:       opListTagsLogGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsLogGroupInput{}
	}

	output := &ListTagsLogGroupOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return ListTagsLogGroupRequest{Request: req, Input: input, Copy: c.ListTagsLogGroupRequest}
}

const opPutDestination = "PutDestination"

// PutDestinationRequest is a API request type for the PutDestination API operation.
type PutDestinationRequest struct {
	*aws.Request
	Input *PutDestinationInput
	Copy  func(*PutDestinationInput) PutDestinationRequest
}

// Send marshals and sends the PutDestination API request.
func (r PutDestinationRequest) Send() (*PutDestinationOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutDestinationOutput), nil
}

// PutDestinationRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates a destination. A destination encapsulates a physical resource
// (such as an Amazon Kinesis stream) and enables you to subscribe to a real-time
// stream of log events for a different account, ingested using PutLogEvents.
// Currently, the only supported physical resource is a Kinesis stream belonging
// to the same account as the destination.
//
// Through an access policy, a destination controls what is written to its Kinesis
// stream. By default, PutDestination does not set any access policy with the
// destination, which means a cross-account user cannot call PutSubscriptionFilter
// against this destination. To enable this, the destination owner must call
// PutDestinationPolicy after PutDestination.
//
//    // Example sending a request using the PutDestinationRequest method.
//    req := client.PutDestinationRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestination
func (c *CloudWatchLogs) PutDestinationRequest(input *PutDestinationInput) PutDestinationRequest {
	op := &aws.Operation{
		Name:       opPutDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDestinationInput{}
	}

	output := &PutDestinationOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutDestinationRequest{Request: req, Input: input, Copy: c.PutDestinationRequest}
}

const opPutDestinationPolicy = "PutDestinationPolicy"

// PutDestinationPolicyRequest is a API request type for the PutDestinationPolicy API operation.
type PutDestinationPolicyRequest struct {
	*aws.Request
	Input *PutDestinationPolicyInput
	Copy  func(*PutDestinationPolicyInput) PutDestinationPolicyRequest
}

// Send marshals and sends the PutDestinationPolicy API request.
func (r PutDestinationPolicyRequest) Send() (*PutDestinationPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutDestinationPolicyOutput), nil
}

// PutDestinationPolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates an access policy associated with an existing destination.
// An access policy is an IAM policy document (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
// that is used to authorize claims to register a subscription filter against
// a given destination.
//
//    // Example sending a request using the PutDestinationPolicyRequest method.
//    req := client.PutDestinationPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicy
func (c *CloudWatchLogs) PutDestinationPolicyRequest(input *PutDestinationPolicyInput) PutDestinationPolicyRequest {
	op := &aws.Operation{
		Name:       opPutDestinationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDestinationPolicyInput{}
	}

	output := &PutDestinationPolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutDestinationPolicyRequest{Request: req, Input: input, Copy: c.PutDestinationPolicyRequest}
}

const opPutLogEvents = "PutLogEvents"

// PutLogEventsRequest is a API request type for the PutLogEvents API operation.
type PutLogEventsRequest struct {
	*aws.Request
	Input *PutLogEventsInput
	Copy  func(*PutLogEventsInput) PutLogEventsRequest
}

// Send marshals and sends the PutLogEvents API request.
func (r PutLogEventsRequest) Send() (*PutLogEventsOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutLogEventsOutput), nil
}

// PutLogEventsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Uploads a batch of log events to the specified log stream.
//
// You must include the sequence token obtained from the response of the previous
// call. An upload in a newly created log stream does not require a sequence
// token. You can also get the sequence token using DescribeLogStreams. If you
// call PutLogEvents twice within a narrow time period using the same value
// for sequenceToken, both calls may be successful, or one may be rejected.
//
// The batch of events must satisfy the following constraints:
//
//    * The maximum batch size is 1,048,576 bytes, and this size is calculated
//    as the sum of all event messages in UTF-8, plus 26 bytes for each log
//    event.
//
//    * None of the log events in the batch can be more than 2 hours in the
//    future.
//
//    * None of the log events in the batch can be older than 14 days or the
//    retention period of the log group.
//
//    * The log events in the batch must be in chronological ordered by their
//    time stamp. The time stamp is the time the event occurred, expressed as
//    the number of milliseconds after Jan 1, 1970 00:00:00 UTC. (In AWS Tools
//    for PowerShell and the AWS SDK for .NET, the timestamp is specified in
//    .NET format: yyyy-mm-ddThh:mm:ss. For example, 2017-09-15T13:45:30.)
//
//    * The maximum number of log events in a batch is 10,000.
//
//    * A batch of log events in a single request cannot span more than 24 hours.
//    Otherwise, the operation fails.
//
// If a call to PutLogEvents returns "UnrecognizedClientException" the most
// likely cause is an invalid AWS access key ID or secret key.
//
//    // Example sending a request using the PutLogEventsRequest method.
//    req := client.PutLogEventsRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutLogEvents
func (c *CloudWatchLogs) PutLogEventsRequest(input *PutLogEventsInput) PutLogEventsRequest {
	op := &aws.Operation{
		Name:       opPutLogEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLogEventsInput{}
	}

	output := &PutLogEventsOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutLogEventsRequest{Request: req, Input: input, Copy: c.PutLogEventsRequest}
}

const opPutMetricFilter = "PutMetricFilter"

// PutMetricFilterRequest is a API request type for the PutMetricFilter API operation.
type PutMetricFilterRequest struct {
	*aws.Request
	Input *PutMetricFilterInput
	Copy  func(*PutMetricFilterInput) PutMetricFilterRequest
}

// Send marshals and sends the PutMetricFilter API request.
func (r PutMetricFilterRequest) Send() (*PutMetricFilterOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutMetricFilterOutput), nil
}

// PutMetricFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates a metric filter and associates it with the specified log
// group. Metric filters allow you to configure rules to extract metric data
// from log events ingested through PutLogEvents.
//
// The maximum number of metric filters that can be associated with a log group
// is 100.
//
//    // Example sending a request using the PutMetricFilterRequest method.
//    req := client.PutMetricFilterRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutMetricFilter
func (c *CloudWatchLogs) PutMetricFilterRequest(input *PutMetricFilterInput) PutMetricFilterRequest {
	op := &aws.Operation{
		Name:       opPutMetricFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricFilterInput{}
	}

	output := &PutMetricFilterOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutMetricFilterRequest{Request: req, Input: input, Copy: c.PutMetricFilterRequest}
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest is a API request type for the PutResourcePolicy API operation.
type PutResourcePolicyRequest struct {
	*aws.Request
	Input *PutResourcePolicyInput
	Copy  func(*PutResourcePolicyInput) PutResourcePolicyRequest
}

// Send marshals and sends the PutResourcePolicy API request.
func (r PutResourcePolicyRequest) Send() (*PutResourcePolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutResourcePolicyOutput), nil
}

// PutResourcePolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates a resource policy allowing other AWS services to put log
// events to this account, such as Amazon Route 53. An account can have up to
// 10 resource policies per region.
//
//    // Example sending a request using the PutResourcePolicyRequest method.
//    req := client.PutResourcePolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutResourcePolicy
func (c *CloudWatchLogs) PutResourcePolicyRequest(input *PutResourcePolicyInput) PutResourcePolicyRequest {
	op := &aws.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output := &PutResourcePolicyOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return PutResourcePolicyRequest{Request: req, Input: input, Copy: c.PutResourcePolicyRequest}
}

const opPutRetentionPolicy = "PutRetentionPolicy"

// PutRetentionPolicyRequest is a API request type for the PutRetentionPolicy API operation.
type PutRetentionPolicyRequest struct {
	*aws.Request
	Input *PutRetentionPolicyInput
	Copy  func(*PutRetentionPolicyInput) PutRetentionPolicyRequest
}

// Send marshals and sends the PutRetentionPolicy API request.
func (r PutRetentionPolicyRequest) Send() (*PutRetentionPolicyOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutRetentionPolicyOutput), nil
}

// PutRetentionPolicyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Sets the retention of the specified log group. A retention policy allows
// you to configure the number of days for which to retain log events in the
// specified log group.
//
//    // Example sending a request using the PutRetentionPolicyRequest method.
//    req := client.PutRetentionPolicyRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicy
func (c *CloudWatchLogs) PutRetentionPolicyRequest(input *PutRetentionPolicyInput) PutRetentionPolicyRequest {
	op := &aws.Operation{
		Name:       opPutRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionPolicyInput{}
	}

	output := &PutRetentionPolicyOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutRetentionPolicyRequest{Request: req, Input: input, Copy: c.PutRetentionPolicyRequest}
}

const opPutSubscriptionFilter = "PutSubscriptionFilter"

// PutSubscriptionFilterRequest is a API request type for the PutSubscriptionFilter API operation.
type PutSubscriptionFilterRequest struct {
	*aws.Request
	Input *PutSubscriptionFilterInput
	Copy  func(*PutSubscriptionFilterInput) PutSubscriptionFilterRequest
}

// Send marshals and sends the PutSubscriptionFilter API request.
func (r PutSubscriptionFilterRequest) Send() (*PutSubscriptionFilterOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*PutSubscriptionFilterOutput), nil
}

// PutSubscriptionFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Creates or updates a subscription filter and associates it with the specified
// log group. Subscription filters allow you to subscribe to a real-time stream
// of log events ingested through PutLogEvents and have them delivered to a
// specific destination. Currently, the supported destinations are:
//
//    * An Amazon Kinesis stream belonging to the same account as the subscription
//    filter, for same-account delivery.
//
//    * A logical destination that belongs to a different account, for cross-account
//    delivery.
//
//    * An Amazon Kinesis Firehose delivery stream that belongs to the same
//    account as the subscription filter, for same-account delivery.
//
//    * An AWS Lambda function that belongs to the same account as the subscription
//    filter, for same-account delivery.
//
// There can only be one subscription filter associated with a log group. If
// you are updating an existing filter, you must specify the correct name in
// filterName. Otherwise, the call fails because you cannot associate a second
// filter with a log group.
//
//    // Example sending a request using the PutSubscriptionFilterRequest method.
//    req := client.PutSubscriptionFilterRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilter
func (c *CloudWatchLogs) PutSubscriptionFilterRequest(input *PutSubscriptionFilterInput) PutSubscriptionFilterRequest {
	op := &aws.Operation{
		Name:       opPutSubscriptionFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutSubscriptionFilterInput{}
	}

	output := &PutSubscriptionFilterOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return PutSubscriptionFilterRequest{Request: req, Input: input, Copy: c.PutSubscriptionFilterRequest}
}

const opTagLogGroup = "TagLogGroup"

// TagLogGroupRequest is a API request type for the TagLogGroup API operation.
type TagLogGroupRequest struct {
	*aws.Request
	Input *TagLogGroupInput
	Copy  func(*TagLogGroupInput) TagLogGroupRequest
}

// Send marshals and sends the TagLogGroup API request.
func (r TagLogGroupRequest) Send() (*TagLogGroupOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*TagLogGroupOutput), nil
}

// TagLogGroupRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Adds or updates the specified tags for the specified log group.
//
// To list the tags for a log group, use ListTagsLogGroup. To remove tags, use
// UntagLogGroup.
//
// For more information about tags, see Tag Log Groups in Amazon CloudWatch
// Logs (http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/log-group-tagging.html)
// in the Amazon CloudWatch Logs User Guide.
//
//    // Example sending a request using the TagLogGroupRequest method.
//    req := client.TagLogGroupRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagLogGroup
func (c *CloudWatchLogs) TagLogGroupRequest(input *TagLogGroupInput) TagLogGroupRequest {
	op := &aws.Operation{
		Name:       opTagLogGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagLogGroupInput{}
	}

	output := &TagLogGroupOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return TagLogGroupRequest{Request: req, Input: input, Copy: c.TagLogGroupRequest}
}

const opTestMetricFilter = "TestMetricFilter"

// TestMetricFilterRequest is a API request type for the TestMetricFilter API operation.
type TestMetricFilterRequest struct {
	*aws.Request
	Input *TestMetricFilterInput
	Copy  func(*TestMetricFilterInput) TestMetricFilterRequest
}

// Send marshals and sends the TestMetricFilter API request.
func (r TestMetricFilterRequest) Send() (*TestMetricFilterOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*TestMetricFilterOutput), nil
}

// TestMetricFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Tests the filter pattern of a metric filter against a sample of log event
// messages. You can use this operation to validate the correctness of a metric
// filter pattern.
//
//    // Example sending a request using the TestMetricFilterRequest method.
//    req := client.TestMetricFilterRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilter
func (c *CloudWatchLogs) TestMetricFilterRequest(input *TestMetricFilterInput) TestMetricFilterRequest {
	op := &aws.Operation{
		Name:       opTestMetricFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestMetricFilterInput{}
	}

	output := &TestMetricFilterOutput{}
	req := c.newRequest(op, input, output)
	output.responseMetadata = aws.Response{Request: req}

	return TestMetricFilterRequest{Request: req, Input: input, Copy: c.TestMetricFilterRequest}
}

const opUntagLogGroup = "UntagLogGroup"

// UntagLogGroupRequest is a API request type for the UntagLogGroup API operation.
type UntagLogGroupRequest struct {
	*aws.Request
	Input *UntagLogGroupInput
	Copy  func(*UntagLogGroupInput) UntagLogGroupRequest
}

// Send marshals and sends the UntagLogGroup API request.
func (r UntagLogGroupRequest) Send() (*UntagLogGroupOutput, error) {
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	return r.Request.Data.(*UntagLogGroupOutput), nil
}

// UntagLogGroupRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Removes the specified tags from the specified log group.
//
// To list the tags for a log group, use ListTagsLogGroup. To add tags, use
// UntagLogGroup.
//
//    // Example sending a request using the UntagLogGroupRequest method.
//    req := client.UntagLogGroupRequest(params)
//    resp, err := req.Send()
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagLogGroup
func (c *CloudWatchLogs) UntagLogGroupRequest(input *UntagLogGroupInput) UntagLogGroupRequest {
	op := &aws.Operation{
		Name:       opUntagLogGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagLogGroupInput{}
	}

	output := &UntagLogGroupOutput{}
	req := c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output.responseMetadata = aws.Response{Request: req}

	return UntagLogGroupRequest{Request: req, Input: input, Copy: c.UntagLogGroupRequest}
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKeyRequest
type AssociateKmsKeyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
	// For more information, see Amazon Resource Names - AWS Key Management Service
	// (AWS KMS) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateKmsKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateKmsKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateKmsKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateKmsKeyInput"}

	if s.KmsKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsKeyId"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKeyOutput
type AssociateKmsKeyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s AssociateKmsKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateKmsKeyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s AssociateKmsKeyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CancelExportTaskRequest
type CancelExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the export task.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelExportTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelExportTaskInput"}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CancelExportTaskOutput
type CancelExportTaskOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s CancelExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelExportTaskOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CancelExportTaskOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateExportTaskRequest
type CreateExportTaskInput struct {
	_ struct{} `type:"structure"`

	// The name of S3 bucket for the exported log data. The bucket must be in the
	// same AWS region.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The prefix used as the start of the key for every object exported. If you
	// don't specify a value, the default is exportedlogs.
	DestinationPrefix *string `locationName:"destinationPrefix" type:"string"`

	// The start time of the range for the request, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC. Events with a time stamp earlier than this
	// time are not exported.
	//
	// From is a required field
	From *int64 `locationName:"from" type:"long" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// Export only log streams that match the provided prefix. If you don't specify
	// a value, no prefix filter is applied.
	LogStreamNamePrefix *string `locationName:"logStreamNamePrefix" min:"1" type:"string"`

	// The name of the export task.
	TaskName *string `locationName:"taskName" min:"1" type:"string"`

	// The end time of the range for the request, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC. Events with a time stamp later than this
	// time are not exported.
	//
	// To is a required field
	To *int64 `locationName:"to" type:"long" required:"true"`
}

// String returns the string representation
func (s CreateExportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateExportTaskInput"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Destination", 1))
	}

	if s.From == nil {
		invalidParams.Add(aws.NewErrParamRequired("From"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.LogStreamNamePrefix != nil && len(*s.LogStreamNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamNamePrefix", 1))
	}
	if s.TaskName != nil && len(*s.TaskName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskName", 1))
	}

	if s.To == nil {
		invalidParams.Add(aws.NewErrParamRequired("To"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateExportTaskResponse
type CreateExportTaskOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The ID of the export task.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateExportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportTaskOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateExportTaskOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogGroupRequest
type CreateLogGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
	// For more information, see Amazon Resource Names - AWS Key Management Service
	// (AWS KMS) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The key-value pairs to use for the tags.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateLogGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLogGroupInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogGroupOutput
type CreateLogGroupOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s CreateLogGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogGroupOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateLogGroupOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogStreamRequest
type CreateLogStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The name of the log stream.
	//
	// LogStreamName is a required field
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLogStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLogStreamInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.LogStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamName"))
	}
	if s.LogStreamName != nil && len(*s.LogStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogStreamOutput
type CreateLogStreamOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s CreateLogStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogStreamOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s CreateLogStreamOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDestinationRequest
type DeleteDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the destination.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDestinationInput"}

	if s.DestinationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationName"))
	}
	if s.DestinationName != nil && len(*s.DestinationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDestinationOutput
type DeleteDestinationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDestinationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteDestinationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogGroupRequest
type DeleteLogGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLogGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLogGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLogGroupInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogGroupOutput
type DeleteLogGroupOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteLogGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogGroupOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteLogGroupOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogStreamRequest
type DeleteLogStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The name of the log stream.
	//
	// LogStreamName is a required field
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLogStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLogStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLogStreamInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.LogStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamName"))
	}
	if s.LogStreamName != nil && len(*s.LogStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogStreamOutput
type DeleteLogStreamOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteLogStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogStreamOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteLogStreamOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteMetricFilterRequest
type DeleteMetricFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the metric filter.
	//
	// FilterName is a required field
	FilterName *string `locationName:"filterName" min:"1" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMetricFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMetricFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMetricFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMetricFilterInput"}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterName", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteMetricFilterOutput
type DeleteMetricFilterOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteMetricFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMetricFilterOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteMetricFilterOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteResourcePolicyRequest
type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to be revoked. This parameter is required.
	PolicyName *string `locationName:"policyName" type:"string"`
}

// String returns the string representation
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteResourcePolicyOutput
type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteResourcePolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteRetentionPolicyRequest
type DeleteRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetentionPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRetentionPolicyInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteRetentionPolicyOutput
type DeleteRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteRetentionPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilterRequest
type DeleteSubscriptionFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the subscription filter.
	//
	// FilterName is a required field
	FilterName *string `locationName:"filterName" min:"1" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubscriptionFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSubscriptionFilterInput"}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterName", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilterOutput
type DeleteSubscriptionFilterOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DeleteSubscriptionFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionFilterOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DeleteSubscriptionFilterOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinationsRequest
type DescribeDestinationsInput struct {
	_ struct{} `type:"structure"`

	// The prefix to match. If you don't specify a value, no prefix filter is applied.
	DestinationNamePrefix *string `min:"1" type:"string"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDestinationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDestinationsInput"}
	if s.DestinationNamePrefix != nil && len(*s.DestinationNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationNamePrefix", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinationsResponse
type DescribeDestinationsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The destinations.
	Destinations []Destination `locationName:"destinations" type:"list"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDestinationsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeDestinationsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasksRequest
type DescribeExportTasksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The status code of the export task. Specifying a status code filters the
	// results to zero or more export tasks.
	StatusCode ExportTaskStatusCode `locationName:"statusCode" type:"string" enum:"true"`

	// The ID of the export task. Specifying a task ID filters the results to zero
	// or one export tasks.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeExportTasksInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasksResponse
type DescribeExportTasksOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The export tasks.
	ExportTasks []ExportTask `locationName:"exportTasks" type:"list"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeExportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExportTasksOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeExportTasksOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroupsRequest
type DescribeLogGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The prefix to match.
	LogGroupNamePrefix *string `locationName:"logGroupNamePrefix" min:"1" type:"string"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeLogGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLogGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLogGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLogGroupsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.LogGroupNamePrefix != nil && len(*s.LogGroupNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupNamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroupsResponse
type DescribeLogGroupsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The log groups.
	LogGroups []LogGroup `locationName:"logGroups" type:"list"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeLogGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLogGroupsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeLogGroupsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreamsRequest
type DescribeLogStreamsInput struct {
	_ struct{} `type:"structure"`

	// If the value is true, results are returned in descending order. If the value
	// is to false, results are returned in ascending order. The default value is
	// false.
	Descending *bool `locationName:"descending" type:"boolean"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The prefix to match.
	//
	// If orderBy is LastEventTime,you cannot specify this parameter.
	LogStreamNamePrefix *string `locationName:"logStreamNamePrefix" min:"1" type:"string"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// If the value is LogStreamName, the results are ordered by log stream name.
	// If the value is LastEventTime, the results are ordered by the event time.
	// The default value is LogStreamName.
	//
	// If you order the results by event time, you cannot specify the logStreamNamePrefix
	// parameter.
	//
	// lastEventTimestamp represents the time of the most recent log event in the
	// log stream in CloudWatch Logs. This number is expressed as the number of
	// milliseconds after Jan 1, 1970 00:00:00 UTC. lastEventTimeStamp updates on
	// an eventual consistency basis. It typically updates in less than an hour
	// from ingestion, but may take longer in some rare situations.
	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeLogStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLogStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLogStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLogStreamsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.LogStreamNamePrefix != nil && len(*s.LogStreamNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamNamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreamsResponse
type DescribeLogStreamsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The log streams.
	LogStreams []LogStream `locationName:"logStreams" type:"list"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeLogStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLogStreamsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeLogStreamsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFiltersRequest
type DescribeMetricFiltersInput struct {
	_ struct{} `type:"structure"`

	// The prefix to match.
	FilterNamePrefix *string `locationName:"filterNamePrefix" min:"1" type:"string"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// Filters results to include only those with the specified metric name. If
	// you include this parameter in your request, you must also include the metricNamespace
	// parameter.
	MetricName *string `locationName:"metricName" type:"string"`

	// Filters results to include only those in the specified namespace. If you
	// include this parameter in your request, you must also include the metricName
	// parameter.
	MetricNamespace *string `locationName:"metricNamespace" type:"string"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeMetricFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMetricFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMetricFiltersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMetricFiltersInput"}
	if s.FilterNamePrefix != nil && len(*s.FilterNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterNamePrefix", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFiltersResponse
type DescribeMetricFiltersOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The metric filters.
	MetricFilters []MetricFilter `locationName:"metricFilters" type:"list"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeMetricFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMetricFiltersOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeMetricFiltersOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePoliciesRequest
type DescribeResourcePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of resource policies to be displayed with one call of
	// this API.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeResourcePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourcePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePoliciesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeResourcePoliciesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePoliciesResponse
type DescribeResourcePoliciesOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The resource policies that exist in this account.
	ResourcePolicies []ResourcePolicy `locationName:"resourcePolicies" type:"list"`
}

// String returns the string representation
func (s DescribeResourcePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourcePoliciesOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeResourcePoliciesOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFiltersRequest
type DescribeSubscriptionFiltersInput struct {
	_ struct{} `type:"structure"`

	// The prefix to match. If you don't specify a value, no prefix filter is applied.
	FilterNamePrefix *string `locationName:"filterNamePrefix" min:"1" type:"string"`

	// The maximum number of items returned. If you don't specify a value, the default
	// is up to 50 items.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeSubscriptionFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscriptionFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSubscriptionFiltersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSubscriptionFiltersInput"}
	if s.FilterNamePrefix != nil && len(*s.FilterNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterNamePrefix", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFiltersResponse
type DescribeSubscriptionFiltersOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The token for the next set of items to return. The token expires after 24
	// hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The subscription filters.
	SubscriptionFilters []SubscriptionFilter `locationName:"subscriptionFilters" type:"list"`
}

// String returns the string representation
func (s DescribeSubscriptionFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubscriptionFiltersOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DescribeSubscriptionFiltersOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Represents a cross-account destination that receives subscription log events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// An IAM policy document that governs which AWS accounts can create subscription
	// filters against this destination.
	AccessPolicy *string `locationName:"accessPolicy" min:"1" type:"string"`

	// The ARN of this destination.
	Arn *string `locationName:"arn" type:"string"`

	// The creation time of the destination, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64 `locationName:"creationTime" type:"long"`

	// The name of the destination.
	DestinationName *string `locationName:"destinationName" min:"1" type:"string"`

	// A role for impersonation, used when delivering log events to the target.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the physical target to where the log events
	// are delivered (for example, a Kinesis stream).
	TargetArn *string `locationName:"targetArn" min:"1" type:"string"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DisassociateKmsKeyRequest
type DisassociateKmsKeyInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateKmsKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateKmsKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateKmsKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateKmsKeyInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DisassociateKmsKeyOutput
type DisassociateKmsKeyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s DisassociateKmsKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateKmsKeyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s DisassociateKmsKeyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Represents an export task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ExportTask
type ExportTask struct {
	_ struct{} `type:"structure"`

	// The name of Amazon S3 bucket to which the log data was exported.
	Destination *string `locationName:"destination" min:"1" type:"string"`

	// The prefix that was used as the start of Amazon S3 key for every object exported.
	DestinationPrefix *string `locationName:"destinationPrefix" type:"string"`

	// Execution info about the export task.
	ExecutionInfo *ExportTaskExecutionInfo `locationName:"executionInfo" type:"structure"`

	// The start time, expressed as the number of milliseconds after Jan 1, 1970
	// 00:00:00 UTC. Events with a time stamp before this time are not exported.
	From *int64 `locationName:"from" type:"long"`

	// The name of the log group from which logs data was exported.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// The status of the export task.
	Status *ExportTaskStatus `locationName:"status" type:"structure"`

	// The ID of the export task.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`

	// The name of the export task.
	TaskName *string `locationName:"taskName" min:"1" type:"string"`

	// The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
	// UTC. Events with a time stamp later than this time are not exported.
	To *int64 `locationName:"to" type:"long"`
}

// String returns the string representation
func (s ExportTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportTask) GoString() string {
	return s.String()
}

// Represents the status of an export task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ExportTaskExecutionInfo
type ExportTaskExecutionInfo struct {
	_ struct{} `type:"structure"`

	// The completion time of the export task, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	CompletionTime *int64 `locationName:"completionTime" type:"long"`

	// The creation time of the export task, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64 `locationName:"creationTime" type:"long"`
}

// String returns the string representation
func (s ExportTaskExecutionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportTaskExecutionInfo) GoString() string {
	return s.String()
}

// Represents the status of an export task.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ExportTaskStatus
type ExportTaskStatus struct {
	_ struct{} `type:"structure"`

	// The status code of the export task.
	Code ExportTaskStatusCode `locationName:"code" type:"string" enum:"true"`

	// The status message related to the status code.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ExportTaskStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportTaskStatus) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEventsRequest
type FilterLogEventsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time range, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC. Events with a time stamp later than this time are
	// not returned.
	EndTime *int64 `locationName:"endTime" type:"long"`

	// The filter pattern to use. For more information, see Filter and Pattern Syntax
	// (http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
	//
	// If not provided, all the events are matched.
	FilterPattern *string `locationName:"filterPattern" type:"string"`

	// If the value is true, the operation makes a best effort to provide responses
	// that contain events from multiple log streams within the log group, interleaved
	// in a single response. If the value is false, all the matched log events in
	// the first log stream are searched first, then those in the next log stream,
	// and so on. The default is false.
	Interleaved *bool `locationName:"interleaved" type:"boolean"`

	// The maximum number of events to return. The default is 10,000 events.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group to search.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// Filters the results to include only events from log streams that have names
	// starting with this prefix.
	//
	// If you specify a value for both logStreamNamePrefix and logStreamNames, but
	// the value for logStreamNamePrefix does not match any log stream names specified
	// in logStreamNames, the action returns an InvalidParameterException error.
	LogStreamNamePrefix *string `locationName:"logStreamNamePrefix" min:"1" type:"string"`

	// Filters the results to only logs from the log streams in this list.
	//
	// If you specify a value for both logStreamNamePrefix and logStreamNames, but
	// the value for logStreamNamePrefix does not match any log stream names specified
	// in logStreamNames, the action returns an InvalidParameterException error.
	LogStreamNames []string `locationName:"logStreamNames" min:"1" type:"list"`

	// The token for the next set of events to return. (You received this token
	// from a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The start of the time range, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC. Events with a time stamp before this time are not
	// returned.
	StartTime *int64 `locationName:"startTime" type:"long"`
}

// String returns the string representation
func (s FilterLogEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterLogEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterLogEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FilterLogEventsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.LogStreamNamePrefix != nil && len(*s.LogStreamNamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamNamePrefix", 1))
	}
	if s.LogStreamNames != nil && len(s.LogStreamNames) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamNames", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEventsResponse
type FilterLogEventsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The matched events.
	Events []FilteredLogEvent `locationName:"events" type:"list"`

	// The token to use when requesting the next set of items. The token expires
	// after 24 hours.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Indicates which log streams have been searched and whether each has been
	// searched completely.
	SearchedLogStreams []SearchedLogStream `locationName:"searchedLogStreams" type:"list"`
}

// String returns the string representation
func (s FilterLogEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterLogEventsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s FilterLogEventsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Represents a matched event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilteredLogEvent
type FilteredLogEvent struct {
	_ struct{} `type:"structure"`

	// The ID of the event.
	EventId *string `locationName:"eventId" type:"string"`

	// The time the event was ingested, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	IngestionTime *int64 `locationName:"ingestionTime" type:"long"`

	// The name of the log stream this event belongs to.
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string"`

	// The data contained in the log event.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The time the event occurred, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC.
	Timestamp *int64 `locationName:"timestamp" type:"long"`
}

// String returns the string representation
func (s FilteredLogEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilteredLogEvent) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEventsRequest
type GetLogEventsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time range, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC. Events with a time stamp equal to or later than
	// this time are not included.
	EndTime *int64 `locationName:"endTime" type:"long"`

	// The maximum number of log events returned. If you don't specify a value,
	// the maximum is as many log events as can fit in a response size of 1 MB,
	// up to 10,000 log events.
	Limit *int64 `locationName:"limit" min:"1" type:"integer"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The name of the log stream.
	//
	// LogStreamName is a required field
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// If the value is true, the earliest log events are returned first. If the
	// value is false, the latest log events are returned first. The default value
	// is false.
	StartFromHead *bool `locationName:"startFromHead" type:"boolean"`

	// The start of the time range, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC. Events with a time stamp equal to this time or
	// later than this time are included. Events with a time stamp earlier than
	// this time are not included.
	StartTime *int64 `locationName:"startTime" type:"long"`
}

// String returns the string representation
func (s GetLogEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLogEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLogEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLogEventsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.LogStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamName"))
	}
	if s.LogStreamName != nil && len(*s.LogStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEventsResponse
type GetLogEventsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The events.
	Events []OutputLogEvent `locationName:"events" type:"list"`

	// The token for the next set of items in the backward direction. The token
	// expires after 24 hours. This token will never be null. If you have reached
	// the end of the stream, it will return the same token you passed in.
	NextBackwardToken *string `locationName:"nextBackwardToken" min:"1" type:"string"`

	// The token for the next set of items in the forward direction. The token expires
	// after 24 hours. If you have reached the end of the stream, it will return
	// the same token you passed in.
	NextForwardToken *string `locationName:"nextForwardToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetLogEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLogEventsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s GetLogEventsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Represents a log event, which is a record of activity that was recorded by
// the application or resource being monitored.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/InputLogEvent
type InputLogEvent struct {
	_ struct{} `type:"structure"`

	// The raw event message.
	//
	// Message is a required field
	Message *string `locationName:"message" min:"1" type:"string" required:"true"`

	// The time the event occurred, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC.
	//
	// Timestamp is a required field
	Timestamp *int64 `locationName:"timestamp" type:"long" required:"true"`
}

// String returns the string representation
func (s InputLogEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLogEvent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLogEvent) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLogEvent"}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Message", 1))
	}

	if s.Timestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsLogGroupRequest
type ListTagsLogGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsLogGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsLogGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsLogGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTagsLogGroupInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsLogGroupResponse
type ListTagsLogGroupOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The tags for the log group.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsLogGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsLogGroupOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s ListTagsLogGroupOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Represents a log group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/LogGroup
type LogGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the log group.
	Arn *string `locationName:"arn" type:"string"`

	// The creation time of the log group, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64 `locationName:"creationTime" type:"long"`

	// The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The name of the log group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// The number of metric filters.
	MetricFilterCount *int64 `locationName:"metricFilterCount" type:"integer"`

	// The number of days to retain the log events in the specified log group. Possible
	// values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731,
	// 1827, and 3653.
	RetentionInDays *int64 `locationName:"retentionInDays" type:"integer"`

	// The number of bytes stored.
	StoredBytes *int64 `locationName:"storedBytes" type:"long"`
}

// String returns the string representation
func (s LogGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogGroup) GoString() string {
	return s.String()
}

// Represents a log stream, which is a sequence of log events from a single
// emitter of logs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/LogStream
type LogStream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the log stream.
	Arn *string `locationName:"arn" type:"string"`

	// The creation time of the stream, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64 `locationName:"creationTime" type:"long"`

	// The time of the first event, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC.
	FirstEventTimestamp *int64 `locationName:"firstEventTimestamp" type:"long"`

	// the time of the most recent log event in the log stream in CloudWatch Logs.
	// This number is expressed as the number of milliseconds after Jan 1, 1970
	// 00:00:00 UTC. lastEventTime updates on an eventual consistency basis. It
	// typically updates in less than an hour from ingestion, but may take longer
	// in some rare situations.
	LastEventTimestamp *int64 `locationName:"lastEventTimestamp" type:"long"`

	// The ingestion time, expressed as the number of milliseconds after Jan 1,
	// 1970 00:00:00 UTC.
	LastIngestionTime *int64 `locationName:"lastIngestionTime" type:"long"`

	// The name of the log stream.
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string"`

	// The number of bytes stored.
	StoredBytes *int64 `locationName:"storedBytes" type:"long"`

	// The sequence token.
	UploadSequenceToken *string `locationName:"uploadSequenceToken" min:"1" type:"string"`
}

// String returns the string representation
func (s LogStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogStream) GoString() string {
	return s.String()
}

// Metric filters express how CloudWatch Logs would extract metric observations
// from ingested log events and transform them into metric data in a CloudWatch
// metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/MetricFilter
type MetricFilter struct {
	_ struct{} `type:"structure"`

	// The creation time of the metric filter, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64 `locationName:"creationTime" type:"long"`

	// The name of the metric filter.
	FilterName *string `locationName:"filterName" min:"1" type:"string"`

	// A symbolic description of how CloudWatch Logs should interpret the data in
	// each log event. For example, a log event may contain time stamps, IP addresses,
	// strings, and so on. You use the filter pattern to specify what to look for
	// in the log event message.
	FilterPattern *string `locationName:"filterPattern" type:"string"`

	// The name of the log group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	// The metric transformations.
	MetricTransformations []MetricTransformation `locationName:"metricTransformations" min:"1" type:"list"`
}

// String returns the string representation
func (s MetricFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricFilter) GoString() string {
	return s.String()
}

// Represents a matched event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/MetricFilterMatchRecord
type MetricFilterMatchRecord struct {
	_ struct{} `type:"structure"`

	// The raw event data.
	EventMessage *string `locationName:"eventMessage" min:"1" type:"string"`

	// The event number.
	EventNumber *int64 `locationName:"eventNumber" type:"long"`

	// The values extracted from the event data by the filter.
	ExtractedValues map[string]string `locationName:"extractedValues" type:"map"`
}

// String returns the string representation
func (s MetricFilterMatchRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricFilterMatchRecord) GoString() string {
	return s.String()
}

// Indicates how to transform ingested log events in to metric data in a CloudWatch
// metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/MetricTransformation
type MetricTransformation struct {
	_ struct{} `type:"structure"`

	// (Optional) The value to emit when a filter pattern does not match a log event.
	// This value can be null.
	DefaultValue *float64 `locationName:"defaultValue" type:"double"`

	// The name of the CloudWatch metric.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	// The namespace of the CloudWatch metric.
	//
	// MetricNamespace is a required field
	MetricNamespace *string `locationName:"metricNamespace" type:"string" required:"true"`

	// The value to publish to the CloudWatch metric when a filter pattern matches
	// a log event.
	//
	// MetricValue is a required field
	MetricValue *string `locationName:"metricValue" type:"string" required:"true"`
}

// String returns the string representation
func (s MetricTransformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricTransformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricTransformation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricTransformation"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.MetricNamespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricNamespace"))
	}

	if s.MetricValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a log event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/OutputLogEvent
type OutputLogEvent struct {
	_ struct{} `type:"structure"`

	// The time the event was ingested, expressed as the number of milliseconds
	// after Jan 1, 1970 00:00:00 UTC.
	IngestionTime *int64 `locationName:"ingestionTime" type:"long"`

	// The data contained in the log event.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The time the event occurred, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC.
	Timestamp *int64 `locationName:"timestamp" type:"long"`
}

// String returns the string representation
func (s OutputLogEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLogEvent) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationRequest
type PutDestinationInput struct {
	_ struct{} `type:"structure"`

	// A name for the destination.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"1" type:"string" required:"true"`

	// The ARN of an IAM role that grants CloudWatch Logs permissions to call the
	// Amazon Kinesis PutRecord operation on the destination stream.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The ARN of an Amazon Kinesis stream to which to deliver matching log events.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutDestinationInput"}

	if s.DestinationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationName"))
	}
	if s.DestinationName != nil && len(*s.DestinationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if s.TargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationResponse
type PutDestinationOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The destination.
	Destination *Destination `locationName:"destination" type:"structure"`
}

// String returns the string representation
func (s PutDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDestinationOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutDestinationOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicyRequest
type PutDestinationPolicyInput struct {
	_ struct{} `type:"structure"`

	// An IAM policy document that authorizes cross-account users to deliver their
	// log events to the associated destination.
	//
	// AccessPolicy is a required field
	AccessPolicy *string `locationName:"accessPolicy" min:"1" type:"string" required:"true"`

	// A name for an existing destination.
	//
	// DestinationName is a required field
	DestinationName *string `locationName:"destinationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutDestinationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDestinationPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDestinationPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutDestinationPolicyInput"}

	if s.AccessPolicy == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessPolicy"))
	}
	if s.AccessPolicy != nil && len(*s.AccessPolicy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessPolicy", 1))
	}

	if s.DestinationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationName"))
	}
	if s.DestinationName != nil && len(*s.DestinationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicyOutput
type PutDestinationPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutDestinationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDestinationPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutDestinationPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutLogEventsRequest
type PutLogEventsInput struct {
	_ struct{} `type:"structure"`

	// The log events.
	//
	// LogEvents is a required field
	LogEvents []InputLogEvent `locationName:"logEvents" min:"1" type:"list" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The name of the log stream.
	//
	// LogStreamName is a required field
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string" required:"true"`

	// The sequence token obtained from the response of the previous PutLogEvents
	// call. An upload in a newly created log stream does not require a sequence
	// token. You can also get the sequence token using DescribeLogStreams. If you
	// call PutLogEvents twice within a narrow time period using the same value
	// for sequenceToken, both calls may be successful, or one may be rejected.
	SequenceToken *string `locationName:"sequenceToken" min:"1" type:"string"`
}

// String returns the string representation
func (s PutLogEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLogEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLogEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutLogEventsInput"}

	if s.LogEvents == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogEvents"))
	}
	if s.LogEvents != nil && len(s.LogEvents) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogEvents", 1))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.LogStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamName"))
	}
	if s.LogStreamName != nil && len(*s.LogStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamName", 1))
	}
	if s.SequenceToken != nil && len(*s.SequenceToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SequenceToken", 1))
	}
	if s.LogEvents != nil {
		for i, v := range s.LogEvents {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogEvents", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutLogEventsResponse
type PutLogEventsOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The next sequence token.
	NextSequenceToken *string `locationName:"nextSequenceToken" min:"1" type:"string"`

	// The rejected events.
	RejectedLogEventsInfo *RejectedLogEventsInfo `locationName:"rejectedLogEventsInfo" type:"structure"`
}

// String returns the string representation
func (s PutLogEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLogEventsOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutLogEventsOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutMetricFilterRequest
type PutMetricFilterInput struct {
	_ struct{} `type:"structure"`

	// A name for the metric filter.
	//
	// FilterName is a required field
	FilterName *string `locationName:"filterName" min:"1" type:"string" required:"true"`

	// A filter pattern for extracting metric data out of ingested log events.
	//
	// FilterPattern is a required field
	FilterPattern *string `locationName:"filterPattern" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// A collection of information that defines how metric data gets emitted.
	//
	// MetricTransformations is a required field
	MetricTransformations []MetricTransformation `locationName:"metricTransformations" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutMetricFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutMetricFilterInput"}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterName", 1))
	}

	if s.FilterPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterPattern"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.MetricTransformations == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricTransformations"))
	}
	if s.MetricTransformations != nil && len(s.MetricTransformations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricTransformations", 1))
	}
	if s.MetricTransformations != nil {
		for i, v := range s.MetricTransformations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricTransformations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutMetricFilterOutput
type PutMetricFilterOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutMetricFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMetricFilterOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutMetricFilterOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutResourcePolicyRequest
type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Details of the new policy, including the identity of the principal that is
	// enabled to put logs to this account. This is formatted as a JSON string.
	//
	// The following example creates a resource policy enabling the Route 53 service
	// to put DNS query logs in to the specified log group. Replace "logArn" with
	// the ARN of your CloudWatch Logs resource, such as a log group or log stream.
	//
	// { "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs",
	// "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ]
	// }, "Action":"logs:PutLogEvents", "Resource": "logArn" } ] }
	PolicyDocument *string `locationName:"policyDocument" min:"1" type:"string"`

	// Name of the new policy. This parameter is required.
	PolicyName *string `locationName:"policyName" type:"string"`
}

// String returns the string representation
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyDocument", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutResourcePolicyResponse
type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The new policy.
	ResourcePolicy *ResourcePolicy `locationName:"resourcePolicy" type:"structure"`
}

// String returns the string representation
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutResourcePolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicyRequest
type PutRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The number of days to retain the log events in the specified log group. Possible
	// values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731,
	// 1827, and 3653.
	//
	// RetentionInDays is a required field
	RetentionInDays *int64 `locationName:"retentionInDays" type:"integer" required:"true"`
}

// String returns the string representation
func (s PutRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRetentionPolicyInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.RetentionInDays == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetentionInDays"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicyOutput
type PutRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionPolicyOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutRetentionPolicyOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilterRequest
type PutSubscriptionFilterInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the destination to deliver matching log events to. Currently,
	// the supported destinations are:
	//
	//    * An Amazon Kinesis stream belonging to the same account as the subscription
	//    filter, for same-account delivery.
	//
	//    * A logical destination (specified using an ARN) belonging to a different
	//    account, for cross-account delivery.
	//
	//    * An Amazon Kinesis Firehose delivery stream belonging to the same account
	//    as the subscription filter, for same-account delivery.
	//
	//    * An AWS Lambda function belonging to the same account as the subscription
	//    filter, for same-account delivery.
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" min:"1" type:"string" required:"true"`

	// The method used to distribute log data to the destination. By default log
	// data is grouped by log stream, but the grouping can be set to random for
	// a more even distribution. This property is only applicable when the destination
	// is an Amazon Kinesis stream.
	Distribution Distribution `locationName:"distribution" type:"string" enum:"true"`

	// A name for the subscription filter. If you are updating an existing filter,
	// you must specify the correct name in filterName. Otherwise, the call fails
	// because you cannot associate a second filter with a log group. To find the
	// name of the filter currently associated with a log group, use DescribeSubscriptionFilters.
	//
	// FilterName is a required field
	FilterName *string `locationName:"filterName" min:"1" type:"string" required:"true"`

	// A filter pattern for subscribing to a filtered stream of log events.
	//
	// FilterPattern is a required field
	FilterPattern *string `locationName:"filterPattern" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The ARN of an IAM role that grants CloudWatch Logs permissions to deliver
	// ingested log events to the destination stream. You don't need to provide
	// the ARN when you are working with a logical destination for cross-account
	// delivery.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s PutSubscriptionFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSubscriptionFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSubscriptionFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutSubscriptionFilterInput"}

	if s.DestinationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationArn"))
	}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationArn", 1))
	}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterName", 1))
	}

	if s.FilterPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterPattern"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilterOutput
type PutSubscriptionFilterOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s PutSubscriptionFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSubscriptionFilterOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s PutSubscriptionFilterOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Represents the rejected events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/RejectedLogEventsInfo
type RejectedLogEventsInfo struct {
	_ struct{} `type:"structure"`

	// The expired log events.
	ExpiredLogEventEndIndex *int64 `locationName:"expiredLogEventEndIndex" type:"integer"`

	// The log events that are too new.
	TooNewLogEventStartIndex *int64 `locationName:"tooNewLogEventStartIndex" type:"integer"`

	// The log events that are too old.
	TooOldLogEventEndIndex *int64 `locationName:"tooOldLogEventEndIndex" type:"integer"`
}

// String returns the string representation
func (s RejectedLogEventsInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectedLogEventsInfo) GoString() string {
	return s.String()
}

// A policy enabling one or more entities to put logs to a log group in this
// account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ResourcePolicy
type ResourcePolicy struct {
	_ struct{} `type:"structure"`

	// Time stamp showing when this policy was last updated, expressed as the number
	// of milliseconds after Jan 1, 1970 00:00:00 UTC.
	LastUpdatedTime *int64 `locationName:"lastUpdatedTime" type:"long"`

	// The details of the policy.
	PolicyDocument *string `locationName:"policyDocument" min:"1" type:"string"`

	// The name of the resource policy.
	PolicyName *string `locationName:"policyName" type:"string"`
}

// String returns the string representation
func (s ResourcePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePolicy) GoString() string {
	return s.String()
}

// Represents the search status of a log stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/SearchedLogStream
type SearchedLogStream struct {
	_ struct{} `type:"structure"`

	// The name of the log stream.
	LogStreamName *string `locationName:"logStreamName" min:"1" type:"string"`

	// Indicates whether all the events in this log stream were searched.
	SearchedCompletely *bool `locationName:"searchedCompletely" type:"boolean"`
}

// String returns the string representation
func (s SearchedLogStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchedLogStream) GoString() string {
	return s.String()
}

// Represents a subscription filter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/SubscriptionFilter
type SubscriptionFilter struct {
	_ struct{} `type:"structure"`

	// The creation time of the subscription filter, expressed as the number of
	// milliseconds after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64 `locationName:"creationTime" type:"long"`

	// The Amazon Resource Name (ARN) of the destination.
	DestinationArn *string `locationName:"destinationArn" min:"1" type:"string"`

	// The method used to distribute log data to the destination, which can be either
	// random or grouped by log stream.
	Distribution Distribution `locationName:"distribution" type:"string" enum:"true"`

	// The name of the subscription filter.
	FilterName *string `locationName:"filterName" min:"1" type:"string"`

	// A symbolic description of how CloudWatch Logs should interpret the data in
	// each log event. For example, a log event may contain time stamps, IP addresses,
	// strings, and so on. You use the filter pattern to specify what to look for
	// in the log event message.
	FilterPattern *string `locationName:"filterPattern" type:"string"`

	// The name of the log group.
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string"`

	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s SubscriptionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscriptionFilter) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagLogGroupRequest
type TagLogGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The key-value pairs to use for the tags.
	//
	// Tags is a required field
	Tags map[string]string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagLogGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagLogGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagLogGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagLogGroupInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagLogGroupOutput
type TagLogGroupOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s TagLogGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagLogGroupOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s TagLogGroupOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilterRequest
type TestMetricFilterInput struct {
	_ struct{} `type:"structure"`

	// A symbolic description of how CloudWatch Logs should interpret the data in
	// each log event. For example, a log event may contain time stamps, IP addresses,
	// strings, and so on. You use the filter pattern to specify what to look for
	// in the log event message.
	//
	// FilterPattern is a required field
	FilterPattern *string `locationName:"filterPattern" type:"string" required:"true"`

	// The log event messages to test.
	//
	// LogEventMessages is a required field
	LogEventMessages []string `locationName:"logEventMessages" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TestMetricFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestMetricFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestMetricFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestMetricFilterInput"}

	if s.FilterPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterPattern"))
	}

	if s.LogEventMessages == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogEventMessages"))
	}
	if s.LogEventMessages != nil && len(s.LogEventMessages) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogEventMessages", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilterResponse
type TestMetricFilterOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response

	// The matched events.
	Matches []MetricFilterMatchRecord `locationName:"matches" type:"list"`
}

// String returns the string representation
func (s TestMetricFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestMetricFilterOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s TestMetricFilterOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagLogGroupRequest
type UntagLogGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The tag keys. The corresponding tags are removed from the log group.
	//
	// Tags is a required field
	Tags []string `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagLogGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagLogGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagLogGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagLogGroupInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagLogGroupOutput
type UntagLogGroupOutput struct {
	_ struct{} `type:"structure"`

	responseMetadata aws.Response
}

// String returns the string representation
func (s UntagLogGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagLogGroupOutput) GoString() string {
	return s.String()
}

// SDKResponseMetdata return sthe response metadata for the API.
func (s UntagLogGroupOutput) SDKResponseMetadata() aws.Response {
	return s.responseMetadata
}

// The method used to distribute log data to the destination, which can be either
// random or grouped by log stream.
type Distribution string

// Enum values for Distribution
const (
	DistributionRandom      Distribution = "Random"
	DistributionByLogStream Distribution = "ByLogStream"
)

func (enum Distribution) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Distribution) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ExportTaskStatusCode string

// Enum values for ExportTaskStatusCode
const (
	ExportTaskStatusCodeCancelled     ExportTaskStatusCode = "CANCELLED"
	ExportTaskStatusCodeCompleted     ExportTaskStatusCode = "COMPLETED"
	ExportTaskStatusCodeFailed        ExportTaskStatusCode = "FAILED"
	ExportTaskStatusCodePending       ExportTaskStatusCode = "PENDING"
	ExportTaskStatusCodePendingCancel ExportTaskStatusCode = "PENDING_CANCEL"
	ExportTaskStatusCodeRunning       ExportTaskStatusCode = "RUNNING"
)

func (enum ExportTaskStatusCode) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ExportTaskStatusCode) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type OrderBy string

// Enum values for OrderBy
const (
	OrderByLogStreamName OrderBy = "LogStreamName"
	OrderByLastEventTime OrderBy = "LastEventTime"
)

func (enum OrderBy) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum OrderBy) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
