AC_DEFUN(BEACON_CHECK_PERL,
[
  ver=$1
  AC_ARG_WITH(perl,
	    AC_HELP_STRING([--with-perl=PATH],
			   [specify the path to the perl interpreter to use]),
  [
    case "$withval" in
      "no")
        AC_MSG_ERROR([disabling perl is not allowed])
       ;;
       "yes")
         BEACON_FIND_PERL(check,$ver)
       ;;
       *)
         BEACON_FIND_PERL($withval,$ver)
       ;;
       esac
  ],
  [
    BEACON_FIND_PERL(check,$ver)
  ])

])

AC_DEFUN(BEACON_FIND_PERL,
[
  where=$1
  ver=$2

  if test $where = check; then
    AC_PATH_PROG(PERL,perl,none)
  else
    AC_MSG_NOTICE([using perl... $where])
    PERL=$where
  fi

  if test "$PERL" != "none"; then
    AC_MSG_CHECKING([perl version >= $ver])
    $PERL -e "use $ver;" > /dev/null 2>&1
    if test $? -ne 0; then
      AC_MSG_RESULT(no);
      AC_MSG_ERROR([perl is too old (< $ver)])
    else
      AC_MSG_RESULT(ok);
    fi

  fi
])



